<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OspProperty StructType
 * Meta informations extracted from the WSDL
 * - documentation: Контейнер OspProperty «Отдел СП» | Содержит сведения о расчетном счете отдела СП
 * - type: tns:OspProperty
 * @subpackage Structs
 */
class OspProperty extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор объекта, присвоенный АИС ФССП России | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The OspCode
     * Meta informations extracted from the WSDL
     * - documentation: Код отдела СП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OspCode;
    /**
     * The BeginDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала действия | Дата начала действия реквизитов, Неуказанное значение сигнализирует о том, что реквизиты действуют на
     * момент ответа на запрос | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания действия | Дата окончания действия реквизитов. Неуказанное значение сигнализирует о том, что срок окончения
     * действия реквизитов неизвестен | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $EndDate;
    /**
     * The DivName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование подразделения | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DivName;
    /**
     * The DivFullName
     * Meta informations extracted from the WSDL
     * - documentation: Полное наименование подразделения | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DivFullName;
    /**
     * The DivHeadName
     * Meta informations extracted from the WSDL
     * - documentation: Руководитель | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $DivHeadName;
    /**
     * The DivHeadPostName
     * Meta informations extracted from the WSDL
     * - documentation: Должность руководителя | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DivHeadPostName;
    /**
     * The DivDeputyHeadName
     * Meta informations extracted from the WSDL
     * - documentation: Заместитель руководителя | Полное имя физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $DivDeputyHeadName;
    /**
     * The DivDeputyHeadPostName
     * Meta informations extracted from the WSDL
     * - documentation: Должность заместитель руководителя | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DivDeputyHeadPostName;
    /**
     * The DivAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес юридический | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DivAdr;
    /**
     * The DivEmail
     * Meta informations extracted from the WSDL
     * - documentation: Адрес электронной почты | Адрес электронной почты
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $DivEmail;
    /**
     * The DivTel
     * Meta informations extracted from the WSDL
     * - documentation: Телефон ССП | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DivTel;
    /**
     * The DivTelReception
     * Meta informations extracted from the WSDL
     * - documentation: Телефон приемной | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DivTelReception;
    /**
     * The DivFax
     * Meta informations extracted from the WSDL
     * - documentation: Факс | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DivFax;
    /**
     * The DivOfficeHours
     * Meta informations extracted from the WSDL
     * - documentation: Часы работы | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DivOfficeHours;
    /**
     * The DivReceptionHours
     * Meta informations extracted from the WSDL
     * - documentation: Часы приема | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DivReceptionHours;
    /**
     * The RecpName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование ОСП для платежей | Строка длиной от 1 до 160 символов
     * - maxLength: 160
     * - minLength: 1
     * @var string
     */
    public $RecpName;
    /**
     * The RecpAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес получателя | Строка длиной от 1 до 200 символов
     * - maxLength: 200
     * - minLength: 1
     * @var string
     */
    public $RecpAdr;
    /**
     * The RecpBank
     * Meta informations extracted from the WSDL
     * - documentation: Банк получателя. | Строка длиной от 1 до 80 символов
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $RecpBank;
    /**
     * The RecpBIK
     * Meta informations extracted from the WSDL
     * - documentation: БИК банка получателя. | Банковский идентификационный код (БИК)
     * - length: 9
     * - pattern: [0-9]{9}
     * @var string
     */
    public $RecpBIK;
    /**
     * The RecpCnt
     * Meta informations extracted from the WSDL
     * - documentation: Расчетный счет. | Строка длиной от 1 до 20 символов
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $RecpCnt;
    /**
     * The RecpINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН получателя. | ИНН юридического лица
     * - length: 10
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}
     * @var string
     */
    public $RecpINN;
    /**
     * The RecpKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП получателя. | КПП
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $RecpKPP;
    /**
     * The OKATO
     * Meta informations extracted from the WSDL
     * - documentation: Код ОКАТО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $OKATO;
    /**
     * The OKTMO
     * Meta informations extracted from the WSDL
     * - documentation: ОКТМО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - maxLength: 11
     * - minLength: 8
     * - pattern: ([0-9]{8})|([0-9]{11})
     * @var string
     */
    public $OKTMO;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Адрес подразделения | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Address;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об отделе
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\OspDetail[]
     */
    public $Details;
    /**
     * Constructor method for OspProperty
     * @uses OspProperty::setInternalKey()
     * @uses OspProperty::setOspCode()
     * @uses OspProperty::setBeginDate()
     * @uses OspProperty::setEndDate()
     * @uses OspProperty::setDivName()
     * @uses OspProperty::setDivFullName()
     * @uses OspProperty::setDivHeadName()
     * @uses OspProperty::setDivHeadPostName()
     * @uses OspProperty::setDivDeputyHeadName()
     * @uses OspProperty::setDivDeputyHeadPostName()
     * @uses OspProperty::setDivAdr()
     * @uses OspProperty::setDivEmail()
     * @uses OspProperty::setDivTel()
     * @uses OspProperty::setDivTelReception()
     * @uses OspProperty::setDivFax()
     * @uses OspProperty::setDivOfficeHours()
     * @uses OspProperty::setDivReceptionHours()
     * @uses OspProperty::setRecpName()
     * @uses OspProperty::setRecpAdr()
     * @uses OspProperty::setRecpBank()
     * @uses OspProperty::setRecpBIK()
     * @uses OspProperty::setRecpCnt()
     * @uses OspProperty::setRecpINN()
     * @uses OspProperty::setRecpKPP()
     * @uses OspProperty::setOKATO()
     * @uses OspProperty::setOKTMO()
     * @uses OspProperty::setAddress()
     * @uses OspProperty::setDetails()
     * @param int $internalKey
     * @param string $ospCode
     * @param string $beginDate
     * @param string $endDate
     * @param string $divName
     * @param string $divFullName
     * @param string $divHeadName
     * @param string $divHeadPostName
     * @param string $divDeputyHeadName
     * @param string $divDeputyHeadPostName
     * @param string $divAdr
     * @param string $divEmail
     * @param string $divTel
     * @param string $divTelReception
     * @param string $divFax
     * @param string $divOfficeHours
     * @param string $divReceptionHours
     * @param string $recpName
     * @param string $recpAdr
     * @param string $recpBank
     * @param string $recpBIK
     * @param string $recpCnt
     * @param string $recpINN
     * @param string $recpKPP
     * @param string $oKATO
     * @param string $oKTMO
     * @param string $address
     * @param \AisFssp\StructType\OspDetail[] $details
     */
    public function __construct($internalKey = null, $ospCode = null, $beginDate = null, $endDate = null, $divName = null, $divFullName = null, $divHeadName = null, $divHeadPostName = null, $divDeputyHeadName = null, $divDeputyHeadPostName = null, $divAdr = null, $divEmail = null, $divTel = null, $divTelReception = null, $divFax = null, $divOfficeHours = null, $divReceptionHours = null, $recpName = null, $recpAdr = null, $recpBank = null, $recpBIK = null, $recpCnt = null, $recpINN = null, $recpKPP = null, $oKATO = null, $oKTMO = null, $address = null, array $details = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setOspCode($ospCode)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setDivName($divName)
            ->setDivFullName($divFullName)
            ->setDivHeadName($divHeadName)
            ->setDivHeadPostName($divHeadPostName)
            ->setDivDeputyHeadName($divDeputyHeadName)
            ->setDivDeputyHeadPostName($divDeputyHeadPostName)
            ->setDivAdr($divAdr)
            ->setDivEmail($divEmail)
            ->setDivTel($divTel)
            ->setDivTelReception($divTelReception)
            ->setDivFax($divFax)
            ->setDivOfficeHours($divOfficeHours)
            ->setDivReceptionHours($divReceptionHours)
            ->setRecpName($recpName)
            ->setRecpAdr($recpAdr)
            ->setRecpBank($recpBank)
            ->setRecpBIK($recpBIK)
            ->setRecpCnt($recpCnt)
            ->setRecpINN($recpINN)
            ->setRecpKPP($recpKPP)
            ->setOKATO($oKATO)
            ->setOKTMO($oKTMO)
            ->setAddress($address)
            ->setDetails($details);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\OspProperty
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get OspCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->OspCode;
    }
    /**
     * Set OspCode value
     * @param string $ospCode
     * @return \AisFssp\StructType\OspProperty
     */
    public function setOspCode($ospCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($ospCode) && strlen($ospCode) !== 5) || (is_array($ospCode) && count($ospCode) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($ospCode) && !preg_match('/[0-9]{5}/', $ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($ospCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ospCode) && !is_string($ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ospCode)), __LINE__);
        }
        $this->OspCode = $ospCode;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string|null
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \AisFssp\StructType\OspProperty
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: maxExclusive
        if ($beginDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $beginDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($beginDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $beginDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \AisFssp\StructType\OspProperty
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: maxExclusive
        if ($endDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $endDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($endDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $endDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get DivName value
     * @return string|null
     */
    public function getDivName()
    {
        return $this->DivName;
    }
    /**
     * Set DivName value
     * @param string $divName
     * @return \AisFssp\StructType\OspProperty
     */
    public function setDivName($divName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($divName) && strlen($divName) > 1000) || (is_array($divName) && count($divName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($divName) ? strlen($divName) : count($divName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($divName) && strlen($divName) < 1) || (is_array($divName) && count($divName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($divName) && !is_string($divName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($divName)), __LINE__);
        }
        $this->DivName = $divName;
        return $this;
    }
    /**
     * Get DivFullName value
     * @return string|null
     */
    public function getDivFullName()
    {
        return $this->DivFullName;
    }
    /**
     * Set DivFullName value
     * @param string $divFullName
     * @return \AisFssp\StructType\OspProperty
     */
    public function setDivFullName($divFullName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($divFullName) && strlen($divFullName) > 1000) || (is_array($divFullName) && count($divFullName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($divFullName) ? strlen($divFullName) : count($divFullName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($divFullName) && strlen($divFullName) < 1) || (is_array($divFullName) && count($divFullName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($divFullName) && !is_string($divFullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($divFullName)), __LINE__);
        }
        $this->DivFullName = $divFullName;
        return $this;
    }
    /**
     * Get DivHeadName value
     * @return string|null
     */
    public function getDivHeadName()
    {
        return $this->DivHeadName;
    }
    /**
     * Set DivHeadName value
     * @param string $divHeadName
     * @return \AisFssp\StructType\OspProperty
     */
    public function setDivHeadName($divHeadName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($divHeadName) && strlen($divHeadName) > 100) || (is_array($divHeadName) && count($divHeadName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($divHeadName) ? strlen($divHeadName) : count($divHeadName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($divHeadName) && strlen($divHeadName) < 1) || (is_array($divHeadName) && count($divHeadName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($divHeadName) && !is_string($divHeadName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($divHeadName)), __LINE__);
        }
        $this->DivHeadName = $divHeadName;
        return $this;
    }
    /**
     * Get DivHeadPostName value
     * @return string|null
     */
    public function getDivHeadPostName()
    {
        return $this->DivHeadPostName;
    }
    /**
     * Set DivHeadPostName value
     * @param string $divHeadPostName
     * @return \AisFssp\StructType\OspProperty
     */
    public function setDivHeadPostName($divHeadPostName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($divHeadPostName) && strlen($divHeadPostName) > 1000) || (is_array($divHeadPostName) && count($divHeadPostName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($divHeadPostName) ? strlen($divHeadPostName) : count($divHeadPostName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($divHeadPostName) && strlen($divHeadPostName) < 1) || (is_array($divHeadPostName) && count($divHeadPostName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($divHeadPostName) && !is_string($divHeadPostName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($divHeadPostName)), __LINE__);
        }
        $this->DivHeadPostName = $divHeadPostName;
        return $this;
    }
    /**
     * Get DivDeputyHeadName value
     * @return string|null
     */
    public function getDivDeputyHeadName()
    {
        return $this->DivDeputyHeadName;
    }
    /**
     * Set DivDeputyHeadName value
     * @param string $divDeputyHeadName
     * @return \AisFssp\StructType\OspProperty
     */
    public function setDivDeputyHeadName($divDeputyHeadName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($divDeputyHeadName) && strlen($divDeputyHeadName) > 100) || (is_array($divDeputyHeadName) && count($divDeputyHeadName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($divDeputyHeadName) ? strlen($divDeputyHeadName) : count($divDeputyHeadName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($divDeputyHeadName) && strlen($divDeputyHeadName) < 1) || (is_array($divDeputyHeadName) && count($divDeputyHeadName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($divDeputyHeadName) && !is_string($divDeputyHeadName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($divDeputyHeadName)), __LINE__);
        }
        $this->DivDeputyHeadName = $divDeputyHeadName;
        return $this;
    }
    /**
     * Get DivDeputyHeadPostName value
     * @return string|null
     */
    public function getDivDeputyHeadPostName()
    {
        return $this->DivDeputyHeadPostName;
    }
    /**
     * Set DivDeputyHeadPostName value
     * @param string $divDeputyHeadPostName
     * @return \AisFssp\StructType\OspProperty
     */
    public function setDivDeputyHeadPostName($divDeputyHeadPostName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($divDeputyHeadPostName) && strlen($divDeputyHeadPostName) > 1000) || (is_array($divDeputyHeadPostName) && count($divDeputyHeadPostName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($divDeputyHeadPostName) ? strlen($divDeputyHeadPostName) : count($divDeputyHeadPostName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($divDeputyHeadPostName) && strlen($divDeputyHeadPostName) < 1) || (is_array($divDeputyHeadPostName) && count($divDeputyHeadPostName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($divDeputyHeadPostName) && !is_string($divDeputyHeadPostName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($divDeputyHeadPostName)), __LINE__);
        }
        $this->DivDeputyHeadPostName = $divDeputyHeadPostName;
        return $this;
    }
    /**
     * Get DivAdr value
     * @return string|null
     */
    public function getDivAdr()
    {
        return $this->DivAdr;
    }
    /**
     * Set DivAdr value
     * @param string $divAdr
     * @return \AisFssp\StructType\OspProperty
     */
    public function setDivAdr($divAdr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($divAdr) && strlen($divAdr) > 300) || (is_array($divAdr) && count($divAdr) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($divAdr) ? strlen($divAdr) : count($divAdr)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($divAdr) && strlen($divAdr) < 1) || (is_array($divAdr) && count($divAdr) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($divAdr) && !is_string($divAdr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($divAdr)), __LINE__);
        }
        $this->DivAdr = $divAdr;
        return $this;
    }
    /**
     * Get DivEmail value
     * @return string|null
     */
    public function getDivEmail()
    {
        return $this->DivEmail;
    }
    /**
     * Set DivEmail value
     * @param string $divEmail
     * @return \AisFssp\StructType\OspProperty
     */
    public function setDivEmail($divEmail = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($divEmail) && strlen($divEmail) > 100) || (is_array($divEmail) && count($divEmail) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($divEmail) ? strlen($divEmail) : count($divEmail)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($divEmail) && strlen($divEmail) < 1) || (is_array($divEmail) && count($divEmail) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($divEmail) && !is_string($divEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($divEmail)), __LINE__);
        }
        $this->DivEmail = $divEmail;
        return $this;
    }
    /**
     * Get DivTel value
     * @return string|null
     */
    public function getDivTel()
    {
        return $this->DivTel;
    }
    /**
     * Set DivTel value
     * @param string $divTel
     * @return \AisFssp\StructType\OspProperty
     */
    public function setDivTel($divTel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($divTel) && strlen($divTel) > 25) || (is_array($divTel) && count($divTel) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($divTel) ? strlen($divTel) : count($divTel)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($divTel) && strlen($divTel) < 1) || (is_array($divTel) && count($divTel) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($divTel) && !is_string($divTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($divTel)), __LINE__);
        }
        $this->DivTel = $divTel;
        return $this;
    }
    /**
     * Get DivTelReception value
     * @return string|null
     */
    public function getDivTelReception()
    {
        return $this->DivTelReception;
    }
    /**
     * Set DivTelReception value
     * @param string $divTelReception
     * @return \AisFssp\StructType\OspProperty
     */
    public function setDivTelReception($divTelReception = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($divTelReception) && strlen($divTelReception) > 25) || (is_array($divTelReception) && count($divTelReception) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($divTelReception) ? strlen($divTelReception) : count($divTelReception)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($divTelReception) && strlen($divTelReception) < 1) || (is_array($divTelReception) && count($divTelReception) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($divTelReception) && !is_string($divTelReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($divTelReception)), __LINE__);
        }
        $this->DivTelReception = $divTelReception;
        return $this;
    }
    /**
     * Get DivFax value
     * @return string|null
     */
    public function getDivFax()
    {
        return $this->DivFax;
    }
    /**
     * Set DivFax value
     * @param string $divFax
     * @return \AisFssp\StructType\OspProperty
     */
    public function setDivFax($divFax = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($divFax) && strlen($divFax) > 25) || (is_array($divFax) && count($divFax) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($divFax) ? strlen($divFax) : count($divFax)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($divFax) && strlen($divFax) < 1) || (is_array($divFax) && count($divFax) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($divFax) && !is_string($divFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($divFax)), __LINE__);
        }
        $this->DivFax = $divFax;
        return $this;
    }
    /**
     * Get DivOfficeHours value
     * @return string|null
     */
    public function getDivOfficeHours()
    {
        return $this->DivOfficeHours;
    }
    /**
     * Set DivOfficeHours value
     * @param string $divOfficeHours
     * @return \AisFssp\StructType\OspProperty
     */
    public function setDivOfficeHours($divOfficeHours = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($divOfficeHours) && strlen($divOfficeHours) > 1000) || (is_array($divOfficeHours) && count($divOfficeHours) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($divOfficeHours) ? strlen($divOfficeHours) : count($divOfficeHours)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($divOfficeHours) && strlen($divOfficeHours) < 1) || (is_array($divOfficeHours) && count($divOfficeHours) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($divOfficeHours) && !is_string($divOfficeHours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($divOfficeHours)), __LINE__);
        }
        $this->DivOfficeHours = $divOfficeHours;
        return $this;
    }
    /**
     * Get DivReceptionHours value
     * @return string|null
     */
    public function getDivReceptionHours()
    {
        return $this->DivReceptionHours;
    }
    /**
     * Set DivReceptionHours value
     * @param string $divReceptionHours
     * @return \AisFssp\StructType\OspProperty
     */
    public function setDivReceptionHours($divReceptionHours = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($divReceptionHours) && strlen($divReceptionHours) > 1000) || (is_array($divReceptionHours) && count($divReceptionHours) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($divReceptionHours) ? strlen($divReceptionHours) : count($divReceptionHours)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($divReceptionHours) && strlen($divReceptionHours) < 1) || (is_array($divReceptionHours) && count($divReceptionHours) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($divReceptionHours) && !is_string($divReceptionHours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($divReceptionHours)), __LINE__);
        }
        $this->DivReceptionHours = $divReceptionHours;
        return $this;
    }
    /**
     * Get RecpName value
     * @return string|null
     */
    public function getRecpName()
    {
        return $this->RecpName;
    }
    /**
     * Set RecpName value
     * @param string $recpName
     * @return \AisFssp\StructType\OspProperty
     */
    public function setRecpName($recpName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($recpName) && strlen($recpName) > 160) || (is_array($recpName) && count($recpName) > 160)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 160 element(s) or a scalar of 160 character(s) at most, "%d" length given', is_scalar($recpName) ? strlen($recpName) : count($recpName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($recpName) && strlen($recpName) < 1) || (is_array($recpName) && count($recpName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($recpName) && !is_string($recpName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recpName)), __LINE__);
        }
        $this->RecpName = $recpName;
        return $this;
    }
    /**
     * Get RecpAdr value
     * @return string|null
     */
    public function getRecpAdr()
    {
        return $this->RecpAdr;
    }
    /**
     * Set RecpAdr value
     * @param string $recpAdr
     * @return \AisFssp\StructType\OspProperty
     */
    public function setRecpAdr($recpAdr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($recpAdr) && strlen($recpAdr) > 200) || (is_array($recpAdr) && count($recpAdr) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($recpAdr) ? strlen($recpAdr) : count($recpAdr)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($recpAdr) && strlen($recpAdr) < 1) || (is_array($recpAdr) && count($recpAdr) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($recpAdr) && !is_string($recpAdr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recpAdr)), __LINE__);
        }
        $this->RecpAdr = $recpAdr;
        return $this;
    }
    /**
     * Get RecpBank value
     * @return string|null
     */
    public function getRecpBank()
    {
        return $this->RecpBank;
    }
    /**
     * Set RecpBank value
     * @param string $recpBank
     * @return \AisFssp\StructType\OspProperty
     */
    public function setRecpBank($recpBank = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($recpBank) && strlen($recpBank) > 80) || (is_array($recpBank) && count($recpBank) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($recpBank) ? strlen($recpBank) : count($recpBank)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($recpBank) && strlen($recpBank) < 1) || (is_array($recpBank) && count($recpBank) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($recpBank) && !is_string($recpBank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recpBank)), __LINE__);
        }
        $this->RecpBank = $recpBank;
        return $this;
    }
    /**
     * Get RecpBIK value
     * @return string|null
     */
    public function getRecpBIK()
    {
        return $this->RecpBIK;
    }
    /**
     * Set RecpBIK value
     * @param string $recpBIK
     * @return \AisFssp\StructType\OspProperty
     */
    public function setRecpBIK($recpBIK = null)
    {
        // validation for constraint: length
        if ((is_scalar($recpBIK) && strlen($recpBIK) !== 9) || (is_array($recpBIK) && count($recpBIK) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($recpBIK) && !preg_match('/[0-9]{9}/', $recpBIK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{9}", "%s" given', var_export($recpBIK, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($recpBIK) && !is_string($recpBIK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recpBIK)), __LINE__);
        }
        $this->RecpBIK = $recpBIK;
        return $this;
    }
    /**
     * Get RecpCnt value
     * @return string|null
     */
    public function getRecpCnt()
    {
        return $this->RecpCnt;
    }
    /**
     * Set RecpCnt value
     * @param string $recpCnt
     * @return \AisFssp\StructType\OspProperty
     */
    public function setRecpCnt($recpCnt = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($recpCnt) && strlen($recpCnt) > 20) || (is_array($recpCnt) && count($recpCnt) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($recpCnt) ? strlen($recpCnt) : count($recpCnt)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($recpCnt) && strlen($recpCnt) < 1) || (is_array($recpCnt) && count($recpCnt) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($recpCnt) && !is_string($recpCnt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recpCnt)), __LINE__);
        }
        $this->RecpCnt = $recpCnt;
        return $this;
    }
    /**
     * Get RecpINN value
     * @return string|null
     */
    public function getRecpINN()
    {
        return $this->RecpINN;
    }
    /**
     * Set RecpINN value
     * @param string $recpINN
     * @return \AisFssp\StructType\OspProperty
     */
    public function setRecpINN($recpINN = null)
    {
        // validation for constraint: length
        if ((is_scalar($recpINN) && strlen($recpINN) !== 10) || (is_array($recpINN) && count($recpINN) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($recpINN) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}/', $recpINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}", "%s" given', var_export($recpINN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($recpINN) && !is_string($recpINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recpINN)), __LINE__);
        }
        $this->RecpINN = $recpINN;
        return $this;
    }
    /**
     * Get RecpKPP value
     * @return string|null
     */
    public function getRecpKPP()
    {
        return $this->RecpKPP;
    }
    /**
     * Set RecpKPP value
     * @param string $recpKPP
     * @return \AisFssp\StructType\OspProperty
     */
    public function setRecpKPP($recpKPP = null)
    {
        // validation for constraint: length
        if ((is_scalar($recpKPP) && strlen($recpKPP) !== 9) || (is_array($recpKPP) && count($recpKPP) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($recpKPP) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}/', $recpKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}", "%s" given', var_export($recpKPP, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($recpKPP) && !is_string($recpKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recpKPP)), __LINE__);
        }
        $this->RecpKPP = $recpKPP;
        return $this;
    }
    /**
     * Get OKATO value
     * @return string|null
     */
    public function getOKATO()
    {
        return $this->OKATO;
    }
    /**
     * Set OKATO value
     * @param string $oKATO
     * @return \AisFssp\StructType\OspProperty
     */
    public function setOKATO($oKATO = null)
    {
        // validation for constraint: length
        if ((is_scalar($oKATO) && strlen($oKATO) !== 11) || (is_array($oKATO) && count($oKATO) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($oKATO) && !preg_match('/[0-9]{11}/', $oKATO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{11}", "%s" given', var_export($oKATO, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oKATO) && !is_string($oKATO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oKATO)), __LINE__);
        }
        $this->OKATO = $oKATO;
        return $this;
    }
    /**
     * Get OKTMO value
     * @return string|null
     */
    public function getOKTMO()
    {
        return $this->OKTMO;
    }
    /**
     * Set OKTMO value
     * @param string $oKTMO
     * @return \AisFssp\StructType\OspProperty
     */
    public function setOKTMO($oKTMO = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oKTMO) && strlen($oKTMO) > 11) || (is_array($oKTMO) && count($oKTMO) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($oKTMO) ? strlen($oKTMO) : count($oKTMO)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($oKTMO) && strlen($oKTMO) < 8) || (is_array($oKTMO) && count($oKTMO) < 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($oKTMO) && !preg_match('/([0-9]{8})|([0-9]{11})/', $oKTMO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{8})|([0-9]{11})", "%s" given', var_export($oKTMO, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oKTMO) && !is_string($oKTMO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oKTMO)), __LINE__);
        }
        $this->OKTMO = $oKTMO;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \AisFssp\StructType\OspProperty
     */
    public function setAddress($address = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($address) && strlen($address) > 300) || (is_array($address) && count($address) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($address) ? strlen($address) : count($address)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($address) && strlen($address) < 1) || (is_array($address) && count($address) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Details value
     * @return \AisFssp\StructType\OspDetail[]|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\OspDetail[] $details
     * @return \AisFssp\StructType\OspProperty
     */
    public function setDetails(array $details = array())
    {
        foreach ($details as $ospPropertyDetailsItem) {
            // validation for constraint: itemType
            if (!$ospPropertyDetailsItem instanceof \AisFssp\StructType\OspDetail) {
                throw new \InvalidArgumentException(sprintf('The Details property can only contain items of \AisFssp\StructType\OspDetail, "%s" given', is_object($ospPropertyDetailsItem) ? get_class($ospPropertyDetailsItem) : gettype($ospPropertyDetailsItem)), __LINE__);
            }
        }
        $this->Details = $details;
        return $this;
    }
    /**
     * Add item to Details value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\OspDetail $item
     * @return \AisFssp\StructType\OspProperty
     */
    public function addToDetails(\AisFssp\StructType\OspDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\OspDetail) {
            throw new \InvalidArgumentException(sprintf('The Details property can only contain items of \AisFssp\StructType\OspDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Details[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\OspProperty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
