<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NoticeReadinessSaleSeizedProperty StructType
 * Meta informations extracted from the WSDL
 * - documentation: Уведомление о готовности к реализации арестованного имущества | ЭП
 * - type: tns:NoticeReadinessSaleSeizedProperty
 * @subpackage Structs
 */
class NoticeReadinessSaleSeizedProperty extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Идентификатор уведомления о готовности к реализации арестованного имущества. | Ключ объекта, присвоенний
     * информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The NoticeNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер уведомления | Номер уведомления о готовности к реализации арестованного имущества. | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $NoticeNum;
    /**
     * The NoticeDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата уведомления | Дата уведомления о готовности к реализации арестованного имущества. | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $NoticeDate;
    /**
     * The ProcDocId
     * Meta informations extracted from the WSDL
     * - documentation: Ключ постановления | Ключ постановления судебного пристава-исполнителя о передачи арестованного имущества должника на
     * реализацию. | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $ProcDocId;
    /**
     * The ProcDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Электронный номер постановления | Электронный номер постановления судебного пристава-исполнителя о передачи арестованного
     * имущества должника на реализацию. | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $ProcDocNumber;
    /**
     * The ProcDocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата вынесения постановления | Дата вынесения постановления судебного пристава-исполнителя о передачи арестованного
     * имущества должника на реализацию. | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ProcDocDate;
    /**
     * The NoticeReadinessSaleSeizedPropertyBase
     * Meta informations extracted from the WSDL
     * - documentation: Уведомление
     * - minOccurs: 0
     * @var string
     */
    public $NoticeReadinessSaleSeizedPropertyBase;
    /**
     * The SignatureNoticeReadinessSaleSeizedPropertyBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП уведомления | ЭП уведомления о готовности к реализации арестованного имущества вынесенного в электронном виде, элемента
     * «NoticeReadinessSaleSeizedPropertyBase» в формате pkcs#7, в кодировке Base64.
     * - minOccurs: 0
     * @var string
     */
    public $SignatureNoticeReadinessSaleSeizedPropertyBase;
    /**
     * The IP
     * Meta informations extracted from the WSDL
     * - documentation: ИП | Содержит основные сведения об исполнительном производстве и должнике.
     * @var \AisFssp\StructType\IP
     */
    public $IP;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - documentation: Приложенные файлы | Дополнительные данные в произвольных форматах.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\AttachmentType[]
     */
    public $attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for NoticeReadinessSaleSeizedProperty
     * @uses NoticeReadinessSaleSeizedProperty::setInternalKey()
     * @uses NoticeReadinessSaleSeizedProperty::setNoticeNum()
     * @uses NoticeReadinessSaleSeizedProperty::setNoticeDate()
     * @uses NoticeReadinessSaleSeizedProperty::setProcDocId()
     * @uses NoticeReadinessSaleSeizedProperty::setProcDocNumber()
     * @uses NoticeReadinessSaleSeizedProperty::setProcDocDate()
     * @uses NoticeReadinessSaleSeizedProperty::setNoticeReadinessSaleSeizedPropertyBase()
     * @uses NoticeReadinessSaleSeizedProperty::setSignatureNoticeReadinessSaleSeizedPropertyBase()
     * @uses NoticeReadinessSaleSeizedProperty::setIP()
     * @uses NoticeReadinessSaleSeizedProperty::setAttachments()
     * @uses NoticeReadinessSaleSeizedProperty::setSignDateTime()
     * @uses NoticeReadinessSaleSeizedProperty::setSignature()
     * @param int $internalKey
     * @param string $noticeNum
     * @param string $noticeDate
     * @param int $procDocId
     * @param string $procDocNumber
     * @param string $procDocDate
     * @param string $noticeReadinessSaleSeizedPropertyBase
     * @param string $signatureNoticeReadinessSaleSeizedPropertyBase
     * @param \AisFssp\StructType\IP $iP
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     */
    public function __construct($internalKey = null, $noticeNum = null, $noticeDate = null, $procDocId = null, $procDocNumber = null, $procDocDate = null, $noticeReadinessSaleSeizedPropertyBase = null, $signatureNoticeReadinessSaleSeizedPropertyBase = null, \AisFssp\StructType\IP $iP = null, array $attachments = array(), $signDateTime = null, array $signature = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setNoticeNum($noticeNum)
            ->setNoticeDate($noticeDate)
            ->setProcDocId($procDocId)
            ->setProcDocNumber($procDocNumber)
            ->setProcDocDate($procDocDate)
            ->setNoticeReadinessSaleSeizedPropertyBase($noticeReadinessSaleSeizedPropertyBase)
            ->setSignatureNoticeReadinessSaleSeizedPropertyBase($signatureNoticeReadinessSaleSeizedPropertyBase)
            ->setIP($iP)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get NoticeNum value
     * @return string|null
     */
    public function getNoticeNum()
    {
        return $this->NoticeNum;
    }
    /**
     * Set NoticeNum value
     * @param string $noticeNum
     * @return \AisFssp\StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setNoticeNum($noticeNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($noticeNum) && strlen($noticeNum) > 25) || (is_array($noticeNum) && count($noticeNum) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($noticeNum) ? strlen($noticeNum) : count($noticeNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($noticeNum) && strlen($noticeNum) < 1) || (is_array($noticeNum) && count($noticeNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($noticeNum) && !is_string($noticeNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noticeNum)), __LINE__);
        }
        $this->NoticeNum = $noticeNum;
        return $this;
    }
    /**
     * Get NoticeDate value
     * @return string|null
     */
    public function getNoticeDate()
    {
        return $this->NoticeDate;
    }
    /**
     * Set NoticeDate value
     * @param string $noticeDate
     * @return \AisFssp\StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setNoticeDate($noticeDate = null)
    {
        // validation for constraint: maxExclusive
        if ($noticeDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $noticeDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($noticeDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $noticeDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($noticeDate) && !is_string($noticeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noticeDate)), __LINE__);
        }
        $this->NoticeDate = $noticeDate;
        return $this;
    }
    /**
     * Get ProcDocId value
     * @return int|null
     */
    public function getProcDocId()
    {
        return $this->ProcDocId;
    }
    /**
     * Set ProcDocId value
     * @param int $procDocId
     * @return \AisFssp\StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setProcDocId($procDocId = null)
    {
        // validation for constraint: maxInclusive
        if ($procDocId > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $procDocId), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($procDocId < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $procDocId), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($procDocId) && !is_numeric($procDocId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($procDocId)), __LINE__);
        }
        $this->ProcDocId = $procDocId;
        return $this;
    }
    /**
     * Get ProcDocNumber value
     * @return string|null
     */
    public function getProcDocNumber()
    {
        return $this->ProcDocNumber;
    }
    /**
     * Set ProcDocNumber value
     * @param string $procDocNumber
     * @return \AisFssp\StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setProcDocNumber($procDocNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($procDocNumber) && strlen($procDocNumber) > 25) || (is_array($procDocNumber) && count($procDocNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($procDocNumber) ? strlen($procDocNumber) : count($procDocNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($procDocNumber) && strlen($procDocNumber) < 1) || (is_array($procDocNumber) && count($procDocNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($procDocNumber) && !is_string($procDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($procDocNumber)), __LINE__);
        }
        $this->ProcDocNumber = $procDocNumber;
        return $this;
    }
    /**
     * Get ProcDocDate value
     * @return string|null
     */
    public function getProcDocDate()
    {
        return $this->ProcDocDate;
    }
    /**
     * Set ProcDocDate value
     * @param string $procDocDate
     * @return \AisFssp\StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setProcDocDate($procDocDate = null)
    {
        // validation for constraint: maxExclusive
        if ($procDocDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $procDocDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($procDocDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $procDocDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($procDocDate) && !is_string($procDocDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($procDocDate)), __LINE__);
        }
        $this->ProcDocDate = $procDocDate;
        return $this;
    }
    /**
     * Get NoticeReadinessSaleSeizedPropertyBase value
     * @return string|null
     */
    public function getNoticeReadinessSaleSeizedPropertyBase()
    {
        return $this->NoticeReadinessSaleSeizedPropertyBase;
    }
    /**
     * Set NoticeReadinessSaleSeizedPropertyBase value
     * @param string $noticeReadinessSaleSeizedPropertyBase
     * @return \AisFssp\StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setNoticeReadinessSaleSeizedPropertyBase($noticeReadinessSaleSeizedPropertyBase = null)
    {
        // validation for constraint: string
        if (!is_null($noticeReadinessSaleSeizedPropertyBase) && !is_string($noticeReadinessSaleSeizedPropertyBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noticeReadinessSaleSeizedPropertyBase)), __LINE__);
        }
        $this->NoticeReadinessSaleSeizedPropertyBase = $noticeReadinessSaleSeizedPropertyBase;
        return $this;
    }
    /**
     * Get SignatureNoticeReadinessSaleSeizedPropertyBase value
     * @return string|null
     */
    public function getSignatureNoticeReadinessSaleSeizedPropertyBase()
    {
        return $this->SignatureNoticeReadinessSaleSeizedPropertyBase;
    }
    /**
     * Set SignatureNoticeReadinessSaleSeizedPropertyBase value
     * @param string $signatureNoticeReadinessSaleSeizedPropertyBase
     * @return \AisFssp\StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setSignatureNoticeReadinessSaleSeizedPropertyBase($signatureNoticeReadinessSaleSeizedPropertyBase = null)
    {
        // validation for constraint: string
        if (!is_null($signatureNoticeReadinessSaleSeizedPropertyBase) && !is_string($signatureNoticeReadinessSaleSeizedPropertyBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signatureNoticeReadinessSaleSeizedPropertyBase)), __LINE__);
        }
        $this->SignatureNoticeReadinessSaleSeizedPropertyBase = $signatureNoticeReadinessSaleSeizedPropertyBase;
        return $this;
    }
    /**
     * Get IP value
     * @return \AisFssp\StructType\IP|null
     */
    public function getIP()
    {
        return $this->IP;
    }
    /**
     * Set IP value
     * @param \AisFssp\StructType\IP $iP
     * @return \AisFssp\StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setIP(\AisFssp\StructType\IP $iP = null)
    {
        $this->IP = $iP;
        return $this;
    }
    /**
     * Get attachments value
     * @return \AisFssp\StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @return \AisFssp\StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setAttachments(array $attachments = array())
    {
        foreach ($attachments as $noticeReadinessSaleSeizedPropertyAttachmentsItem) {
            // validation for constraint: itemType
            if (!$noticeReadinessSaleSeizedPropertyAttachmentsItem instanceof \AisFssp\StructType\AttachmentType) {
                throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($noticeReadinessSaleSeizedPropertyAttachmentsItem) ? get_class($noticeReadinessSaleSeizedPropertyAttachmentsItem) : gettype($noticeReadinessSaleSeizedPropertyAttachmentsItem)), __LINE__);
            }
        }
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType $item
     * @return \AisFssp\StructType\NoticeReadinessSaleSeizedProperty
     */
    public function addToAttachments(\AisFssp\StructType\AttachmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\AttachmentType) {
            throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\NoticeReadinessSaleSeizedProperty
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $noticeReadinessSaleSeizedPropertySignatureItem) {
            // validation for constraint: itemType
            if (!$noticeReadinessSaleSeizedPropertySignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($noticeReadinessSaleSeizedPropertySignatureItem) ? get_class($noticeReadinessSaleSeizedPropertySignatureItem) : gettype($noticeReadinessSaleSeizedPropertySignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\NoticeReadinessSaleSeizedProperty
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\NoticeReadinessSaleSeizedProperty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
