<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageResultCollection StructType
 * Meta informations extracted from the WSDL
 * - documentation: Результаты приема сообщений
 * @subpackage Structs
 */
class MessageResultCollection extends AbstractStructBase
{
    /**
     * The messageResult
     * Meta informations extracted from the WSDL
     * - documentation: Множество записей с результатами обработки сообщений.
     * - maxOccurs: unbounded
     * @var \AisFssp\StructType\MessageResult[]
     */
    public $messageResult;
    /**
     * Constructor method for MessageResultCollection
     * @uses MessageResultCollection::setMessageResult()
     * @param \AisFssp\StructType\MessageResult[] $messageResult
     */
    public function __construct(array $messageResult = array())
    {
        $this
            ->setMessageResult($messageResult);
    }
    /**
     * Get messageResult value
     * @return \AisFssp\StructType\MessageResult[]|null
     */
    public function getMessageResult()
    {
        return $this->messageResult;
    }
    /**
     * Set messageResult value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\MessageResult[] $messageResult
     * @return \AisFssp\StructType\MessageResultCollection
     */
    public function setMessageResult(array $messageResult = array())
    {
        foreach ($messageResult as $messageResultCollectionMessageResultItem) {
            // validation for constraint: itemType
            if (!$messageResultCollectionMessageResultItem instanceof \AisFssp\StructType\MessageResult) {
                throw new \InvalidArgumentException(sprintf('The messageResult property can only contain items of \AisFssp\StructType\MessageResult, "%s" given', is_object($messageResultCollectionMessageResultItem) ? get_class($messageResultCollectionMessageResultItem) : gettype($messageResultCollectionMessageResultItem)), __LINE__);
            }
        }
        $this->messageResult = $messageResult;
        return $this;
    }
    /**
     * Add item to messageResult value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\MessageResult $item
     * @return \AisFssp\StructType\MessageResultCollection
     */
    public function addToMessageResult(\AisFssp\StructType\MessageResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\MessageResult) {
            throw new \InvalidArgumentException(sprintf('The messageResult property can only contain items of \AisFssp\StructType\MessageResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->messageResult[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\MessageResultCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
