<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MachineDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о машине
 * @subpackage Structs
 */
class MachineDatumType extends InformationType
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: Тип машины
     * @var string
     */
    public $Type;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование машины (агрегата) | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Name;
    /**
     * The Kind
     * Meta informations extracted from the WSDL
     * - documentation: Вид машины (агрегата)
     * - minOccurs: 0
     * @var string
     */
    public $Kind;
    /**
     * The Subkind
     * Meta informations extracted from the WSDL
     * - documentation: Подвид машины (подвид)
     * - minOccurs: 0
     * @var string
     */
    public $Subkind;
    /**
     * The BrandName
     * Meta informations extracted from the WSDL
     * - documentation: Марка машины | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $BrandName;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - documentation: Категория машины | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Category;
    /**
     * The ModelName
     * Meta informations extracted from the WSDL
     * - documentation: Модель | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $ModelName;
    /**
     * The MadeYear
     * Meta informations extracted from the WSDL
     * - documentation: Год выпуска | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $MadeYear;
    /**
     * The Manufacturer
     * Meta informations extracted from the WSDL
     * - documentation: Предприятие-изготовитель | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Manufacturer;
    /**
     * The VIN
     * Meta informations extracted from the WSDL
     * - documentation: VIN | Код начисления УНИФО
     * - minOccurs: 0
     * - length: 17
     * @var string
     */
    public $VIN;
    /**
     * The ChassisNumber
     * Meta informations extracted from the WSDL
     * - documentation: Заводской № машины (рамы) | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $ChassisNumber;
    /**
     * The OKP
     * Meta informations extracted from the WSDL
     * - documentation: ОКП | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $OKP;
    /**
     * The EngineKind
     * Meta informations extracted from the WSDL
     * - documentation: Вид двигателя | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $EngineKind;
    /**
     * The EngineNumber
     * Meta informations extracted from the WSDL
     * - documentation: № двигателя | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $EngineNumber;
    /**
     * The EngineVolume
     * Meta informations extracted from the WSDL
     * - documentation: Рабочий объём двигателя, см3 | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EngineVolume;
    /**
     * The EnginePowerKWh
     * Meta informations extracted from the WSDL
     * - documentation: Мощность двигателя, киловатт | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EnginePowerKWh;
    /**
     * The EnginePowerHp
     * Meta informations extracted from the WSDL
     * - documentation: Мощность двигателя, лошадиных сил | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EnginePowerHp;
    /**
     * The TransmissionNumber
     * Meta informations extracted from the WSDL
     * - documentation: № КПП | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $TransmissionNumber;
    /**
     * The DrivingAxleNumber
     * Meta informations extracted from the WSDL
     * - documentation: № основного ведущего моста | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $DrivingAxleNumber;
    /**
     * The OtherMfgNumber
     * Meta informations extracted from the WSDL
     * - documentation: Прочие заводские номера | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $OtherMfgNumber;
    /**
     * The DesignWeight
     * Meta informations extracted from the WSDL
     * - documentation: Конструкционная масса, кг | Целое | Целое
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * @var int
     */
    public $DesignWeight;
    /**
     * The DesignSpeed
     * Meta informations extracted from the WSDL
     * - documentation: Максимальная конструктивная скорость, км/ч | Положительное короткое целое
     * - minOccurs: 0
     * - minInclusive: 1
     * @var int
     */
    public $DesignSpeed;
    /**
     * The Colour
     * Meta informations extracted from the WSDL
     * - documentation: Цвет | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Colour;
    /**
     * The RequireDoc
     * Meta informations extracted from the WSDL
     * - documentation: Документ подтверждения соответствия
     * - minOccurs: 0
     * @var string
     */
    public $RequireDoc;
    /**
     * The RequireDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа подтверждения соответствия | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $RequireDocNumber;
    /**
     * The RequireDocIssuer
     * Meta informations extracted from the WSDL
     * - documentation: Орган выдавший документ подтверждения соответствия | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $RequireDocIssuer;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - documentation: Особые отметки | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Notes;
    /**
     * The HasWritedOff
     * Meta informations extracted from the WSDL
     * - documentation: Списана | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $HasWritedOff;
    /**
     * The HasLost
     * Meta informations extracted from the WSDL
     * - documentation: Утеряна | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $HasLost;
    /**
     * The HasStealed
     * Meta informations extracted from the WSDL
     * - documentation: Похищена | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $HasStealed;
    /**
     * The HasRestricted
     * Meta informations extracted from the WSDL
     * - documentation: Ограничение | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $HasRestricted;
    /**
     * Constructor method for MachineDatumType
     * @uses MachineDatumType::setType()
     * @uses MachineDatumType::setName()
     * @uses MachineDatumType::setKind()
     * @uses MachineDatumType::setSubkind()
     * @uses MachineDatumType::setBrandName()
     * @uses MachineDatumType::setCategory()
     * @uses MachineDatumType::setModelName()
     * @uses MachineDatumType::setMadeYear()
     * @uses MachineDatumType::setManufacturer()
     * @uses MachineDatumType::setVIN()
     * @uses MachineDatumType::setChassisNumber()
     * @uses MachineDatumType::setOKP()
     * @uses MachineDatumType::setEngineKind()
     * @uses MachineDatumType::setEngineNumber()
     * @uses MachineDatumType::setEngineVolume()
     * @uses MachineDatumType::setEnginePowerKWh()
     * @uses MachineDatumType::setEnginePowerHp()
     * @uses MachineDatumType::setTransmissionNumber()
     * @uses MachineDatumType::setDrivingAxleNumber()
     * @uses MachineDatumType::setOtherMfgNumber()
     * @uses MachineDatumType::setDesignWeight()
     * @uses MachineDatumType::setDesignSpeed()
     * @uses MachineDatumType::setColour()
     * @uses MachineDatumType::setRequireDoc()
     * @uses MachineDatumType::setRequireDocNumber()
     * @uses MachineDatumType::setRequireDocIssuer()
     * @uses MachineDatumType::setNotes()
     * @uses MachineDatumType::setHasWritedOff()
     * @uses MachineDatumType::setHasLost()
     * @uses MachineDatumType::setHasStealed()
     * @uses MachineDatumType::setHasRestricted()
     * @param string $type
     * @param string $name
     * @param string $kind
     * @param string $subkind
     * @param string $brandName
     * @param string $category
     * @param string $modelName
     * @param string $madeYear
     * @param string $manufacturer
     * @param string $vIN
     * @param string $chassisNumber
     * @param string $oKP
     * @param string $engineKind
     * @param string $engineNumber
     * @param float $engineVolume
     * @param float $enginePowerKWh
     * @param float $enginePowerHp
     * @param string $transmissionNumber
     * @param string $drivingAxleNumber
     * @param string $otherMfgNumber
     * @param int $designWeight
     * @param int $designSpeed
     * @param string $colour
     * @param string $requireDoc
     * @param string $requireDocNumber
     * @param string $requireDocIssuer
     * @param string $notes
     * @param bool $hasWritedOff
     * @param bool $hasLost
     * @param bool $hasStealed
     * @param bool $hasRestricted
     */
    public function __construct($type = null, $name = null, $kind = null, $subkind = null, $brandName = null, $category = null, $modelName = null, $madeYear = null, $manufacturer = null, $vIN = null, $chassisNumber = null, $oKP = null, $engineKind = null, $engineNumber = null, $engineVolume = null, $enginePowerKWh = null, $enginePowerHp = null, $transmissionNumber = null, $drivingAxleNumber = null, $otherMfgNumber = null, $designWeight = null, $designSpeed = null, $colour = null, $requireDoc = null, $requireDocNumber = null, $requireDocIssuer = null, $notes = null, $hasWritedOff = null, $hasLost = null, $hasStealed = null, $hasRestricted = null)
    {
        $this
            ->setType($type)
            ->setName($name)
            ->setKind($kind)
            ->setSubkind($subkind)
            ->setBrandName($brandName)
            ->setCategory($category)
            ->setModelName($modelName)
            ->setMadeYear($madeYear)
            ->setManufacturer($manufacturer)
            ->setVIN($vIN)
            ->setChassisNumber($chassisNumber)
            ->setOKP($oKP)
            ->setEngineKind($engineKind)
            ->setEngineNumber($engineNumber)
            ->setEngineVolume($engineVolume)
            ->setEnginePowerKWh($enginePowerKWh)
            ->setEnginePowerHp($enginePowerHp)
            ->setTransmissionNumber($transmissionNumber)
            ->setDrivingAxleNumber($drivingAxleNumber)
            ->setOtherMfgNumber($otherMfgNumber)
            ->setDesignWeight($designWeight)
            ->setDesignSpeed($designSpeed)
            ->setColour($colour)
            ->setRequireDoc($requireDoc)
            ->setRequireDocNumber($requireDocNumber)
            ->setRequireDocIssuer($requireDocIssuer)
            ->setNotes($notes)
            ->setHasWritedOff($hasWritedOff)
            ->setHasLost($hasLost)
            ->setHasStealed($hasStealed)
            ->setHasRestricted($hasRestricted);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \AisFssp\EnumType\MachineType::valueIsValid()
     * @uses \AisFssp\EnumType\MachineType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\MachineType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \AisFssp\EnumType\MachineType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 1000) || (is_array($name) && count($name) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($name) && strlen($name) < 1) || (is_array($name) && count($name) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Kind value
     * @return string|null
     */
    public function getKind()
    {
        return $this->Kind;
    }
    /**
     * Set Kind value
     * @uses \AisFssp\EnumType\MachineKind::valueIsValid()
     * @uses \AisFssp\EnumType\MachineKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kind
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setKind($kind = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\MachineKind::valueIsValid($kind)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $kind, implode(', ', \AisFssp\EnumType\MachineKind::getValidValues())), __LINE__);
        }
        $this->Kind = $kind;
        return $this;
    }
    /**
     * Get Subkind value
     * @return string|null
     */
    public function getSubkind()
    {
        return $this->Subkind;
    }
    /**
     * Set Subkind value
     * @uses \AisFssp\EnumType\MachineSubkind::valueIsValid()
     * @uses \AisFssp\EnumType\MachineSubkind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subkind
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setSubkind($subkind = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\MachineSubkind::valueIsValid($subkind)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subkind, implode(', ', \AisFssp\EnumType\MachineSubkind::getValidValues())), __LINE__);
        }
        $this->Subkind = $subkind;
        return $this;
    }
    /**
     * Get BrandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param string $brandName
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setBrandName($brandName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($brandName) && strlen($brandName) > 50) || (is_array($brandName) && count($brandName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($brandName) ? strlen($brandName) : count($brandName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($brandName) && strlen($brandName) < 1) || (is_array($brandName) && count($brandName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($brandName) && !is_string($brandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brandName)), __LINE__);
        }
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setCategory($category = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($category) && strlen($category) > 50) || (is_array($category) && count($category) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($category) ? strlen($category) : count($category)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($category) && strlen($category) < 1) || (is_array($category) && count($category) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get ModelName value
     * @return string|null
     */
    public function getModelName()
    {
        return $this->ModelName;
    }
    /**
     * Set ModelName value
     * @param string $modelName
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setModelName($modelName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($modelName) && strlen($modelName) > 50) || (is_array($modelName) && count($modelName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($modelName) ? strlen($modelName) : count($modelName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($modelName) && strlen($modelName) < 1) || (is_array($modelName) && count($modelName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($modelName) && !is_string($modelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelName)), __LINE__);
        }
        $this->ModelName = $modelName;
        return $this;
    }
    /**
     * Get MadeYear value
     * @return string|null
     */
    public function getMadeYear()
    {
        return $this->MadeYear;
    }
    /**
     * Set MadeYear value
     * @param string $madeYear
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setMadeYear($madeYear = null)
    {
        // validation for constraint: maxInclusive
        if ($madeYear > 2099) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2099, "%s" given', $madeYear), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($madeYear < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $madeYear), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($madeYear) && !is_string($madeYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($madeYear)), __LINE__);
        }
        $this->MadeYear = $madeYear;
        return $this;
    }
    /**
     * Get Manufacturer value
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->Manufacturer;
    }
    /**
     * Set Manufacturer value
     * @param string $manufacturer
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setManufacturer($manufacturer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($manufacturer) && strlen($manufacturer) > 300) || (is_array($manufacturer) && count($manufacturer) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($manufacturer) ? strlen($manufacturer) : count($manufacturer)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($manufacturer) && strlen($manufacturer) < 1) || (is_array($manufacturer) && count($manufacturer) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($manufacturer) && !is_string($manufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manufacturer)), __LINE__);
        }
        $this->Manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get VIN value
     * @return string|null
     */
    public function getVIN()
    {
        return $this->VIN;
    }
    /**
     * Set VIN value
     * @param string $vIN
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setVIN($vIN = null)
    {
        // validation for constraint: length
        if ((is_scalar($vIN) && strlen($vIN) !== 17) || (is_array($vIN) && count($vIN) !== 17)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 17 element(s) or a scalar of 17 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vIN) && !is_string($vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vIN)), __LINE__);
        }
        $this->VIN = $vIN;
        return $this;
    }
    /**
     * Get ChassisNumber value
     * @return string|null
     */
    public function getChassisNumber()
    {
        return $this->ChassisNumber;
    }
    /**
     * Set ChassisNumber value
     * @param string $chassisNumber
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setChassisNumber($chassisNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chassisNumber) && strlen($chassisNumber) > 50) || (is_array($chassisNumber) && count($chassisNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($chassisNumber) ? strlen($chassisNumber) : count($chassisNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($chassisNumber) && strlen($chassisNumber) < 1) || (is_array($chassisNumber) && count($chassisNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chassisNumber) && !is_string($chassisNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chassisNumber)), __LINE__);
        }
        $this->ChassisNumber = $chassisNumber;
        return $this;
    }
    /**
     * Get OKP value
     * @return string|null
     */
    public function getOKP()
    {
        return $this->OKP;
    }
    /**
     * Set OKP value
     * @param string $oKP
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setOKP($oKP = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oKP) && strlen($oKP) > 50) || (is_array($oKP) && count($oKP) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($oKP) ? strlen($oKP) : count($oKP)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($oKP) && strlen($oKP) < 1) || (is_array($oKP) && count($oKP) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oKP) && !is_string($oKP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oKP)), __LINE__);
        }
        $this->OKP = $oKP;
        return $this;
    }
    /**
     * Get EngineKind value
     * @return string|null
     */
    public function getEngineKind()
    {
        return $this->EngineKind;
    }
    /**
     * Set EngineKind value
     * @param string $engineKind
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setEngineKind($engineKind = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($engineKind) && strlen($engineKind) > 50) || (is_array($engineKind) && count($engineKind) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($engineKind) ? strlen($engineKind) : count($engineKind)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($engineKind) && strlen($engineKind) < 1) || (is_array($engineKind) && count($engineKind) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($engineKind) && !is_string($engineKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($engineKind)), __LINE__);
        }
        $this->EngineKind = $engineKind;
        return $this;
    }
    /**
     * Get EngineNumber value
     * @return string|null
     */
    public function getEngineNumber()
    {
        return $this->EngineNumber;
    }
    /**
     * Set EngineNumber value
     * @param string $engineNumber
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setEngineNumber($engineNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($engineNumber) && strlen($engineNumber) > 50) || (is_array($engineNumber) && count($engineNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($engineNumber) ? strlen($engineNumber) : count($engineNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($engineNumber) && strlen($engineNumber) < 1) || (is_array($engineNumber) && count($engineNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($engineNumber) && !is_string($engineNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($engineNumber)), __LINE__);
        }
        $this->EngineNumber = $engineNumber;
        return $this;
    }
    /**
     * Get EngineVolume value
     * @return float|null
     */
    public function getEngineVolume()
    {
        return $this->EngineVolume;
    }
    /**
     * Set EngineVolume value
     * @param float $engineVolume
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setEngineVolume($engineVolume = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($engineVolume) && strlen(substr($engineVolume, strpos($engineVolume, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($engineVolume, strpos($engineVolume, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($engineVolume) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $engineVolume)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($engineVolume, strpos($engineVolume, '.')))), __LINE__);
        }
        $this->EngineVolume = $engineVolume;
        return $this;
    }
    /**
     * Get EnginePowerKWh value
     * @return float|null
     */
    public function getEnginePowerKWh()
    {
        return $this->EnginePowerKWh;
    }
    /**
     * Set EnginePowerKWh value
     * @param float $enginePowerKWh
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setEnginePowerKWh($enginePowerKWh = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($enginePowerKWh) && strlen(substr($enginePowerKWh, strpos($enginePowerKWh, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($enginePowerKWh, strpos($enginePowerKWh, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($enginePowerKWh) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $enginePowerKWh)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($enginePowerKWh, strpos($enginePowerKWh, '.')))), __LINE__);
        }
        $this->EnginePowerKWh = $enginePowerKWh;
        return $this;
    }
    /**
     * Get EnginePowerHp value
     * @return float|null
     */
    public function getEnginePowerHp()
    {
        return $this->EnginePowerHp;
    }
    /**
     * Set EnginePowerHp value
     * @param float $enginePowerHp
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setEnginePowerHp($enginePowerHp = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($enginePowerHp) && strlen(substr($enginePowerHp, strpos($enginePowerHp, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($enginePowerHp, strpos($enginePowerHp, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($enginePowerHp) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $enginePowerHp)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($enginePowerHp, strpos($enginePowerHp, '.')))), __LINE__);
        }
        $this->EnginePowerHp = $enginePowerHp;
        return $this;
    }
    /**
     * Get TransmissionNumber value
     * @return string|null
     */
    public function getTransmissionNumber()
    {
        return $this->TransmissionNumber;
    }
    /**
     * Set TransmissionNumber value
     * @param string $transmissionNumber
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setTransmissionNumber($transmissionNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($transmissionNumber) && strlen($transmissionNumber) > 50) || (is_array($transmissionNumber) && count($transmissionNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($transmissionNumber) ? strlen($transmissionNumber) : count($transmissionNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($transmissionNumber) && strlen($transmissionNumber) < 1) || (is_array($transmissionNumber) && count($transmissionNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transmissionNumber) && !is_string($transmissionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transmissionNumber)), __LINE__);
        }
        $this->TransmissionNumber = $transmissionNumber;
        return $this;
    }
    /**
     * Get DrivingAxleNumber value
     * @return string|null
     */
    public function getDrivingAxleNumber()
    {
        return $this->DrivingAxleNumber;
    }
    /**
     * Set DrivingAxleNumber value
     * @param string $drivingAxleNumber
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setDrivingAxleNumber($drivingAxleNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($drivingAxleNumber) && strlen($drivingAxleNumber) > 50) || (is_array($drivingAxleNumber) && count($drivingAxleNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($drivingAxleNumber) ? strlen($drivingAxleNumber) : count($drivingAxleNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($drivingAxleNumber) && strlen($drivingAxleNumber) < 1) || (is_array($drivingAxleNumber) && count($drivingAxleNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($drivingAxleNumber) && !is_string($drivingAxleNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($drivingAxleNumber)), __LINE__);
        }
        $this->DrivingAxleNumber = $drivingAxleNumber;
        return $this;
    }
    /**
     * Get OtherMfgNumber value
     * @return string|null
     */
    public function getOtherMfgNumber()
    {
        return $this->OtherMfgNumber;
    }
    /**
     * Set OtherMfgNumber value
     * @param string $otherMfgNumber
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setOtherMfgNumber($otherMfgNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($otherMfgNumber) && strlen($otherMfgNumber) > 50) || (is_array($otherMfgNumber) && count($otherMfgNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($otherMfgNumber) ? strlen($otherMfgNumber) : count($otherMfgNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($otherMfgNumber) && strlen($otherMfgNumber) < 1) || (is_array($otherMfgNumber) && count($otherMfgNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($otherMfgNumber) && !is_string($otherMfgNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherMfgNumber)), __LINE__);
        }
        $this->OtherMfgNumber = $otherMfgNumber;
        return $this;
    }
    /**
     * Get DesignWeight value
     * @return int|null
     */
    public function getDesignWeight()
    {
        return $this->DesignWeight;
    }
    /**
     * Set DesignWeight value
     * @param int $designWeight
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setDesignWeight($designWeight = null)
    {
        // validation for constraint: maxInclusive
        if ($designWeight > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $designWeight), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($designWeight) && !is_numeric($designWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($designWeight)), __LINE__);
        }
        $this->DesignWeight = $designWeight;
        return $this;
    }
    /**
     * Get DesignSpeed value
     * @return int|null
     */
    public function getDesignSpeed()
    {
        return $this->DesignSpeed;
    }
    /**
     * Set DesignSpeed value
     * @param int $designSpeed
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setDesignSpeed($designSpeed = null)
    {
        // validation for constraint: minInclusive
        if ($designSpeed < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $designSpeed), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($designSpeed) && !is_numeric($designSpeed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($designSpeed)), __LINE__);
        }
        $this->DesignSpeed = $designSpeed;
        return $this;
    }
    /**
     * Get Colour value
     * @return string|null
     */
    public function getColour()
    {
        return $this->Colour;
    }
    /**
     * Set Colour value
     * @param string $colour
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setColour($colour = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($colour) && strlen($colour) > 50) || (is_array($colour) && count($colour) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($colour) ? strlen($colour) : count($colour)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($colour) && strlen($colour) < 1) || (is_array($colour) && count($colour) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($colour) && !is_string($colour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($colour)), __LINE__);
        }
        $this->Colour = $colour;
        return $this;
    }
    /**
     * Get RequireDoc value
     * @return string|null
     */
    public function getRequireDoc()
    {
        return $this->RequireDoc;
    }
    /**
     * Set RequireDoc value
     * @uses \AisFssp\EnumType\RequirementsDocType::valueIsValid()
     * @uses \AisFssp\EnumType\RequirementsDocType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requireDoc
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setRequireDoc($requireDoc = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\RequirementsDocType::valueIsValid($requireDoc)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $requireDoc, implode(', ', \AisFssp\EnumType\RequirementsDocType::getValidValues())), __LINE__);
        }
        $this->RequireDoc = $requireDoc;
        return $this;
    }
    /**
     * Get RequireDocNumber value
     * @return string|null
     */
    public function getRequireDocNumber()
    {
        return $this->RequireDocNumber;
    }
    /**
     * Set RequireDocNumber value
     * @param string $requireDocNumber
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setRequireDocNumber($requireDocNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requireDocNumber) && strlen($requireDocNumber) > 25) || (is_array($requireDocNumber) && count($requireDocNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($requireDocNumber) ? strlen($requireDocNumber) : count($requireDocNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requireDocNumber) && strlen($requireDocNumber) < 1) || (is_array($requireDocNumber) && count($requireDocNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requireDocNumber) && !is_string($requireDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requireDocNumber)), __LINE__);
        }
        $this->RequireDocNumber = $requireDocNumber;
        return $this;
    }
    /**
     * Get RequireDocIssuer value
     * @return string|null
     */
    public function getRequireDocIssuer()
    {
        return $this->RequireDocIssuer;
    }
    /**
     * Set RequireDocIssuer value
     * @param string $requireDocIssuer
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setRequireDocIssuer($requireDocIssuer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requireDocIssuer) && strlen($requireDocIssuer) > 300) || (is_array($requireDocIssuer) && count($requireDocIssuer) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($requireDocIssuer) ? strlen($requireDocIssuer) : count($requireDocIssuer)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requireDocIssuer) && strlen($requireDocIssuer) < 1) || (is_array($requireDocIssuer) && count($requireDocIssuer) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requireDocIssuer) && !is_string($requireDocIssuer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requireDocIssuer)), __LINE__);
        }
        $this->RequireDocIssuer = $requireDocIssuer;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($notes) && strlen($notes) > 1000) || (is_array($notes) && count($notes) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($notes) ? strlen($notes) : count($notes)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($notes) && strlen($notes) < 1) || (is_array($notes) && count($notes) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get HasWritedOff value
     * @return bool|null
     */
    public function getHasWritedOff()
    {
        return $this->HasWritedOff;
    }
    /**
     * Set HasWritedOff value
     * @param bool $hasWritedOff
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setHasWritedOff($hasWritedOff = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasWritedOff) && !is_bool($hasWritedOff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasWritedOff)), __LINE__);
        }
        $this->HasWritedOff = $hasWritedOff;
        return $this;
    }
    /**
     * Get HasLost value
     * @return bool|null
     */
    public function getHasLost()
    {
        return $this->HasLost;
    }
    /**
     * Set HasLost value
     * @param bool $hasLost
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setHasLost($hasLost = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasLost) && !is_bool($hasLost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasLost)), __LINE__);
        }
        $this->HasLost = $hasLost;
        return $this;
    }
    /**
     * Get HasStealed value
     * @return bool|null
     */
    public function getHasStealed()
    {
        return $this->HasStealed;
    }
    /**
     * Set HasStealed value
     * @param bool $hasStealed
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setHasStealed($hasStealed = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasStealed) && !is_bool($hasStealed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasStealed)), __LINE__);
        }
        $this->HasStealed = $hasStealed;
        return $this;
    }
    /**
     * Get HasRestricted value
     * @return bool|null
     */
    public function getHasRestricted()
    {
        return $this->HasRestricted;
    }
    /**
     * Set HasRestricted value
     * @param bool $hasRestricted
     * @return \AisFssp\StructType\MachineDatumType
     */
    public function setHasRestricted($hasRestricted = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasRestricted) && !is_bool($hasRestricted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasRestricted)), __LINE__);
        }
        $this->HasRestricted = $hasRestricted;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\MachineDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
