<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LookupTableData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Данные справочника | Записи данных одного справочника | Данные справочника
 * @subpackage Structs
 */
class LookupTableData extends AbstractStructBase
{
    /**
     * The caption
     * Meta informations extracted from the WSDL
     * - documentation: Заголовок справочника | Заголовок
     * - use: required
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $caption;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The lookupTable
     * Meta informations extracted from the WSDL
     * - documentation: Тип справочника
     * - minOccurs: 0
     * @var string
     */
    public $lookupTable;
    /**
     * The filter
     * Meta informations extracted from the WSDL
     * - documentation: Дополнительное условие | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $filter;
    /**
     * The osp
     * Meta informations extracted from the WSDL
     * - documentation: Отдел судебных приставов
     * @var \AisFssp\StructType\OspProperty
     */
    public $osp;
    /**
     * The idDocType
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа, удостоверяющего личность
     * @var \AisFssp\StructType\IdDocTypeProperty
     */
    public $idDocType;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - documentation: Валюта
     * @var \AisFssp\StructType\CurrencyProperty
     */
    public $currency;
    /**
     * The pievFormat
     * Meta informations extracted from the WSDL
     * - documentation: Версии форматов ПИЭВ
     * @var \AisFssp\StructType\PievFormatVersion
     */
    public $pievFormat;
    /**
     * Constructor method for LookupTableData
     * @uses LookupTableData::setCaption()
     * @uses LookupTableData::setAny()
     * @uses LookupTableData::setLookupTable()
     * @uses LookupTableData::setFilter()
     * @uses LookupTableData::setOsp()
     * @uses LookupTableData::setIdDocType()
     * @uses LookupTableData::setCurrency()
     * @uses LookupTableData::setPievFormat()
     * @param string $caption
     * @param \DOMDocument $any
     * @param string $lookupTable
     * @param string $filter
     * @param \AisFssp\StructType\OspProperty $osp
     * @param \AisFssp\StructType\IdDocTypeProperty $idDocType
     * @param \AisFssp\StructType\CurrencyProperty $currency
     * @param \AisFssp\StructType\PievFormatVersion $pievFormat
     */
    public function __construct($caption = null, \DOMDocument $any = null, $lookupTable = null, $filter = null, \AisFssp\StructType\OspProperty $osp = null, \AisFssp\StructType\IdDocTypeProperty $idDocType = null, \AisFssp\StructType\CurrencyProperty $currency = null, \AisFssp\StructType\PievFormatVersion $pievFormat = null)
    {
        $this
            ->setCaption($caption)
            ->setAny($any)
            ->setLookupTable($lookupTable)
            ->setFilter($filter)
            ->setOsp($osp)
            ->setIdDocType($idDocType)
            ->setCurrency($currency)
            ->setPievFormat($pievFormat);
    }
    /**
     * Get caption value
     * @return string
     */
    public function getCaption()
    {
        return $this->caption;
    }
    /**
     * Set caption value
     * @param string $caption
     * @return \AisFssp\StructType\LookupTableData
     */
    public function setCaption($caption = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($caption) && strlen($caption) > 80) || (is_array($caption) && count($caption) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($caption) ? strlen($caption) : count($caption)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($caption) && strlen($caption) < 1) || (is_array($caption) && count($caption) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($caption) && !is_string($caption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($caption)), __LINE__);
        }
        $this->caption = $caption;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \AisFssp\StructType\LookupTableData::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \AisFssp\StructType\LookupTableData
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Get lookupTable value
     * @return string|null
     */
    public function getLookupTable()
    {
        return $this->lookupTable;
    }
    /**
     * Set lookupTable value
     * @uses \AisFssp\EnumType\LookupTableType::valueIsValid()
     * @uses \AisFssp\EnumType\LookupTableType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lookupTable
     * @return \AisFssp\StructType\LookupTableData
     */
    public function setLookupTable($lookupTable = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\LookupTableType::valueIsValid($lookupTable)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $lookupTable, implode(', ', \AisFssp\EnumType\LookupTableType::getValidValues())), __LINE__);
        }
        $this->lookupTable = $lookupTable;
        return $this;
    }
    /**
     * Get filter value
     * @return string|null
     */
    public function getFilter()
    {
        return $this->filter;
    }
    /**
     * Set filter value
     * @param string $filter
     * @return \AisFssp\StructType\LookupTableData
     */
    public function setFilter($filter = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($filter) && strlen($filter) > 1000) || (is_array($filter) && count($filter) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($filter) ? strlen($filter) : count($filter)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($filter) && strlen($filter) < 1) || (is_array($filter) && count($filter) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($filter) && !is_string($filter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filter)), __LINE__);
        }
        $this->filter = $filter;
        return $this;
    }
    /**
     * Get osp value
     * @return \AisFssp\StructType\OspProperty|null
     */
    public function getOsp()
    {
        return $this->osp;
    }
    /**
     * Set osp value
     * @param \AisFssp\StructType\OspProperty $osp
     * @return \AisFssp\StructType\LookupTableData
     */
    public function setOsp(\AisFssp\StructType\OspProperty $osp = null)
    {
        $this->osp = $osp;
        return $this;
    }
    /**
     * Get idDocType value
     * @return \AisFssp\StructType\IdDocTypeProperty|null
     */
    public function getIdDocType()
    {
        return $this->idDocType;
    }
    /**
     * Set idDocType value
     * @param \AisFssp\StructType\IdDocTypeProperty $idDocType
     * @return \AisFssp\StructType\LookupTableData
     */
    public function setIdDocType(\AisFssp\StructType\IdDocTypeProperty $idDocType = null)
    {
        $this->idDocType = $idDocType;
        return $this;
    }
    /**
     * Get currency value
     * @return \AisFssp\StructType\CurrencyProperty|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \AisFssp\StructType\CurrencyProperty $currency
     * @return \AisFssp\StructType\LookupTableData
     */
    public function setCurrency(\AisFssp\StructType\CurrencyProperty $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get pievFormat value
     * @return \AisFssp\StructType\PievFormatVersion|null
     */
    public function getPievFormat()
    {
        return $this->pievFormat;
    }
    /**
     * Set pievFormat value
     * @param \AisFssp\StructType\PievFormatVersion $pievFormat
     * @return \AisFssp\StructType\LookupTableData
     */
    public function setPievFormat(\AisFssp\StructType\PievFormatVersion $pievFormat = null)
    {
        $this->pievFormat = $pievFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\LookupTableData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
