<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvestigationDataInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Информация об исполнительных производствах по реестру долга
 * - type: tns:InvestigationDataInfo
 * @subpackage Structs
 */
class InvestigationDataInfo extends AbstractStructBase
{
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The registryKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор записи | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $registryKey;
    /**
     * The ospCode
     * Meta informations extracted from the WSDL
     * - documentation: Код отдела | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $ospCode;
    /**
     * The invData
     * Meta informations extracted from the WSDL
     * - documentation: Дата розыска | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $invData;
    /**
     * The issueNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер розыска | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $issueNumber;
    /**
     * The IPNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNum;
    /**
     * The ip
     * Meta informations extracted from the WSDL
     * - documentation: ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\IPExt[]
     */
    public $ip;
    /**
     * Constructor method for InvestigationDataInfo
     * @uses InvestigationDataInfo::setInternalKey()
     * @uses InvestigationDataInfo::setRegistryKey()
     * @uses InvestigationDataInfo::setOspCode()
     * @uses InvestigationDataInfo::setInvData()
     * @uses InvestigationDataInfo::setIssueNumber()
     * @uses InvestigationDataInfo::setIPNum()
     * @uses InvestigationDataInfo::setIp()
     * @param int $internalKey
     * @param int $registryKey
     * @param string $ospCode
     * @param string $invData
     * @param string $issueNumber
     * @param string $iPNum
     * @param \AisFssp\StructType\IPExt[] $ip
     */
    public function __construct($internalKey = null, $registryKey = null, $ospCode = null, $invData = null, $issueNumber = null, $iPNum = null, array $ip = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setRegistryKey($registryKey)
            ->setOspCode($ospCode)
            ->setInvData($invData)
            ->setIssueNumber($issueNumber)
            ->setIPNum($iPNum)
            ->setIp($ip);
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\InvestigationDataInfo
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get registryKey value
     * @return int|null
     */
    public function getRegistryKey()
    {
        return $this->registryKey;
    }
    /**
     * Set registryKey value
     * @param int $registryKey
     * @return \AisFssp\StructType\InvestigationDataInfo
     */
    public function setRegistryKey($registryKey = null)
    {
        // validation for constraint: maxInclusive
        if ($registryKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $registryKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($registryKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $registryKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($registryKey) && !is_numeric($registryKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($registryKey)), __LINE__);
        }
        $this->registryKey = $registryKey;
        return $this;
    }
    /**
     * Get ospCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->ospCode;
    }
    /**
     * Set ospCode value
     * @param string $ospCode
     * @return \AisFssp\StructType\InvestigationDataInfo
     */
    public function setOspCode($ospCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($ospCode) && strlen($ospCode) !== 5) || (is_array($ospCode) && count($ospCode) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($ospCode) && !preg_match('/[0-9]{5}/', $ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($ospCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ospCode) && !is_string($ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ospCode)), __LINE__);
        }
        $this->ospCode = $ospCode;
        return $this;
    }
    /**
     * Get invData value
     * @return string|null
     */
    public function getInvData()
    {
        return $this->invData;
    }
    /**
     * Set invData value
     * @param string $invData
     * @return \AisFssp\StructType\InvestigationDataInfo
     */
    public function setInvData($invData = null)
    {
        // validation for constraint: maxExclusive
        if ($invData >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $invData), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($invData < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $invData), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invData) && !is_string($invData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invData)), __LINE__);
        }
        $this->invData = $invData;
        return $this;
    }
    /**
     * Get issueNumber value
     * @return string|null
     */
    public function getIssueNumber()
    {
        return $this->issueNumber;
    }
    /**
     * Set issueNumber value
     * @param string $issueNumber
     * @return \AisFssp\StructType\InvestigationDataInfo
     */
    public function setIssueNumber($issueNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($issueNumber) && strlen($issueNumber) > 25) || (is_array($issueNumber) && count($issueNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($issueNumber) ? strlen($issueNumber) : count($issueNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($issueNumber) && strlen($issueNumber) < 1) || (is_array($issueNumber) && count($issueNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($issueNumber) && !is_string($issueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issueNumber)), __LINE__);
        }
        $this->issueNumber = $issueNumber;
        return $this;
    }
    /**
     * Get IPNum value
     * @return string|null
     */
    public function getIPNum()
    {
        return $this->IPNum;
    }
    /**
     * Set IPNum value
     * @param string $iPNum
     * @return \AisFssp\StructType\InvestigationDataInfo
     */
    public function setIPNum($iPNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iPNum) && strlen($iPNum) > 25) || (is_array($iPNum) && count($iPNum) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($iPNum) ? strlen($iPNum) : count($iPNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iPNum) && strlen($iPNum) < 1) || (is_array($iPNum) && count($iPNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPNum) && !is_string($iPNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPNum)), __LINE__);
        }
        $this->IPNum = $iPNum;
        return $this;
    }
    /**
     * Get ip value
     * @return \AisFssp\StructType\IPExt[]|null
     */
    public function getIp()
    {
        return $this->ip;
    }
    /**
     * Set ip value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPExt[] $ip
     * @return \AisFssp\StructType\InvestigationDataInfo
     */
    public function setIp(array $ip = array())
    {
        foreach ($ip as $investigationDataInfoIpItem) {
            // validation for constraint: itemType
            if (!$investigationDataInfoIpItem instanceof \AisFssp\StructType\IPExt) {
                throw new \InvalidArgumentException(sprintf('The ip property can only contain items of \AisFssp\StructType\IPExt, "%s" given', is_object($investigationDataInfoIpItem) ? get_class($investigationDataInfoIpItem) : gettype($investigationDataInfoIpItem)), __LINE__);
            }
        }
        $this->ip = $ip;
        return $this;
    }
    /**
     * Add item to ip value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPExt $item
     * @return \AisFssp\StructType\InvestigationDataInfo
     */
    public function addToIp(\AisFssp\StructType\IPExt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\IPExt) {
            throw new \InvalidArgumentException(sprintf('The ip property can only contain items of \AisFssp\StructType\IPExt, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ip[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\InvestigationDataInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
