<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvestigationData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Данные о разыскиваемом лице
 * - type: tns:InvestigationData
 * @subpackage Structs
 */
class InvestigationData extends AbstractStructBase
{
    /**
     * The ospCode
     * Meta informations extracted from the WSDL
     * - documentation: Код отдела | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $ospCode;
    /**
     * The registryKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор записи | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $registryKey;
    /**
     * The unloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время выгрузки | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $unloadDate;
    /**
     * The ipNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $ipNumber;
    /**
     * The ipRiseDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ИП | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ipRiseDate;
    /**
     * The ipNumberComp
     * Meta informations extracted from the WSDL
     * - documentation: Номер сводного ИП | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $ipNumberComp;
    /**
     * The invCategory
     * Meta informations extracted from the WSDL
     * - documentation: Категория розыска | Категория розыска
     * - length: 1
     * @var string
     */
    public $invCategory;
    /**
     * The invDate
     * Meta informations extracted from the WSDL
     * - documentation: Розыск объявлен | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $invDate;
    /**
     * The issueNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер дела | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $issueNumber;
    /**
     * The investigatedName
     * Meta informations extracted from the WSDL
     * - documentation: Разыскивается (лицо) | Полное имя физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $investigatedName;
    /**
     * The investigatedOrgName
     * Meta informations extracted from the WSDL
     * - documentation: Разыскивается (организация) | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $investigatedOrgName;
    /**
     * The birthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $birthDate;
    /**
     * The birthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $birthYear;
    /**
     * The parentName
     * Meta informations extracted from the WSDL
     * - documentation: Родитель | Полное имя физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $parentName;
    /**
     * The parentBirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения родителя | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $parentBirthDate;
    /**
     * The parentBirthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения родителя | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $parentBirthYear;
    /**
     * The debtorAddress
     * Meta informations extracted from the WSDL
     * - documentation: Адрес организации | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $debtorAddress;
    /**
     * The INN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН должника | ИНН
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $INN;
    /**
     * The SNILS
     * Meta informations extracted from the WSDL
     * - documentation: СНИЛС должника | СНИЛС
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $SNILS;
    /**
     * The PHOTO
     * Meta informations extracted from the WSDL
     * - documentation: Фотография должника | Заполняется закодированным в формате BASE64 фотоизображением должника, находящимся во вложении с типом
     * «Фотография» разыскного дела.
     * - minOccurs: 0
     * @var string
     */
    public $PHOTO;
    /**
     * Constructor method for InvestigationData
     * @uses InvestigationData::setOspCode()
     * @uses InvestigationData::setRegistryKey()
     * @uses InvestigationData::setUnloadDate()
     * @uses InvestigationData::setIpNumber()
     * @uses InvestigationData::setIpRiseDate()
     * @uses InvestigationData::setIpNumberComp()
     * @uses InvestigationData::setInvCategory()
     * @uses InvestigationData::setInvDate()
     * @uses InvestigationData::setIssueNumber()
     * @uses InvestigationData::setInvestigatedName()
     * @uses InvestigationData::setInvestigatedOrgName()
     * @uses InvestigationData::setBirthDate()
     * @uses InvestigationData::setBirthYear()
     * @uses InvestigationData::setParentName()
     * @uses InvestigationData::setParentBirthDate()
     * @uses InvestigationData::setParentBirthYear()
     * @uses InvestigationData::setDebtorAddress()
     * @uses InvestigationData::setINN()
     * @uses InvestigationData::setSNILS()
     * @uses InvestigationData::setPHOTO()
     * @param string $ospCode
     * @param int $registryKey
     * @param string $unloadDate
     * @param string $ipNumber
     * @param string $ipRiseDate
     * @param string $ipNumberComp
     * @param string $invCategory
     * @param string $invDate
     * @param string $issueNumber
     * @param string $investigatedName
     * @param string $investigatedOrgName
     * @param string $birthDate
     * @param string $birthYear
     * @param string $parentName
     * @param string $parentBirthDate
     * @param string $parentBirthYear
     * @param string $debtorAddress
     * @param string $iNN
     * @param string $sNILS
     * @param string $pHOTO
     */
    public function __construct($ospCode = null, $registryKey = null, $unloadDate = null, $ipNumber = null, $ipRiseDate = null, $ipNumberComp = null, $invCategory = null, $invDate = null, $issueNumber = null, $investigatedName = null, $investigatedOrgName = null, $birthDate = null, $birthYear = null, $parentName = null, $parentBirthDate = null, $parentBirthYear = null, $debtorAddress = null, $iNN = null, $sNILS = null, $pHOTO = null)
    {
        $this
            ->setOspCode($ospCode)
            ->setRegistryKey($registryKey)
            ->setUnloadDate($unloadDate)
            ->setIpNumber($ipNumber)
            ->setIpRiseDate($ipRiseDate)
            ->setIpNumberComp($ipNumberComp)
            ->setInvCategory($invCategory)
            ->setInvDate($invDate)
            ->setIssueNumber($issueNumber)
            ->setInvestigatedName($investigatedName)
            ->setInvestigatedOrgName($investigatedOrgName)
            ->setBirthDate($birthDate)
            ->setBirthYear($birthYear)
            ->setParentName($parentName)
            ->setParentBirthDate($parentBirthDate)
            ->setParentBirthYear($parentBirthYear)
            ->setDebtorAddress($debtorAddress)
            ->setINN($iNN)
            ->setSNILS($sNILS)
            ->setPHOTO($pHOTO);
    }
    /**
     * Get ospCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->ospCode;
    }
    /**
     * Set ospCode value
     * @param string $ospCode
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setOspCode($ospCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($ospCode) && strlen($ospCode) !== 5) || (is_array($ospCode) && count($ospCode) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($ospCode) && !preg_match('/[0-9]{5}/', $ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($ospCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ospCode) && !is_string($ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ospCode)), __LINE__);
        }
        $this->ospCode = $ospCode;
        return $this;
    }
    /**
     * Get registryKey value
     * @return int|null
     */
    public function getRegistryKey()
    {
        return $this->registryKey;
    }
    /**
     * Set registryKey value
     * @param int $registryKey
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setRegistryKey($registryKey = null)
    {
        // validation for constraint: maxInclusive
        if ($registryKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $registryKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($registryKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $registryKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($registryKey) && !is_numeric($registryKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($registryKey)), __LINE__);
        }
        $this->registryKey = $registryKey;
        return $this;
    }
    /**
     * Get unloadDate value
     * @return string|null
     */
    public function getUnloadDate()
    {
        return $this->unloadDate;
    }
    /**
     * Set unloadDate value
     * @param string $unloadDate
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setUnloadDate($unloadDate = null)
    {
        // validation for constraint: maxExclusive
        if ($unloadDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $unloadDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($unloadDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $unloadDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unloadDate) && !is_string($unloadDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unloadDate)), __LINE__);
        }
        $this->unloadDate = $unloadDate;
        return $this;
    }
    /**
     * Get ipNumber value
     * @return string|null
     */
    public function getIpNumber()
    {
        return $this->ipNumber;
    }
    /**
     * Set ipNumber value
     * @param string $ipNumber
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setIpNumber($ipNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ipNumber) && strlen($ipNumber) > 25) || (is_array($ipNumber) && count($ipNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($ipNumber) ? strlen($ipNumber) : count($ipNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ipNumber) && strlen($ipNumber) < 1) || (is_array($ipNumber) && count($ipNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ipNumber) && !is_string($ipNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipNumber)), __LINE__);
        }
        $this->ipNumber = $ipNumber;
        return $this;
    }
    /**
     * Get ipRiseDate value
     * @return string|null
     */
    public function getIpRiseDate()
    {
        return $this->ipRiseDate;
    }
    /**
     * Set ipRiseDate value
     * @param string $ipRiseDate
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setIpRiseDate($ipRiseDate = null)
    {
        // validation for constraint: maxExclusive
        if ($ipRiseDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $ipRiseDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($ipRiseDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $ipRiseDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ipRiseDate) && !is_string($ipRiseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipRiseDate)), __LINE__);
        }
        $this->ipRiseDate = $ipRiseDate;
        return $this;
    }
    /**
     * Get ipNumberComp value
     * @return string|null
     */
    public function getIpNumberComp()
    {
        return $this->ipNumberComp;
    }
    /**
     * Set ipNumberComp value
     * @param string $ipNumberComp
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setIpNumberComp($ipNumberComp = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ipNumberComp) && strlen($ipNumberComp) > 25) || (is_array($ipNumberComp) && count($ipNumberComp) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($ipNumberComp) ? strlen($ipNumberComp) : count($ipNumberComp)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ipNumberComp) && strlen($ipNumberComp) < 1) || (is_array($ipNumberComp) && count($ipNumberComp) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ipNumberComp) && !is_string($ipNumberComp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipNumberComp)), __LINE__);
        }
        $this->ipNumberComp = $ipNumberComp;
        return $this;
    }
    /**
     * Get invCategory value
     * @return string|null
     */
    public function getInvCategory()
    {
        return $this->invCategory;
    }
    /**
     * Set invCategory value
     * @param string $invCategory
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setInvCategory($invCategory = null)
    {
        // validation for constraint: length
        if ((is_scalar($invCategory) && strlen($invCategory) !== 1) || (is_array($invCategory) && count($invCategory) !== 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invCategory) && !is_string($invCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invCategory)), __LINE__);
        }
        $this->invCategory = $invCategory;
        return $this;
    }
    /**
     * Get invDate value
     * @return string|null
     */
    public function getInvDate()
    {
        return $this->invDate;
    }
    /**
     * Set invDate value
     * @param string $invDate
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setInvDate($invDate = null)
    {
        // validation for constraint: maxExclusive
        if ($invDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $invDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($invDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $invDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invDate) && !is_string($invDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invDate)), __LINE__);
        }
        $this->invDate = $invDate;
        return $this;
    }
    /**
     * Get issueNumber value
     * @return string|null
     */
    public function getIssueNumber()
    {
        return $this->issueNumber;
    }
    /**
     * Set issueNumber value
     * @param string $issueNumber
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setIssueNumber($issueNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($issueNumber) && strlen($issueNumber) > 25) || (is_array($issueNumber) && count($issueNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($issueNumber) ? strlen($issueNumber) : count($issueNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($issueNumber) && strlen($issueNumber) < 1) || (is_array($issueNumber) && count($issueNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($issueNumber) && !is_string($issueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issueNumber)), __LINE__);
        }
        $this->issueNumber = $issueNumber;
        return $this;
    }
    /**
     * Get investigatedName value
     * @return string|null
     */
    public function getInvestigatedName()
    {
        return $this->investigatedName;
    }
    /**
     * Set investigatedName value
     * @param string $investigatedName
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setInvestigatedName($investigatedName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($investigatedName) && strlen($investigatedName) > 100) || (is_array($investigatedName) && count($investigatedName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($investigatedName) ? strlen($investigatedName) : count($investigatedName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($investigatedName) && strlen($investigatedName) < 1) || (is_array($investigatedName) && count($investigatedName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($investigatedName) && !is_string($investigatedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($investigatedName)), __LINE__);
        }
        $this->investigatedName = $investigatedName;
        return $this;
    }
    /**
     * Get investigatedOrgName value
     * @return string|null
     */
    public function getInvestigatedOrgName()
    {
        return $this->investigatedOrgName;
    }
    /**
     * Set investigatedOrgName value
     * @param string $investigatedOrgName
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setInvestigatedOrgName($investigatedOrgName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($investigatedOrgName) && strlen($investigatedOrgName) > 1000) || (is_array($investigatedOrgName) && count($investigatedOrgName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($investigatedOrgName) ? strlen($investigatedOrgName) : count($investigatedOrgName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($investigatedOrgName) && strlen($investigatedOrgName) < 1) || (is_array($investigatedOrgName) && count($investigatedOrgName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($investigatedOrgName) && !is_string($investigatedOrgName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($investigatedOrgName)), __LINE__);
        }
        $this->investigatedOrgName = $investigatedOrgName;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: maxExclusive
        if ($birthDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $birthDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($birthDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $birthDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Get birthYear value
     * @return string|null
     */
    public function getBirthYear()
    {
        return $this->birthYear;
    }
    /**
     * Set birthYear value
     * @param string $birthYear
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setBirthYear($birthYear = null)
    {
        // validation for constraint: maxInclusive
        if ($birthYear > 2099) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2099, "%s" given', $birthYear), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($birthYear < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $birthYear), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($birthYear) && !is_string($birthYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthYear)), __LINE__);
        }
        $this->birthYear = $birthYear;
        return $this;
    }
    /**
     * Get parentName value
     * @return string|null
     */
    public function getParentName()
    {
        return $this->parentName;
    }
    /**
     * Set parentName value
     * @param string $parentName
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setParentName($parentName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($parentName) && strlen($parentName) > 100) || (is_array($parentName) && count($parentName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($parentName) ? strlen($parentName) : count($parentName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($parentName) && strlen($parentName) < 1) || (is_array($parentName) && count($parentName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parentName) && !is_string($parentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parentName)), __LINE__);
        }
        $this->parentName = $parentName;
        return $this;
    }
    /**
     * Get parentBirthDate value
     * @return string|null
     */
    public function getParentBirthDate()
    {
        return $this->parentBirthDate;
    }
    /**
     * Set parentBirthDate value
     * @param string $parentBirthDate
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setParentBirthDate($parentBirthDate = null)
    {
        // validation for constraint: maxExclusive
        if ($parentBirthDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $parentBirthDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($parentBirthDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $parentBirthDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parentBirthDate) && !is_string($parentBirthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parentBirthDate)), __LINE__);
        }
        $this->parentBirthDate = $parentBirthDate;
        return $this;
    }
    /**
     * Get parentBirthYear value
     * @return string|null
     */
    public function getParentBirthYear()
    {
        return $this->parentBirthYear;
    }
    /**
     * Set parentBirthYear value
     * @param string $parentBirthYear
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setParentBirthYear($parentBirthYear = null)
    {
        // validation for constraint: maxInclusive
        if ($parentBirthYear > 2099) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2099, "%s" given', $parentBirthYear), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($parentBirthYear < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $parentBirthYear), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parentBirthYear) && !is_string($parentBirthYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parentBirthYear)), __LINE__);
        }
        $this->parentBirthYear = $parentBirthYear;
        return $this;
    }
    /**
     * Get debtorAddress value
     * @return string|null
     */
    public function getDebtorAddress()
    {
        return $this->debtorAddress;
    }
    /**
     * Set debtorAddress value
     * @param string $debtorAddress
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setDebtorAddress($debtorAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorAddress) && strlen($debtorAddress) > 300) || (is_array($debtorAddress) && count($debtorAddress) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($debtorAddress) ? strlen($debtorAddress) : count($debtorAddress)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorAddress) && strlen($debtorAddress) < 1) || (is_array($debtorAddress) && count($debtorAddress) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorAddress) && !is_string($debtorAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorAddress)), __LINE__);
        }
        $this->debtorAddress = $debtorAddress;
        return $this;
    }
    /**
     * Get INN value
     * @return string|null
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setINN($iNN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iNN) && strlen($iNN) > 12) || (is_array($iNN) && count($iNN) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($iNN) ? strlen($iNN) : count($iNN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iNN) && strlen($iNN) < 10) || (is_array($iNN) && count($iNN) < 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($iNN) && !preg_match('/(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})/', $iNN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})", "%s" given', var_export($iNN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iNN) && !is_string($iNN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNN)), __LINE__);
        }
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get SNILS value
     * @return string|null
     */
    public function getSNILS()
    {
        return $this->SNILS;
    }
    /**
     * Set SNILS value
     * @param string $sNILS
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setSNILS($sNILS = null)
    {
        // validation for constraint: length
        if ((is_scalar($sNILS) && strlen($sNILS) !== 11) || (is_array($sNILS) && count($sNILS) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($sNILS) && !preg_match('/[0-9]{11}/', $sNILS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{11}", "%s" given', var_export($sNILS, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sNILS) && !is_string($sNILS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sNILS)), __LINE__);
        }
        $this->SNILS = $sNILS;
        return $this;
    }
    /**
     * Get PHOTO value
     * @return string|null
     */
    public function getPHOTO()
    {
        return $this->PHOTO;
    }
    /**
     * Set PHOTO value
     * @param string $pHOTO
     * @return \AisFssp\StructType\InvestigationData
     */
    public function setPHOTO($pHOTO = null)
    {
        // validation for constraint: string
        if (!is_null($pHOTO) && !is_string($pHOTO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pHOTO)), __LINE__);
        }
        $this->PHOTO = $pHOTO;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\InvestigationData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
