<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InquiryMessage StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос интерактивный (синхронный) | ЭЦП | Технологическая ЭЦП (накладывается сервером, формирующим сообщение)
 * @subpackage Structs
 */
class InquiryMessage extends SyncRq
{
    /**
     * The debtorIPListRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос реестра ИП по должнику
     * @var \AisFssp\StructType\DebtorIPListRequestType
     */
    public $debtorIPListRequest;
    /**
     * The IPSideRequestExistence
     * Meta informations extracted from the WSDL
     * - documentation: Регистрация запроса о наличии ИП
     * @var \AisFssp\StructType\IPSideRequestExistenceType
     */
    public $IPSideRequestExistence;
    /**
     * The IPSideRequestCourseID
     * Meta informations extracted from the WSDL
     * - documentation: Регистрация запроса о ходе ИП по исполнительному документу
     * @var \AisFssp\StructType\IPSideRequestCourseIDType
     */
    public $IPSideRequestCourseID;
    /**
     * The IPSideRequestCourseIP
     * Meta informations extracted from the WSDL
     * - documentation: Регистрация запроса о ходе ИП по номеру ИП
     * @var \AisFssp\StructType\IPSideRequestCourseIPType
     */
    public $IPSideRequestCourseIP;
    /**
     * The IPReqAppResultRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос на получение ответов на заявления или запросы в ОСП
     * @var \AisFssp\StructType\IPReqAppResultRequestType
     */
    public $IPReqAppResultRequest;
    /**
     * The IPBriefInfoRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос сведений ИП по номеру ИП
     * @var \AisFssp\StructType\IPBriefInfoRequestType
     */
    public $IPBriefInfoRequest;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for InquiryMessage
     * @uses InquiryMessage::setDebtorIPListRequest()
     * @uses InquiryMessage::setIPSideRequestExistence()
     * @uses InquiryMessage::setIPSideRequestCourseID()
     * @uses InquiryMessage::setIPSideRequestCourseIP()
     * @uses InquiryMessage::setIPReqAppResultRequest()
     * @uses InquiryMessage::setIPBriefInfoRequest()
     * @uses InquiryMessage::setSignature()
     * @param \AisFssp\StructType\DebtorIPListRequestType $debtorIPListRequest
     * @param \AisFssp\StructType\IPSideRequestExistenceType $iPSideRequestExistence
     * @param \AisFssp\StructType\IPSideRequestCourseIDType $iPSideRequestCourseID
     * @param \AisFssp\StructType\IPSideRequestCourseIPType $iPSideRequestCourseIP
     * @param \AisFssp\StructType\IPReqAppResultRequestType $iPReqAppResultRequest
     * @param \AisFssp\StructType\IPBriefInfoRequestType $iPBriefInfoRequest
     * @param \AisFssp\StructType\SignatureType[] $signature
     */
    public function __construct(\AisFssp\StructType\DebtorIPListRequestType $debtorIPListRequest = null, \AisFssp\StructType\IPSideRequestExistenceType $iPSideRequestExistence = null, \AisFssp\StructType\IPSideRequestCourseIDType $iPSideRequestCourseID = null, \AisFssp\StructType\IPSideRequestCourseIPType $iPSideRequestCourseIP = null, \AisFssp\StructType\IPReqAppResultRequestType $iPReqAppResultRequest = null, \AisFssp\StructType\IPBriefInfoRequestType $iPBriefInfoRequest = null, array $signature = array())
    {
        $this
            ->setDebtorIPListRequest($debtorIPListRequest)
            ->setIPSideRequestExistence($iPSideRequestExistence)
            ->setIPSideRequestCourseID($iPSideRequestCourseID)
            ->setIPSideRequestCourseIP($iPSideRequestCourseIP)
            ->setIPReqAppResultRequest($iPReqAppResultRequest)
            ->setIPBriefInfoRequest($iPBriefInfoRequest)
            ->setSignature($signature);
    }
    /**
     * Get debtorIPListRequest value
     * @return \AisFssp\StructType\DebtorIPListRequestType|null
     */
    public function getDebtorIPListRequest()
    {
        return $this->debtorIPListRequest;
    }
    /**
     * Set debtorIPListRequest value
     * @param \AisFssp\StructType\DebtorIPListRequestType $debtorIPListRequest
     * @return \AisFssp\StructType\InquiryMessage
     */
    public function setDebtorIPListRequest(\AisFssp\StructType\DebtorIPListRequestType $debtorIPListRequest = null)
    {
        $this->debtorIPListRequest = $debtorIPListRequest;
        return $this;
    }
    /**
     * Get IPSideRequestExistence value
     * @return \AisFssp\StructType\IPSideRequestExistenceType|null
     */
    public function getIPSideRequestExistence()
    {
        return $this->IPSideRequestExistence;
    }
    /**
     * Set IPSideRequestExistence value
     * @param \AisFssp\StructType\IPSideRequestExistenceType $iPSideRequestExistence
     * @return \AisFssp\StructType\InquiryMessage
     */
    public function setIPSideRequestExistence(\AisFssp\StructType\IPSideRequestExistenceType $iPSideRequestExistence = null)
    {
        $this->IPSideRequestExistence = $iPSideRequestExistence;
        return $this;
    }
    /**
     * Get IPSideRequestCourseID value
     * @return \AisFssp\StructType\IPSideRequestCourseIDType|null
     */
    public function getIPSideRequestCourseID()
    {
        return $this->IPSideRequestCourseID;
    }
    /**
     * Set IPSideRequestCourseID value
     * @param \AisFssp\StructType\IPSideRequestCourseIDType $iPSideRequestCourseID
     * @return \AisFssp\StructType\InquiryMessage
     */
    public function setIPSideRequestCourseID(\AisFssp\StructType\IPSideRequestCourseIDType $iPSideRequestCourseID = null)
    {
        $this->IPSideRequestCourseID = $iPSideRequestCourseID;
        return $this;
    }
    /**
     * Get IPSideRequestCourseIP value
     * @return \AisFssp\StructType\IPSideRequestCourseIPType|null
     */
    public function getIPSideRequestCourseIP()
    {
        return $this->IPSideRequestCourseIP;
    }
    /**
     * Set IPSideRequestCourseIP value
     * @param \AisFssp\StructType\IPSideRequestCourseIPType $iPSideRequestCourseIP
     * @return \AisFssp\StructType\InquiryMessage
     */
    public function setIPSideRequestCourseIP(\AisFssp\StructType\IPSideRequestCourseIPType $iPSideRequestCourseIP = null)
    {
        $this->IPSideRequestCourseIP = $iPSideRequestCourseIP;
        return $this;
    }
    /**
     * Get IPReqAppResultRequest value
     * @return \AisFssp\StructType\IPReqAppResultRequestType|null
     */
    public function getIPReqAppResultRequest()
    {
        return $this->IPReqAppResultRequest;
    }
    /**
     * Set IPReqAppResultRequest value
     * @param \AisFssp\StructType\IPReqAppResultRequestType $iPReqAppResultRequest
     * @return \AisFssp\StructType\InquiryMessage
     */
    public function setIPReqAppResultRequest(\AisFssp\StructType\IPReqAppResultRequestType $iPReqAppResultRequest = null)
    {
        $this->IPReqAppResultRequest = $iPReqAppResultRequest;
        return $this;
    }
    /**
     * Get IPBriefInfoRequest value
     * @return \AisFssp\StructType\IPBriefInfoRequestType|null
     */
    public function getIPBriefInfoRequest()
    {
        return $this->IPBriefInfoRequest;
    }
    /**
     * Set IPBriefInfoRequest value
     * @param \AisFssp\StructType\IPBriefInfoRequestType $iPBriefInfoRequest
     * @return \AisFssp\StructType\InquiryMessage
     */
    public function setIPBriefInfoRequest(\AisFssp\StructType\IPBriefInfoRequestType $iPBriefInfoRequest = null)
    {
        $this->IPBriefInfoRequest = $iPBriefInfoRequest;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\InquiryMessage
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $inquiryMessageSignatureItem) {
            // validation for constraint: itemType
            if (!$inquiryMessageSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($inquiryMessageSignatureItem) ? get_class($inquiryMessageSignatureItem) : gettype($inquiryMessageSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\InquiryMessage
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\InquiryMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
