<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InformationDocument StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о документе
 * - type: tns:InformationDocument
 * @subpackage Structs
 */
class InformationDocument extends AbstractStructBase
{
    /**
     * The Organization
     * Meta informations extracted from the WSDL
     * - documentation: Код отправителя | Код отправителя | Код организации | NSI_MVV_Organization
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $Organization;
    /**
     * The Department
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения отправителя | Код подразделения отправителя | Код подразделения организации | NSI_MVV_Department
     * - minOccurs: 0
     * - maxLength: 320
     * - minLength: 1
     * @var string
     */
    public $Department;
    /**
     * The OrganizationRecipient
     * Meta informations extracted from the WSDL
     * - documentation: Код получателя | Код получателя | Код организации | NSI_MVV_Organization
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $OrganizationRecipient;
    /**
     * The DepartmentRecipient
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения получателя | Код подразделения получателя | Код подразделения организации | NSI_MVV_Department
     * - minOccurs: 0
     * - maxLength: 320
     * - minLength: 1
     * @var string
     */
    public $DepartmentRecipient;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа отправителя | Идентификатор документа отправителя | Идентификатор объекта, присвоенный объекту АИС
     * внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в
     * пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ID;
    /**
     * The IncomingDocKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор входящего документа | Идентификатор входящего документа в рамках которого подготавливается документ (ответ) |
     * Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным
     * для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $IncomingDocKey;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: Код типа документа | Код типа документа согласно классификатору документов АИС ФССП России | Тип документа АИС ФССП России (тип
     * документа ПКОСП) | Тип документа электронного документооборота | NSI_Document | Наименование объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $Type;
    /**
     * The DocumentDate
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационная дата документа | Регистрационная дата отправляемого документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocumentDate;
    /**
     * The DocumentNumber
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер документа | Регистрационный номер отправляемого документа, в случае отсутствия может указываться
     * идентификатор в соответствии с размерностью поля | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocumentNumber;
    /**
     * The DocumentCaseNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер дела | Номер дела | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $DocumentCaseNumber;
    /**
     * The Filename
     * Meta informations extracted from the WSDL
     * - documentation: Имя файла | Имя передаваемого файла (zip-архива) | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $Filename;
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - documentation: Данные документа | В элементе передаются данные файла (контент вложения) в Base64, например: zip-архив
     * @var string
     */
    public $Content;
    /**
     * The IsUnstructuredFormat
     * Meta informations extracted from the WSDL
     * - documentation: Формат вложения структурированный | Устанавливается в значение true, если вложение (передается в элементе «Данные документа»)
     * имеет структурированный формат. Поле обязательно для заполнения, если документ передается между контрагентами в рамках обмена по видам
     * сведения ФССП России начиная с версии 1.1.0 | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $IsUnstructuredFormat;
    /**
     * The IsZippedPacket
     * Meta informations extracted from the WSDL
     * - documentation: Содержимое вложения упаковано Zip-алгоритмом | Устанавливается в true в случае, если вложение (передается в элементе «Данные
     * документа») упаковано Zip-алгоритмом. Поле обязательно для заполнения, если документ передается между контрагентами в рамках обмена по
     * видам сведения ФССП России начиная с версии 1.1.0 | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $IsZippedPacket;
    /**
     * The StructuredFormatType
     * Meta informations extracted from the WSDL
     * - documentation: Пространство имен структурированного формата | Указывается пространство имен для вложений, имеющих структурированный формат.
     * Поле обязательно для заполнения, если документ передается между контрагентами в рамках обмена по видам сведения ФССП России начиная с
     * версии 1.1.0
     * - minOccurs: 0
     * @var string
     */
    public $StructuredFormatType;
    /**
     * Constructor method for InformationDocument
     * @uses InformationDocument::setOrganization()
     * @uses InformationDocument::setDepartment()
     * @uses InformationDocument::setOrganizationRecipient()
     * @uses InformationDocument::setDepartmentRecipient()
     * @uses InformationDocument::setID()
     * @uses InformationDocument::setIncomingDocKey()
     * @uses InformationDocument::setType()
     * @uses InformationDocument::setDocumentDate()
     * @uses InformationDocument::setDocumentNumber()
     * @uses InformationDocument::setDocumentCaseNumber()
     * @uses InformationDocument::setFilename()
     * @uses InformationDocument::setContent()
     * @uses InformationDocument::setIsUnstructuredFormat()
     * @uses InformationDocument::setIsZippedPacket()
     * @uses InformationDocument::setStructuredFormatType()
     * @param string $organization
     * @param string $department
     * @param string $organizationRecipient
     * @param string $departmentRecipient
     * @param string $iD
     * @param string $incomingDocKey
     * @param string $type
     * @param string $documentDate
     * @param string $documentNumber
     * @param string $documentCaseNumber
     * @param string $filename
     * @param string $content
     * @param bool $isUnstructuredFormat
     * @param bool $isZippedPacket
     * @param string $structuredFormatType
     */
    public function __construct($organization = null, $department = null, $organizationRecipient = null, $departmentRecipient = null, $iD = null, $incomingDocKey = null, $type = null, $documentDate = null, $documentNumber = null, $documentCaseNumber = null, $filename = null, $content = null, $isUnstructuredFormat = null, $isZippedPacket = null, $structuredFormatType = null)
    {
        $this
            ->setOrganization($organization)
            ->setDepartment($department)
            ->setOrganizationRecipient($organizationRecipient)
            ->setDepartmentRecipient($departmentRecipient)
            ->setID($iD)
            ->setIncomingDocKey($incomingDocKey)
            ->setType($type)
            ->setDocumentDate($documentDate)
            ->setDocumentNumber($documentNumber)
            ->setDocumentCaseNumber($documentCaseNumber)
            ->setFilename($filename)
            ->setContent($content)
            ->setIsUnstructuredFormat($isUnstructuredFormat)
            ->setIsZippedPacket($isZippedPacket)
            ->setStructuredFormatType($structuredFormatType);
    }
    /**
     * Get Organization value
     * @return string|null
     */
    public function getOrganization()
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @param string $organization
     * @return \AisFssp\StructType\InformationDocument
     */
    public function setOrganization($organization = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organization) && strlen($organization) > 20) || (is_array($organization) && count($organization) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($organization) ? strlen($organization) : count($organization)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($organization) && strlen($organization) < 1) || (is_array($organization) && count($organization) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organization) && !is_string($organization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organization)), __LINE__);
        }
        $this->Organization = $organization;
        return $this;
    }
    /**
     * Get Department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->Department;
    }
    /**
     * Set Department value
     * @param string $department
     * @return \AisFssp\StructType\InformationDocument
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($department) && strlen($department) > 320) || (is_array($department) && count($department) > 320)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 320 element(s) or a scalar of 320 character(s) at most, "%d" length given', is_scalar($department) ? strlen($department) : count($department)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($department) && strlen($department) < 1) || (is_array($department) && count($department) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($department)), __LINE__);
        }
        $this->Department = $department;
        return $this;
    }
    /**
     * Get OrganizationRecipient value
     * @return string|null
     */
    public function getOrganizationRecipient()
    {
        return $this->OrganizationRecipient;
    }
    /**
     * Set OrganizationRecipient value
     * @param string $organizationRecipient
     * @return \AisFssp\StructType\InformationDocument
     */
    public function setOrganizationRecipient($organizationRecipient = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organizationRecipient) && strlen($organizationRecipient) > 20) || (is_array($organizationRecipient) && count($organizationRecipient) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($organizationRecipient) ? strlen($organizationRecipient) : count($organizationRecipient)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($organizationRecipient) && strlen($organizationRecipient) < 1) || (is_array($organizationRecipient) && count($organizationRecipient) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organizationRecipient) && !is_string($organizationRecipient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organizationRecipient)), __LINE__);
        }
        $this->OrganizationRecipient = $organizationRecipient;
        return $this;
    }
    /**
     * Get DepartmentRecipient value
     * @return string|null
     */
    public function getDepartmentRecipient()
    {
        return $this->DepartmentRecipient;
    }
    /**
     * Set DepartmentRecipient value
     * @param string $departmentRecipient
     * @return \AisFssp\StructType\InformationDocument
     */
    public function setDepartmentRecipient($departmentRecipient = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($departmentRecipient) && strlen($departmentRecipient) > 320) || (is_array($departmentRecipient) && count($departmentRecipient) > 320)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 320 element(s) or a scalar of 320 character(s) at most, "%d" length given', is_scalar($departmentRecipient) ? strlen($departmentRecipient) : count($departmentRecipient)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($departmentRecipient) && strlen($departmentRecipient) < 1) || (is_array($departmentRecipient) && count($departmentRecipient) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($departmentRecipient) && !is_string($departmentRecipient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departmentRecipient)), __LINE__);
        }
        $this->DepartmentRecipient = $departmentRecipient;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \AisFssp\StructType\InformationDocument
     */
    public function setID($iD = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iD) && strlen($iD) > 60) || (is_array($iD) && count($iD) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($iD) ? strlen($iD) : count($iD)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iD) && strlen($iD) < 1) || (is_array($iD) && count($iD) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IncomingDocKey value
     * @return string|null
     */
    public function getIncomingDocKey()
    {
        return $this->IncomingDocKey;
    }
    /**
     * Set IncomingDocKey value
     * @param string $incomingDocKey
     * @return \AisFssp\StructType\InformationDocument
     */
    public function setIncomingDocKey($incomingDocKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($incomingDocKey) && strlen($incomingDocKey) > 60) || (is_array($incomingDocKey) && count($incomingDocKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($incomingDocKey) ? strlen($incomingDocKey) : count($incomingDocKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($incomingDocKey) && strlen($incomingDocKey) < 1) || (is_array($incomingDocKey) && count($incomingDocKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($incomingDocKey) && !is_string($incomingDocKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($incomingDocKey)), __LINE__);
        }
        $this->IncomingDocKey = $incomingDocKey;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \AisFssp\StructType\InformationDocument
     */
    public function setType($type = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($type) && strlen($type) > 1) || (is_array($type) && count($type) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($type) ? strlen($type) : count($type)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($type) && strlen($type) < 1) || (is_array($type) && count($type) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get DocumentDate value
     * @return string|null
     */
    public function getDocumentDate()
    {
        return $this->DocumentDate;
    }
    /**
     * Set DocumentDate value
     * @param string $documentDate
     * @return \AisFssp\StructType\InformationDocument
     */
    public function setDocumentDate($documentDate = null)
    {
        // validation for constraint: maxExclusive
        if ($documentDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $documentDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($documentDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $documentDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($documentDate) && !is_string($documentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentDate)), __LINE__);
        }
        $this->DocumentDate = $documentDate;
        return $this;
    }
    /**
     * Get DocumentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->DocumentNumber;
    }
    /**
     * Set DocumentNumber value
     * @param string $documentNumber
     * @return \AisFssp\StructType\InformationDocument
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($documentNumber) && strlen($documentNumber) > 25) || (is_array($documentNumber) && count($documentNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($documentNumber) ? strlen($documentNumber) : count($documentNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($documentNumber) && strlen($documentNumber) < 1) || (is_array($documentNumber) && count($documentNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentNumber)), __LINE__);
        }
        $this->DocumentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get DocumentCaseNumber value
     * @return string|null
     */
    public function getDocumentCaseNumber()
    {
        return $this->DocumentCaseNumber;
    }
    /**
     * Set DocumentCaseNumber value
     * @param string $documentCaseNumber
     * @return \AisFssp\StructType\InformationDocument
     */
    public function setDocumentCaseNumber($documentCaseNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($documentCaseNumber) && strlen($documentCaseNumber) > 50) || (is_array($documentCaseNumber) && count($documentCaseNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($documentCaseNumber) ? strlen($documentCaseNumber) : count($documentCaseNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($documentCaseNumber) && strlen($documentCaseNumber) < 1) || (is_array($documentCaseNumber) && count($documentCaseNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($documentCaseNumber) && !is_string($documentCaseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentCaseNumber)), __LINE__);
        }
        $this->DocumentCaseNumber = $documentCaseNumber;
        return $this;
    }
    /**
     * Get Filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->Filename;
    }
    /**
     * Set Filename value
     * @param string $filename
     * @return \AisFssp\StructType\InformationDocument
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($filename) && strlen($filename) > 100) || (is_array($filename) && count($filename) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($filename) ? strlen($filename) : count($filename)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($filename) && strlen($filename) < 1) || (is_array($filename) && count($filename) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filename)), __LINE__);
        }
        $this->Filename = $filename;
        return $this;
    }
    /**
     * Get Content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param string $content
     * @return \AisFssp\StructType\InformationDocument
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->Content = $content;
        return $this;
    }
    /**
     * Get IsUnstructuredFormat value
     * @return bool|null
     */
    public function getIsUnstructuredFormat()
    {
        return $this->IsUnstructuredFormat;
    }
    /**
     * Set IsUnstructuredFormat value
     * @param bool $isUnstructuredFormat
     * @return \AisFssp\StructType\InformationDocument
     */
    public function setIsUnstructuredFormat($isUnstructuredFormat = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUnstructuredFormat) && !is_bool($isUnstructuredFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isUnstructuredFormat)), __LINE__);
        }
        $this->IsUnstructuredFormat = $isUnstructuredFormat;
        return $this;
    }
    /**
     * Get IsZippedPacket value
     * @return bool|null
     */
    public function getIsZippedPacket()
    {
        return $this->IsZippedPacket;
    }
    /**
     * Set IsZippedPacket value
     * @param bool $isZippedPacket
     * @return \AisFssp\StructType\InformationDocument
     */
    public function setIsZippedPacket($isZippedPacket = null)
    {
        // validation for constraint: boolean
        if (!is_null($isZippedPacket) && !is_bool($isZippedPacket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isZippedPacket)), __LINE__);
        }
        $this->IsZippedPacket = $isZippedPacket;
        return $this;
    }
    /**
     * Get StructuredFormatType value
     * @return string|null
     */
    public function getStructuredFormatType()
    {
        return $this->StructuredFormatType;
    }
    /**
     * Set StructuredFormatType value
     * @param string $structuredFormatType
     * @return \AisFssp\StructType\InformationDocument
     */
    public function setStructuredFormatType($structuredFormatType = null)
    {
        // validation for constraint: string
        if (!is_null($structuredFormatType) && !is_string($structuredFormatType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($structuredFormatType)), __LINE__);
        }
        $this->StructuredFormatType = $structuredFormatType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\InformationDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
