<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncomingForcedExecDocumentBrief StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных документа «Входящий документ принудительного исполнения (краткая форма)» используется для предоставления
 * информации внешнему контрагенту о документе в составе списка документов.
 * - type: tns:IncomingForcedExecDocumentBrief
 * @subpackage Structs
 */
class IncomingForcedExecDocumentBrief extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа в АИС внешних контрагентов | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом
     * (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с
     * конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document | Наименование
     * объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $DocType;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The SideProperties
     * Meta informations extracted from the WSDL
     * - documentation: Реквизиты стороны ИП
     * @var \AisFssp\StructType\ContragentDatumType
     */
    public $SideProperties;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Статус заявления
     * @var string
     */
    public $Status;
    /**
     * Constructor method for IncomingForcedExecDocumentBrief
     * @uses IncomingForcedExecDocumentBrief::setExternalKey()
     * @uses IncomingForcedExecDocumentBrief::setDocType()
     * @uses IncomingForcedExecDocumentBrief::setDocNumber()
     * @uses IncomingForcedExecDocumentBrief::setDocDate()
     * @uses IncomingForcedExecDocumentBrief::setSideProperties()
     * @uses IncomingForcedExecDocumentBrief::setStatus()
     * @param string $externalKey
     * @param string $docType
     * @param string $docNumber
     * @param string $docDate
     * @param \AisFssp\StructType\ContragentDatumType $sideProperties
     * @param string $status
     */
    public function __construct($externalKey = null, $docType = null, $docNumber = null, $docDate = null, \AisFssp\StructType\ContragentDatumType $sideProperties = null, $status = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setDocType($docType)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setSideProperties($sideProperties)
            ->setStatus($status);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\IncomingForcedExecDocumentBrief
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \AisFssp\StructType\IncomingForcedExecDocumentBrief
     */
    public function setDocType($docType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docType) && strlen($docType) > 1) || (is_array($docType) && count($docType) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($docType) ? strlen($docType) : count($docType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docType) && strlen($docType) < 1) || (is_array($docType) && count($docType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docType) && !is_string($docType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docType)), __LINE__);
        }
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\IncomingForcedExecDocumentBrief
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\IncomingForcedExecDocumentBrief
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get SideProperties value
     * @return \AisFssp\StructType\ContragentDatumType|null
     */
    public function getSideProperties()
    {
        return $this->SideProperties;
    }
    /**
     * Set SideProperties value
     * @param \AisFssp\StructType\ContragentDatumType $sideProperties
     * @return \AisFssp\StructType\IncomingForcedExecDocumentBrief
     */
    public function setSideProperties(\AisFssp\StructType\ContragentDatumType $sideProperties = null)
    {
        $this->SideProperties = $sideProperties;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \AisFssp\EnumType\ApplicationStatus::valueIsValid()
     * @uses \AisFssp\EnumType\ApplicationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \AisFssp\StructType\IncomingForcedExecDocumentBrief
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ApplicationStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \AisFssp\EnumType\ApplicationStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IncomingForcedExecDocumentBrief
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
