<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdDocTypeProperty StructType
 * Meta informations extracted from the WSDL
 * - documentation: Код типа документа, удостоверяющего личность
 * @subpackage Structs
 */
class IdDocTypeProperty extends AbstractStructBase
{
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - documentation: Код вида документа | Код типа документа, удостоверяющего личность
     * - minOccurs: 0
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $code;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида документа | Строка длиной от 1 до 150 символов
     * - minOccurs: 0
     * - maxLength: 150
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Описание документа | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $description;
    /**
     * Constructor method for IdDocTypeProperty
     * @uses IdDocTypeProperty::setCode()
     * @uses IdDocTypeProperty::setName()
     * @uses IdDocTypeProperty::setDescription()
     * @param string $code
     * @param string $name
     * @param string $description
     */
    public function __construct($code = null, $name = null, $description = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setDescription($description);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \AisFssp\StructType\IdDocTypeProperty
     */
    public function setCode($code = null)
    {
        // validation for constraint: length
        if ((is_scalar($code) && strlen($code) !== 2) || (is_array($code) && count($code) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($code) && !preg_match('/[0-9]{2}/', $code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{2}", "%s" given', var_export($code, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \AisFssp\StructType\IdDocTypeProperty
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 150) || (is_array($name) && count($name) > 150)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 150 element(s) or a scalar of 150 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($name) && strlen($name) < 1) || (is_array($name) && count($name) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \AisFssp\StructType\IdDocTypeProperty
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 1000) || (is_array($description) && count($description) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($description) && strlen($description) < 1) || (is_array($description) && count($description) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IdDocTypeProperty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
