<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPReqAppResultReponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ IPReqAppResultReponseType «Ответы СПИ на запросы или заявления» | ЭП
 * - type: tns:IPReqAppResultReponseType
 * @subpackage Structs
 */
class IPReqAppResultReponseType extends AbstractStructBase
{
    /**
     * The requestKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ запроса | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор
     * должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $requestKey;
    /**
     * The responseKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ответа | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор
     * должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $responseKey;
    /**
     * The origin
     * Meta informations extracted from the WSDL
     * - documentation: Адрес отправителя запроса
     * - minOccurs: 0
     * @var \AisFssp\StructType\RedAddress
     */
    public $origin;
    /**
     * The docNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа ответа | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $docNumber;
    /**
     * The docDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа ответа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $docDate;
    /**
     * The appStatus
     * Meta informations extracted from the WSDL
     * - documentation: Код смены статуса заявления
     * @var string
     */
    public $appStatus;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IPReqAppResultReponseType
     * @uses IPReqAppResultReponseType::setRequestKey()
     * @uses IPReqAppResultReponseType::setResponseKey()
     * @uses IPReqAppResultReponseType::setOrigin()
     * @uses IPReqAppResultReponseType::setDocNumber()
     * @uses IPReqAppResultReponseType::setDocDate()
     * @uses IPReqAppResultReponseType::setAppStatus()
     * @uses IPReqAppResultReponseType::setSignature()
     * @uses IPReqAppResultReponseType::setId()
     * @param string $requestKey
     * @param string $responseKey
     * @param \AisFssp\StructType\RedAddress $origin
     * @param string $docNumber
     * @param string $docDate
     * @param string $appStatus
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($requestKey = null, $responseKey = null, \AisFssp\StructType\RedAddress $origin = null, $docNumber = null, $docDate = null, $appStatus = null, array $signature = array(), $id = null)
    {
        $this
            ->setRequestKey($requestKey)
            ->setResponseKey($responseKey)
            ->setOrigin($origin)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setAppStatus($appStatus)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get requestKey value
     * @return string|null
     */
    public function getRequestKey()
    {
        return $this->requestKey;
    }
    /**
     * Set requestKey value
     * @param string $requestKey
     * @return \AisFssp\StructType\IPReqAppResultReponseType
     */
    public function setRequestKey($requestKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestKey) && strlen($requestKey) > 60) || (is_array($requestKey) && count($requestKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($requestKey) ? strlen($requestKey) : count($requestKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestKey) && strlen($requestKey) < 1) || (is_array($requestKey) && count($requestKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestKey) && !is_string($requestKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestKey)), __LINE__);
        }
        $this->requestKey = $requestKey;
        return $this;
    }
    /**
     * Get responseKey value
     * @return string|null
     */
    public function getResponseKey()
    {
        return $this->responseKey;
    }
    /**
     * Set responseKey value
     * @param string $responseKey
     * @return \AisFssp\StructType\IPReqAppResultReponseType
     */
    public function setResponseKey($responseKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($responseKey) && strlen($responseKey) > 60) || (is_array($responseKey) && count($responseKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($responseKey) ? strlen($responseKey) : count($responseKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($responseKey) && strlen($responseKey) < 1) || (is_array($responseKey) && count($responseKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($responseKey) && !is_string($responseKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseKey)), __LINE__);
        }
        $this->responseKey = $responseKey;
        return $this;
    }
    /**
     * Get origin value
     * @return \AisFssp\StructType\RedAddress|null
     */
    public function getOrigin()
    {
        return $this->origin;
    }
    /**
     * Set origin value
     * @param \AisFssp\StructType\RedAddress $origin
     * @return \AisFssp\StructType\IPReqAppResultReponseType
     */
    public function setOrigin(\AisFssp\StructType\RedAddress $origin = null)
    {
        $this->origin = $origin;
        return $this;
    }
    /**
     * Get docNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->docNumber;
    }
    /**
     * Set docNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\IPReqAppResultReponseType
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->docNumber = $docNumber;
        return $this;
    }
    /**
     * Get docDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->docDate;
    }
    /**
     * Set docDate value
     * @param string $docDate
     * @return \AisFssp\StructType\IPReqAppResultReponseType
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->docDate = $docDate;
        return $this;
    }
    /**
     * Get appStatus value
     * @return string|null
     */
    public function getAppStatus()
    {
        return $this->appStatus;
    }
    /**
     * Set appStatus value
     * @uses \AisFssp\EnumType\ApplicationStatus::valueIsValid()
     * @uses \AisFssp\EnumType\ApplicationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appStatus
     * @return \AisFssp\StructType\IPReqAppResultReponseType
     */
    public function setAppStatus($appStatus = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ApplicationStatus::valueIsValid($appStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $appStatus, implode(', ', \AisFssp\EnumType\ApplicationStatus::getValidValues())), __LINE__);
        }
        $this->appStatus = $appStatus;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\IPReqAppResultReponseType
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $iPReqAppResultReponseTypeSignatureItem) {
            // validation for constraint: itemType
            if (!$iPReqAppResultReponseTypeSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($iPReqAppResultReponseTypeSignatureItem) ? get_class($iPReqAppResultReponseTypeSignatureItem) : gettype($iPReqAppResultReponseTypeSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\IPReqAppResultReponseType
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\IPReqAppResultReponseType
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IPReqAppResultReponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
