<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPExt StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных IPExt «Исполнительное производство (расширенное)»
 * @subpackage Structs
 */
class IPExt extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The DebtorType
     * Meta informations extracted from the WSDL
     * - documentation: Тип должника
     * @var string
     */
    public $DebtorType;
    /**
     * The DebtorName
     * Meta informations extracted from the WSDL
     * - documentation: ФИО полностью/наименование должника | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DebtorName;
    /**
     * The DebtorBirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения ФЛ | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DebtorBirthDate;
    /**
     * The DebtorBirthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения ФЛ | Год (выпуска, рождения и т. п.)
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $DebtorBirthYear;
    /**
     * The DebtorINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН ЮЛ/ИП | ИНН
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $DebtorINN;
    /**
     * The DebtorKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП | КПП
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $DebtorKPP;
    /**
     * The DebtorSnils
     * Meta informations extracted from the WSDL
     * - documentation: СНИЛС ФЛ | СНИЛС
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $DebtorSnils;
    /**
     * The DebtorAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес должника | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DebtorAdr;
    /**
     * The DebtorTelephone
     * Meta informations extracted from the WSDL
     * - documentation: Телефоный номер | Строка длиной от 1 до 16 символов
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $DebtorTelephone;
    /**
     * The IdExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор ИД АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $IdExternalKey;
    /**
     * The IDDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ИД | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IDDate;
    /**
     * The IDType
     * Meta informations extracted from the WSDL
     * - documentation: Тип ИД
     * @var string
     */
    public $IDType;
    /**
     * The IDSubj
     * Meta informations extracted from the WSDL
     * - documentation: Код предмета исполнения | Код предмета исполнения | NSI_IDoc_Subj_Exec
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $IDSubj;
    /**
     * The IDOrgName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование органа, выдавшего ИД | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $IDOrgName;
    /**
     * The CaseDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата дела | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $CaseDate;
    /**
     * The IPNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNum;
    /**
     * The IPDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата возбуждения ИП | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IPDate;
    /**
     * The IPNumComp
     * Meta informations extracted from the WSDL
     * - documentation: Номер сводного ИП | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNumComp;
    /**
     * The IDSum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма долга по ИД | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IDSum;
    /**
     * The IPDebtRestTotal
     * Meta informations extracted from the WSDL
     * - documentation: Остаток долга всего | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IPDebtRestTotal;
    /**
     * The IPDebtRestIp
     * Meta informations extracted from the WSDL
     * - documentation: Остаток основного долга по ИП | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IPDebtRestIp;
    /**
     * The IPDebtRestFine
     * Meta informations extracted from the WSDL
     * - documentation: Остаток основного долга по штрафу СПИ | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IPDebtRestFine;
    /**
     * The IPDebtRestDuty
     * Meta informations extracted from the WSDL
     * - documentation: Остаток задолженности по исполнительскому сбору | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IPDebtRestDuty;
    /**
     * The IPDebtRestBudg
     * Meta informations extracted from the WSDL
     * - documentation: Остаток задолженности по расходам по исполнительским действиям в бюджет | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IPDebtRestBudg;
    /**
     * The IPDebtRestOther
     * Meta informations extracted from the WSDL
     * - documentation: Остаток задолженности по расходам по исполнительским действиям третьим лицам | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IPDebtRestOther;
    /**
     * The IPPaymentDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата последнего поступления средств на депозитный счет по производству | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IPPaymentDate;
    /**
     * The IPPaymentAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма зачисленных, но не распределенных средств | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IPPaymentAmount;
    /**
     * The OSPCode
     * Meta informations extracted from the WSDL
     * - documentation: ОСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OSPCode;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ краткое | Строка длиной от 1 до 20 символов
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The SPITelephone
     * Meta informations extracted from the WSDL
     * - documentation: Телефон СПИ | Строка длиной от 1 до 18 символов
     * - maxLength: 18
     * - minLength: 1
     * @var string
     */
    public $SPITelephone;
    /**
     * Constructor method for IPExt
     * @uses IPExt::setInternalKey()
     * @uses IPExt::setDebtorType()
     * @uses IPExt::setDebtorName()
     * @uses IPExt::setDebtorBirthDate()
     * @uses IPExt::setDebtorBirthYear()
     * @uses IPExt::setDebtorINN()
     * @uses IPExt::setDebtorKPP()
     * @uses IPExt::setDebtorSnils()
     * @uses IPExt::setDebtorAdr()
     * @uses IPExt::setDebtorTelephone()
     * @uses IPExt::setIdExternalKey()
     * @uses IPExt::setIDDate()
     * @uses IPExt::setIDType()
     * @uses IPExt::setIDSubj()
     * @uses IPExt::setIDOrgName()
     * @uses IPExt::setCaseDate()
     * @uses IPExt::setIPNum()
     * @uses IPExt::setIPDate()
     * @uses IPExt::setIPNumComp()
     * @uses IPExt::setIDSum()
     * @uses IPExt::setIPDebtRestTotal()
     * @uses IPExt::setIPDebtRestIp()
     * @uses IPExt::setIPDebtRestFine()
     * @uses IPExt::setIPDebtRestDuty()
     * @uses IPExt::setIPDebtRestBudg()
     * @uses IPExt::setIPDebtRestOther()
     * @uses IPExt::setIPPaymentDate()
     * @uses IPExt::setIPPaymentAmount()
     * @uses IPExt::setOSPCode()
     * @uses IPExt::setSPIFio()
     * @uses IPExt::setSPITelephone()
     * @param int $internalKey
     * @param string $debtorType
     * @param string $debtorName
     * @param string $debtorBirthDate
     * @param string $debtorBirthYear
     * @param string $debtorINN
     * @param string $debtorKPP
     * @param string $debtorSnils
     * @param string $debtorAdr
     * @param string $debtorTelephone
     * @param string $idExternalKey
     * @param string $iDDate
     * @param string $iDType
     * @param string $iDSubj
     * @param string $iDOrgName
     * @param string $caseDate
     * @param string $iPNum
     * @param string $iPDate
     * @param string $iPNumComp
     * @param float $iDSum
     * @param float $iPDebtRestTotal
     * @param float $iPDebtRestIp
     * @param float $iPDebtRestFine
     * @param float $iPDebtRestDuty
     * @param float $iPDebtRestBudg
     * @param float $iPDebtRestOther
     * @param string $iPPaymentDate
     * @param float $iPPaymentAmount
     * @param string $oSPCode
     * @param string $sPIFio
     * @param string $sPITelephone
     */
    public function __construct($internalKey = null, $debtorType = null, $debtorName = null, $debtorBirthDate = null, $debtorBirthYear = null, $debtorINN = null, $debtorKPP = null, $debtorSnils = null, $debtorAdr = null, $debtorTelephone = null, $idExternalKey = null, $iDDate = null, $iDType = null, $iDSubj = null, $iDOrgName = null, $caseDate = null, $iPNum = null, $iPDate = null, $iPNumComp = null, $iDSum = null, $iPDebtRestTotal = null, $iPDebtRestIp = null, $iPDebtRestFine = null, $iPDebtRestDuty = null, $iPDebtRestBudg = null, $iPDebtRestOther = null, $iPPaymentDate = null, $iPPaymentAmount = null, $oSPCode = null, $sPIFio = null, $sPITelephone = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setDebtorType($debtorType)
            ->setDebtorName($debtorName)
            ->setDebtorBirthDate($debtorBirthDate)
            ->setDebtorBirthYear($debtorBirthYear)
            ->setDebtorINN($debtorINN)
            ->setDebtorKPP($debtorKPP)
            ->setDebtorSnils($debtorSnils)
            ->setDebtorAdr($debtorAdr)
            ->setDebtorTelephone($debtorTelephone)
            ->setIdExternalKey($idExternalKey)
            ->setIDDate($iDDate)
            ->setIDType($iDType)
            ->setIDSubj($iDSubj)
            ->setIDOrgName($iDOrgName)
            ->setCaseDate($caseDate)
            ->setIPNum($iPNum)
            ->setIPDate($iPDate)
            ->setIPNumComp($iPNumComp)
            ->setIDSum($iDSum)
            ->setIPDebtRestTotal($iPDebtRestTotal)
            ->setIPDebtRestIp($iPDebtRestIp)
            ->setIPDebtRestFine($iPDebtRestFine)
            ->setIPDebtRestDuty($iPDebtRestDuty)
            ->setIPDebtRestBudg($iPDebtRestBudg)
            ->setIPDebtRestOther($iPDebtRestOther)
            ->setIPPaymentDate($iPPaymentDate)
            ->setIPPaymentAmount($iPPaymentAmount)
            ->setOSPCode($oSPCode)
            ->setSPIFio($sPIFio)
            ->setSPITelephone($sPITelephone);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\IPExt
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get DebtorType value
     * @return string|null
     */
    public function getDebtorType()
    {
        return $this->DebtorType;
    }
    /**
     * Set DebtorType value
     * @uses \AisFssp\EnumType\ContragentType::valueIsValid()
     * @uses \AisFssp\EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $debtorType
     * @return \AisFssp\StructType\IPExt
     */
    public function setDebtorType($debtorType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ContragentType::valueIsValid($debtorType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $debtorType, implode(', ', \AisFssp\EnumType\ContragentType::getValidValues())), __LINE__);
        }
        $this->DebtorType = $debtorType;
        return $this;
    }
    /**
     * Get DebtorName value
     * @return string|null
     */
    public function getDebtorName()
    {
        return $this->DebtorName;
    }
    /**
     * Set DebtorName value
     * @param string $debtorName
     * @return \AisFssp\StructType\IPExt
     */
    public function setDebtorName($debtorName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorName) && strlen($debtorName) > 1000) || (is_array($debtorName) && count($debtorName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($debtorName) ? strlen($debtorName) : count($debtorName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorName) && strlen($debtorName) < 1) || (is_array($debtorName) && count($debtorName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorName) && !is_string($debtorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorName)), __LINE__);
        }
        $this->DebtorName = $debtorName;
        return $this;
    }
    /**
     * Get DebtorBirthDate value
     * @return string|null
     */
    public function getDebtorBirthDate()
    {
        return $this->DebtorBirthDate;
    }
    /**
     * Set DebtorBirthDate value
     * @param string $debtorBirthDate
     * @return \AisFssp\StructType\IPExt
     */
    public function setDebtorBirthDate($debtorBirthDate = null)
    {
        // validation for constraint: maxExclusive
        if ($debtorBirthDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $debtorBirthDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($debtorBirthDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $debtorBirthDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorBirthDate) && !is_string($debtorBirthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorBirthDate)), __LINE__);
        }
        $this->DebtorBirthDate = $debtorBirthDate;
        return $this;
    }
    /**
     * Get DebtorBirthYear value
     * @return string|null
     */
    public function getDebtorBirthYear()
    {
        return $this->DebtorBirthYear;
    }
    /**
     * Set DebtorBirthYear value
     * @param string $debtorBirthYear
     * @return \AisFssp\StructType\IPExt
     */
    public function setDebtorBirthYear($debtorBirthYear = null)
    {
        // validation for constraint: maxInclusive
        if ($debtorBirthYear > 2099) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2099, "%s" given', $debtorBirthYear), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($debtorBirthYear < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $debtorBirthYear), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorBirthYear) && !is_string($debtorBirthYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorBirthYear)), __LINE__);
        }
        $this->DebtorBirthYear = $debtorBirthYear;
        return $this;
    }
    /**
     * Get DebtorINN value
     * @return string|null
     */
    public function getDebtorINN()
    {
        return $this->DebtorINN;
    }
    /**
     * Set DebtorINN value
     * @param string $debtorINN
     * @return \AisFssp\StructType\IPExt
     */
    public function setDebtorINN($debtorINN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorINN) && strlen($debtorINN) > 12) || (is_array($debtorINN) && count($debtorINN) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($debtorINN) ? strlen($debtorINN) : count($debtorINN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorINN) && strlen($debtorINN) < 10) || (is_array($debtorINN) && count($debtorINN) < 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($debtorINN) && !preg_match('/(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})/', $debtorINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})", "%s" given', var_export($debtorINN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorINN) && !is_string($debtorINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorINN)), __LINE__);
        }
        $this->DebtorINN = $debtorINN;
        return $this;
    }
    /**
     * Get DebtorKPP value
     * @return string|null
     */
    public function getDebtorKPP()
    {
        return $this->DebtorKPP;
    }
    /**
     * Set DebtorKPP value
     * @param string $debtorKPP
     * @return \AisFssp\StructType\IPExt
     */
    public function setDebtorKPP($debtorKPP = null)
    {
        // validation for constraint: length
        if ((is_scalar($debtorKPP) && strlen($debtorKPP) !== 9) || (is_array($debtorKPP) && count($debtorKPP) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($debtorKPP) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}/', $debtorKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}", "%s" given', var_export($debtorKPP, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorKPP) && !is_string($debtorKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorKPP)), __LINE__);
        }
        $this->DebtorKPP = $debtorKPP;
        return $this;
    }
    /**
     * Get DebtorSnils value
     * @return string|null
     */
    public function getDebtorSnils()
    {
        return $this->DebtorSnils;
    }
    /**
     * Set DebtorSnils value
     * @param string $debtorSnils
     * @return \AisFssp\StructType\IPExt
     */
    public function setDebtorSnils($debtorSnils = null)
    {
        // validation for constraint: length
        if ((is_scalar($debtorSnils) && strlen($debtorSnils) !== 11) || (is_array($debtorSnils) && count($debtorSnils) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($debtorSnils) && !preg_match('/[0-9]{11}/', $debtorSnils)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{11}", "%s" given', var_export($debtorSnils, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorSnils) && !is_string($debtorSnils)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorSnils)), __LINE__);
        }
        $this->DebtorSnils = $debtorSnils;
        return $this;
    }
    /**
     * Get DebtorAdr value
     * @return string|null
     */
    public function getDebtorAdr()
    {
        return $this->DebtorAdr;
    }
    /**
     * Set DebtorAdr value
     * @param string $debtorAdr
     * @return \AisFssp\StructType\IPExt
     */
    public function setDebtorAdr($debtorAdr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorAdr) && strlen($debtorAdr) > 300) || (is_array($debtorAdr) && count($debtorAdr) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($debtorAdr) ? strlen($debtorAdr) : count($debtorAdr)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorAdr) && strlen($debtorAdr) < 1) || (is_array($debtorAdr) && count($debtorAdr) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorAdr) && !is_string($debtorAdr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorAdr)), __LINE__);
        }
        $this->DebtorAdr = $debtorAdr;
        return $this;
    }
    /**
     * Get DebtorTelephone value
     * @return string|null
     */
    public function getDebtorTelephone()
    {
        return $this->DebtorTelephone;
    }
    /**
     * Set DebtorTelephone value
     * @param string $debtorTelephone
     * @return \AisFssp\StructType\IPExt
     */
    public function setDebtorTelephone($debtorTelephone = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorTelephone) && strlen($debtorTelephone) > 16) || (is_array($debtorTelephone) && count($debtorTelephone) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($debtorTelephone) ? strlen($debtorTelephone) : count($debtorTelephone)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorTelephone) && strlen($debtorTelephone) < 1) || (is_array($debtorTelephone) && count($debtorTelephone) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorTelephone) && !is_string($debtorTelephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorTelephone)), __LINE__);
        }
        $this->DebtorTelephone = $debtorTelephone;
        return $this;
    }
    /**
     * Get IdExternalKey value
     * @return string|null
     */
    public function getIdExternalKey()
    {
        return $this->IdExternalKey;
    }
    /**
     * Set IdExternalKey value
     * @param string $idExternalKey
     * @return \AisFssp\StructType\IPExt
     */
    public function setIdExternalKey($idExternalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($idExternalKey) && strlen($idExternalKey) > 60) || (is_array($idExternalKey) && count($idExternalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($idExternalKey) ? strlen($idExternalKey) : count($idExternalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($idExternalKey) && strlen($idExternalKey) < 1) || (is_array($idExternalKey) && count($idExternalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idExternalKey) && !is_string($idExternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idExternalKey)), __LINE__);
        }
        $this->IdExternalKey = $idExternalKey;
        return $this;
    }
    /**
     * Get IDDate value
     * @return string|null
     */
    public function getIDDate()
    {
        return $this->IDDate;
    }
    /**
     * Set IDDate value
     * @param string $iDDate
     * @return \AisFssp\StructType\IPExt
     */
    public function setIDDate($iDDate = null)
    {
        // validation for constraint: maxExclusive
        if ($iDDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $iDDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($iDDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $iDDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDDate) && !is_string($iDDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDDate)), __LINE__);
        }
        $this->IDDate = $iDDate;
        return $this;
    }
    /**
     * Get IDType value
     * @return string|null
     */
    public function getIDType()
    {
        return $this->IDType;
    }
    /**
     * Set IDType value
     * @uses \AisFssp\EnumType\IdType::valueIsValid()
     * @uses \AisFssp\EnumType\IdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDType
     * @return \AisFssp\StructType\IPExt
     */
    public function setIDType($iDType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\IdType::valueIsValid($iDType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $iDType, implode(', ', \AisFssp\EnumType\IdType::getValidValues())), __LINE__);
        }
        $this->IDType = $iDType;
        return $this;
    }
    /**
     * Get IDSubj value
     * @return string|null
     */
    public function getIDSubj()
    {
        return $this->IDSubj;
    }
    /**
     * Set IDSubj value
     * @param string $iDSubj
     * @return \AisFssp\StructType\IPExt
     */
    public function setIDSubj($iDSubj = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDSubj) && strlen($iDSubj) > 8) || (is_array($iDSubj) && count($iDSubj) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($iDSubj) ? strlen($iDSubj) : count($iDSubj)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDSubj) && strlen($iDSubj) < 1) || (is_array($iDSubj) && count($iDSubj) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDSubj) && !is_string($iDSubj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDSubj)), __LINE__);
        }
        $this->IDSubj = $iDSubj;
        return $this;
    }
    /**
     * Get IDOrgName value
     * @return string|null
     */
    public function getIDOrgName()
    {
        return $this->IDOrgName;
    }
    /**
     * Set IDOrgName value
     * @param string $iDOrgName
     * @return \AisFssp\StructType\IPExt
     */
    public function setIDOrgName($iDOrgName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDOrgName) && strlen($iDOrgName) > 300) || (is_array($iDOrgName) && count($iDOrgName) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($iDOrgName) ? strlen($iDOrgName) : count($iDOrgName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDOrgName) && strlen($iDOrgName) < 1) || (is_array($iDOrgName) && count($iDOrgName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDOrgName) && !is_string($iDOrgName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDOrgName)), __LINE__);
        }
        $this->IDOrgName = $iDOrgName;
        return $this;
    }
    /**
     * Get CaseDate value
     * @return string|null
     */
    public function getCaseDate()
    {
        return $this->CaseDate;
    }
    /**
     * Set CaseDate value
     * @param string $caseDate
     * @return \AisFssp\StructType\IPExt
     */
    public function setCaseDate($caseDate = null)
    {
        // validation for constraint: maxExclusive
        if ($caseDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $caseDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($caseDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $caseDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($caseDate) && !is_string($caseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($caseDate)), __LINE__);
        }
        $this->CaseDate = $caseDate;
        return $this;
    }
    /**
     * Get IPNum value
     * @return string|null
     */
    public function getIPNum()
    {
        return $this->IPNum;
    }
    /**
     * Set IPNum value
     * @param string $iPNum
     * @return \AisFssp\StructType\IPExt
     */
    public function setIPNum($iPNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iPNum) && strlen($iPNum) > 25) || (is_array($iPNum) && count($iPNum) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($iPNum) ? strlen($iPNum) : count($iPNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iPNum) && strlen($iPNum) < 1) || (is_array($iPNum) && count($iPNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPNum) && !is_string($iPNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPNum)), __LINE__);
        }
        $this->IPNum = $iPNum;
        return $this;
    }
    /**
     * Get IPDate value
     * @return string|null
     */
    public function getIPDate()
    {
        return $this->IPDate;
    }
    /**
     * Set IPDate value
     * @param string $iPDate
     * @return \AisFssp\StructType\IPExt
     */
    public function setIPDate($iPDate = null)
    {
        // validation for constraint: maxExclusive
        if ($iPDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $iPDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($iPDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $iPDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPDate) && !is_string($iPDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPDate)), __LINE__);
        }
        $this->IPDate = $iPDate;
        return $this;
    }
    /**
     * Get IPNumComp value
     * @return string|null
     */
    public function getIPNumComp()
    {
        return $this->IPNumComp;
    }
    /**
     * Set IPNumComp value
     * @param string $iPNumComp
     * @return \AisFssp\StructType\IPExt
     */
    public function setIPNumComp($iPNumComp = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iPNumComp) && strlen($iPNumComp) > 25) || (is_array($iPNumComp) && count($iPNumComp) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($iPNumComp) ? strlen($iPNumComp) : count($iPNumComp)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iPNumComp) && strlen($iPNumComp) < 1) || (is_array($iPNumComp) && count($iPNumComp) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPNumComp) && !is_string($iPNumComp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPNumComp)), __LINE__);
        }
        $this->IPNumComp = $iPNumComp;
        return $this;
    }
    /**
     * Get IDSum value
     * @return float|null
     */
    public function getIDSum()
    {
        return $this->IDSum;
    }
    /**
     * Set IDSum value
     * @param float $iDSum
     * @return \AisFssp\StructType\IPExt
     */
    public function setIDSum($iDSum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($iDSum) && strlen(substr($iDSum, strpos($iDSum, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($iDSum, strpos($iDSum, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($iDSum) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $iDSum)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($iDSum, strpos($iDSum, '.')))), __LINE__);
        }
        $this->IDSum = $iDSum;
        return $this;
    }
    /**
     * Get IPDebtRestTotal value
     * @return float|null
     */
    public function getIPDebtRestTotal()
    {
        return $this->IPDebtRestTotal;
    }
    /**
     * Set IPDebtRestTotal value
     * @param float $iPDebtRestTotal
     * @return \AisFssp\StructType\IPExt
     */
    public function setIPDebtRestTotal($iPDebtRestTotal = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($iPDebtRestTotal) && strlen(substr($iPDebtRestTotal, strpos($iPDebtRestTotal, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($iPDebtRestTotal, strpos($iPDebtRestTotal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($iPDebtRestTotal) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $iPDebtRestTotal)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($iPDebtRestTotal, strpos($iPDebtRestTotal, '.')))), __LINE__);
        }
        $this->IPDebtRestTotal = $iPDebtRestTotal;
        return $this;
    }
    /**
     * Get IPDebtRestIp value
     * @return float|null
     */
    public function getIPDebtRestIp()
    {
        return $this->IPDebtRestIp;
    }
    /**
     * Set IPDebtRestIp value
     * @param float $iPDebtRestIp
     * @return \AisFssp\StructType\IPExt
     */
    public function setIPDebtRestIp($iPDebtRestIp = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($iPDebtRestIp) && strlen(substr($iPDebtRestIp, strpos($iPDebtRestIp, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($iPDebtRestIp, strpos($iPDebtRestIp, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($iPDebtRestIp) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $iPDebtRestIp)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($iPDebtRestIp, strpos($iPDebtRestIp, '.')))), __LINE__);
        }
        $this->IPDebtRestIp = $iPDebtRestIp;
        return $this;
    }
    /**
     * Get IPDebtRestFine value
     * @return float|null
     */
    public function getIPDebtRestFine()
    {
        return $this->IPDebtRestFine;
    }
    /**
     * Set IPDebtRestFine value
     * @param float $iPDebtRestFine
     * @return \AisFssp\StructType\IPExt
     */
    public function setIPDebtRestFine($iPDebtRestFine = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($iPDebtRestFine) && strlen(substr($iPDebtRestFine, strpos($iPDebtRestFine, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($iPDebtRestFine, strpos($iPDebtRestFine, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($iPDebtRestFine) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $iPDebtRestFine)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($iPDebtRestFine, strpos($iPDebtRestFine, '.')))), __LINE__);
        }
        $this->IPDebtRestFine = $iPDebtRestFine;
        return $this;
    }
    /**
     * Get IPDebtRestDuty value
     * @return float|null
     */
    public function getIPDebtRestDuty()
    {
        return $this->IPDebtRestDuty;
    }
    /**
     * Set IPDebtRestDuty value
     * @param float $iPDebtRestDuty
     * @return \AisFssp\StructType\IPExt
     */
    public function setIPDebtRestDuty($iPDebtRestDuty = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($iPDebtRestDuty) && strlen(substr($iPDebtRestDuty, strpos($iPDebtRestDuty, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($iPDebtRestDuty, strpos($iPDebtRestDuty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($iPDebtRestDuty) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $iPDebtRestDuty)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($iPDebtRestDuty, strpos($iPDebtRestDuty, '.')))), __LINE__);
        }
        $this->IPDebtRestDuty = $iPDebtRestDuty;
        return $this;
    }
    /**
     * Get IPDebtRestBudg value
     * @return float|null
     */
    public function getIPDebtRestBudg()
    {
        return $this->IPDebtRestBudg;
    }
    /**
     * Set IPDebtRestBudg value
     * @param float $iPDebtRestBudg
     * @return \AisFssp\StructType\IPExt
     */
    public function setIPDebtRestBudg($iPDebtRestBudg = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($iPDebtRestBudg) && strlen(substr($iPDebtRestBudg, strpos($iPDebtRestBudg, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($iPDebtRestBudg, strpos($iPDebtRestBudg, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($iPDebtRestBudg) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $iPDebtRestBudg)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($iPDebtRestBudg, strpos($iPDebtRestBudg, '.')))), __LINE__);
        }
        $this->IPDebtRestBudg = $iPDebtRestBudg;
        return $this;
    }
    /**
     * Get IPDebtRestOther value
     * @return float|null
     */
    public function getIPDebtRestOther()
    {
        return $this->IPDebtRestOther;
    }
    /**
     * Set IPDebtRestOther value
     * @param float $iPDebtRestOther
     * @return \AisFssp\StructType\IPExt
     */
    public function setIPDebtRestOther($iPDebtRestOther = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($iPDebtRestOther) && strlen(substr($iPDebtRestOther, strpos($iPDebtRestOther, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($iPDebtRestOther, strpos($iPDebtRestOther, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($iPDebtRestOther) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $iPDebtRestOther)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($iPDebtRestOther, strpos($iPDebtRestOther, '.')))), __LINE__);
        }
        $this->IPDebtRestOther = $iPDebtRestOther;
        return $this;
    }
    /**
     * Get IPPaymentDate value
     * @return string|null
     */
    public function getIPPaymentDate()
    {
        return $this->IPPaymentDate;
    }
    /**
     * Set IPPaymentDate value
     * @param string $iPPaymentDate
     * @return \AisFssp\StructType\IPExt
     */
    public function setIPPaymentDate($iPPaymentDate = null)
    {
        // validation for constraint: maxExclusive
        if ($iPPaymentDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $iPPaymentDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($iPPaymentDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $iPPaymentDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPPaymentDate) && !is_string($iPPaymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPPaymentDate)), __LINE__);
        }
        $this->IPPaymentDate = $iPPaymentDate;
        return $this;
    }
    /**
     * Get IPPaymentAmount value
     * @return float|null
     */
    public function getIPPaymentAmount()
    {
        return $this->IPPaymentAmount;
    }
    /**
     * Set IPPaymentAmount value
     * @param float $iPPaymentAmount
     * @return \AisFssp\StructType\IPExt
     */
    public function setIPPaymentAmount($iPPaymentAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($iPPaymentAmount) && strlen(substr($iPPaymentAmount, strpos($iPPaymentAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($iPPaymentAmount, strpos($iPPaymentAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($iPPaymentAmount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $iPPaymentAmount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($iPPaymentAmount, strpos($iPPaymentAmount, '.')))), __LINE__);
        }
        $this->IPPaymentAmount = $iPPaymentAmount;
        return $this;
    }
    /**
     * Get OSPCode value
     * @return string|null
     */
    public function getOSPCode()
    {
        return $this->OSPCode;
    }
    /**
     * Set OSPCode value
     * @param string $oSPCode
     * @return \AisFssp\StructType\IPExt
     */
    public function setOSPCode($oSPCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($oSPCode) && strlen($oSPCode) !== 5) || (is_array($oSPCode) && count($oSPCode) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($oSPCode) && !preg_match('/[0-9]{5}/', $oSPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($oSPCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oSPCode) && !is_string($oSPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oSPCode)), __LINE__);
        }
        $this->OSPCode = $oSPCode;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \AisFssp\StructType\IPExt
     */
    public function setSPIFio($sPIFio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPIFio) && strlen($sPIFio) > 20) || (is_array($sPIFio) && count($sPIFio) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($sPIFio) ? strlen($sPIFio) : count($sPIFio)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPIFio) && strlen($sPIFio) < 1) || (is_array($sPIFio) && count($sPIFio) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPIFio) && !is_string($sPIFio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPIFio)), __LINE__);
        }
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get SPITelephone value
     * @return string|null
     */
    public function getSPITelephone()
    {
        return $this->SPITelephone;
    }
    /**
     * Set SPITelephone value
     * @param string $sPITelephone
     * @return \AisFssp\StructType\IPExt
     */
    public function setSPITelephone($sPITelephone = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPITelephone) && strlen($sPITelephone) > 18) || (is_array($sPITelephone) && count($sPITelephone) > 18)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 18 element(s) or a scalar of 18 character(s) at most, "%d" length given', is_scalar($sPITelephone) ? strlen($sPITelephone) : count($sPITelephone)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPITelephone) && strlen($sPITelephone) < 1) || (is_array($sPITelephone) && count($sPITelephone) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPITelephone) && !is_string($sPITelephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPITelephone)), __LINE__);
        }
        $this->SPITelephone = $sPITelephone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IPExt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
