<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPDocInfoType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документы ИП | Содержит ответ на запрос стороны исполнительного производства о ходе исполнительного производства, в
 * частности, сведения о документах по ИП
 * - type: tns:IPDocInfoType
 * @subpackage Structs
 */
class IPDocInfoType extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП РФ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The IpInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП РФ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IpInternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата события или документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The SPIId
     * Meta informations extracted from the WSDL
     * - documentation: Код СПИ сделавший запрос | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $SPIId;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The SPIPost
     * Meta informations extracted from the WSDL
     * - documentation: Код должности СПИ | Код должности СПИ
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $SPIPost;
    /**
     * The DocNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNum;
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа или события | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота |
     * NSI_Document | Наименование объекта NCORE
     * - minOccurs: 0
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $DocType;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала действия | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $StartDate;
    /**
     * The FinDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания действия | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $FinDate;
    /**
     * The Counterpart
     * Meta informations extracted from the WSDL
     * - documentation: Контрагент | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Counterpart;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - documentation: Текст основания принятия решения | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Reason;
    /**
     * The Article
     * Meta informations extracted from the WSDL
     * - documentation: Статья основания принятия решения | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Article;
    /**
     * The Point
     * Meta informations extracted from the WSDL
     * - documentation: Пункт статьи | Пункт статьи основания | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Point;
    /**
     * The ArticlePart
     * Meta informations extracted from the WSDL
     * - documentation: Подпункт статьи основания решения | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $ArticlePart;
    /**
     * Constructor method for IPDocInfoType
     * @uses IPDocInfoType::setInternalKey()
     * @uses IPDocInfoType::setIpInternalKey()
     * @uses IPDocInfoType::setDocDate()
     * @uses IPDocInfoType::setSPIId()
     * @uses IPDocInfoType::setSPIFio()
     * @uses IPDocInfoType::setSPIPost()
     * @uses IPDocInfoType::setDocNum()
     * @uses IPDocInfoType::setDocType()
     * @uses IPDocInfoType::setStartDate()
     * @uses IPDocInfoType::setFinDate()
     * @uses IPDocInfoType::setCounterpart()
     * @uses IPDocInfoType::setReason()
     * @uses IPDocInfoType::setArticle()
     * @uses IPDocInfoType::setPoint()
     * @uses IPDocInfoType::setArticlePart()
     * @param int $internalKey
     * @param int $ipInternalKey
     * @param string $docDate
     * @param int $sPIId
     * @param string $sPIFio
     * @param string $sPIPost
     * @param string $docNum
     * @param string $docType
     * @param string $startDate
     * @param string $finDate
     * @param string $counterpart
     * @param string $reason
     * @param string $article
     * @param string $point
     * @param string $articlePart
     */
    public function __construct($internalKey = null, $ipInternalKey = null, $docDate = null, $sPIId = null, $sPIFio = null, $sPIPost = null, $docNum = null, $docType = null, $startDate = null, $finDate = null, $counterpart = null, $reason = null, $article = null, $point = null, $articlePart = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setIpInternalKey($ipInternalKey)
            ->setDocDate($docDate)
            ->setSPIId($sPIId)
            ->setSPIFio($sPIFio)
            ->setSPIPost($sPIPost)
            ->setDocNum($docNum)
            ->setDocType($docType)
            ->setStartDate($startDate)
            ->setFinDate($finDate)
            ->setCounterpart($counterpart)
            ->setReason($reason)
            ->setArticle($article)
            ->setPoint($point)
            ->setArticlePart($articlePart);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\IPDocInfoType
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get IpInternalKey value
     * @return int|null
     */
    public function getIpInternalKey()
    {
        return $this->IpInternalKey;
    }
    /**
     * Set IpInternalKey value
     * @param int $ipInternalKey
     * @return \AisFssp\StructType\IPDocInfoType
     */
    public function setIpInternalKey($ipInternalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($ipInternalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $ipInternalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($ipInternalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $ipInternalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($ipInternalKey) && !is_numeric($ipInternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ipInternalKey)), __LINE__);
        }
        $this->IpInternalKey = $ipInternalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\IPDocInfoType
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get SPIId value
     * @return int|null
     */
    public function getSPIId()
    {
        return $this->SPIId;
    }
    /**
     * Set SPIId value
     * @param int $sPIId
     * @return \AisFssp\StructType\IPDocInfoType
     */
    public function setSPIId($sPIId = null)
    {
        // validation for constraint: maxInclusive
        if ($sPIId > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $sPIId), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($sPIId < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $sPIId), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($sPIId) && !is_numeric($sPIId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sPIId)), __LINE__);
        }
        $this->SPIId = $sPIId;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \AisFssp\StructType\IPDocInfoType
     */
    public function setSPIFio($sPIFio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPIFio) && strlen($sPIFio) > 100) || (is_array($sPIFio) && count($sPIFio) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($sPIFio) ? strlen($sPIFio) : count($sPIFio)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPIFio) && strlen($sPIFio) < 1) || (is_array($sPIFio) && count($sPIFio) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPIFio) && !is_string($sPIFio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPIFio)), __LINE__);
        }
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get SPIPost value
     * @return string|null
     */
    public function getSPIPost()
    {
        return $this->SPIPost;
    }
    /**
     * Set SPIPost value
     * @param string $sPIPost
     * @return \AisFssp\StructType\IPDocInfoType
     */
    public function setSPIPost($sPIPost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPIPost) && strlen($sPIPost) > 25) || (is_array($sPIPost) && count($sPIPost) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($sPIPost) ? strlen($sPIPost) : count($sPIPost)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPIPost) && strlen($sPIPost) < 1) || (is_array($sPIPost) && count($sPIPost) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($sPIPost) && !preg_match('/[0-9\\-\\.\\s]+/', $sPIPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9\-\.\s]+", "%s" given', var_export($sPIPost, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPIPost) && !is_string($sPIPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPIPost)), __LINE__);
        }
        $this->SPIPost = $sPIPost;
        return $this;
    }
    /**
     * Get DocNum value
     * @return string|null
     */
    public function getDocNum()
    {
        return $this->DocNum;
    }
    /**
     * Set DocNum value
     * @param string $docNum
     * @return \AisFssp\StructType\IPDocInfoType
     */
    public function setDocNum($docNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNum) && strlen($docNum) > 25) || (is_array($docNum) && count($docNum) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNum) ? strlen($docNum) : count($docNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNum) && strlen($docNum) < 1) || (is_array($docNum) && count($docNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNum) && !is_string($docNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNum)), __LINE__);
        }
        $this->DocNum = $docNum;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \AisFssp\StructType\IPDocInfoType
     */
    public function setDocType($docType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docType) && strlen($docType) > 1) || (is_array($docType) && count($docType) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($docType) ? strlen($docType) : count($docType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docType) && strlen($docType) < 1) || (is_array($docType) && count($docType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docType) && !is_string($docType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docType)), __LINE__);
        }
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \AisFssp\StructType\IPDocInfoType
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: maxExclusive
        if ($startDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($startDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get FinDate value
     * @return string|null
     */
    public function getFinDate()
    {
        return $this->FinDate;
    }
    /**
     * Set FinDate value
     * @param string $finDate
     * @return \AisFssp\StructType\IPDocInfoType
     */
    public function setFinDate($finDate = null)
    {
        // validation for constraint: maxExclusive
        if ($finDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $finDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($finDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $finDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($finDate) && !is_string($finDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($finDate)), __LINE__);
        }
        $this->FinDate = $finDate;
        return $this;
    }
    /**
     * Get Counterpart value
     * @return string|null
     */
    public function getCounterpart()
    {
        return $this->Counterpart;
    }
    /**
     * Set Counterpart value
     * @param string $counterpart
     * @return \AisFssp\StructType\IPDocInfoType
     */
    public function setCounterpart($counterpart = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($counterpart) && strlen($counterpart) > 300) || (is_array($counterpart) && count($counterpart) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($counterpart) ? strlen($counterpart) : count($counterpart)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($counterpart) && strlen($counterpart) < 1) || (is_array($counterpart) && count($counterpart) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($counterpart) && !is_string($counterpart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($counterpart)), __LINE__);
        }
        $this->Counterpart = $counterpart;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \AisFssp\StructType\IPDocInfoType
     */
    public function setReason($reason = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($reason) && strlen($reason) > 300) || (is_array($reason) && count($reason) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($reason) ? strlen($reason) : count($reason)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($reason) && strlen($reason) < 1) || (is_array($reason) && count($reason) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get Article value
     * @return string|null
     */
    public function getArticle()
    {
        return $this->Article;
    }
    /**
     * Set Article value
     * @param string $article
     * @return \AisFssp\StructType\IPDocInfoType
     */
    public function setArticle($article = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($article) && strlen($article) > 10) || (is_array($article) && count($article) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($article) ? strlen($article) : count($article)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($article) && strlen($article) < 1) || (is_array($article) && count($article) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($article) && !is_string($article)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($article)), __LINE__);
        }
        $this->Article = $article;
        return $this;
    }
    /**
     * Get Point value
     * @return string|null
     */
    public function getPoint()
    {
        return $this->Point;
    }
    /**
     * Set Point value
     * @param string $point
     * @return \AisFssp\StructType\IPDocInfoType
     */
    public function setPoint($point = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($point) && strlen($point) > 10) || (is_array($point) && count($point) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($point) ? strlen($point) : count($point)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($point) && strlen($point) < 1) || (is_array($point) && count($point) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($point) && !is_string($point)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($point)), __LINE__);
        }
        $this->Point = $point;
        return $this;
    }
    /**
     * Get ArticlePart value
     * @return string|null
     */
    public function getArticlePart()
    {
        return $this->ArticlePart;
    }
    /**
     * Set ArticlePart value
     * @param string $articlePart
     * @return \AisFssp\StructType\IPDocInfoType
     */
    public function setArticlePart($articlePart = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($articlePart) && strlen($articlePart) > 10) || (is_array($articlePart) && count($articlePart) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($articlePart) ? strlen($articlePart) : count($articlePart)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($articlePart) && strlen($articlePart) < 1) || (is_array($articlePart) && count($articlePart) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($articlePart) && !is_string($articlePart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($articlePart)), __LINE__);
        }
        $this->ArticlePart = $articlePart;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IPDocInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
