<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPDataInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Информация об исполнительных производствах | ЭП
 * - type: tns:IPDataInfo
 * @subpackage Structs
 */
class IPDataInfo extends AbstractStructBase
{
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The requestKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $requestKey;
    /**
     * The ip
     * Meta informations extracted from the WSDL
     * - documentation: ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\IP[]
     */
    public $ip;
    /**
     * The data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\Data[]
     */
    public $data;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IPDataInfo
     * @uses IPDataInfo::setInternalKey()
     * @uses IPDataInfo::setRequestKey()
     * @uses IPDataInfo::setIp()
     * @uses IPDataInfo::setData()
     * @uses IPDataInfo::setSignature()
     * @uses IPDataInfo::setId()
     * @param int $internalKey
     * @param string $requestKey
     * @param \AisFssp\StructType\IP[] $ip
     * @param \AisFssp\StructType\Data[] $data
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $requestKey = null, array $ip = array(), array $data = array(), array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestKey($requestKey)
            ->setIp($ip)
            ->setData($data)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\IPDataInfo
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get requestKey value
     * @return string|null
     */
    public function getRequestKey()
    {
        return $this->requestKey;
    }
    /**
     * Set requestKey value
     * @param string $requestKey
     * @return \AisFssp\StructType\IPDataInfo
     */
    public function setRequestKey($requestKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestKey) && strlen($requestKey) > 60) || (is_array($requestKey) && count($requestKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($requestKey) ? strlen($requestKey) : count($requestKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestKey) && strlen($requestKey) < 1) || (is_array($requestKey) && count($requestKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestKey) && !is_string($requestKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestKey)), __LINE__);
        }
        $this->requestKey = $requestKey;
        return $this;
    }
    /**
     * Get ip value
     * @return \AisFssp\StructType\IP[]|null
     */
    public function getIp()
    {
        return $this->ip;
    }
    /**
     * Set ip value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IP[] $ip
     * @return \AisFssp\StructType\IPDataInfo
     */
    public function setIp(array $ip = array())
    {
        foreach ($ip as $iPDataInfoIpItem) {
            // validation for constraint: itemType
            if (!$iPDataInfoIpItem instanceof \AisFssp\StructType\IP) {
                throw new \InvalidArgumentException(sprintf('The ip property can only contain items of \AisFssp\StructType\IP, "%s" given', is_object($iPDataInfoIpItem) ? get_class($iPDataInfoIpItem) : gettype($iPDataInfoIpItem)), __LINE__);
            }
        }
        $this->ip = $ip;
        return $this;
    }
    /**
     * Add item to ip value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IP $item
     * @return \AisFssp\StructType\IPDataInfo
     */
    public function addToIp(\AisFssp\StructType\IP $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\IP) {
            throw new \InvalidArgumentException(sprintf('The ip property can only contain items of \AisFssp\StructType\IP, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ip[] = $item;
        return $this;
    }
    /**
     * Get data value
     * @return \AisFssp\StructType\Data[]|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data[] $data
     * @return \AisFssp\StructType\IPDataInfo
     */
    public function setData(array $data = array())
    {
        foreach ($data as $iPDataInfoDataItem) {
            // validation for constraint: itemType
            if (!$iPDataInfoDataItem instanceof \AisFssp\StructType\Data) {
                throw new \InvalidArgumentException(sprintf('The data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($iPDataInfoDataItem) ? get_class($iPDataInfoDataItem) : gettype($iPDataInfoDataItem)), __LINE__);
            }
        }
        $this->data = $data;
        return $this;
    }
    /**
     * Add item to data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data $item
     * @return \AisFssp\StructType\IPDataInfo
     */
    public function addToData(\AisFssp\StructType\Data $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Data) {
            throw new \InvalidArgumentException(sprintf('The data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->data[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\IPDataInfo
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $iPDataInfoSignatureItem) {
            // validation for constraint: itemType
            if (!$iPDataInfoSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($iPDataInfoSignatureItem) ? get_class($iPDataInfoSignatureItem) : gettype($iPDataInfoSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\IPDataInfo
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\IPDataInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IPDataInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
