<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMessagesRs StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ - сообщения
 * @subpackage Structs
 */
class GetMessagesRs extends Response
{
    /**
     * The hasMore
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия сообщений помимо передаваемого ответа
     * @var bool
     */
    public $hasMore;
    /**
     * The results
     * Meta informations extracted from the WSDL
     * - documentation: Результаты приема сообщений веб-сервисом ФССП России
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \AisFssp\StructType\MessageResultCollection
     */
    public $results;
    /**
     * The messages
     * Meta informations extracted from the WSDL
     * - documentation: Сообщение | В настоящее время выполняется передача одного сообщения.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \AisFssp\StructType\MessageCollection
     */
    public $messages;
    /**
     * Constructor method for GetMessagesRs
     * @uses GetMessagesRs::setHasMore()
     * @uses GetMessagesRs::setResults()
     * @uses GetMessagesRs::setMessages()
     * @param bool $hasMore
     * @param \AisFssp\StructType\MessageResultCollection $results
     * @param \AisFssp\StructType\MessageCollection $messages
     */
    public function __construct($hasMore = null, \AisFssp\StructType\MessageResultCollection $results = null, \AisFssp\StructType\MessageCollection $messages = null)
    {
        $this
            ->setHasMore($hasMore)
            ->setResults($results)
            ->setMessages($messages);
    }
    /**
     * Get hasMore value
     * @return bool|null
     */
    public function getHasMore()
    {
        return $this->hasMore;
    }
    /**
     * Set hasMore value
     * @param bool $hasMore
     * @return \AisFssp\StructType\GetMessagesRs
     */
    public function setHasMore($hasMore = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMore) && !is_bool($hasMore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasMore)), __LINE__);
        }
        $this->hasMore = $hasMore;
        return $this;
    }
    /**
     * Get results value
     * @return \AisFssp\StructType\MessageResultCollection|null
     */
    public function getResults()
    {
        return $this->results;
    }
    /**
     * Set results value
     * @param \AisFssp\StructType\MessageResultCollection $results
     * @return \AisFssp\StructType\GetMessagesRs
     */
    public function setResults(\AisFssp\StructType\MessageResultCollection $results = null)
    {
        $this->results = $results;
        return $this;
    }
    /**
     * Get messages value
     * @return \AisFssp\StructType\MessageCollection|null
     */
    public function getMessages()
    {
        return $this->messages;
    }
    /**
     * Set messages value
     * @param \AisFssp\StructType\MessageCollection $messages
     * @return \AisFssp\StructType\GetMessagesRs
     */
    public function setMessages(\AisFssp\StructType\MessageCollection $messages = null)
    {
        $this->messages = $messages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\GetMessagesRs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
