<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForgnFndrCompanyDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об иностранном учредителе — юридическом лице
 * @subpackage Structs
 */
class ForgnFndrCompanyDatumType extends CompanyDatumType
{
    /**
     * The capitalAmount
     * Meta informations extracted from the WSDL
     * - documentation: Размер вклада в уставной капитал учредителя (в рублях) | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $capitalAmount;
    /**
     * The countryId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор страны | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $countryId;
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - documentation: Код страны | Код страны буквенный | Трехзначный (альфа-3) буквенный код страны мира по классификатору ОКСМ
     * - minOccurs: 0
     * - length: 3
     * @var string
     */
    public $countryCode;
    /**
     * The countryName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование страны | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $countryName;
    /**
     * Constructor method for ForgnFndrCompanyDatumType
     * @uses ForgnFndrCompanyDatumType::setCapitalAmount()
     * @uses ForgnFndrCompanyDatumType::setCountryId()
     * @uses ForgnFndrCompanyDatumType::setCountryCode()
     * @uses ForgnFndrCompanyDatumType::setCountryName()
     * @param float $capitalAmount
     * @param int $countryId
     * @param string $countryCode
     * @param string $countryName
     */
    public function __construct($capitalAmount = null, $countryId = null, $countryCode = null, $countryName = null)
    {
        $this
            ->setCapitalAmount($capitalAmount)
            ->setCountryId($countryId)
            ->setCountryCode($countryCode)
            ->setCountryName($countryName);
    }
    /**
     * Get capitalAmount value
     * @return float|null
     */
    public function getCapitalAmount()
    {
        return $this->capitalAmount;
    }
    /**
     * Set capitalAmount value
     * @param float $capitalAmount
     * @return \AisFssp\StructType\ForgnFndrCompanyDatumType
     */
    public function setCapitalAmount($capitalAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($capitalAmount) && strlen(substr($capitalAmount, strpos($capitalAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($capitalAmount, strpos($capitalAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($capitalAmount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $capitalAmount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($capitalAmount, strpos($capitalAmount, '.')))), __LINE__);
        }
        $this->capitalAmount = $capitalAmount;
        return $this;
    }
    /**
     * Get countryId value
     * @return int|null
     */
    public function getCountryId()
    {
        return $this->countryId;
    }
    /**
     * Set countryId value
     * @param int $countryId
     * @return \AisFssp\StructType\ForgnFndrCompanyDatumType
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($countryId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $countryId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($countryId, strpos($countryId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($countryId) && !is_numeric($countryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($countryId)), __LINE__);
        }
        $this->countryId = $countryId;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \AisFssp\StructType\ForgnFndrCompanyDatumType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($countryCode) && strlen($countryCode) !== 3) || (is_array($countryCode) && count($countryCode) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get countryName value
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->countryName;
    }
    /**
     * Set countryName value
     * @param string $countryName
     * @return \AisFssp\StructType\ForgnFndrCompanyDatumType
     */
    public function setCountryName($countryName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($countryName) && strlen($countryName) > 255) || (is_array($countryName) && count($countryName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($countryName) ? strlen($countryName) : count($countryName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($countryName) && strlen($countryName) < 1) || (is_array($countryName) && count($countryName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($countryName) && !is_string($countryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryName)), __LINE__);
        }
        $this->countryName = $countryName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ForgnFndrCompanyDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
