<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForcedExecDocumentRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос на получение документа по внутренней прямой ссылке | используется для получения электронного документа стороной
 * исполнительного производства по его реквизитам
 * - type: tns:ForcedExecDocumentRequest
 * @subpackage Structs
 */
class ForcedExecDocumentRequest extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса | Идентификатор запроса, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа (бар-код) | Штрих-код в формате code39
     * - maxLength: 44
     * - minLength: 1
     * - pattern: [0-9A-Z\-\.\+$/%]+
     * @var string
     */
    public $Barcode;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The IpSideFio
     * Meta informations extracted from the WSDL
     * - documentation: Сторона исполнительного производства
     * @var \AisFssp\StructType\FioType
     */
    public $IpSideFio;
    /**
     * The PrincipalSNILS
     * Meta informations extracted from the WSDL
     * - documentation: СНИЛС обратившегося лица | СНИЛС
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $PrincipalSNILS;
    /**
     * The PrincipalFio
     * Meta informations extracted from the WSDL
     * - documentation: Владелец сертификата
     * @var \AisFssp\StructType\FioType
     */
    public $PrincipalFio;
    /**
     * Constructor method for ForcedExecDocumentRequest
     * @uses ForcedExecDocumentRequest::setExternalKey()
     * @uses ForcedExecDocumentRequest::setBarcode()
     * @uses ForcedExecDocumentRequest::setDocNumber()
     * @uses ForcedExecDocumentRequest::setDocDate()
     * @uses ForcedExecDocumentRequest::setIpSideFio()
     * @uses ForcedExecDocumentRequest::setPrincipalSNILS()
     * @uses ForcedExecDocumentRequest::setPrincipalFio()
     * @param string $externalKey
     * @param string $barcode
     * @param string $docNumber
     * @param string $docDate
     * @param \AisFssp\StructType\FioType $ipSideFio
     * @param string $principalSNILS
     * @param \AisFssp\StructType\FioType $principalFio
     */
    public function __construct($externalKey = null, $barcode = null, $docNumber = null, $docDate = null, \AisFssp\StructType\FioType $ipSideFio = null, $principalSNILS = null, \AisFssp\StructType\FioType $principalFio = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setBarcode($barcode)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setIpSideFio($ipSideFio)
            ->setPrincipalSNILS($principalSNILS)
            ->setPrincipalFio($principalFio);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\ForcedExecDocumentRequest
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \AisFssp\StructType\ForcedExecDocumentRequest
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($barcode) && strlen($barcode) > 44) || (is_array($barcode) && count($barcode) > 44)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 44 element(s) or a scalar of 44 character(s) at most, "%d" length given', is_scalar($barcode) ? strlen($barcode) : count($barcode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($barcode) && strlen($barcode) < 1) || (is_array($barcode) && count($barcode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($barcode) && !preg_match('/[0-9A-Z\\-\\.\\+$\/%]+/', $barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9A-Z\-\.\+$/%]+", "%s" given', var_export($barcode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\ForcedExecDocumentRequest
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\ForcedExecDocumentRequest
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get IpSideFio value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getIpSideFio()
    {
        return $this->IpSideFio;
    }
    /**
     * Set IpSideFio value
     * @param \AisFssp\StructType\FioType $ipSideFio
     * @return \AisFssp\StructType\ForcedExecDocumentRequest
     */
    public function setIpSideFio(\AisFssp\StructType\FioType $ipSideFio = null)
    {
        $this->IpSideFio = $ipSideFio;
        return $this;
    }
    /**
     * Get PrincipalSNILS value
     * @return string|null
     */
    public function getPrincipalSNILS()
    {
        return $this->PrincipalSNILS;
    }
    /**
     * Set PrincipalSNILS value
     * @param string $principalSNILS
     * @return \AisFssp\StructType\ForcedExecDocumentRequest
     */
    public function setPrincipalSNILS($principalSNILS = null)
    {
        // validation for constraint: length
        if ((is_scalar($principalSNILS) && strlen($principalSNILS) !== 11) || (is_array($principalSNILS) && count($principalSNILS) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($principalSNILS) && !preg_match('/[0-9]{11}/', $principalSNILS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{11}", "%s" given', var_export($principalSNILS, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($principalSNILS) && !is_string($principalSNILS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($principalSNILS)), __LINE__);
        }
        $this->PrincipalSNILS = $principalSNILS;
        return $this;
    }
    /**
     * Get PrincipalFio value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getPrincipalFio()
    {
        return $this->PrincipalFio;
    }
    /**
     * Set PrincipalFio value
     * @param \AisFssp\StructType\FioType $principalFio
     * @return \AisFssp\StructType\ForcedExecDocumentRequest
     */
    public function setPrincipalFio(\AisFssp\StructType\FioType $principalFio = null)
    {
        $this->PrincipalFio = $principalFio;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ForcedExecDocumentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
