<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FishNonquotaContractDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о договорах пользования водными биоресурсами, которые отнесены к объектам рыболовства и общий допустимый улов
 * которых не устанавливается
 * @subpackage Structs
 */
class FishNonquotaContractDatumType extends FishDatumType
{
    /**
     * The volume
     * Meta informations extracted from the WSDL
     * - documentation: Объем | Количество
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $volume;
    /**
     * The OKEICode
     * Meta informations extracted from the WSDL
     * - documentation: Код единицы по ОКЕИ | Код ОКЕИ
     * - length: 3
     * @var string
     */
    public $OKEICode;
    /**
     * The OKEIName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование единицы по ОКЕИ | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $OKEIName;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала договора | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $startDate;
    /**
     * The finishDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания договора | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $finishDate;
    /**
     * The finDocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата соглашения о расторжении | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $finDocDate;
    /**
     * The finDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер соглашения о расторжении | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $finDocNumber;
    /**
     * The finDocGround
     * Meta informations extracted from the WSDL
     * - documentation: Основание расторжения договора | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $finDocGround;
    /**
     * Constructor method for FishNonquotaContractDatumType
     * @uses FishNonquotaContractDatumType::setVolume()
     * @uses FishNonquotaContractDatumType::setOKEICode()
     * @uses FishNonquotaContractDatumType::setOKEIName()
     * @uses FishNonquotaContractDatumType::setStartDate()
     * @uses FishNonquotaContractDatumType::setFinishDate()
     * @uses FishNonquotaContractDatumType::setFinDocDate()
     * @uses FishNonquotaContractDatumType::setFinDocNumber()
     * @uses FishNonquotaContractDatumType::setFinDocGround()
     * @param float $volume
     * @param string $oKEICode
     * @param string $oKEIName
     * @param string $startDate
     * @param string $finishDate
     * @param string $finDocDate
     * @param string $finDocNumber
     * @param string $finDocGround
     */
    public function __construct($volume = null, $oKEICode = null, $oKEIName = null, $startDate = null, $finishDate = null, $finDocDate = null, $finDocNumber = null, $finDocGround = null)
    {
        $this
            ->setVolume($volume)
            ->setOKEICode($oKEICode)
            ->setOKEIName($oKEIName)
            ->setStartDate($startDate)
            ->setFinishDate($finishDate)
            ->setFinDocDate($finDocDate)
            ->setFinDocNumber($finDocNumber)
            ->setFinDocGround($finDocGround);
    }
    /**
     * Get volume value
     * @return float|null
     */
    public function getVolume()
    {
        return $this->volume;
    }
    /**
     * Set volume value
     * @param float $volume
     * @return \AisFssp\StructType\FishNonquotaContractDatumType
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($volume) && strlen(substr($volume, strpos($volume, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($volume, strpos($volume, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($volume) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $volume)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($volume, strpos($volume, '.')))), __LINE__);
        }
        $this->volume = $volume;
        return $this;
    }
    /**
     * Get OKEICode value
     * @return string|null
     */
    public function getOKEICode()
    {
        return $this->OKEICode;
    }
    /**
     * Set OKEICode value
     * @param string $oKEICode
     * @return \AisFssp\StructType\FishNonquotaContractDatumType
     */
    public function setOKEICode($oKEICode = null)
    {
        // validation for constraint: length
        if ((is_scalar($oKEICode) && strlen($oKEICode) !== 3) || (is_array($oKEICode) && count($oKEICode) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oKEICode) && !is_string($oKEICode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oKEICode)), __LINE__);
        }
        $this->OKEICode = $oKEICode;
        return $this;
    }
    /**
     * Get OKEIName value
     * @return string|null
     */
    public function getOKEIName()
    {
        return $this->OKEIName;
    }
    /**
     * Set OKEIName value
     * @param string $oKEIName
     * @return \AisFssp\StructType\FishNonquotaContractDatumType
     */
    public function setOKEIName($oKEIName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oKEIName) && strlen($oKEIName) > 100) || (is_array($oKEIName) && count($oKEIName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($oKEIName) ? strlen($oKEIName) : count($oKEIName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($oKEIName) && strlen($oKEIName) < 1) || (is_array($oKEIName) && count($oKEIName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oKEIName) && !is_string($oKEIName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oKEIName)), __LINE__);
        }
        $this->OKEIName = $oKEIName;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \AisFssp\StructType\FishNonquotaContractDatumType
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: maxExclusive
        if ($startDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($startDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get finishDate value
     * @return string|null
     */
    public function getFinishDate()
    {
        return $this->finishDate;
    }
    /**
     * Set finishDate value
     * @param string $finishDate
     * @return \AisFssp\StructType\FishNonquotaContractDatumType
     */
    public function setFinishDate($finishDate = null)
    {
        // validation for constraint: maxExclusive
        if ($finishDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $finishDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($finishDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $finishDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($finishDate) && !is_string($finishDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($finishDate)), __LINE__);
        }
        $this->finishDate = $finishDate;
        return $this;
    }
    /**
     * Get finDocDate value
     * @return string|null
     */
    public function getFinDocDate()
    {
        return $this->finDocDate;
    }
    /**
     * Set finDocDate value
     * @param string $finDocDate
     * @return \AisFssp\StructType\FishNonquotaContractDatumType
     */
    public function setFinDocDate($finDocDate = null)
    {
        // validation for constraint: maxExclusive
        if ($finDocDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $finDocDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($finDocDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $finDocDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($finDocDate) && !is_string($finDocDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($finDocDate)), __LINE__);
        }
        $this->finDocDate = $finDocDate;
        return $this;
    }
    /**
     * Get finDocNumber value
     * @return string|null
     */
    public function getFinDocNumber()
    {
        return $this->finDocNumber;
    }
    /**
     * Set finDocNumber value
     * @param string $finDocNumber
     * @return \AisFssp\StructType\FishNonquotaContractDatumType
     */
    public function setFinDocNumber($finDocNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($finDocNumber) && strlen($finDocNumber) > 25) || (is_array($finDocNumber) && count($finDocNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($finDocNumber) ? strlen($finDocNumber) : count($finDocNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($finDocNumber) && strlen($finDocNumber) < 1) || (is_array($finDocNumber) && count($finDocNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($finDocNumber) && !is_string($finDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($finDocNumber)), __LINE__);
        }
        $this->finDocNumber = $finDocNumber;
        return $this;
    }
    /**
     * Get finDocGround value
     * @return string|null
     */
    public function getFinDocGround()
    {
        return $this->finDocGround;
    }
    /**
     * Set finDocGround value
     * @param string $finDocGround
     * @return \AisFssp\StructType\FishNonquotaContractDatumType
     */
    public function setFinDocGround($finDocGround = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($finDocGround) && strlen($finDocGround) > 300) || (is_array($finDocGround) && count($finDocGround) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($finDocGround) ? strlen($finDocGround) : count($finDocGround)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($finDocGround) && strlen($finDocGround) < 1) || (is_array($finDocGround) && count($finDocGround) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($finDocGround) && !is_string($finDocGround)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($finDocGround)), __LINE__);
        }
        $this->finDocGround = $finDocGround;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\FishNonquotaContractDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
