<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FileDataBlock StructType
 * Meta informations extracted from the WSDL
 * - documentation: Данные фрагмента файла
 * @subpackage Structs
 */
class FileDataBlock extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - documentation: Смещение от начала файла, байт | Смещение от начала файла
     * - minInclusive: 0
     * @var int
     */
    public $offset;
    /**
     * The length
     * Meta informations extracted from the WSDL
     * - documentation: Длина фрагмента файла в байтах | Размер файла
     * - minInclusive: 0
     * @var int
     */
    public $length;
    /**
     * The receiver_pack_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор пакета | Заполняется для пакетного режима передачи данных | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $receiver_pack_id;
    /**
     * The receiver_env_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор конверта | Заполняется для пакетного режима передачи данных | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $receiver_env_id;
    /**
     * The receiver_doc_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа | Заполняется для типа файла DOCUMENT, ALL_ATTACHMENTS, SINGLE_ATTACHMENT | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $receiver_doc_id;
    /**
     * The encoding
     * Meta informations extracted from the WSDL
     * - documentation: Код таблицы символов в формате "IANA CHARACTER SETS"
     * - maxLength: 40
     * - minLength: 1
     * @var string
     */
    public $encoding;
    /**
     * The size
     * Meta informations extracted from the WSDL
     * - documentation: Размер файла
     * - minInclusive: 0
     * @var int
     */
    public $size;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The digest
     * Meta informations extracted from the WSDL
     * - length: 32
     * @var string
     */
    public $digest;
    /**
     * The signature_digest
     * Meta informations extracted from the WSDL
     * - length: 32
     * @var string
     */
    public $signature_digest;
    /**
     * The pack_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $pack_id;
    /**
     * The env_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $env_id;
    /**
     * The doc_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $doc_id;
    /**
     * The attachmentTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Тип вложения
     * - maxLength: 31
     * - minLength: 1
     * @var string
     */
    public $attachmentTypeCode;
    /**
     * The systemCode1
     * Meta informations extracted from the WSDL
     * - documentation: Системный код 1
     * - maxLength: 31
     * - minLength: 1
     * @var string
     */
    public $systemCode1;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Имя файла
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * The content_type
     * Meta informations extracted from the WSDL
     * - documentation: MIME-тип данных | MIME-тип данных
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $content_type;
    /**
     * The attachment_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $attachment_id;
    /**
     * Constructor method for FileDataBlock
     * @uses FileDataBlock::set_()
     * @uses FileDataBlock::setOffset()
     * @uses FileDataBlock::setLength()
     * @uses FileDataBlock::setReceiver_pack_id()
     * @uses FileDataBlock::setReceiver_env_id()
     * @uses FileDataBlock::setReceiver_doc_id()
     * @uses FileDataBlock::setEncoding()
     * @uses FileDataBlock::setSize()
     * @uses FileDataBlock::setType()
     * @uses FileDataBlock::setDigest()
     * @uses FileDataBlock::setSignature_digest()
     * @uses FileDataBlock::setPack_id()
     * @uses FileDataBlock::setEnv_id()
     * @uses FileDataBlock::setDoc_id()
     * @uses FileDataBlock::setAttachmentTypeCode()
     * @uses FileDataBlock::setSystemCode1()
     * @uses FileDataBlock::setName()
     * @uses FileDataBlock::setContent_type()
     * @uses FileDataBlock::setAttachment_id()
     * @param string $_
     * @param int $offset
     * @param int $length
     * @param string $receiver_pack_id
     * @param string $receiver_env_id
     * @param string $receiver_doc_id
     * @param string $encoding
     * @param int $size
     * @param string $type
     * @param string $digest
     * @param string $signature_digest
     * @param string $pack_id
     * @param string $env_id
     * @param string $doc_id
     * @param string $attachmentTypeCode
     * @param string $systemCode1
     * @param string $name
     * @param string $content_type
     * @param string $attachment_id
     */
    public function __construct($_ = null, $offset = null, $length = null, $receiver_pack_id = null, $receiver_env_id = null, $receiver_doc_id = null, $encoding = null, $size = null, $type = null, $digest = null, $signature_digest = null, $pack_id = null, $env_id = null, $doc_id = null, $attachmentTypeCode = null, $systemCode1 = null, $name = null, $content_type = null, $attachment_id = null)
    {
        $this
            ->set_($_)
            ->setOffset($offset)
            ->setLength($length)
            ->setReceiver_pack_id($receiver_pack_id)
            ->setReceiver_env_id($receiver_env_id)
            ->setReceiver_doc_id($receiver_doc_id)
            ->setEncoding($encoding)
            ->setSize($size)
            ->setType($type)
            ->setDigest($digest)
            ->setSignature_digest($signature_digest)
            ->setPack_id($pack_id)
            ->setEnv_id($env_id)
            ->setDoc_id($doc_id)
            ->setAttachmentTypeCode($attachmentTypeCode)
            ->setSystemCode1($systemCode1)
            ->setName($name)
            ->setContent_type($content_type)
            ->setAttachment_id($attachment_id);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: minInclusive
        if ($offset < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $offset), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Get length value
     * @return int|null
     */
    public function getLength()
    {
        return $this->length;
    }
    /**
     * Set length value
     * @param int $length
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function setLength($length = null)
    {
        // validation for constraint: minInclusive
        if ($length < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $length), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($length) && !is_numeric($length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($length)), __LINE__);
        }
        $this->length = $length;
        return $this;
    }
    /**
     * Get receiver_pack_id value
     * @return string|null
     */
    public function getReceiver_pack_id()
    {
        return $this->receiver_pack_id;
    }
    /**
     * Set receiver_pack_id value
     * @param string $receiver_pack_id
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function setReceiver_pack_id($receiver_pack_id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($receiver_pack_id) && strlen($receiver_pack_id) > 60) || (is_array($receiver_pack_id) && count($receiver_pack_id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($receiver_pack_id) ? strlen($receiver_pack_id) : count($receiver_pack_id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($receiver_pack_id) && strlen($receiver_pack_id) < 1) || (is_array($receiver_pack_id) && count($receiver_pack_id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($receiver_pack_id) && !is_string($receiver_pack_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiver_pack_id)), __LINE__);
        }
        $this->receiver_pack_id = $receiver_pack_id;
        return $this;
    }
    /**
     * Get receiver_env_id value
     * @return string|null
     */
    public function getReceiver_env_id()
    {
        return $this->receiver_env_id;
    }
    /**
     * Set receiver_env_id value
     * @param string $receiver_env_id
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function setReceiver_env_id($receiver_env_id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($receiver_env_id) && strlen($receiver_env_id) > 60) || (is_array($receiver_env_id) && count($receiver_env_id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($receiver_env_id) ? strlen($receiver_env_id) : count($receiver_env_id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($receiver_env_id) && strlen($receiver_env_id) < 1) || (is_array($receiver_env_id) && count($receiver_env_id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($receiver_env_id) && !is_string($receiver_env_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiver_env_id)), __LINE__);
        }
        $this->receiver_env_id = $receiver_env_id;
        return $this;
    }
    /**
     * Get receiver_doc_id value
     * @return string|null
     */
    public function getReceiver_doc_id()
    {
        return $this->receiver_doc_id;
    }
    /**
     * Set receiver_doc_id value
     * @param string $receiver_doc_id
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function setReceiver_doc_id($receiver_doc_id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($receiver_doc_id) && strlen($receiver_doc_id) > 60) || (is_array($receiver_doc_id) && count($receiver_doc_id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($receiver_doc_id) ? strlen($receiver_doc_id) : count($receiver_doc_id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($receiver_doc_id) && strlen($receiver_doc_id) < 1) || (is_array($receiver_doc_id) && count($receiver_doc_id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($receiver_doc_id) && !is_string($receiver_doc_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiver_doc_id)), __LINE__);
        }
        $this->receiver_doc_id = $receiver_doc_id;
        return $this;
    }
    /**
     * Get encoding value
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->encoding;
    }
    /**
     * Set encoding value
     * @param string $encoding
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function setEncoding($encoding = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($encoding) && strlen($encoding) > 40) || (is_array($encoding) && count($encoding) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($encoding) ? strlen($encoding) : count($encoding)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($encoding) && strlen($encoding) < 1) || (is_array($encoding) && count($encoding) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($encoding) && !is_string($encoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($encoding)), __LINE__);
        }
        $this->encoding = $encoding;
        return $this;
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function setSize($size = null)
    {
        // validation for constraint: minInclusive
        if ($size < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $size), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($size) && !is_numeric($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \AisFssp\EnumType\FileType::valueIsValid()
     * @uses \AisFssp\EnumType\FileType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\FileType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \AisFssp\EnumType\FileType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get digest value
     * @return string|null
     */
    public function getDigest()
    {
        return $this->digest;
    }
    /**
     * Set digest value
     * @param string $digest
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function setDigest($digest = null)
    {
        // validation for constraint: length
        if ((is_scalar($digest) && strlen($digest) !== 32) || (is_array($digest) && count($digest) !== 32)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($digest) && !is_string($digest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digest)), __LINE__);
        }
        $this->digest = $digest;
        return $this;
    }
    /**
     * Get signature_digest value
     * @return string|null
     */
    public function getSignature_digest()
    {
        return $this->signature_digest;
    }
    /**
     * Set signature_digest value
     * @param string $signature_digest
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function setSignature_digest($signature_digest = null)
    {
        // validation for constraint: length
        if ((is_scalar($signature_digest) && strlen($signature_digest) !== 32) || (is_array($signature_digest) && count($signature_digest) !== 32)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signature_digest) && !is_string($signature_digest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signature_digest)), __LINE__);
        }
        $this->signature_digest = $signature_digest;
        return $this;
    }
    /**
     * Get pack_id value
     * @return string|null
     */
    public function getPack_id()
    {
        return $this->pack_id;
    }
    /**
     * Set pack_id value
     * @param string $pack_id
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function setPack_id($pack_id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pack_id) && strlen($pack_id) > 60) || (is_array($pack_id) && count($pack_id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($pack_id) ? strlen($pack_id) : count($pack_id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($pack_id) && strlen($pack_id) < 1) || (is_array($pack_id) && count($pack_id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pack_id) && !is_string($pack_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pack_id)), __LINE__);
        }
        $this->pack_id = $pack_id;
        return $this;
    }
    /**
     * Get env_id value
     * @return string|null
     */
    public function getEnv_id()
    {
        return $this->env_id;
    }
    /**
     * Set env_id value
     * @param string $env_id
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function setEnv_id($env_id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($env_id) && strlen($env_id) > 60) || (is_array($env_id) && count($env_id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($env_id) ? strlen($env_id) : count($env_id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($env_id) && strlen($env_id) < 1) || (is_array($env_id) && count($env_id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($env_id) && !is_string($env_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($env_id)), __LINE__);
        }
        $this->env_id = $env_id;
        return $this;
    }
    /**
     * Get doc_id value
     * @return string|null
     */
    public function getDoc_id()
    {
        return $this->doc_id;
    }
    /**
     * Set doc_id value
     * @param string $doc_id
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function setDoc_id($doc_id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($doc_id) && strlen($doc_id) > 60) || (is_array($doc_id) && count($doc_id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($doc_id) ? strlen($doc_id) : count($doc_id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($doc_id) && strlen($doc_id) < 1) || (is_array($doc_id) && count($doc_id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($doc_id) && !is_string($doc_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($doc_id)), __LINE__);
        }
        $this->doc_id = $doc_id;
        return $this;
    }
    /**
     * Get attachmentTypeCode value
     * @return string|null
     */
    public function getAttachmentTypeCode()
    {
        return $this->attachmentTypeCode;
    }
    /**
     * Set attachmentTypeCode value
     * @param string $attachmentTypeCode
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function setAttachmentTypeCode($attachmentTypeCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($attachmentTypeCode) && strlen($attachmentTypeCode) > 31) || (is_array($attachmentTypeCode) && count($attachmentTypeCode) > 31)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 31 element(s) or a scalar of 31 character(s) at most, "%d" length given', is_scalar($attachmentTypeCode) ? strlen($attachmentTypeCode) : count($attachmentTypeCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($attachmentTypeCode) && strlen($attachmentTypeCode) < 1) || (is_array($attachmentTypeCode) && count($attachmentTypeCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($attachmentTypeCode) && !is_string($attachmentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attachmentTypeCode)), __LINE__);
        }
        $this->attachmentTypeCode = $attachmentTypeCode;
        return $this;
    }
    /**
     * Get systemCode1 value
     * @return string|null
     */
    public function getSystemCode1()
    {
        return $this->systemCode1;
    }
    /**
     * Set systemCode1 value
     * @param string $systemCode1
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function setSystemCode1($systemCode1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($systemCode1) && strlen($systemCode1) > 31) || (is_array($systemCode1) && count($systemCode1) > 31)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 31 element(s) or a scalar of 31 character(s) at most, "%d" length given', is_scalar($systemCode1) ? strlen($systemCode1) : count($systemCode1)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($systemCode1) && strlen($systemCode1) < 1) || (is_array($systemCode1) && count($systemCode1) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($systemCode1) && !is_string($systemCode1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemCode1)), __LINE__);
        }
        $this->systemCode1 = $systemCode1;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($name) && strlen($name) < 1) || (is_array($name) && count($name) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get content_type value
     * @return string|null
     */
    public function getContent_type()
    {
        return $this->content_type;
    }
    /**
     * Set content_type value
     * @param string $content_type
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function setContent_type($content_type = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($content_type) && strlen($content_type) > 255) || (is_array($content_type) && count($content_type) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($content_type) ? strlen($content_type) : count($content_type)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($content_type) && strlen($content_type) < 1) || (is_array($content_type) && count($content_type) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($content_type) && !is_string($content_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content_type)), __LINE__);
        }
        $this->content_type = $content_type;
        return $this;
    }
    /**
     * Get attachment_id value
     * @return string|null
     */
    public function getAttachment_id()
    {
        return $this->attachment_id;
    }
    /**
     * Set attachment_id value
     * @param string $attachment_id
     * @return \AisFssp\StructType\FileDataBlock
     */
    public function setAttachment_id($attachment_id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($attachment_id) && strlen($attachment_id) > 60) || (is_array($attachment_id) && count($attachment_id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($attachment_id) ? strlen($attachment_id) : count($attachment_id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($attachment_id) && strlen($attachment_id) < 1) || (is_array($attachment_id) && count($attachment_id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($attachment_id) && !is_string($attachment_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attachment_id)), __LINE__);
        }
        $this->attachment_id = $attachment_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\FileDataBlock
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
