<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtPayments StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ ExtPayments «Оплата долга» | Содержит сведения об уплаченных на депозитный счет через системы платежей денежных средствах
 * | ЭП
 * - type: tns:ExtPayments
 * @subpackage Structs
 */
class ExtPayments extends AbstractStructBase
{
    /**
     * The ExtPayment
     * Meta informations extracted from the WSDL
     * - documentation: Платежи
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \AisFssp\StructType\ExtPayment[]
     */
    public $ExtPayment;
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор реестра оплаты, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The DebtInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ реестра ФССП России | Устарело. Следует использовать поле chargeDocKey в контейнере ExtPayment | Ключ объекта, присвоенний
     * информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $DebtInternalKey;
    /**
     * The IPInfoInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ сведений ИП | Устарело. Следует использовать поле chargeDocKey в контейнере ExtPayment | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IPInfoInternalKey;
    /**
     * The OspCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ОСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OspCode;
    /**
     * The ReeCreated
     * Meta informations extracted from the WSDL
     * - documentation: Дата реестра | Дата формирования реестра | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ReeCreated;
    /**
     * The PayCount
     * Meta informations extracted from the WSDL
     * - documentation: Количество платежей | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $PayCount;
    /**
     * The ReeSum
     * Meta informations extracted from the WSDL
     * - documentation: Общая сумма | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $ReeSum;
    /**
     * The PDDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата платежного документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PDDate;
    /**
     * The PDNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер платежного документа | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $PDNum;
    /**
     * The Payer
     * Meta informations extracted from the WSDL
     * - documentation: Плательщик
     * @var \AisFssp\StructType\PayProperties
     */
    public $Payer;
    /**
     * The Payee
     * Meta informations extracted from the WSDL
     * - documentation: Получатель
     * @var \AisFssp\StructType\PayProperties
     */
    public $Payee;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - documentation: Прикрепленные файлы
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\AttachmentType[]
     */
    public $attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for ExtPayments
     * @uses ExtPayments::setExtPayment()
     * @uses ExtPayments::setExternalKey()
     * @uses ExtPayments::setDebtInternalKey()
     * @uses ExtPayments::setIPInfoInternalKey()
     * @uses ExtPayments::setOspCode()
     * @uses ExtPayments::setReeCreated()
     * @uses ExtPayments::setPayCount()
     * @uses ExtPayments::setReeSum()
     * @uses ExtPayments::setPDDate()
     * @uses ExtPayments::setPDNum()
     * @uses ExtPayments::setPayer()
     * @uses ExtPayments::setPayee()
     * @uses ExtPayments::setAttachments()
     * @uses ExtPayments::setSignDateTime()
     * @uses ExtPayments::setSignature()
     * @uses ExtPayments::setId()
     * @param \AisFssp\StructType\ExtPayment[] $extPayment
     * @param string $externalKey
     * @param int $debtInternalKey
     * @param int $iPInfoInternalKey
     * @param string $ospCode
     * @param string $reeCreated
     * @param int $payCount
     * @param float $reeSum
     * @param string $pDDate
     * @param string $pDNum
     * @param \AisFssp\StructType\PayProperties $payer
     * @param \AisFssp\StructType\PayProperties $payee
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct(array $extPayment = array(), $externalKey = null, $debtInternalKey = null, $iPInfoInternalKey = null, $ospCode = null, $reeCreated = null, $payCount = null, $reeSum = null, $pDDate = null, $pDNum = null, \AisFssp\StructType\PayProperties $payer = null, \AisFssp\StructType\PayProperties $payee = null, array $attachments = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setExtPayment($extPayment)
            ->setExternalKey($externalKey)
            ->setDebtInternalKey($debtInternalKey)
            ->setIPInfoInternalKey($iPInfoInternalKey)
            ->setOspCode($ospCode)
            ->setReeCreated($reeCreated)
            ->setPayCount($payCount)
            ->setReeSum($reeSum)
            ->setPDDate($pDDate)
            ->setPDNum($pDNum)
            ->setPayer($payer)
            ->setPayee($payee)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExtPayment value
     * @return \AisFssp\StructType\ExtPayment[]
     */
    public function getExtPayment()
    {
        return $this->ExtPayment;
    }
    /**
     * Set ExtPayment value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ExtPayment[] $extPayment
     * @return \AisFssp\StructType\ExtPayments
     */
    public function setExtPayment(array $extPayment = array())
    {
        foreach ($extPayment as $extPaymentsExtPaymentItem) {
            // validation for constraint: itemType
            if (!$extPaymentsExtPaymentItem instanceof \AisFssp\StructType\ExtPayment) {
                throw new \InvalidArgumentException(sprintf('The ExtPayment property can only contain items of \AisFssp\StructType\ExtPayment, "%s" given', is_object($extPaymentsExtPaymentItem) ? get_class($extPaymentsExtPaymentItem) : gettype($extPaymentsExtPaymentItem)), __LINE__);
            }
        }
        $this->ExtPayment = $extPayment;
        return $this;
    }
    /**
     * Add item to ExtPayment value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ExtPayment $item
     * @return \AisFssp\StructType\ExtPayments
     */
    public function addToExtPayment(\AisFssp\StructType\ExtPayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\ExtPayment) {
            throw new \InvalidArgumentException(sprintf('The ExtPayment property can only contain items of \AisFssp\StructType\ExtPayment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ExtPayment[] = $item;
        return $this;
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\ExtPayments
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get DebtInternalKey value
     * @return int|null
     */
    public function getDebtInternalKey()
    {
        return $this->DebtInternalKey;
    }
    /**
     * Set DebtInternalKey value
     * @param int $debtInternalKey
     * @return \AisFssp\StructType\ExtPayments
     */
    public function setDebtInternalKey($debtInternalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($debtInternalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $debtInternalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($debtInternalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $debtInternalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($debtInternalKey) && !is_numeric($debtInternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($debtInternalKey)), __LINE__);
        }
        $this->DebtInternalKey = $debtInternalKey;
        return $this;
    }
    /**
     * Get IPInfoInternalKey value
     * @return int|null
     */
    public function getIPInfoInternalKey()
    {
        return $this->IPInfoInternalKey;
    }
    /**
     * Set IPInfoInternalKey value
     * @param int $iPInfoInternalKey
     * @return \AisFssp\StructType\ExtPayments
     */
    public function setIPInfoInternalKey($iPInfoInternalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($iPInfoInternalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $iPInfoInternalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($iPInfoInternalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $iPInfoInternalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($iPInfoInternalKey) && !is_numeric($iPInfoInternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iPInfoInternalKey)), __LINE__);
        }
        $this->IPInfoInternalKey = $iPInfoInternalKey;
        return $this;
    }
    /**
     * Get OspCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->OspCode;
    }
    /**
     * Set OspCode value
     * @param string $ospCode
     * @return \AisFssp\StructType\ExtPayments
     */
    public function setOspCode($ospCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($ospCode) && strlen($ospCode) !== 5) || (is_array($ospCode) && count($ospCode) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($ospCode) && !preg_match('/[0-9]{5}/', $ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($ospCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ospCode) && !is_string($ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ospCode)), __LINE__);
        }
        $this->OspCode = $ospCode;
        return $this;
    }
    /**
     * Get ReeCreated value
     * @return string|null
     */
    public function getReeCreated()
    {
        return $this->ReeCreated;
    }
    /**
     * Set ReeCreated value
     * @param string $reeCreated
     * @return \AisFssp\StructType\ExtPayments
     */
    public function setReeCreated($reeCreated = null)
    {
        // validation for constraint: maxExclusive
        if ($reeCreated >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $reeCreated), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($reeCreated < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $reeCreated), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($reeCreated) && !is_string($reeCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reeCreated)), __LINE__);
        }
        $this->ReeCreated = $reeCreated;
        return $this;
    }
    /**
     * Get PayCount value
     * @return int|null
     */
    public function getPayCount()
    {
        return $this->PayCount;
    }
    /**
     * Set PayCount value
     * @param int $payCount
     * @return \AisFssp\StructType\ExtPayments
     */
    public function setPayCount($payCount = null)
    {
        // validation for constraint: maxInclusive
        if ($payCount > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $payCount), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($payCount) && !is_numeric($payCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($payCount)), __LINE__);
        }
        $this->PayCount = $payCount;
        return $this;
    }
    /**
     * Get ReeSum value
     * @return float|null
     */
    public function getReeSum()
    {
        return $this->ReeSum;
    }
    /**
     * Set ReeSum value
     * @param float $reeSum
     * @return \AisFssp\StructType\ExtPayments
     */
    public function setReeSum($reeSum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($reeSum) && strlen(substr($reeSum, strpos($reeSum, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($reeSum, strpos($reeSum, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($reeSum) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $reeSum)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($reeSum, strpos($reeSum, '.')))), __LINE__);
        }
        $this->ReeSum = $reeSum;
        return $this;
    }
    /**
     * Get PDDate value
     * @return string|null
     */
    public function getPDDate()
    {
        return $this->PDDate;
    }
    /**
     * Set PDDate value
     * @param string $pDDate
     * @return \AisFssp\StructType\ExtPayments
     */
    public function setPDDate($pDDate = null)
    {
        // validation for constraint: maxExclusive
        if ($pDDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $pDDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($pDDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $pDDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pDDate) && !is_string($pDDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pDDate)), __LINE__);
        }
        $this->PDDate = $pDDate;
        return $this;
    }
    /**
     * Get PDNum value
     * @return string|null
     */
    public function getPDNum()
    {
        return $this->PDNum;
    }
    /**
     * Set PDNum value
     * @param string $pDNum
     * @return \AisFssp\StructType\ExtPayments
     */
    public function setPDNum($pDNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pDNum) && strlen($pDNum) > 20) || (is_array($pDNum) && count($pDNum) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($pDNum) ? strlen($pDNum) : count($pDNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($pDNum) && strlen($pDNum) < 1) || (is_array($pDNum) && count($pDNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pDNum) && !is_string($pDNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pDNum)), __LINE__);
        }
        $this->PDNum = $pDNum;
        return $this;
    }
    /**
     * Get Payer value
     * @return \AisFssp\StructType\PayProperties|null
     */
    public function getPayer()
    {
        return $this->Payer;
    }
    /**
     * Set Payer value
     * @param \AisFssp\StructType\PayProperties $payer
     * @return \AisFssp\StructType\ExtPayments
     */
    public function setPayer(\AisFssp\StructType\PayProperties $payer = null)
    {
        $this->Payer = $payer;
        return $this;
    }
    /**
     * Get Payee value
     * @return \AisFssp\StructType\PayProperties|null
     */
    public function getPayee()
    {
        return $this->Payee;
    }
    /**
     * Set Payee value
     * @param \AisFssp\StructType\PayProperties $payee
     * @return \AisFssp\StructType\ExtPayments
     */
    public function setPayee(\AisFssp\StructType\PayProperties $payee = null)
    {
        $this->Payee = $payee;
        return $this;
    }
    /**
     * Get attachments value
     * @return \AisFssp\StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @return \AisFssp\StructType\ExtPayments
     */
    public function setAttachments(array $attachments = array())
    {
        foreach ($attachments as $extPaymentsAttachmentsItem) {
            // validation for constraint: itemType
            if (!$extPaymentsAttachmentsItem instanceof \AisFssp\StructType\AttachmentType) {
                throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($extPaymentsAttachmentsItem) ? get_class($extPaymentsAttachmentsItem) : gettype($extPaymentsAttachmentsItem)), __LINE__);
            }
        }
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType $item
     * @return \AisFssp\StructType\ExtPayments
     */
    public function addToAttachments(\AisFssp\StructType\AttachmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\AttachmentType) {
            throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\ExtPayments
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\ExtPayments
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $extPaymentsSignatureItem) {
            // validation for constraint: itemType
            if (!$extPaymentsSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($extPaymentsSignatureItem) ? get_class($extPaymentsSignatureItem) : gettype($extPaymentsSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\ExtPayments
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\ExtPayments
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ExtPayments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
