<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtPayment StructType
 * Meta informations extracted from the WSDL
 * - documentation: Контейнер Платеж
 * - type: tns:ExtPayment
 * @subpackage Structs
 */
class ExtPayment extends AbstractStructBase
{
    /**
     * The IpInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП России | Уникальный идентификатор исполнительного производства, присвоенный АИС ФССП России | Ключ объекта,
     * присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IpInternalKey;
    /**
     * The ChargeDocKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ документа, предоставляющего сведения об ИП | Идентификатор документа, по которому произведено начисление суммы долга по
     * ИП.Может быть идентификатором реестра долга или идентификатором сведений ИП.Обязательно использование значения этого элемента, в том
     * случае, если не используются элементы DebtInternalKey или IPInfoInternalKey в документе ExtPayments | Ключ объекта, присвоенний информационной системой ФССП
     * РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $ChargeDocKey;
    /**
     * The OspCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ОСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OspCode;
    /**
     * The IpNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IpNumber;
    /**
     * The IpRiseDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата возбуждения ИП | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IpRiseDate;
    /**
     * The PayID
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор платежа | Строка длиной от 1 до 36 символов
     * - maxLength: 36
     * - minLength: 1
     * @var string
     */
    public $PayID;
    /**
     * The Terminal
     * Meta informations extracted from the WSDL
     * - documentation: Терминал | Код терминала, банкомата, окна и др., откуда поступил платеж | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $Terminal;
    /**
     * The ChargeStatus
     * Meta informations extracted from the WSDL
     * - documentation: Статус платежа | Статус, отображающий изменение данных платежа, полученный от ГИС ГМП
     * - minOccurs: 0
     * @var string
     */
    public $ChargeStatus;
    /**
     * The UNIFOCode
     * Meta informations extracted from the WSDL
     * - documentation: Код начисления УНИФО | Код начисления УНИФО
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 20
     * - pattern: (([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]
     * @var string
     */
    public $UNIFOCode;
    /**
     * The BudgetCode
     * Meta informations extracted from the WSDL
     * - documentation: Код бюджетной классификации | Код бюджетной классификации
     * - minOccurs: 0
     * - length: 20
     * @var string
     */
    public $BudgetCode;
    /**
     * The PayDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время платежа | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $PayDateTime;
    /**
     * The PaySum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма платежа | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $PaySum;
    /**
     * The Narrative
     * Meta informations extracted from the WSDL
     * - documentation: Назначение платежа | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $Narrative;
    /**
     * The PayerIdentifier
     * Meta informations extracted from the WSDL
     * - documentation: Уникальный идентификатор плательщика | Строка длиной от 1 до 25 символов
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PayerIdentifier;
    /**
     * Constructor method for ExtPayment
     * @uses ExtPayment::setIpInternalKey()
     * @uses ExtPayment::setChargeDocKey()
     * @uses ExtPayment::setOspCode()
     * @uses ExtPayment::setIpNumber()
     * @uses ExtPayment::setIpRiseDate()
     * @uses ExtPayment::setPayID()
     * @uses ExtPayment::setTerminal()
     * @uses ExtPayment::setChargeStatus()
     * @uses ExtPayment::setUNIFOCode()
     * @uses ExtPayment::setBudgetCode()
     * @uses ExtPayment::setPayDateTime()
     * @uses ExtPayment::setPaySum()
     * @uses ExtPayment::setNarrative()
     * @uses ExtPayment::setPayerIdentifier()
     * @param int $ipInternalKey
     * @param int $chargeDocKey
     * @param string $ospCode
     * @param string $ipNumber
     * @param string $ipRiseDate
     * @param string $payID
     * @param string $terminal
     * @param string $chargeStatus
     * @param string $uNIFOCode
     * @param string $budgetCode
     * @param string $payDateTime
     * @param float $paySum
     * @param string $narrative
     * @param string $payerIdentifier
     */
    public function __construct($ipInternalKey = null, $chargeDocKey = null, $ospCode = null, $ipNumber = null, $ipRiseDate = null, $payID = null, $terminal = null, $chargeStatus = null, $uNIFOCode = null, $budgetCode = null, $payDateTime = null, $paySum = null, $narrative = null, $payerIdentifier = null)
    {
        $this
            ->setIpInternalKey($ipInternalKey)
            ->setChargeDocKey($chargeDocKey)
            ->setOspCode($ospCode)
            ->setIpNumber($ipNumber)
            ->setIpRiseDate($ipRiseDate)
            ->setPayID($payID)
            ->setTerminal($terminal)
            ->setChargeStatus($chargeStatus)
            ->setUNIFOCode($uNIFOCode)
            ->setBudgetCode($budgetCode)
            ->setPayDateTime($payDateTime)
            ->setPaySum($paySum)
            ->setNarrative($narrative)
            ->setPayerIdentifier($payerIdentifier);
    }
    /**
     * Get IpInternalKey value
     * @return int|null
     */
    public function getIpInternalKey()
    {
        return $this->IpInternalKey;
    }
    /**
     * Set IpInternalKey value
     * @param int $ipInternalKey
     * @return \AisFssp\StructType\ExtPayment
     */
    public function setIpInternalKey($ipInternalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($ipInternalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $ipInternalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($ipInternalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $ipInternalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($ipInternalKey) && !is_numeric($ipInternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ipInternalKey)), __LINE__);
        }
        $this->IpInternalKey = $ipInternalKey;
        return $this;
    }
    /**
     * Get ChargeDocKey value
     * @return int|null
     */
    public function getChargeDocKey()
    {
        return $this->ChargeDocKey;
    }
    /**
     * Set ChargeDocKey value
     * @param int $chargeDocKey
     * @return \AisFssp\StructType\ExtPayment
     */
    public function setChargeDocKey($chargeDocKey = null)
    {
        // validation for constraint: maxInclusive
        if ($chargeDocKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $chargeDocKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($chargeDocKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $chargeDocKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($chargeDocKey) && !is_numeric($chargeDocKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeDocKey)), __LINE__);
        }
        $this->ChargeDocKey = $chargeDocKey;
        return $this;
    }
    /**
     * Get OspCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->OspCode;
    }
    /**
     * Set OspCode value
     * @param string $ospCode
     * @return \AisFssp\StructType\ExtPayment
     */
    public function setOspCode($ospCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($ospCode) && strlen($ospCode) !== 5) || (is_array($ospCode) && count($ospCode) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($ospCode) && !preg_match('/[0-9]{5}/', $ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($ospCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ospCode) && !is_string($ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ospCode)), __LINE__);
        }
        $this->OspCode = $ospCode;
        return $this;
    }
    /**
     * Get IpNumber value
     * @return string|null
     */
    public function getIpNumber()
    {
        return $this->IpNumber;
    }
    /**
     * Set IpNumber value
     * @param string $ipNumber
     * @return \AisFssp\StructType\ExtPayment
     */
    public function setIpNumber($ipNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ipNumber) && strlen($ipNumber) > 25) || (is_array($ipNumber) && count($ipNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($ipNumber) ? strlen($ipNumber) : count($ipNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ipNumber) && strlen($ipNumber) < 1) || (is_array($ipNumber) && count($ipNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ipNumber) && !is_string($ipNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipNumber)), __LINE__);
        }
        $this->IpNumber = $ipNumber;
        return $this;
    }
    /**
     * Get IpRiseDate value
     * @return string|null
     */
    public function getIpRiseDate()
    {
        return $this->IpRiseDate;
    }
    /**
     * Set IpRiseDate value
     * @param string $ipRiseDate
     * @return \AisFssp\StructType\ExtPayment
     */
    public function setIpRiseDate($ipRiseDate = null)
    {
        // validation for constraint: maxExclusive
        if ($ipRiseDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $ipRiseDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($ipRiseDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $ipRiseDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ipRiseDate) && !is_string($ipRiseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipRiseDate)), __LINE__);
        }
        $this->IpRiseDate = $ipRiseDate;
        return $this;
    }
    /**
     * Get PayID value
     * @return string|null
     */
    public function getPayID()
    {
        return $this->PayID;
    }
    /**
     * Set PayID value
     * @param string $payID
     * @return \AisFssp\StructType\ExtPayment
     */
    public function setPayID($payID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($payID) && strlen($payID) > 36) || (is_array($payID) && count($payID) > 36)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s) at most, "%d" length given', is_scalar($payID) ? strlen($payID) : count($payID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($payID) && strlen($payID) < 1) || (is_array($payID) && count($payID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($payID) && !is_string($payID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payID)), __LINE__);
        }
        $this->PayID = $payID;
        return $this;
    }
    /**
     * Get Terminal value
     * @return string|null
     */
    public function getTerminal()
    {
        return $this->Terminal;
    }
    /**
     * Set Terminal value
     * @param string $terminal
     * @return \AisFssp\StructType\ExtPayment
     */
    public function setTerminal($terminal = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($terminal) && strlen($terminal) > 20) || (is_array($terminal) && count($terminal) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($terminal) ? strlen($terminal) : count($terminal)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($terminal) && strlen($terminal) < 1) || (is_array($terminal) && count($terminal) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($terminal) && !is_string($terminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminal)), __LINE__);
        }
        $this->Terminal = $terminal;
        return $this;
    }
    /**
     * Get ChargeStatus value
     * @return string|null
     */
    public function getChargeStatus()
    {
        return $this->ChargeStatus;
    }
    /**
     * Set ChargeStatus value
     * @uses \AisFssp\EnumType\ChargeStatusType::valueIsValid()
     * @uses \AisFssp\EnumType\ChargeStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $chargeStatus
     * @return \AisFssp\StructType\ExtPayment
     */
    public function setChargeStatus($chargeStatus = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ChargeStatusType::valueIsValid($chargeStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $chargeStatus, implode(', ', \AisFssp\EnumType\ChargeStatusType::getValidValues())), __LINE__);
        }
        $this->ChargeStatus = $chargeStatus;
        return $this;
    }
    /**
     * Get UNIFOCode value
     * @return string|null
     */
    public function getUNIFOCode()
    {
        return $this->UNIFOCode;
    }
    /**
     * Set UNIFOCode value
     * @param string $uNIFOCode
     * @return \AisFssp\StructType\ExtPayment
     */
    public function setUNIFOCode($uNIFOCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uNIFOCode) && strlen($uNIFOCode) > 25) || (is_array($uNIFOCode) && count($uNIFOCode) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($uNIFOCode) ? strlen($uNIFOCode) : count($uNIFOCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($uNIFOCode) && strlen($uNIFOCode) < 20) || (is_array($uNIFOCode) && count($uNIFOCode) < 20)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($uNIFOCode) && !preg_match('/(([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]/', $uNIFOCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]", "%s" given', var_export($uNIFOCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uNIFOCode) && !is_string($uNIFOCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uNIFOCode)), __LINE__);
        }
        $this->UNIFOCode = $uNIFOCode;
        return $this;
    }
    /**
     * Get BudgetCode value
     * @return string|null
     */
    public function getBudgetCode()
    {
        return $this->BudgetCode;
    }
    /**
     * Set BudgetCode value
     * @param string $budgetCode
     * @return \AisFssp\StructType\ExtPayment
     */
    public function setBudgetCode($budgetCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($budgetCode) && strlen($budgetCode) !== 20) || (is_array($budgetCode) && count($budgetCode) !== 20)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($budgetCode) && !is_string($budgetCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($budgetCode)), __LINE__);
        }
        $this->BudgetCode = $budgetCode;
        return $this;
    }
    /**
     * Get PayDateTime value
     * @return string|null
     */
    public function getPayDateTime()
    {
        return $this->PayDateTime;
    }
    /**
     * Set PayDateTime value
     * @param string $payDateTime
     * @return \AisFssp\StructType\ExtPayment
     */
    public function setPayDateTime($payDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($payDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $payDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($payDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $payDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($payDateTime) && !is_string($payDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payDateTime)), __LINE__);
        }
        $this->PayDateTime = $payDateTime;
        return $this;
    }
    /**
     * Get PaySum value
     * @return float|null
     */
    public function getPaySum()
    {
        return $this->PaySum;
    }
    /**
     * Set PaySum value
     * @param float $paySum
     * @return \AisFssp\StructType\ExtPayment
     */
    public function setPaySum($paySum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($paySum) && strlen(substr($paySum, strpos($paySum, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($paySum, strpos($paySum, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($paySum) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $paySum)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($paySum, strpos($paySum, '.')))), __LINE__);
        }
        $this->PaySum = $paySum;
        return $this;
    }
    /**
     * Get Narrative value
     * @return string|null
     */
    public function getNarrative()
    {
        return $this->Narrative;
    }
    /**
     * Set Narrative value
     * @param string $narrative
     * @return \AisFssp\StructType\ExtPayment
     */
    public function setNarrative($narrative = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($narrative) && strlen($narrative) > 255) || (is_array($narrative) && count($narrative) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($narrative) ? strlen($narrative) : count($narrative)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($narrative) && strlen($narrative) < 1) || (is_array($narrative) && count($narrative) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($narrative) && !is_string($narrative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($narrative)), __LINE__);
        }
        $this->Narrative = $narrative;
        return $this;
    }
    /**
     * Get PayerIdentifier value
     * @return string|null
     */
    public function getPayerIdentifier()
    {
        return $this->PayerIdentifier;
    }
    /**
     * Set PayerIdentifier value
     * @param string $payerIdentifier
     * @return \AisFssp\StructType\ExtPayment
     */
    public function setPayerIdentifier($payerIdentifier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($payerIdentifier) && strlen($payerIdentifier) > 25) || (is_array($payerIdentifier) && count($payerIdentifier) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($payerIdentifier) ? strlen($payerIdentifier) : count($payerIdentifier)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($payerIdentifier) && strlen($payerIdentifier) < 1) || (is_array($payerIdentifier) && count($payerIdentifier) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($payerIdentifier) && !is_string($payerIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payerIdentifier)), __LINE__);
        }
        $this->PayerIdentifier = $payerIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ExtPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
