<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtDebtFix StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ ExtDebtFix «Погашение ИД» | Содержит сведения о самостоятельном погашении долга должником по ИД непосредственно
 * взыскателю (не через депозитный счет). Сведения включают проверочную информацию о должнике в связи с неуникальностью реквизитов
 * исполнительного документа | ЭП
 * - type: tns:ExtDebtFix
 * @subpackage Structs
 */
class ExtDebtFix extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор документа, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The IdExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор ИД АИС ВК | Идентификатор исполнительного документа, полученного ранее от АИС внешнего контрагента |
     * Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным
     * для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $IdExternalKey;
    /**
     * The IDNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИД | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IDNum;
    /**
     * The IDDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ИД | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IDDate;
    /**
     * The DebtorBirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения должника (для ФЛ) | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DebtorBirthDate;
    /**
     * The DebtorBirthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения ФЛ | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $DebtorBirthYear;
    /**
     * The DebtorINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН должника (для ИП/ЮЛ) | ИНН
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $DebtorINN;
    /**
     * The DebtorKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП должника | Код причины постановки на учет ЮЛ | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $DebtorKPP;
    /**
     * The DebtorOGRN
     * Meta informations extracted from the WSDL
     * - documentation: ОГРН/ОГРНИП | ОГРН/ОГРНИП ЮЛ/ИП | Основной государственный регистрационный номер (ОГРН)/Основной государственный
     * регистрационный номер индивидуального предпринимателя (ОГРНИП)
     * - minOccurs: 0
     * - maxLength: 15
     * - minLength: 13
     * - pattern: ([0-9]{13})|([0-9]{15})
     * @var string
     */
    public $DebtorOGRN;
    /**
     * The DebtorAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес должника | Адрес должника в формате «Код страны» + «запятая» + «Адрес в формате 9 запятых по КЛАДР» или (в случае отсутствия
     * кода страны) в произвольном формате | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DebtorAdr;
    /**
     * The PaySum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма платежа | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $PaySum;
    /**
     * The PDDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата платежного документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PDDate;
    /**
     * The PDNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер платежного документа | Строка длиной от 1 до 36 символов
     * - minOccurs: 0
     * - maxLength: 36
     * - minLength: 1
     * @var string
     */
    public $PDNum;
    /**
     * The ChargeStatus
     * Meta informations extracted from the WSDL
     * - documentation: Статус платежа | Статус, отображающий изменение данных платежа, полученный от ГИС ГМП
     * - minOccurs: 0
     * @var string
     */
    public $ChargeStatus;
    /**
     * The IPNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNum;
    /**
     * The IsPayingOff
     * Meta informations extracted from the WSDL
     * - documentation: Уточнение или погашение
     * @var string
     */
    public $IsPayingOff;
    /**
     * The ExtDebtFixBase
     * Meta informations extracted from the WSDL
     * - documentation: Погашение ИД | Электронное обращение составленный в соответствии с форматом Приложения № 3 «Форматы электронного обращение» в
     * кодировке Base64
     * - minOccurs: 0
     * @var string
     */
    public $ExtDebtFixBase;
    /**
     * The SignatureBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП Погашение ИД | Электронное обращение составленный в соответствии с форматом Приложения № 3 «Форматы электронного
     * обращение» в кодировке Base64
     * - minOccurs: 0
     * @var string
     */
    public $SignatureBase;
    /**
     * The PaymentProperties
     * Meta informations extracted from the WSDL
     * - documentation: Реквизиты для перечисления | Реквизиты для перечисления взысканных сумм взыскателю (для налоговых платежей может быть указано
     * больше одного набора реквизитов). Тип данных описан в документе «Исполнительный документ»
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\PaymentProperties[]
     */
    public $PaymentProperties;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - documentation: Прикрепленные файлы
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\AttachmentType[]
     */
    public $attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for ExtDebtFix
     * @uses ExtDebtFix::setExternalKey()
     * @uses ExtDebtFix::setIdExternalKey()
     * @uses ExtDebtFix::setIDNum()
     * @uses ExtDebtFix::setIDDate()
     * @uses ExtDebtFix::setDebtorBirthDate()
     * @uses ExtDebtFix::setDebtorBirthYear()
     * @uses ExtDebtFix::setDebtorINN()
     * @uses ExtDebtFix::setDebtorKPP()
     * @uses ExtDebtFix::setDebtorOGRN()
     * @uses ExtDebtFix::setDebtorAdr()
     * @uses ExtDebtFix::setPaySum()
     * @uses ExtDebtFix::setPDDate()
     * @uses ExtDebtFix::setPDNum()
     * @uses ExtDebtFix::setChargeStatus()
     * @uses ExtDebtFix::setIPNum()
     * @uses ExtDebtFix::setIsPayingOff()
     * @uses ExtDebtFix::setExtDebtFixBase()
     * @uses ExtDebtFix::setSignatureBase()
     * @uses ExtDebtFix::setPaymentProperties()
     * @uses ExtDebtFix::setAttachments()
     * @uses ExtDebtFix::setSignDateTime()
     * @uses ExtDebtFix::setSignature()
     * @uses ExtDebtFix::setId()
     * @param string $externalKey
     * @param string $idExternalKey
     * @param string $iDNum
     * @param string $iDDate
     * @param string $debtorBirthDate
     * @param string $debtorBirthYear
     * @param string $debtorINN
     * @param string $debtorKPP
     * @param string $debtorOGRN
     * @param string $debtorAdr
     * @param float $paySum
     * @param string $pDDate
     * @param string $pDNum
     * @param string $chargeStatus
     * @param string $iPNum
     * @param string $isPayingOff
     * @param string $extDebtFixBase
     * @param string $signatureBase
     * @param \AisFssp\StructType\PaymentProperties[] $paymentProperties
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $idExternalKey = null, $iDNum = null, $iDDate = null, $debtorBirthDate = null, $debtorBirthYear = null, $debtorINN = null, $debtorKPP = null, $debtorOGRN = null, $debtorAdr = null, $paySum = null, $pDDate = null, $pDNum = null, $chargeStatus = null, $iPNum = null, $isPayingOff = null, $extDebtFixBase = null, $signatureBase = null, array $paymentProperties = array(), array $attachments = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setIdExternalKey($idExternalKey)
            ->setIDNum($iDNum)
            ->setIDDate($iDDate)
            ->setDebtorBirthDate($debtorBirthDate)
            ->setDebtorBirthYear($debtorBirthYear)
            ->setDebtorINN($debtorINN)
            ->setDebtorKPP($debtorKPP)
            ->setDebtorOGRN($debtorOGRN)
            ->setDebtorAdr($debtorAdr)
            ->setPaySum($paySum)
            ->setPDDate($pDDate)
            ->setPDNum($pDNum)
            ->setChargeStatus($chargeStatus)
            ->setIPNum($iPNum)
            ->setIsPayingOff($isPayingOff)
            ->setExtDebtFixBase($extDebtFixBase)
            ->setSignatureBase($signatureBase)
            ->setPaymentProperties($paymentProperties)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get IdExternalKey value
     * @return string|null
     */
    public function getIdExternalKey()
    {
        return $this->IdExternalKey;
    }
    /**
     * Set IdExternalKey value
     * @param string $idExternalKey
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setIdExternalKey($idExternalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($idExternalKey) && strlen($idExternalKey) > 60) || (is_array($idExternalKey) && count($idExternalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($idExternalKey) ? strlen($idExternalKey) : count($idExternalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($idExternalKey) && strlen($idExternalKey) < 1) || (is_array($idExternalKey) && count($idExternalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idExternalKey) && !is_string($idExternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idExternalKey)), __LINE__);
        }
        $this->IdExternalKey = $idExternalKey;
        return $this;
    }
    /**
     * Get IDNum value
     * @return string|null
     */
    public function getIDNum()
    {
        return $this->IDNum;
    }
    /**
     * Set IDNum value
     * @param string $iDNum
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setIDNum($iDNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDNum) && strlen($iDNum) > 25) || (is_array($iDNum) && count($iDNum) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($iDNum) ? strlen($iDNum) : count($iDNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDNum) && strlen($iDNum) < 1) || (is_array($iDNum) && count($iDNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDNum) && !is_string($iDNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDNum)), __LINE__);
        }
        $this->IDNum = $iDNum;
        return $this;
    }
    /**
     * Get IDDate value
     * @return string|null
     */
    public function getIDDate()
    {
        return $this->IDDate;
    }
    /**
     * Set IDDate value
     * @param string $iDDate
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setIDDate($iDDate = null)
    {
        // validation for constraint: maxExclusive
        if ($iDDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $iDDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($iDDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $iDDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDDate) && !is_string($iDDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDDate)), __LINE__);
        }
        $this->IDDate = $iDDate;
        return $this;
    }
    /**
     * Get DebtorBirthDate value
     * @return string|null
     */
    public function getDebtorBirthDate()
    {
        return $this->DebtorBirthDate;
    }
    /**
     * Set DebtorBirthDate value
     * @param string $debtorBirthDate
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setDebtorBirthDate($debtorBirthDate = null)
    {
        // validation for constraint: maxExclusive
        if ($debtorBirthDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $debtorBirthDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($debtorBirthDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $debtorBirthDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorBirthDate) && !is_string($debtorBirthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorBirthDate)), __LINE__);
        }
        $this->DebtorBirthDate = $debtorBirthDate;
        return $this;
    }
    /**
     * Get DebtorBirthYear value
     * @return string|null
     */
    public function getDebtorBirthYear()
    {
        return $this->DebtorBirthYear;
    }
    /**
     * Set DebtorBirthYear value
     * @param string $debtorBirthYear
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setDebtorBirthYear($debtorBirthYear = null)
    {
        // validation for constraint: maxInclusive
        if ($debtorBirthYear > 2099) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2099, "%s" given', $debtorBirthYear), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($debtorBirthYear < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $debtorBirthYear), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorBirthYear) && !is_string($debtorBirthYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorBirthYear)), __LINE__);
        }
        $this->DebtorBirthYear = $debtorBirthYear;
        return $this;
    }
    /**
     * Get DebtorINN value
     * @return string|null
     */
    public function getDebtorINN()
    {
        return $this->DebtorINN;
    }
    /**
     * Set DebtorINN value
     * @param string $debtorINN
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setDebtorINN($debtorINN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorINN) && strlen($debtorINN) > 12) || (is_array($debtorINN) && count($debtorINN) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($debtorINN) ? strlen($debtorINN) : count($debtorINN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorINN) && strlen($debtorINN) < 10) || (is_array($debtorINN) && count($debtorINN) < 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($debtorINN) && !preg_match('/(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})/', $debtorINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})", "%s" given', var_export($debtorINN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorINN) && !is_string($debtorINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorINN)), __LINE__);
        }
        $this->DebtorINN = $debtorINN;
        return $this;
    }
    /**
     * Get DebtorKPP value
     * @return string|null
     */
    public function getDebtorKPP()
    {
        return $this->DebtorKPP;
    }
    /**
     * Set DebtorKPP value
     * @param string $debtorKPP
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setDebtorKPP($debtorKPP = null)
    {
        // validation for constraint: length
        if ((is_scalar($debtorKPP) && strlen($debtorKPP) !== 9) || (is_array($debtorKPP) && count($debtorKPP) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($debtorKPP) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}/', $debtorKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}", "%s" given', var_export($debtorKPP, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorKPP) && !is_string($debtorKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorKPP)), __LINE__);
        }
        $this->DebtorKPP = $debtorKPP;
        return $this;
    }
    /**
     * Get DebtorOGRN value
     * @return string|null
     */
    public function getDebtorOGRN()
    {
        return $this->DebtorOGRN;
    }
    /**
     * Set DebtorOGRN value
     * @param string $debtorOGRN
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setDebtorOGRN($debtorOGRN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorOGRN) && strlen($debtorOGRN) > 15) || (is_array($debtorOGRN) && count($debtorOGRN) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($debtorOGRN) ? strlen($debtorOGRN) : count($debtorOGRN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorOGRN) && strlen($debtorOGRN) < 13) || (is_array($debtorOGRN) && count($debtorOGRN) < 13)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($debtorOGRN) && !preg_match('/([0-9]{13})|([0-9]{15})/', $debtorOGRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{13})|([0-9]{15})", "%s" given', var_export($debtorOGRN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorOGRN) && !is_string($debtorOGRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorOGRN)), __LINE__);
        }
        $this->DebtorOGRN = $debtorOGRN;
        return $this;
    }
    /**
     * Get DebtorAdr value
     * @return string|null
     */
    public function getDebtorAdr()
    {
        return $this->DebtorAdr;
    }
    /**
     * Set DebtorAdr value
     * @param string $debtorAdr
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setDebtorAdr($debtorAdr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorAdr) && strlen($debtorAdr) > 300) || (is_array($debtorAdr) && count($debtorAdr) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($debtorAdr) ? strlen($debtorAdr) : count($debtorAdr)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorAdr) && strlen($debtorAdr) < 1) || (is_array($debtorAdr) && count($debtorAdr) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorAdr) && !is_string($debtorAdr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorAdr)), __LINE__);
        }
        $this->DebtorAdr = $debtorAdr;
        return $this;
    }
    /**
     * Get PaySum value
     * @return float|null
     */
    public function getPaySum()
    {
        return $this->PaySum;
    }
    /**
     * Set PaySum value
     * @param float $paySum
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setPaySum($paySum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($paySum) && strlen(substr($paySum, strpos($paySum, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($paySum, strpos($paySum, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($paySum) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $paySum)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($paySum, strpos($paySum, '.')))), __LINE__);
        }
        $this->PaySum = $paySum;
        return $this;
    }
    /**
     * Get PDDate value
     * @return string|null
     */
    public function getPDDate()
    {
        return $this->PDDate;
    }
    /**
     * Set PDDate value
     * @param string $pDDate
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setPDDate($pDDate = null)
    {
        // validation for constraint: maxExclusive
        if ($pDDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $pDDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($pDDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $pDDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pDDate) && !is_string($pDDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pDDate)), __LINE__);
        }
        $this->PDDate = $pDDate;
        return $this;
    }
    /**
     * Get PDNum value
     * @return string|null
     */
    public function getPDNum()
    {
        return $this->PDNum;
    }
    /**
     * Set PDNum value
     * @param string $pDNum
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setPDNum($pDNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pDNum) && strlen($pDNum) > 36) || (is_array($pDNum) && count($pDNum) > 36)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 36 element(s) or a scalar of 36 character(s) at most, "%d" length given', is_scalar($pDNum) ? strlen($pDNum) : count($pDNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($pDNum) && strlen($pDNum) < 1) || (is_array($pDNum) && count($pDNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pDNum) && !is_string($pDNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pDNum)), __LINE__);
        }
        $this->PDNum = $pDNum;
        return $this;
    }
    /**
     * Get ChargeStatus value
     * @return string|null
     */
    public function getChargeStatus()
    {
        return $this->ChargeStatus;
    }
    /**
     * Set ChargeStatus value
     * @uses \AisFssp\EnumType\ChargeStatusType::valueIsValid()
     * @uses \AisFssp\EnumType\ChargeStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $chargeStatus
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setChargeStatus($chargeStatus = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ChargeStatusType::valueIsValid($chargeStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $chargeStatus, implode(', ', \AisFssp\EnumType\ChargeStatusType::getValidValues())), __LINE__);
        }
        $this->ChargeStatus = $chargeStatus;
        return $this;
    }
    /**
     * Get IPNum value
     * @return string|null
     */
    public function getIPNum()
    {
        return $this->IPNum;
    }
    /**
     * Set IPNum value
     * @param string $iPNum
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setIPNum($iPNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iPNum) && strlen($iPNum) > 25) || (is_array($iPNum) && count($iPNum) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($iPNum) ? strlen($iPNum) : count($iPNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iPNum) && strlen($iPNum) < 1) || (is_array($iPNum) && count($iPNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPNum) && !is_string($iPNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPNum)), __LINE__);
        }
        $this->IPNum = $iPNum;
        return $this;
    }
    /**
     * Get IsPayingOff value
     * @return string|null
     */
    public function getIsPayingOff()
    {
        return $this->IsPayingOff;
    }
    /**
     * Set IsPayingOff value
     * @uses \AisFssp\EnumType\PayOffFlagType::valueIsValid()
     * @uses \AisFssp\EnumType\PayOffFlagType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $isPayingOff
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setIsPayingOff($isPayingOff = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\PayOffFlagType::valueIsValid($isPayingOff)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $isPayingOff, implode(', ', \AisFssp\EnumType\PayOffFlagType::getValidValues())), __LINE__);
        }
        $this->IsPayingOff = $isPayingOff;
        return $this;
    }
    /**
     * Get ExtDebtFixBase value
     * @return string|null
     */
    public function getExtDebtFixBase()
    {
        return $this->ExtDebtFixBase;
    }
    /**
     * Set ExtDebtFixBase value
     * @param string $extDebtFixBase
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setExtDebtFixBase($extDebtFixBase = null)
    {
        // validation for constraint: string
        if (!is_null($extDebtFixBase) && !is_string($extDebtFixBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extDebtFixBase)), __LINE__);
        }
        $this->ExtDebtFixBase = $extDebtFixBase;
        return $this;
    }
    /**
     * Get SignatureBase value
     * @return string|null
     */
    public function getSignatureBase()
    {
        return $this->SignatureBase;
    }
    /**
     * Set SignatureBase value
     * @param string $signatureBase
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setSignatureBase($signatureBase = null)
    {
        // validation for constraint: string
        if (!is_null($signatureBase) && !is_string($signatureBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signatureBase)), __LINE__);
        }
        $this->SignatureBase = $signatureBase;
        return $this;
    }
    /**
     * Get PaymentProperties value
     * @return \AisFssp\StructType\PaymentProperties[]|null
     */
    public function getPaymentProperties()
    {
        return $this->PaymentProperties;
    }
    /**
     * Set PaymentProperties value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\PaymentProperties[] $paymentProperties
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setPaymentProperties(array $paymentProperties = array())
    {
        foreach ($paymentProperties as $extDebtFixPaymentPropertiesItem) {
            // validation for constraint: itemType
            if (!$extDebtFixPaymentPropertiesItem instanceof \AisFssp\StructType\PaymentProperties) {
                throw new \InvalidArgumentException(sprintf('The PaymentProperties property can only contain items of \AisFssp\StructType\PaymentProperties, "%s" given', is_object($extDebtFixPaymentPropertiesItem) ? get_class($extDebtFixPaymentPropertiesItem) : gettype($extDebtFixPaymentPropertiesItem)), __LINE__);
            }
        }
        $this->PaymentProperties = $paymentProperties;
        return $this;
    }
    /**
     * Add item to PaymentProperties value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\PaymentProperties $item
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function addToPaymentProperties(\AisFssp\StructType\PaymentProperties $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\PaymentProperties) {
            throw new \InvalidArgumentException(sprintf('The PaymentProperties property can only contain items of \AisFssp\StructType\PaymentProperties, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentProperties[] = $item;
        return $this;
    }
    /**
     * Get attachments value
     * @return \AisFssp\StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setAttachments(array $attachments = array())
    {
        foreach ($attachments as $extDebtFixAttachmentsItem) {
            // validation for constraint: itemType
            if (!$extDebtFixAttachmentsItem instanceof \AisFssp\StructType\AttachmentType) {
                throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($extDebtFixAttachmentsItem) ? get_class($extDebtFixAttachmentsItem) : gettype($extDebtFixAttachmentsItem)), __LINE__);
            }
        }
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType $item
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function addToAttachments(\AisFssp\StructType\AttachmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\AttachmentType) {
            throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $extDebtFixSignatureItem) {
            // validation for constraint: itemType
            if (!$extDebtFixSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($extDebtFixSignatureItem) ? get_class($extDebtFixSignatureItem) : gettype($extDebtFixSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ExtDebtFix
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
