<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Envelopes StructType
 * Meta informations extracted from the WSDL
 * - documentation: Конверты документов для передачи по варианту 2
 * @subpackage Structs
 */
class Envelopes extends AbstractStructBase
{
    /**
     * The Envelope
     * Meta informations extracted from the WSDL
     * - documentation: Конверт документа
     * - maxOccurs: unbounded
     * @var \AisFssp\StructType\Envelope[]
     */
    public $Envelope;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Envelopes
     * @uses Envelopes::setEnvelope()
     * @uses Envelopes::setId()
     * @param \AisFssp\StructType\Envelope[] $envelope
     * @param string $id
     */
    public function __construct(array $envelope = array(), $id = null)
    {
        $this
            ->setEnvelope($envelope)
            ->setId($id);
    }
    /**
     * Get Envelope value
     * @return \AisFssp\StructType\Envelope[]|null
     */
    public function getEnvelope()
    {
        return $this->Envelope;
    }
    /**
     * Set Envelope value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Envelope[] $envelope
     * @return \AisFssp\StructType\Envelopes
     */
    public function setEnvelope(array $envelope = array())
    {
        foreach ($envelope as $envelopesEnvelopeItem) {
            // validation for constraint: itemType
            if (!$envelopesEnvelopeItem instanceof \AisFssp\StructType\Envelope) {
                throw new \InvalidArgumentException(sprintf('The Envelope property can only contain items of \AisFssp\StructType\Envelope, "%s" given', is_object($envelopesEnvelopeItem) ? get_class($envelopesEnvelopeItem) : gettype($envelopesEnvelopeItem)), __LINE__);
            }
        }
        $this->Envelope = $envelope;
        return $this;
    }
    /**
     * Add item to Envelope value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Envelope $item
     * @return \AisFssp\StructType\Envelopes
     */
    public function addToEnvelope(\AisFssp\StructType\Envelope $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Envelope) {
            throw new \InvalidArgumentException(sprintf('The Envelope property can only contain items of \AisFssp\StructType\Envelope, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Envelope[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\Envelopes
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\Envelopes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
