<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmbeddedDocumentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ в формате принудительного исполнения в электронном виде | Используется для передачи юридически значимых документов
 * в соответствующем формате. Тип данных позволяет передавать документ в двоичной форме, подпись документа в формате PKCS#7, а также вложения
 * документа
 * @subpackage Structs
 */
class EmbeddedDocumentType extends AbstractStructBase
{
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document | Наименование
     * объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $DocType;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - documentation: Данные документа
     * @var string
     */
    public $Content;
    /**
     * The DigitalSignature
     * Meta informations extracted from the WSDL
     * - documentation: ЭП документа | Подпись документа в формате PKCS#7 detached
     * - minOccurs: 0
     * @var string
     */
    public $DigitalSignature;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - documentation: Вложения
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\AttachmentType[]
     */
    public $Attachments;
    /**
     * Constructor method for EmbeddedDocumentType
     * @uses EmbeddedDocumentType::setDocType()
     * @uses EmbeddedDocumentType::setDocNumber()
     * @uses EmbeddedDocumentType::setDocDate()
     * @uses EmbeddedDocumentType::setContent()
     * @uses EmbeddedDocumentType::setDigitalSignature()
     * @uses EmbeddedDocumentType::setAttachments()
     * @param string $docType
     * @param string $docNumber
     * @param string $docDate
     * @param string $content
     * @param string $digitalSignature
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     */
    public function __construct($docType = null, $docNumber = null, $docDate = null, $content = null, $digitalSignature = null, array $attachments = array())
    {
        $this
            ->setDocType($docType)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setContent($content)
            ->setDigitalSignature($digitalSignature)
            ->setAttachments($attachments);
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \AisFssp\StructType\EmbeddedDocumentType
     */
    public function setDocType($docType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docType) && strlen($docType) > 1) || (is_array($docType) && count($docType) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($docType) ? strlen($docType) : count($docType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docType) && strlen($docType) < 1) || (is_array($docType) && count($docType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docType) && !is_string($docType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docType)), __LINE__);
        }
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\EmbeddedDocumentType
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\EmbeddedDocumentType
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get Content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param string $content
     * @return \AisFssp\StructType\EmbeddedDocumentType
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->Content = $content;
        return $this;
    }
    /**
     * Get DigitalSignature value
     * @return string|null
     */
    public function getDigitalSignature()
    {
        return $this->DigitalSignature;
    }
    /**
     * Set DigitalSignature value
     * @param string $digitalSignature
     * @return \AisFssp\StructType\EmbeddedDocumentType
     */
    public function setDigitalSignature($digitalSignature = null)
    {
        // validation for constraint: string
        if (!is_null($digitalSignature) && !is_string($digitalSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digitalSignature)), __LINE__);
        }
        $this->DigitalSignature = $digitalSignature;
        return $this;
    }
    /**
     * Get Attachments value
     * @return \AisFssp\StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->Attachments;
    }
    /**
     * Set Attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @return \AisFssp\StructType\EmbeddedDocumentType
     */
    public function setAttachments(array $attachments = array())
    {
        foreach ($attachments as $embeddedDocumentTypeAttachmentsItem) {
            // validation for constraint: itemType
            if (!$embeddedDocumentTypeAttachmentsItem instanceof \AisFssp\StructType\AttachmentType) {
                throw new \InvalidArgumentException(sprintf('The Attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($embeddedDocumentTypeAttachmentsItem) ? get_class($embeddedDocumentTypeAttachmentsItem) : gettype($embeddedDocumentTypeAttachmentsItem)), __LINE__);
            }
        }
        $this->Attachments = $attachments;
        return $this;
    }
    /**
     * Add item to Attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType $item
     * @return \AisFssp\StructType\EmbeddedDocumentType
     */
    public function addToAttachments(\AisFssp\StructType\AttachmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\AttachmentType) {
            throw new \InvalidArgumentException(sprintf('The Attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Attachments[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\EmbeddedDocumentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
