<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EQNotifyAppResult StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ на изменение статуса заявки записи на приём
 * - type: tns:EQNotifyAppResult
 * @subpackage Structs
 */
class EQNotifyAppResult extends AbstractStructBase
{
    /**
     * The RequestExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $RequestExternalKey;
    /**
     * The AppId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор заявки | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $AppId;
    /**
     * The ResultStatus
     * Meta informations extracted from the WSDL
     * - documentation: Статус выполнения действия
     * @var string
     */
    public $ResultStatus;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ошибки | Целое | Целое
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrortText
     * Meta informations extracted from the WSDL
     * - documentation: Описание ошибки | Массив произвольных данных (текстовый)
     * - minOccurs: 0
     * @var string
     */
    public $ErrortText;
    /**
     * The AppResult
     * Meta informations extracted from the WSDL
     * - documentation: Результат обработка заявки
     * - minOccurs: 0
     * @var string
     */
    public $AppResult;
    /**
     * Constructor method for EQNotifyAppResult
     * @uses EQNotifyAppResult::setRequestExternalKey()
     * @uses EQNotifyAppResult::setAppId()
     * @uses EQNotifyAppResult::setResultStatus()
     * @uses EQNotifyAppResult::setErrorCode()
     * @uses EQNotifyAppResult::setErrortText()
     * @uses EQNotifyAppResult::setAppResult()
     * @param string $requestExternalKey
     * @param int $appId
     * @param string $resultStatus
     * @param int $errorCode
     * @param string $errortText
     * @param string $appResult
     */
    public function __construct($requestExternalKey = null, $appId = null, $resultStatus = null, $errorCode = null, $errortText = null, $appResult = null)
    {
        $this
            ->setRequestExternalKey($requestExternalKey)
            ->setAppId($appId)
            ->setResultStatus($resultStatus)
            ->setErrorCode($errorCode)
            ->setErrortText($errortText)
            ->setAppResult($appResult);
    }
    /**
     * Get RequestExternalKey value
     * @return string|null
     */
    public function getRequestExternalKey()
    {
        return $this->RequestExternalKey;
    }
    /**
     * Set RequestExternalKey value
     * @param string $requestExternalKey
     * @return \AisFssp\StructType\EQNotifyAppResult
     */
    public function setRequestExternalKey($requestExternalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestExternalKey) && strlen($requestExternalKey) > 60) || (is_array($requestExternalKey) && count($requestExternalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($requestExternalKey) ? strlen($requestExternalKey) : count($requestExternalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestExternalKey) && strlen($requestExternalKey) < 1) || (is_array($requestExternalKey) && count($requestExternalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestExternalKey) && !is_string($requestExternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestExternalKey)), __LINE__);
        }
        $this->RequestExternalKey = $requestExternalKey;
        return $this;
    }
    /**
     * Get AppId value
     * @return int|null
     */
    public function getAppId()
    {
        return $this->AppId;
    }
    /**
     * Set AppId value
     * @param int $appId
     * @return \AisFssp\StructType\EQNotifyAppResult
     */
    public function setAppId($appId = null)
    {
        // validation for constraint: maxInclusive
        if ($appId > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $appId), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($appId < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $appId), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($appId) && !is_numeric($appId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($appId)), __LINE__);
        }
        $this->AppId = $appId;
        return $this;
    }
    /**
     * Get ResultStatus value
     * @return string|null
     */
    public function getResultStatus()
    {
        return $this->ResultStatus;
    }
    /**
     * Set ResultStatus value
     * @uses \AisFssp\EnumType\EQAppointmentStatusType::valueIsValid()
     * @uses \AisFssp\EnumType\EQAppointmentStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultStatus
     * @return \AisFssp\StructType\EQNotifyAppResult
     */
    public function setResultStatus($resultStatus = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\EQAppointmentStatusType::valueIsValid($resultStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $resultStatus, implode(', ', \AisFssp\EnumType\EQAppointmentStatusType::getValidValues())), __LINE__);
        }
        $this->ResultStatus = $resultStatus;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \AisFssp\StructType\EQNotifyAppResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: maxInclusive
        if ($errorCode > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $errorCode), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($errorCode) && !is_numeric($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrortText value
     * @return string|null
     */
    public function getErrortText()
    {
        return $this->ErrortText;
    }
    /**
     * Set ErrortText value
     * @param string $errortText
     * @return \AisFssp\StructType\EQNotifyAppResult
     */
    public function setErrortText($errortText = null)
    {
        // validation for constraint: string
        if (!is_null($errortText) && !is_string($errortText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errortText)), __LINE__);
        }
        $this->ErrortText = $errortText;
        return $this;
    }
    /**
     * Get AppResult value
     * @return string|null
     */
    public function getAppResult()
    {
        return $this->AppResult;
    }
    /**
     * Set AppResult value
     * @param string $appResult
     * @return \AisFssp\StructType\EQNotifyAppResult
     */
    public function setAppResult($appResult = null)
    {
        // validation for constraint: string
        if (!is_null($appResult) && !is_string($appResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appResult)), __LINE__);
        }
        $this->AppResult = $appResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\EQNotifyAppResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
