<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EApplicationType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Электронное обращение | Используется для передачи в ФССП России электронного обращения | ЭП
 * - type: tns:EApplicationType
 * @subpackage Structs
 */
class EApplicationType extends AbstractStructBase
{
    /**
     * The EApplicationKey
     * Meta informations extracted from the WSDL
     * - documentation: Уникальный ключ электронного заявления | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и
     * прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным
     * внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $EApplicationKey;
    /**
     * The EApplicationType
     * Meta informations extracted from the WSDL
     * - documentation: Тип заявления | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document |
     * Наименование объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $EApplicationType;
    /**
     * The EApplicationDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата электронного заявления | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $EApplicationDate;
    /**
     * The PersonalInfromation
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о Заявителе
     * @var \AisFssp\StructType\ContragentDatumType
     */
    public $PersonalInfromation;
    /**
     * The EApplicationBase
     * Meta informations extracted from the WSDL
     * - documentation: Электронное обращение | Электронное обращение составленный в соответствии с форматом Приложения № 3 «Форматы электронного
     * обращение» в кодировке Base64.
     * @var string
     */
    public $EApplicationBase;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The SignatureBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП электронного обращения | ЭП электронного обращения, элемента «EApplicationBase» в формате pkcs#7.
     * @var string
     */
    public $SignatureBase;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - documentation: Прикрепленные файлы
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\AttachmentType[]
     */
    public $Attachments;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for EApplicationType
     * @uses EApplicationType::setEApplicationKey()
     * @uses EApplicationType::setEApplicationType()
     * @uses EApplicationType::setEApplicationDate()
     * @uses EApplicationType::setPersonalInfromation()
     * @uses EApplicationType::setEApplicationBase()
     * @uses EApplicationType::setSignDateTime()
     * @uses EApplicationType::setSignatureBase()
     * @uses EApplicationType::setAttachments()
     * @uses EApplicationType::setSignature()
     * @param string $eApplicationKey
     * @param string $eApplicationType
     * @param string $eApplicationDate
     * @param \AisFssp\StructType\ContragentDatumType $personalInfromation
     * @param string $eApplicationBase
     * @param string $signDateTime
     * @param string $signatureBase
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @param \AisFssp\StructType\SignatureType[] $signature
     */
    public function __construct($eApplicationKey = null, $eApplicationType = null, $eApplicationDate = null, \AisFssp\StructType\ContragentDatumType $personalInfromation = null, $eApplicationBase = null, $signDateTime = null, $signatureBase = null, array $attachments = array(), array $signature = array())
    {
        $this
            ->setEApplicationKey($eApplicationKey)
            ->setEApplicationType($eApplicationType)
            ->setEApplicationDate($eApplicationDate)
            ->setPersonalInfromation($personalInfromation)
            ->setEApplicationBase($eApplicationBase)
            ->setSignDateTime($signDateTime)
            ->setSignatureBase($signatureBase)
            ->setAttachments($attachments)
            ->setSignature($signature);
    }
    /**
     * Get EApplicationKey value
     * @return string|null
     */
    public function getEApplicationKey()
    {
        return $this->EApplicationKey;
    }
    /**
     * Set EApplicationKey value
     * @param string $eApplicationKey
     * @return \AisFssp\StructType\EApplicationType
     */
    public function setEApplicationKey($eApplicationKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($eApplicationKey) && strlen($eApplicationKey) > 60) || (is_array($eApplicationKey) && count($eApplicationKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($eApplicationKey) ? strlen($eApplicationKey) : count($eApplicationKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($eApplicationKey) && strlen($eApplicationKey) < 1) || (is_array($eApplicationKey) && count($eApplicationKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($eApplicationKey) && !is_string($eApplicationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eApplicationKey)), __LINE__);
        }
        $this->EApplicationKey = $eApplicationKey;
        return $this;
    }
    /**
     * Get EApplicationType value
     * @return string|null
     */
    public function getEApplicationType()
    {
        return $this->EApplicationType;
    }
    /**
     * Set EApplicationType value
     * @param string $eApplicationType
     * @return \AisFssp\StructType\EApplicationType
     */
    public function setEApplicationType($eApplicationType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($eApplicationType) && strlen($eApplicationType) > 1) || (is_array($eApplicationType) && count($eApplicationType) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($eApplicationType) ? strlen($eApplicationType) : count($eApplicationType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($eApplicationType) && strlen($eApplicationType) < 1) || (is_array($eApplicationType) && count($eApplicationType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($eApplicationType) && !is_string($eApplicationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eApplicationType)), __LINE__);
        }
        $this->EApplicationType = $eApplicationType;
        return $this;
    }
    /**
     * Get EApplicationDate value
     * @return string|null
     */
    public function getEApplicationDate()
    {
        return $this->EApplicationDate;
    }
    /**
     * Set EApplicationDate value
     * @param string $eApplicationDate
     * @return \AisFssp\StructType\EApplicationType
     */
    public function setEApplicationDate($eApplicationDate = null)
    {
        // validation for constraint: maxExclusive
        if ($eApplicationDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $eApplicationDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($eApplicationDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $eApplicationDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($eApplicationDate) && !is_string($eApplicationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eApplicationDate)), __LINE__);
        }
        $this->EApplicationDate = $eApplicationDate;
        return $this;
    }
    /**
     * Get PersonalInfromation value
     * @return \AisFssp\StructType\ContragentDatumType|null
     */
    public function getPersonalInfromation()
    {
        return $this->PersonalInfromation;
    }
    /**
     * Set PersonalInfromation value
     * @param \AisFssp\StructType\ContragentDatumType $personalInfromation
     * @return \AisFssp\StructType\EApplicationType
     */
    public function setPersonalInfromation(\AisFssp\StructType\ContragentDatumType $personalInfromation = null)
    {
        $this->PersonalInfromation = $personalInfromation;
        return $this;
    }
    /**
     * Get EApplicationBase value
     * @return string|null
     */
    public function getEApplicationBase()
    {
        return $this->EApplicationBase;
    }
    /**
     * Set EApplicationBase value
     * @param string $eApplicationBase
     * @return \AisFssp\StructType\EApplicationType
     */
    public function setEApplicationBase($eApplicationBase = null)
    {
        // validation for constraint: string
        if (!is_null($eApplicationBase) && !is_string($eApplicationBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eApplicationBase)), __LINE__);
        }
        $this->EApplicationBase = $eApplicationBase;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\EApplicationType
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get SignatureBase value
     * @return string|null
     */
    public function getSignatureBase()
    {
        return $this->SignatureBase;
    }
    /**
     * Set SignatureBase value
     * @param string $signatureBase
     * @return \AisFssp\StructType\EApplicationType
     */
    public function setSignatureBase($signatureBase = null)
    {
        // validation for constraint: string
        if (!is_null($signatureBase) && !is_string($signatureBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signatureBase)), __LINE__);
        }
        $this->SignatureBase = $signatureBase;
        return $this;
    }
    /**
     * Get Attachments value
     * @return \AisFssp\StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->Attachments;
    }
    /**
     * Set Attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @return \AisFssp\StructType\EApplicationType
     */
    public function setAttachments(array $attachments = array())
    {
        foreach ($attachments as $eApplicationTypeAttachmentsItem) {
            // validation for constraint: itemType
            if (!$eApplicationTypeAttachmentsItem instanceof \AisFssp\StructType\AttachmentType) {
                throw new \InvalidArgumentException(sprintf('The Attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($eApplicationTypeAttachmentsItem) ? get_class($eApplicationTypeAttachmentsItem) : gettype($eApplicationTypeAttachmentsItem)), __LINE__);
            }
        }
        $this->Attachments = $attachments;
        return $this;
    }
    /**
     * Add item to Attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType $item
     * @return \AisFssp\StructType\EApplicationType
     */
    public function addToAttachments(\AisFssp\StructType\AttachmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\AttachmentType) {
            throw new \InvalidArgumentException(sprintf('The Attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Attachments[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\EApplicationType
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $eApplicationTypeSignatureItem) {
            // validation for constraint: itemType
            if (!$eApplicationTypeSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($eApplicationTypeSignatureItem) ? get_class($eApplicationTypeSignatureItem) : gettype($eApplicationTypeSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\EApplicationType
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\EApplicationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
