<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EApplicationResultType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ на электронное обращение | Используется для передачи от ФССП России внешнему контрагенту информации об ответе на
 * электронное обращение Заявителя | ЭП
 * - type: tns:EApplicationResultType
 * @subpackage Structs
 */
class EApplicationResultType extends AbstractStructBase
{
    /**
     * The EApplicationKey
     * Meta informations extracted from the WSDL
     * - documentation: Уникальный ключ электронного заявления | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и
     * прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным
     * внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $EApplicationKey;
    /**
     * The EApplicationResponseKey
     * Meta informations extracted from the WSDL
     * - documentation: Уникальный ключ ответа на электронное обращение | Ключ объекта, присвоенний информационной системой ФССП РФ при создании
     * объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $EApplicationResponseKey;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа ответа на электронное обращение | Обязательно для заполнения в случае код смены статуса принимает значение
     * «COMPLETED». | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата электронного заявления | Обязательно для заполнения в случае код смены статуса принимает значение «COMPLETED». | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The AppStatus
     * Meta informations extracted from the WSDL
     * - documentation: Код смены статуса заявления
     * @var string
     */
    public $AppStatus;
    /**
     * The EApplicationResponseBase
     * Meta informations extracted from the WSDL
     * - documentation: Ответ на электронное обращение | Обязательно для заполнения в случае код смены статуса принимает значение «COMPLETED». Ответ на
     * электронное обращение составленный в соответствии с форматом Приложения № 3 «Форматы электронного обращение» в кодировке Base64.
     * - minOccurs: 0
     * @var string
     */
    public $EApplicationResponseBase;
    /**
     * The SignatureBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП ответа на электронное обращение | Обязательно для заполнения в случае код смены статуса принимает значение «COMPLETED». ЭП
     * ответа электронного обращение элемента «EApplicationResponseBase» в формате pkcs#7.
     * - minOccurs: 0
     * @var string
     */
    public $SignatureBase;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - documentation: Прикрепленные файлы | Дополнительные данные в произвольных форматах.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\AttachmentType[]
     */
    public $Attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for EApplicationResultType
     * @uses EApplicationResultType::setEApplicationKey()
     * @uses EApplicationResultType::setEApplicationResponseKey()
     * @uses EApplicationResultType::setDocNumber()
     * @uses EApplicationResultType::setDocDate()
     * @uses EApplicationResultType::setAppStatus()
     * @uses EApplicationResultType::setEApplicationResponseBase()
     * @uses EApplicationResultType::setSignatureBase()
     * @uses EApplicationResultType::setAttachments()
     * @uses EApplicationResultType::setSignDateTime()
     * @uses EApplicationResultType::setSignature()
     * @param string $eApplicationKey
     * @param int $eApplicationResponseKey
     * @param string $docNumber
     * @param string $docDate
     * @param string $appStatus
     * @param string $eApplicationResponseBase
     * @param string $signatureBase
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     */
    public function __construct($eApplicationKey = null, $eApplicationResponseKey = null, $docNumber = null, $docDate = null, $appStatus = null, $eApplicationResponseBase = null, $signatureBase = null, array $attachments = array(), $signDateTime = null, array $signature = array())
    {
        $this
            ->setEApplicationKey($eApplicationKey)
            ->setEApplicationResponseKey($eApplicationResponseKey)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setAppStatus($appStatus)
            ->setEApplicationResponseBase($eApplicationResponseBase)
            ->setSignatureBase($signatureBase)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature);
    }
    /**
     * Get EApplicationKey value
     * @return string|null
     */
    public function getEApplicationKey()
    {
        return $this->EApplicationKey;
    }
    /**
     * Set EApplicationKey value
     * @param string $eApplicationKey
     * @return \AisFssp\StructType\EApplicationResultType
     */
    public function setEApplicationKey($eApplicationKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($eApplicationKey) && strlen($eApplicationKey) > 60) || (is_array($eApplicationKey) && count($eApplicationKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($eApplicationKey) ? strlen($eApplicationKey) : count($eApplicationKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($eApplicationKey) && strlen($eApplicationKey) < 1) || (is_array($eApplicationKey) && count($eApplicationKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($eApplicationKey) && !is_string($eApplicationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eApplicationKey)), __LINE__);
        }
        $this->EApplicationKey = $eApplicationKey;
        return $this;
    }
    /**
     * Get EApplicationResponseKey value
     * @return int|null
     */
    public function getEApplicationResponseKey()
    {
        return $this->EApplicationResponseKey;
    }
    /**
     * Set EApplicationResponseKey value
     * @param int $eApplicationResponseKey
     * @return \AisFssp\StructType\EApplicationResultType
     */
    public function setEApplicationResponseKey($eApplicationResponseKey = null)
    {
        // validation for constraint: maxInclusive
        if ($eApplicationResponseKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $eApplicationResponseKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($eApplicationResponseKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $eApplicationResponseKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($eApplicationResponseKey) && !is_numeric($eApplicationResponseKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($eApplicationResponseKey)), __LINE__);
        }
        $this->EApplicationResponseKey = $eApplicationResponseKey;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\EApplicationResultType
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\EApplicationResultType
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get AppStatus value
     * @return string|null
     */
    public function getAppStatus()
    {
        return $this->AppStatus;
    }
    /**
     * Set AppStatus value
     * @uses \AisFssp\EnumType\ApplicationStatus::valueIsValid()
     * @uses \AisFssp\EnumType\ApplicationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appStatus
     * @return \AisFssp\StructType\EApplicationResultType
     */
    public function setAppStatus($appStatus = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ApplicationStatus::valueIsValid($appStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $appStatus, implode(', ', \AisFssp\EnumType\ApplicationStatus::getValidValues())), __LINE__);
        }
        $this->AppStatus = $appStatus;
        return $this;
    }
    /**
     * Get EApplicationResponseBase value
     * @return string|null
     */
    public function getEApplicationResponseBase()
    {
        return $this->EApplicationResponseBase;
    }
    /**
     * Set EApplicationResponseBase value
     * @param string $eApplicationResponseBase
     * @return \AisFssp\StructType\EApplicationResultType
     */
    public function setEApplicationResponseBase($eApplicationResponseBase = null)
    {
        // validation for constraint: string
        if (!is_null($eApplicationResponseBase) && !is_string($eApplicationResponseBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eApplicationResponseBase)), __LINE__);
        }
        $this->EApplicationResponseBase = $eApplicationResponseBase;
        return $this;
    }
    /**
     * Get SignatureBase value
     * @return string|null
     */
    public function getSignatureBase()
    {
        return $this->SignatureBase;
    }
    /**
     * Set SignatureBase value
     * @param string $signatureBase
     * @return \AisFssp\StructType\EApplicationResultType
     */
    public function setSignatureBase($signatureBase = null)
    {
        // validation for constraint: string
        if (!is_null($signatureBase) && !is_string($signatureBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signatureBase)), __LINE__);
        }
        $this->SignatureBase = $signatureBase;
        return $this;
    }
    /**
     * Get Attachments value
     * @return \AisFssp\StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->Attachments;
    }
    /**
     * Set Attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @return \AisFssp\StructType\EApplicationResultType
     */
    public function setAttachments(array $attachments = array())
    {
        foreach ($attachments as $eApplicationResultTypeAttachmentsItem) {
            // validation for constraint: itemType
            if (!$eApplicationResultTypeAttachmentsItem instanceof \AisFssp\StructType\AttachmentType) {
                throw new \InvalidArgumentException(sprintf('The Attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($eApplicationResultTypeAttachmentsItem) ? get_class($eApplicationResultTypeAttachmentsItem) : gettype($eApplicationResultTypeAttachmentsItem)), __LINE__);
            }
        }
        $this->Attachments = $attachments;
        return $this;
    }
    /**
     * Add item to Attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType $item
     * @return \AisFssp\StructType\EApplicationResultType
     */
    public function addToAttachments(\AisFssp\StructType\AttachmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\AttachmentType) {
            throw new \InvalidArgumentException(sprintf('The Attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\EApplicationResultType
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\EApplicationResultType
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $eApplicationResultTypeSignatureItem) {
            // validation for constraint: itemType
            if (!$eApplicationResultTypeSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($eApplicationResultTypeSignatureItem) ? get_class($eApplicationResultTypeSignatureItem) : gettype($eApplicationResultTypeSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\EApplicationResultType
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\EApplicationResultType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
