<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentNote StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ DocumentNote «Технологическое сообщение» | ЭП
 * @subpackage Structs
 */
class DocumentNote extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор сообщения, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор сообщения, присвоенный АИС ФССП России | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The TypeDoc
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа | Код документа из справочника электронных документов передаваемых сторонами | Тип документа АИС ФССП России
     * (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document | Наименование объекта NCORE
     * - minOccurs: 0
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $TypeDoc;
    /**
     * The DocExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа АИС ВК | Идентификатор документа, полученного ранее от АИС внешнего контрагента | Идентификатор
     * объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа
     * идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $DocExternalKey;
    /**
     * The DocInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ документа ФССП РФ | Уникальный идентификатор документа, присвоенный АИС ФССП России и переданный ранее внешнему
     * контрагенту | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $DocInternalKey;
    /**
     * The SpecStr
     * Meta informations extracted from the WSDL
     * - documentation: Текст сообщения | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $SpecStr;
    /**
     * The DateMess
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время сообщения | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $DateMess;
    /**
     * The MessCod
     * Meta informations extracted from the WSDL
     * - documentation: Код сообщения | Код сообщения из справочника кодов технологических сообщений
     * @var string
     */
    public $MessCod;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for DocumentNote
     * @uses DocumentNote::setExternalKey()
     * @uses DocumentNote::setInternalKey()
     * @uses DocumentNote::setTypeDoc()
     * @uses DocumentNote::setDocExternalKey()
     * @uses DocumentNote::setDocInternalKey()
     * @uses DocumentNote::setSpecStr()
     * @uses DocumentNote::setDateMess()
     * @uses DocumentNote::setMessCod()
     * @uses DocumentNote::setSignDateTime()
     * @uses DocumentNote::setSignature()
     * @uses DocumentNote::setId()
     * @param string $externalKey
     * @param int $internalKey
     * @param string $typeDoc
     * @param string $docExternalKey
     * @param int $docInternalKey
     * @param string $specStr
     * @param string $dateMess
     * @param string $messCod
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $internalKey = null, $typeDoc = null, $docExternalKey = null, $docInternalKey = null, $specStr = null, $dateMess = null, $messCod = null, $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setInternalKey($internalKey)
            ->setTypeDoc($typeDoc)
            ->setDocExternalKey($docExternalKey)
            ->setDocInternalKey($docInternalKey)
            ->setSpecStr($specStr)
            ->setDateMess($dateMess)
            ->setMessCod($messCod)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\DocumentNote
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\DocumentNote
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get TypeDoc value
     * @return string|null
     */
    public function getTypeDoc()
    {
        return $this->TypeDoc;
    }
    /**
     * Set TypeDoc value
     * @param string $typeDoc
     * @return \AisFssp\StructType\DocumentNote
     */
    public function setTypeDoc($typeDoc = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($typeDoc) && strlen($typeDoc) > 1) || (is_array($typeDoc) && count($typeDoc) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($typeDoc) ? strlen($typeDoc) : count($typeDoc)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($typeDoc) && strlen($typeDoc) < 1) || (is_array($typeDoc) && count($typeDoc) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($typeDoc) && !is_string($typeDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeDoc)), __LINE__);
        }
        $this->TypeDoc = $typeDoc;
        return $this;
    }
    /**
     * Get DocExternalKey value
     * @return string|null
     */
    public function getDocExternalKey()
    {
        return $this->DocExternalKey;
    }
    /**
     * Set DocExternalKey value
     * @param string $docExternalKey
     * @return \AisFssp\StructType\DocumentNote
     */
    public function setDocExternalKey($docExternalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docExternalKey) && strlen($docExternalKey) > 60) || (is_array($docExternalKey) && count($docExternalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($docExternalKey) ? strlen($docExternalKey) : count($docExternalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docExternalKey) && strlen($docExternalKey) < 1) || (is_array($docExternalKey) && count($docExternalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docExternalKey) && !is_string($docExternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docExternalKey)), __LINE__);
        }
        $this->DocExternalKey = $docExternalKey;
        return $this;
    }
    /**
     * Get DocInternalKey value
     * @return int|null
     */
    public function getDocInternalKey()
    {
        return $this->DocInternalKey;
    }
    /**
     * Set DocInternalKey value
     * @param int $docInternalKey
     * @return \AisFssp\StructType\DocumentNote
     */
    public function setDocInternalKey($docInternalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($docInternalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $docInternalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docInternalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $docInternalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($docInternalKey) && !is_numeric($docInternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($docInternalKey)), __LINE__);
        }
        $this->DocInternalKey = $docInternalKey;
        return $this;
    }
    /**
     * Get SpecStr value
     * @return string|null
     */
    public function getSpecStr()
    {
        return $this->SpecStr;
    }
    /**
     * Set SpecStr value
     * @param string $specStr
     * @return \AisFssp\StructType\DocumentNote
     */
    public function setSpecStr($specStr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($specStr) && strlen($specStr) > 1000) || (is_array($specStr) && count($specStr) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($specStr) ? strlen($specStr) : count($specStr)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($specStr) && strlen($specStr) < 1) || (is_array($specStr) && count($specStr) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($specStr) && !is_string($specStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($specStr)), __LINE__);
        }
        $this->SpecStr = $specStr;
        return $this;
    }
    /**
     * Get DateMess value
     * @return string|null
     */
    public function getDateMess()
    {
        return $this->DateMess;
    }
    /**
     * Set DateMess value
     * @param string $dateMess
     * @return \AisFssp\StructType\DocumentNote
     */
    public function setDateMess($dateMess = null)
    {
        // validation for constraint: maxExclusive
        if ($dateMess >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateMess), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateMess < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateMess), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateMess) && !is_string($dateMess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateMess)), __LINE__);
        }
        $this->DateMess = $dateMess;
        return $this;
    }
    /**
     * Get MessCod value
     * @return string|null
     */
    public function getMessCod()
    {
        return $this->MessCod;
    }
    /**
     * Set MessCod value
     * @uses \AisFssp\EnumType\MessageCodeType::valueIsValid()
     * @uses \AisFssp\EnumType\MessageCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $messCod
     * @return \AisFssp\StructType\DocumentNote
     */
    public function setMessCod($messCod = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\MessageCodeType::valueIsValid($messCod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $messCod, implode(', ', \AisFssp\EnumType\MessageCodeType::getValidValues())), __LINE__);
        }
        $this->MessCod = $messCod;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\DocumentNote
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\DocumentNote
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $documentNoteSignatureItem) {
            // validation for constraint: itemType
            if (!$documentNoteSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($documentNoteSignatureItem) ? get_class($documentNoteSignatureItem) : gettype($documentNoteSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\DocumentNote
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\DocumentNote
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DocumentNote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
