<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Document StructType
 * @subpackage Structs
 */
class Document extends AbstractStructBase
{
    /**
     * The MaxCount
     * Meta informations extracted from the WSDL
     * - documentation: Максимальное количество документов | Целое | Целое
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * @var int
     */
    public $MaxCount;
    /**
     * Constructor method for Document
     * @uses Document::setMaxCount()
     * @param int $maxCount
     */
    public function __construct($maxCount = null)
    {
        $this
            ->setMaxCount($maxCount);
    }
    /**
     * Get MaxCount value
     * @return int|null
     */
    public function getMaxCount()
    {
        return $this->MaxCount;
    }
    /**
     * Set MaxCount value
     * @param int $maxCount
     * @return \AisFssp\StructType\Document
     */
    public function setMaxCount($maxCount = null)
    {
        // validation for constraint: maxInclusive
        if ($maxCount > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $maxCount), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($maxCount) && !is_numeric($maxCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxCount)), __LINE__);
        }
        $this->MaxCount = $maxCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\Document
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
