<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocNote StructType
 * Meta informations extracted from the WSDL
 * - documentation: Квитанция на документ пакета
 * @subpackage Structs
 */
class DocNote extends AbstractStructBase
{
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Текст и код сообщения
     * @var \AisFssp\StructType\MessageEx
     */
    public $Message;
    /**
     * The DocRef
     * Meta informations extracted from the WSDL
     * - documentation: Информация о документе
     * - minOccurs: 0
     * @var \AisFssp\StructType\DocumentRef
     */
    public $DocRef;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Статус приема документа.
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The FileNote
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \AisFssp\StructType\AttachmentFileNote
     */
    public $FileNote;
    /**
     * The timestamp
     * Meta informations extracted from the WSDL
     * - documentation: Дата формирования сообщения | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $timestamp;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор сообщения | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $id;
    /**
     * Constructor method for DocNote
     * @uses DocNote::setMessage()
     * @uses DocNote::setDocRef()
     * @uses DocNote::setStatus()
     * @uses DocNote::setFileNote()
     * @uses DocNote::setTimestamp()
     * @uses DocNote::setId()
     * @param \AisFssp\StructType\MessageEx $message
     * @param \AisFssp\StructType\DocumentRef $docRef
     * @param string $status
     * @param \AisFssp\StructType\AttachmentFileNote $fileNote
     * @param string $timestamp
     * @param string $id
     */
    public function __construct(\AisFssp\StructType\MessageEx $message = null, \AisFssp\StructType\DocumentRef $docRef = null, $status = null, \AisFssp\StructType\AttachmentFileNote $fileNote = null, $timestamp = null, $id = null)
    {
        $this
            ->setMessage($message)
            ->setDocRef($docRef)
            ->setStatus($status)
            ->setFileNote($fileNote)
            ->setTimestamp($timestamp)
            ->setId($id);
    }
    /**
     * Get Message value
     * @return \AisFssp\StructType\MessageEx|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param \AisFssp\StructType\MessageEx $message
     * @return \AisFssp\StructType\DocNote
     */
    public function setMessage(\AisFssp\StructType\MessageEx $message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Get DocRef value
     * @return \AisFssp\StructType\DocumentRef|null
     */
    public function getDocRef()
    {
        return $this->DocRef;
    }
    /**
     * Set DocRef value
     * @param \AisFssp\StructType\DocumentRef $docRef
     * @return \AisFssp\StructType\DocNote
     */
    public function setDocRef(\AisFssp\StructType\DocumentRef $docRef = null)
    {
        $this->DocRef = $docRef;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \AisFssp\EnumType\ProcessResult::valueIsValid()
     * @uses \AisFssp\EnumType\ProcessResult::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \AisFssp\StructType\DocNote
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ProcessResult::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \AisFssp\EnumType\ProcessResult::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get FileNote value
     * @return \AisFssp\StructType\AttachmentFileNote|null
     */
    public function getFileNote()
    {
        return $this->FileNote;
    }
    /**
     * Set FileNote value
     * @param \AisFssp\StructType\AttachmentFileNote $fileNote
     * @return \AisFssp\StructType\DocNote
     */
    public function setFileNote(\AisFssp\StructType\AttachmentFileNote $fileNote = null)
    {
        $this->FileNote = $fileNote;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \AisFssp\StructType\DocNote
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: maxExclusive
        if ($timestamp >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $timestamp), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($timestamp < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $timestamp), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \AisFssp\StructType\DocNote
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DocNote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
