<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepositBoxDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о наличии банковских ячеек
 * @subpackage Structs
 */
class DepositBoxDatumType extends InformationType
{
    /**
     * The contractNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер договора | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $contractNumber;
    /**
     * The contractDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата заключения договора | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $contractDate;
    /**
     * Constructor method for DepositBoxDatumType
     * @uses DepositBoxDatumType::setContractNumber()
     * @uses DepositBoxDatumType::setContractDate()
     * @param string $contractNumber
     * @param string $contractDate
     */
    public function __construct($contractNumber = null, $contractDate = null)
    {
        $this
            ->setContractNumber($contractNumber)
            ->setContractDate($contractDate);
    }
    /**
     * Get contractNumber value
     * @return string|null
     */
    public function getContractNumber()
    {
        return $this->contractNumber;
    }
    /**
     * Set contractNumber value
     * @param string $contractNumber
     * @return \AisFssp\StructType\DepositBoxDatumType
     */
    public function setContractNumber($contractNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($contractNumber) && strlen($contractNumber) > 25) || (is_array($contractNumber) && count($contractNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($contractNumber) ? strlen($contractNumber) : count($contractNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($contractNumber) && strlen($contractNumber) < 1) || (is_array($contractNumber) && count($contractNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contractNumber) && !is_string($contractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractNumber)), __LINE__);
        }
        $this->contractNumber = $contractNumber;
        return $this;
    }
    /**
     * Get contractDate value
     * @return string|null
     */
    public function getContractDate()
    {
        return $this->contractDate;
    }
    /**
     * Set contractDate value
     * @param string $contractDate
     * @return \AisFssp\StructType\DepositBoxDatumType
     */
    public function setContractDate($contractDate = null)
    {
        // validation for constraint: maxExclusive
        if ($contractDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $contractDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($contractDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $contractDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contractDate) && !is_string($contractDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractDate)), __LINE__);
        }
        $this->contractDate = $contractDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DepositBoxDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
