<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DebtorStateDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений DebtorStateDataType "Статус должника"
 * @subpackage Structs
 */
class DebtorStateDataType extends InformationType
{
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - documentation: Статус | Сведения о статусе должника | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $State;
    /**
     * Constructor method for DebtorStateDataType
     * @uses DebtorStateDataType::setState()
     * @param string $state
     */
    public function __construct($state = null)
    {
        $this
            ->setState($state);
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \AisFssp\StructType\DebtorStateDataType
     */
    public function setState($state = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($state) && strlen($state) > 300) || (is_array($state) && count($state) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($state) ? strlen($state) : count($state)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($state) && strlen($state) < 1) || (is_array($state) && count($state) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DebtorStateDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
