<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DebtorPropertyChange StructType
 * Meta informations extracted from the WSDL
 * - documentation: Уведомление об изменении реквизитов | ЭП
 * - type: tns:DebtorPropertyChange
 * @subpackage Structs
 */
class DebtorPropertyChange extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор заявления, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The IdExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор ИД АИС ВК | Идентификатор исполнительного документа, полученного ранее от АИС внешнего контрагента. Заполняется
     * в том случае, если ИД был получен ранее от АИС того же внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего
     * контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве
     * обмена данными с конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $IdExternalKey;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер заявления | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата заявления | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The OldDebtorName
     * Meta informations extracted from the WSDL
     * - documentation: Старое наименование должника | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $OldDebtorName;
    /**
     * The OldDebtorFio
     * Meta informations extracted from the WSDL
     * - documentation: Старое ФИО должника
     * - minOccurs: 0
     * @var \AisFssp\StructType\FioType
     */
    public $OldDebtorFio;
    /**
     * The OldDebtorAddress
     * Meta informations extracted from the WSDL
     * - documentation: Старый адрес регистрации должника
     * - minOccurs: 0
     * @var \AisFssp\StructType\AddressType
     */
    public $OldDebtorAddress;
    /**
     * The NewDepartmentCode
     * Meta informations extracted from the WSDL
     * - documentation: Код налогового органа нового места постановки на учет | Код подразделения организации | NSI_MVV_Department
     * - minOccurs: 0
     * - maxLength: 320
     * - minLength: 1
     * @var string
     */
    public $NewDepartmentCode;
    /**
     * The NewDebtorName
     * Meta informations extracted from the WSDL
     * - documentation: Новое наименование должника | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $NewDebtorName;
    /**
     * The NewDebtorFio
     * Meta informations extracted from the WSDL
     * - documentation: Новое ФИО должника
     * - minOccurs: 0
     * @var \AisFssp\StructType\FioType
     */
    public $NewDebtorFio;
    /**
     * The NewDebtorAddress
     * Meta informations extracted from the WSDL
     * - documentation: Новый адрес регистрации должника
     * - minOccurs: 0
     * @var \AisFssp\StructType\AddressType
     */
    public $NewDebtorAddress;
    /**
     * The NewTaxOrganName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование налогового органа нового места постановки на учет | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $NewTaxOrganName;
    /**
     * The NewTaxOrganAddress
     * Meta informations extracted from the WSDL
     * - documentation: Адрес налогового органа нового места постановки на учет | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $NewTaxOrganAddress;
    /**
     * The TaxOrganChangeReason
     * Meta informations extracted from the WSDL
     * - documentation: Причина смены налогового органа места постановки на учет
     * - minOccurs: 0
     * @var string
     */
    public $TaxOrganChangeReason;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for DebtorPropertyChange
     * @uses DebtorPropertyChange::setExternalKey()
     * @uses DebtorPropertyChange::setIdExternalKey()
     * @uses DebtorPropertyChange::setDocNumber()
     * @uses DebtorPropertyChange::setDocDate()
     * @uses DebtorPropertyChange::setOldDebtorName()
     * @uses DebtorPropertyChange::setOldDebtorFio()
     * @uses DebtorPropertyChange::setOldDebtorAddress()
     * @uses DebtorPropertyChange::setNewDepartmentCode()
     * @uses DebtorPropertyChange::setNewDebtorName()
     * @uses DebtorPropertyChange::setNewDebtorFio()
     * @uses DebtorPropertyChange::setNewDebtorAddress()
     * @uses DebtorPropertyChange::setNewTaxOrganName()
     * @uses DebtorPropertyChange::setNewTaxOrganAddress()
     * @uses DebtorPropertyChange::setTaxOrganChangeReason()
     * @uses DebtorPropertyChange::setSignature()
     * @uses DebtorPropertyChange::setId()
     * @param string $externalKey
     * @param string $idExternalKey
     * @param string $docNumber
     * @param string $docDate
     * @param string $oldDebtorName
     * @param \AisFssp\StructType\FioType $oldDebtorFio
     * @param \AisFssp\StructType\AddressType $oldDebtorAddress
     * @param string $newDepartmentCode
     * @param string $newDebtorName
     * @param \AisFssp\StructType\FioType $newDebtorFio
     * @param \AisFssp\StructType\AddressType $newDebtorAddress
     * @param string $newTaxOrganName
     * @param string $newTaxOrganAddress
     * @param string $taxOrganChangeReason
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $idExternalKey = null, $docNumber = null, $docDate = null, $oldDebtorName = null, \AisFssp\StructType\FioType $oldDebtorFio = null, \AisFssp\StructType\AddressType $oldDebtorAddress = null, $newDepartmentCode = null, $newDebtorName = null, \AisFssp\StructType\FioType $newDebtorFio = null, \AisFssp\StructType\AddressType $newDebtorAddress = null, $newTaxOrganName = null, $newTaxOrganAddress = null, $taxOrganChangeReason = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setIdExternalKey($idExternalKey)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setOldDebtorName($oldDebtorName)
            ->setOldDebtorFio($oldDebtorFio)
            ->setOldDebtorAddress($oldDebtorAddress)
            ->setNewDepartmentCode($newDepartmentCode)
            ->setNewDebtorName($newDebtorName)
            ->setNewDebtorFio($newDebtorFio)
            ->setNewDebtorAddress($newDebtorAddress)
            ->setNewTaxOrganName($newTaxOrganName)
            ->setNewTaxOrganAddress($newTaxOrganAddress)
            ->setTaxOrganChangeReason($taxOrganChangeReason)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\DebtorPropertyChange
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get IdExternalKey value
     * @return string|null
     */
    public function getIdExternalKey()
    {
        return $this->IdExternalKey;
    }
    /**
     * Set IdExternalKey value
     * @param string $idExternalKey
     * @return \AisFssp\StructType\DebtorPropertyChange
     */
    public function setIdExternalKey($idExternalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($idExternalKey) && strlen($idExternalKey) > 60) || (is_array($idExternalKey) && count($idExternalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($idExternalKey) ? strlen($idExternalKey) : count($idExternalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($idExternalKey) && strlen($idExternalKey) < 1) || (is_array($idExternalKey) && count($idExternalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idExternalKey) && !is_string($idExternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idExternalKey)), __LINE__);
        }
        $this->IdExternalKey = $idExternalKey;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\DebtorPropertyChange
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\DebtorPropertyChange
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get OldDebtorName value
     * @return string|null
     */
    public function getOldDebtorName()
    {
        return $this->OldDebtorName;
    }
    /**
     * Set OldDebtorName value
     * @param string $oldDebtorName
     * @return \AisFssp\StructType\DebtorPropertyChange
     */
    public function setOldDebtorName($oldDebtorName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oldDebtorName) && strlen($oldDebtorName) > 1000) || (is_array($oldDebtorName) && count($oldDebtorName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($oldDebtorName) ? strlen($oldDebtorName) : count($oldDebtorName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($oldDebtorName) && strlen($oldDebtorName) < 1) || (is_array($oldDebtorName) && count($oldDebtorName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oldDebtorName) && !is_string($oldDebtorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oldDebtorName)), __LINE__);
        }
        $this->OldDebtorName = $oldDebtorName;
        return $this;
    }
    /**
     * Get OldDebtorFio value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getOldDebtorFio()
    {
        return $this->OldDebtorFio;
    }
    /**
     * Set OldDebtorFio value
     * @param \AisFssp\StructType\FioType $oldDebtorFio
     * @return \AisFssp\StructType\DebtorPropertyChange
     */
    public function setOldDebtorFio(\AisFssp\StructType\FioType $oldDebtorFio = null)
    {
        $this->OldDebtorFio = $oldDebtorFio;
        return $this;
    }
    /**
     * Get OldDebtorAddress value
     * @return \AisFssp\StructType\AddressType|null
     */
    public function getOldDebtorAddress()
    {
        return $this->OldDebtorAddress;
    }
    /**
     * Set OldDebtorAddress value
     * @param \AisFssp\StructType\AddressType $oldDebtorAddress
     * @return \AisFssp\StructType\DebtorPropertyChange
     */
    public function setOldDebtorAddress(\AisFssp\StructType\AddressType $oldDebtorAddress = null)
    {
        $this->OldDebtorAddress = $oldDebtorAddress;
        return $this;
    }
    /**
     * Get NewDepartmentCode value
     * @return string|null
     */
    public function getNewDepartmentCode()
    {
        return $this->NewDepartmentCode;
    }
    /**
     * Set NewDepartmentCode value
     * @param string $newDepartmentCode
     * @return \AisFssp\StructType\DebtorPropertyChange
     */
    public function setNewDepartmentCode($newDepartmentCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newDepartmentCode) && strlen($newDepartmentCode) > 320) || (is_array($newDepartmentCode) && count($newDepartmentCode) > 320)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 320 element(s) or a scalar of 320 character(s) at most, "%d" length given', is_scalar($newDepartmentCode) ? strlen($newDepartmentCode) : count($newDepartmentCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($newDepartmentCode) && strlen($newDepartmentCode) < 1) || (is_array($newDepartmentCode) && count($newDepartmentCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newDepartmentCode) && !is_string($newDepartmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newDepartmentCode)), __LINE__);
        }
        $this->NewDepartmentCode = $newDepartmentCode;
        return $this;
    }
    /**
     * Get NewDebtorName value
     * @return string|null
     */
    public function getNewDebtorName()
    {
        return $this->NewDebtorName;
    }
    /**
     * Set NewDebtorName value
     * @param string $newDebtorName
     * @return \AisFssp\StructType\DebtorPropertyChange
     */
    public function setNewDebtorName($newDebtorName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newDebtorName) && strlen($newDebtorName) > 1000) || (is_array($newDebtorName) && count($newDebtorName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($newDebtorName) ? strlen($newDebtorName) : count($newDebtorName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($newDebtorName) && strlen($newDebtorName) < 1) || (is_array($newDebtorName) && count($newDebtorName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newDebtorName) && !is_string($newDebtorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newDebtorName)), __LINE__);
        }
        $this->NewDebtorName = $newDebtorName;
        return $this;
    }
    /**
     * Get NewDebtorFio value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getNewDebtorFio()
    {
        return $this->NewDebtorFio;
    }
    /**
     * Set NewDebtorFio value
     * @param \AisFssp\StructType\FioType $newDebtorFio
     * @return \AisFssp\StructType\DebtorPropertyChange
     */
    public function setNewDebtorFio(\AisFssp\StructType\FioType $newDebtorFio = null)
    {
        $this->NewDebtorFio = $newDebtorFio;
        return $this;
    }
    /**
     * Get NewDebtorAddress value
     * @return \AisFssp\StructType\AddressType|null
     */
    public function getNewDebtorAddress()
    {
        return $this->NewDebtorAddress;
    }
    /**
     * Set NewDebtorAddress value
     * @param \AisFssp\StructType\AddressType $newDebtorAddress
     * @return \AisFssp\StructType\DebtorPropertyChange
     */
    public function setNewDebtorAddress(\AisFssp\StructType\AddressType $newDebtorAddress = null)
    {
        $this->NewDebtorAddress = $newDebtorAddress;
        return $this;
    }
    /**
     * Get NewTaxOrganName value
     * @return string|null
     */
    public function getNewTaxOrganName()
    {
        return $this->NewTaxOrganName;
    }
    /**
     * Set NewTaxOrganName value
     * @param string $newTaxOrganName
     * @return \AisFssp\StructType\DebtorPropertyChange
     */
    public function setNewTaxOrganName($newTaxOrganName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newTaxOrganName) && strlen($newTaxOrganName) > 300) || (is_array($newTaxOrganName) && count($newTaxOrganName) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($newTaxOrganName) ? strlen($newTaxOrganName) : count($newTaxOrganName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($newTaxOrganName) && strlen($newTaxOrganName) < 1) || (is_array($newTaxOrganName) && count($newTaxOrganName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newTaxOrganName) && !is_string($newTaxOrganName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newTaxOrganName)), __LINE__);
        }
        $this->NewTaxOrganName = $newTaxOrganName;
        return $this;
    }
    /**
     * Get NewTaxOrganAddress value
     * @return string|null
     */
    public function getNewTaxOrganAddress()
    {
        return $this->NewTaxOrganAddress;
    }
    /**
     * Set NewTaxOrganAddress value
     * @param string $newTaxOrganAddress
     * @return \AisFssp\StructType\DebtorPropertyChange
     */
    public function setNewTaxOrganAddress($newTaxOrganAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newTaxOrganAddress) && strlen($newTaxOrganAddress) > 300) || (is_array($newTaxOrganAddress) && count($newTaxOrganAddress) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($newTaxOrganAddress) ? strlen($newTaxOrganAddress) : count($newTaxOrganAddress)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($newTaxOrganAddress) && strlen($newTaxOrganAddress) < 1) || (is_array($newTaxOrganAddress) && count($newTaxOrganAddress) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newTaxOrganAddress) && !is_string($newTaxOrganAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newTaxOrganAddress)), __LINE__);
        }
        $this->NewTaxOrganAddress = $newTaxOrganAddress;
        return $this;
    }
    /**
     * Get TaxOrganChangeReason value
     * @return string|null
     */
    public function getTaxOrganChangeReason()
    {
        return $this->TaxOrganChangeReason;
    }
    /**
     * Set TaxOrganChangeReason value
     * @uses \AisFssp\EnumType\TaxOrganChangeReasonCodeType::valueIsValid()
     * @uses \AisFssp\EnumType\TaxOrganChangeReasonCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxOrganChangeReason
     * @return \AisFssp\StructType\DebtorPropertyChange
     */
    public function setTaxOrganChangeReason($taxOrganChangeReason = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\TaxOrganChangeReasonCodeType::valueIsValid($taxOrganChangeReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $taxOrganChangeReason, implode(', ', \AisFssp\EnumType\TaxOrganChangeReasonCodeType::getValidValues())), __LINE__);
        }
        $this->TaxOrganChangeReason = $taxOrganChangeReason;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\DebtorPropertyChange
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $debtorPropertyChangeSignatureItem) {
            // validation for constraint: itemType
            if (!$debtorPropertyChangeSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($debtorPropertyChangeSignatureItem) ? get_class($debtorPropertyChangeSignatureItem) : gettype($debtorPropertyChangeSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\DebtorPropertyChange
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\DebtorPropertyChange
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DebtorPropertyChange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
