<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DebtRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ DebtRequest «Запрос реестра долга» | Данный документ запрашивает реестры задолженности по исполнительным производствам и
 * список ОСП для получения реквизитов для перечисления средств | ЭП
 * - type: tns:DebtRequest
 * @subpackage Structs
 */
class DebtRequest extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор запроса, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The IsUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Признак запроса обновления | Если в этом поле стоит false, то запрашивается реестр целиком | Обертка стандартного xs:boolean |
     * Логический
     * @var bool
     */
    public $IsUpdate;
    /**
     * The LastUnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата последнего реестра | Дата последнего выгруженного обновления реестра задолженности, которое есть у платежной системы |
     * Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $LastUnloadDate;
    /**
     * The DueUnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время, по которые запрашиваются реестры изменений | Используются только при запросе изменений. При запросе полного
     * реестра игнорируется | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $DueUnloadDate;
    /**
     * The MaxResultCount
     * Meta informations extracted from the WSDL
     * - documentation: Максимальное количество реестров | Используются только при запросе изменений. При запросе полного реестра игнорируется. Для
     * поля MaxResultCount значение по умолчанию 17 | Положительное короткое целое
     * - minOccurs: 0
     * - minInclusive: 1
     * @var int
     */
    public $MaxResultCount;
    /**
     * The ToFrom
     * Meta informations extracted from the WSDL
     * - documentation: Код территориального органа | Если указан данный код, возвращаются только реестры для определенного региона. | Ведомственный
     * классификатор отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $ToFrom;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for DebtRequest
     * @uses DebtRequest::setExternalKey()
     * @uses DebtRequest::setIsUpdate()
     * @uses DebtRequest::setLastUnloadDate()
     * @uses DebtRequest::setDueUnloadDate()
     * @uses DebtRequest::setMaxResultCount()
     * @uses DebtRequest::setToFrom()
     * @uses DebtRequest::setSignDateTime()
     * @uses DebtRequest::setSignature()
     * @param string $externalKey
     * @param bool $isUpdate
     * @param string $lastUnloadDate
     * @param string $dueUnloadDate
     * @param int $maxResultCount
     * @param string $toFrom
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     */
    public function __construct($externalKey = null, $isUpdate = null, $lastUnloadDate = null, $dueUnloadDate = null, $maxResultCount = null, $toFrom = null, $signDateTime = null, array $signature = array())
    {
        $this
            ->setExternalKey($externalKey)
            ->setIsUpdate($isUpdate)
            ->setLastUnloadDate($lastUnloadDate)
            ->setDueUnloadDate($dueUnloadDate)
            ->setMaxResultCount($maxResultCount)
            ->setToFrom($toFrom)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\DebtRequest
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get IsUpdate value
     * @return bool|null
     */
    public function getIsUpdate()
    {
        return $this->IsUpdate;
    }
    /**
     * Set IsUpdate value
     * @param bool $isUpdate
     * @return \AisFssp\StructType\DebtRequest
     */
    public function setIsUpdate($isUpdate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdate) && !is_bool($isUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isUpdate)), __LINE__);
        }
        $this->IsUpdate = $isUpdate;
        return $this;
    }
    /**
     * Get LastUnloadDate value
     * @return string|null
     */
    public function getLastUnloadDate()
    {
        return $this->LastUnloadDate;
    }
    /**
     * Set LastUnloadDate value
     * @param string $lastUnloadDate
     * @return \AisFssp\StructType\DebtRequest
     */
    public function setLastUnloadDate($lastUnloadDate = null)
    {
        // validation for constraint: maxExclusive
        if ($lastUnloadDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $lastUnloadDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($lastUnloadDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $lastUnloadDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lastUnloadDate) && !is_string($lastUnloadDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUnloadDate)), __LINE__);
        }
        $this->LastUnloadDate = $lastUnloadDate;
        return $this;
    }
    /**
     * Get DueUnloadDate value
     * @return string|null
     */
    public function getDueUnloadDate()
    {
        return $this->DueUnloadDate;
    }
    /**
     * Set DueUnloadDate value
     * @param string $dueUnloadDate
     * @return \AisFssp\StructType\DebtRequest
     */
    public function setDueUnloadDate($dueUnloadDate = null)
    {
        // validation for constraint: maxExclusive
        if ($dueUnloadDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dueUnloadDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dueUnloadDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dueUnloadDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dueUnloadDate) && !is_string($dueUnloadDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dueUnloadDate)), __LINE__);
        }
        $this->DueUnloadDate = $dueUnloadDate;
        return $this;
    }
    /**
     * Get MaxResultCount value
     * @return int|null
     */
    public function getMaxResultCount()
    {
        return $this->MaxResultCount;
    }
    /**
     * Set MaxResultCount value
     * @param int $maxResultCount
     * @return \AisFssp\StructType\DebtRequest
     */
    public function setMaxResultCount($maxResultCount = null)
    {
        // validation for constraint: minInclusive
        if ($maxResultCount < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $maxResultCount), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($maxResultCount) && !is_numeric($maxResultCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxResultCount)), __LINE__);
        }
        $this->MaxResultCount = $maxResultCount;
        return $this;
    }
    /**
     * Get ToFrom value
     * @return string|null
     */
    public function getToFrom()
    {
        return $this->ToFrom;
    }
    /**
     * Set ToFrom value
     * @param string $toFrom
     * @return \AisFssp\StructType\DebtRequest
     */
    public function setToFrom($toFrom = null)
    {
        // validation for constraint: length
        if ((is_scalar($toFrom) && strlen($toFrom) !== 5) || (is_array($toFrom) && count($toFrom) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($toFrom) && !preg_match('/[0-9]{5}/', $toFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($toFrom, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($toFrom) && !is_string($toFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toFrom)), __LINE__);
        }
        $this->ToFrom = $toFrom;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\DebtRequest
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\DebtRequest
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $debtRequestSignatureItem) {
            // validation for constraint: itemType
            if (!$debtRequestSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($debtRequestSignatureItem) ? get_class($debtRequestSignatureItem) : gettype($debtRequestSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\DebtRequest
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DebtRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
