<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataBlock StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных DataBlock "Пакет документов" | Запрос о полученных физическим лицом суммах, взысканных по ИП | Ответ на запрос о
 * полученных физическим лицом суммах, взысканных по ИП | Запрос в реестр розыска
 * - type: tns:DataBlock
 * @subpackage Structs
 */
class DataBlock extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Обязательно для исходящего документа. Содержит уникальный идентификатор объекта АИС ФССП России | Ключ
     * объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Обязательно для входящего документа. Содержит идентификатор объекта, присвоенный АИС внешнего
     * контрагента. Уникален в рамках типа документа и конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС
     * внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в
     * пространстве обмена данными с конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The FsspTo
     * Meta informations extracted from the WSDL
     * - documentation: ТО | Код территориального органа ФССП России с дополнением до 5 знаков нулями для получения кода ВКСП | Ведомственный
     * классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $FsspTo;
    /**
     * The FsspOsp
     * Meta informations extracted from the WSDL
     * - documentation: ОСП | Код структурного подразделения территориального органа ФССП России (5 цифр) по справочнику структурных подразделений
     * ФССП России (ВКСП) | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $FsspOsp;
    /**
     * The OrgAMD
     * Meta informations extracted from the WSDL
     * - documentation: Контрагент | Код Ведомства по справочнику контрагентов автоматизированного межведомственного документооборота | Код
     * организации | NSI_MVV_Organization
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $OrgAMD;
    /**
     * The DivAMD
     * Meta informations extracted from the WSDL
     * - documentation: Подразделение контрагента | Код подразделения Ведомства по справочнику подразделений организации-контрагента
     * автоматизированного документооборота | Код подразделения организации | NSI_MVV_Department
     * - minOccurs: 0
     * - maxLength: 320
     * - minLength: 1
     * @var string
     */
    public $DivAMD;
    /**
     * The Signed
     * Meta informations extracted from the WSDL
     * - documentation: Подписал | ФИО подписавшего лица | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Signed;
    /**
     * The Query
     * Meta informations extracted from the WSDL
     * - documentation: Запрос СПИ
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\Query[]
     */
    public $Query;
    /**
     * The Answer
     * Meta informations extracted from the WSDL
     * - documentation: Ответ на запрос СПИ
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\Answer[]
     */
    public $Answer;
    /**
     * The AccountQuery
     * Meta informations extracted from the WSDL
     * - documentation: Запрос СПИ на предоставление сведений об архивных счетах и движении денежных средств
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\AccountQuery[]
     */
    public $AccountQuery;
    /**
     * The AccountAnswer
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об архивных счетах и движении денежных средств
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\AccountAnswer[]
     */
    public $AccountAnswer;
    /**
     * The SalaryWithheldQuery
     * Meta informations extracted from the WSDL
     * - documentation: Запрос СПИ на предоставление сведений об архивных счетах и движении денежных средств
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\SalaryWithheldQuery[]
     */
    public $SalaryWithheldQuery;
    /**
     * The SalaryWithheldAnswer
     * Meta informations extracted from the WSDL
     * - documentation: Справка о начисленном денежном довольствии и произведенных удержаниях
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\SalaryWithheldAnswer[]
     */
    public $SalaryWithheldAnswer;
    /**
     * The Restrictn
     * Meta informations extracted from the WSDL
     * - documentation: Постановление к исполнению | Постановление СПИ о наложении ограничения (ареста) или о снятии ограничения (ареста)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\Restrictn[]
     */
    public $Restrictn;
    /**
     * The Report
     * Meta informations extracted from the WSDL
     * - documentation: Уведомление об исполнении | Уведомление об исполнении постановления СПИ
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\Report[]
     */
    public $Report;
    /**
     * The DebtorNewAccountNotice
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об открытии должниками по ИП новых счетов в кредитных организациях
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\DebtorNewAccountNotice[]
     */
    public $DebtorNewAccountNotice;
    /**
     * The ExtDoc
     * Meta informations extracted from the WSDL
     * - documentation: Исполнительный документ | Сведения о предъявленном в ФССП России исполнительном документе в пользу Ведомства
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\ExtDoc[]
     */
    public $ExtDoc;
    /**
     * The ProcDoc
     * Meta informations extracted from the WSDL
     * - documentation: Постановление СПИ | Постановление СПИ, направляемое в адрес Ведомства, представляющего взыскателя
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\ProcDoc[]
     */
    public $ProcDoc;
    /**
     * The ExtDebtFix
     * Meta informations extracted from the WSDL
     * - documentation: Погашение ИД | Реестр погашенной задолженности по исполнительным документам
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\ExtDebtFix[]
     */
    public $ExtDebtFix;
    /**
     * The RecallDoc
     * Meta informations extracted from the WSDL
     * - documentation: Заявление об отзыве ИД | Заявление об отзыве Постановления о взыскании страховых взносов, пеней и штрафов за счет имущества
     * плательщика страховых взносов
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\RecallDoc[]
     */
    public $RecallDoc;
    /**
     * The DebtorPropertyChange
     * Meta informations extracted from the WSDL
     * - documentation: Уведомление об изменении реквизитов
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\DebtorPropertyChange[]
     */
    public $DebtorPropertyChange;
    /**
     * The DebtRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос реестров долга | Запрос реестров долга по ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\DebtRequest[]
     */
    public $DebtRequest;
    /**
     * The Debt
     * Meta informations extracted from the WSDL
     * - documentation: Реестр долга по ИП | Реестр остатков долга по ИП
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \AisFssp\StructType\Debt
     */
    public $Debt;
    /**
     * The ExtPayments
     * Meta informations extracted from the WSDL
     * - documentation: Оплата долга | Реестр оплаченных сумм
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\ExtPayments[]
     */
    public $ExtPayments;
    /**
     * The OspRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос реквизитов ОСП | Запрос параметров ОСП для использования в качестве реквизитов оплаты долга
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\OspRequest[]
     */
    public $OspRequest;
    /**
     * The OspProperties
     * Meta informations extracted from the WSDL
     * - documentation: Реквизиты ОСП | Реквизиты отделов СП для платежей
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\OspProperties[]
     */
    public $OspProperties;
    /**
     * The BankruptDoc
     * Meta informations extracted from the WSDL
     * - documentation: Уведомление об инициировании процедуры банкротства должника | Направляется ФНС в адрес ФССП России
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\BankruptDoc[]
     */
    public $BankruptDoc;
    /**
     * The ArrestFourthStageProperty
     * Meta informations extracted from the WSDL
     * - documentation: Уведомление СПИ об аресте имущества 4й очереди
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\ArrestFourthStagePropertyType[]
     */
    public $ArrestFourthStageProperty;
    /**
     * The DebtorIpNotify
     * Meta informations extracted from the WSDL
     * - documentation: Информация об уведомлении должника о возбуждении ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\DebtorIpNotify[]
     */
    public $DebtorIpNotify;
    /**
     * The NoticeReadinessSaleSeizedProperty
     * Meta informations extracted from the WSDL
     * - documentation: Уведомление о готовности к реализации арестованного имущества
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\NoticeReadinessSaleSeizedProperty[]
     */
    public $NoticeReadinessSaleSeizedProperty;
    /**
     * The NoticeSaleSeizedProperty
     * Meta informations extracted from the WSDL
     * - documentation: Уведомление о реализации арестованного имущества
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\NoticeSaleSeizedProperty[]
     */
    public $NoticeSaleSeizedProperty;
    /**
     * The CertificateDeliveryAcceptance
     * Meta informations extracted from the WSDL
     * - documentation: Акт приема-передачи арестованного имущества
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\CertificateDeliveryAcceptance[]
     */
    public $CertificateDeliveryAcceptance;
    /**
     * The ReportExecutionSale
     * Meta informations extracted from the WSDL
     * - documentation: Отчет о результатах реализации арестованного имущества
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\ReportExecutionSale[]
     */
    public $ReportExecutionSale;
    /**
     * The IPSideQuery
     * Meta informations extracted from the WSDL
     * - documentation: Запрос стороны ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\IPSideQuery[]
     */
    public $IPSideQuery;
    /**
     * The IPSideAnswer
     * Meta informations extracted from the WSDL
     * - documentation: Ответ стороне ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\IPSideAnswer[]
     */
    public $IPSideAnswer;
    /**
     * The exitRestrictionActRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос постановления об ограничении выезда
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\ExitRestrictionActRequest[]
     */
    public $exitRestrictionActRequest;
    /**
     * The exitRestrictionActInfo
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о наличии постановления об ограничении выезда
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\ExitRestrictionActInfo[]
     */
    public $exitRestrictionActInfo;
    /**
     * The RestrictionActRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос сведений об арестах и ограничениях, наложенных судебными приставами-исполнителями на имущество должников
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\RestrictionActRequest[]
     */
    public $RestrictionActRequest;
    /**
     * The RestrictionActInfo
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об арестах и ограничениях, наложенных судебными приставами-исполнителями на имущество должников
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\RestrictionActInfo[]
     */
    public $RestrictionActInfo;
    /**
     * The ipDataRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос информации о наличии и реквизитах ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\IPDataRequest[]
     */
    public $ipDataRequest;
    /**
     * The investigationDataInfo
     * Meta informations extracted from the WSDL
     * - documentation: Информация об исполнительных производствах по реестру розыска
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\InvestigationDataInfo[]
     */
    public $investigationDataInfo;
    /**
     * The ipDataInfo
     * Meta informations extracted from the WSDL
     * - documentation: Информация об исполнительных производствах
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\IPDataInfo[]
     */
    public $ipDataInfo;
    /**
     * The RecoveredAmountRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:RecoveredAmountRequest
     * @var \AisFssp\StructType\RecoveredAmountRequest[]
     */
    public $RecoveredAmountRequest;
    /**
     * The RecoveredAmountAnswer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:RecoveredAmountAnswer
     * @var \AisFssp\StructType\RecoveredAmountAnswer[]
     */
    public $RecoveredAmountAnswer;
    /**
     * The InvestigationRegistryQuery
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:InvestigationRegistryQuery
     * @var \AisFssp\StructType\InvestigationRegistryQuery[]
     */
    public $InvestigationRegistryQuery;
    /**
     * The ArrestRegistryQuery
     * Meta informations extracted from the WSDL
     * - documentation: Запрос в реестр арестованного имущество отправленного на реализацию
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\ArrestRegistryQuery[]
     */
    public $ArrestRegistryQuery;
    /**
     * The ArrestRegistryInfo
     * Meta informations extracted from the WSDL
     * - documentation: Выписка из реестра арестованного имущество отправленного на реализацию
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\ArrestRegistryInfo[]
     */
    public $ArrestRegistryInfo;
    /**
     * The ArrestRegistryDetail
     * Meta informations extracted from the WSDL
     * - documentation: Строка выписки из реестра арестованного имущество отправленного на реализацию
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\ArrestRegistryDetail[]
     */
    public $ArrestRegistryDetail;
    /**
     * The CrimeRegistryQuery
     * Meta informations extracted from the WSDL
     * - documentation: Запрос на получение сведений из реестра розыска подозреваемых в преступлениях
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\CrimeRegistryQuery[]
     */
    public $CrimeRegistryQuery;
    /**
     * The CrimeRegistryInfo
     * Meta informations extracted from the WSDL
     * - documentation: Выписка из реестра розыска подозреваемых в преступлениях
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\CrimeRegistryInfo[]
     */
    public $CrimeRegistryInfo;
    /**
     * The CrimeRegistryDetail
     * Meta informations extracted from the WSDL
     * - documentation: Строка выписки из реестра розыска подозреваемых в преступлениях
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\CrimeRegistryDetail[]
     */
    public $CrimeRegistryDetail;
    /**
     * The caRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос в ВУЦ
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\CaRequest[]
     */
    public $caRequest;
    /**
     * The caAnswer
     * Meta informations extracted from the WSDL
     * - documentation: Ответ ВУЦ
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\CaAnswer[]
     */
    public $caAnswer;
    /**
     * The investigationRegistry
     * Meta informations extracted from the WSDL
     * - documentation: Реестр розыска
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\InvestigationRegistry[]
     */
    public $investigationRegistry;
    /**
     * The PenaltyChargesRegistry
     * Meta informations extracted from the WSDL
     * - documentation: Реестр штрафов по АД
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\PenaltyChargesRegistry[]
     */
    public $PenaltyChargesRegistry;
    /**
     * The RestrictionRegistry
     * Meta informations extracted from the WSDL
     * - documentation: Реестр ограничений
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\RestrictionRegistry[]
     */
    public $RestrictionRegistry;
    /**
     * The ReqAppResult
     * Meta informations extracted from the WSDL
     * - documentation: Запрос получения статуса рассмотрения обращений
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\ReqAppResult[]
     */
    public $ReqAppResult;
    /**
     * The AnswerAppResult
     * Meta informations extracted from the WSDL
     * - documentation: Ответ на запрос статуса рассмотрения обращения
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\AnswerAppResult[]
     */
    public $AnswerAppResult;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Технологическое сообщение | Служебные сообщения об ошибках, квитанции о приеме и прочее
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\DocumentNote[]
     */
    public $Message;
    /**
     * The debtorIPListRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос реестра ИП по должнику
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\DebtorIPListRequestType[]
     */
    public $debtorIPListRequest;
    /**
     * The IPSideRequestExistence
     * Meta informations extracted from the WSDL
     * - documentation: Регистрация запроса о наличии ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\IPSideRequestExistenceType[]
     */
    public $IPSideRequestExistence;
    /**
     * The IPSideRequestCourseID
     * Meta informations extracted from the WSDL
     * - documentation: Регистрация запроса о ходе ИП по исполнительному документу
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\IPSideRequestCourseIDType[]
     */
    public $IPSideRequestCourseID;
    /**
     * The IPSideRequestCourseIP
     * Meta informations extracted from the WSDL
     * - documentation: Регистрация запроса о ходе ИП по номеру ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\IPSideRequestCourseIPType[]
     */
    public $IPSideRequestCourseIP;
    /**
     * The IPReqAppResultRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос на получение ответов на заявления или запросы в ОСП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\IPReqAppResultRequestType[]
     */
    public $IPReqAppResultRequest;
    /**
     * The DebtorIPListResponseType
     * Meta informations extracted from the WSDL
     * - documentation: Список исполнительных производств по должнику
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\DebtorIPListResponseType[]
     */
    public $DebtorIPListResponseType;
    /**
     * The IPReqAppResponseType
     * Meta informations extracted from the WSDL
     * - documentation: Подтверждение регистрации запроса или заявления в ОСП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\IPReqAppResponseType[]
     */
    public $IPReqAppResponseType;
    /**
     * The IPReqAppResultReponseType
     * Meta informations extracted from the WSDL
     * - documentation: Ответы ОСП на запросы или заявления
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\IPReqAppResultReponseType[]
     */
    public $IPReqAppResultReponseType;
    /**
     * The EApplicationType
     * Meta informations extracted from the WSDL
     * - documentation: Электронное обращение
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\EApplicationType[]
     */
    public $EApplicationType;
    /**
     * The EApplicationResultType
     * Meta informations extracted from the WSDL
     * - documentation: Ответ на электронное обращение
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\EApplicationResultType[]
     */
    public $EApplicationResultType;
    /**
     * The MailStateTrackingRequest
     * Meta informations extracted from the WSDL
     * - documentation: Документ MailStateTrackingRequest "Запрос статуса корреспонденции" | Тип данных документа «Запрос статуса корреспонденции» используется
     * для передачи из ПКОСП в МВВ запроса на отслеживание стутуса заказных отправлений
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\MailStateTrackingRequest[]
     */
    public $MailStateTrackingRequest;
    /**
     * The MailState
     * Meta informations extracted from the WSDL
     * - documentation: Документ MailState "Статус корреспонденции" | Тип данных документа «Статус корреспонденции» используется для передачи из МВВ в
     * ПКОСП информации о статусе заказного отправления.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\MailState[]
     */
    public $MailState;
    /**
     * The IncomingForcedExecDocument
     * Meta informations extracted from the WSDL
     * - documentation: Входящий документ принудительного исполнения | Тип данных документа «Входящий документ принудительного исполнения»
     * используется приема документов от внешних контрагентов
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\IncomingForcedExecDocument[]
     */
    public $IncomingForcedExecDocument;
    /**
     * The OutgoingForcedExecDocument
     * Meta informations extracted from the WSDL
     * - documentation: Исходящий документ принудительного исполнения | Тип данных документа «Исходящий документ принудительного исполнения»
     * используется для передачи документов внешним контрагентам
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\OutgoingForcedExecDocument[]
     */
    public $OutgoingForcedExecDocument;
    /**
     * The IncomingEMailMessage
     * Meta informations extracted from the WSDL
     * - documentation: Исходящий документ принудительного исполнения | Тип данных документа «Исходящий документ принудительного исполнения»
     * используется для передачи документов внешним контрагентам
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\IncomingEMailMessage[]
     */
    public $IncomingEMailMessage;
    /**
     * The OutgoingEMailMessage
     * Meta informations extracted from the WSDL
     * - documentation: Исходящий документ принудительного исполнения | Тип данных документа «Исходящий документ принудительного исполнения»
     * используется для передачи документов внешним контрагентам
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\OutgoingEMailMessage[]
     */
    public $OutgoingEMailMessage;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for DataBlock
     * @uses DataBlock::setInternalKey()
     * @uses DataBlock::setExternalKey()
     * @uses DataBlock::setFsspTo()
     * @uses DataBlock::setFsspOsp()
     * @uses DataBlock::setOrgAMD()
     * @uses DataBlock::setDivAMD()
     * @uses DataBlock::setSigned()
     * @uses DataBlock::setQuery()
     * @uses DataBlock::setAnswer()
     * @uses DataBlock::setAccountQuery()
     * @uses DataBlock::setAccountAnswer()
     * @uses DataBlock::setSalaryWithheldQuery()
     * @uses DataBlock::setSalaryWithheldAnswer()
     * @uses DataBlock::setRestrictn()
     * @uses DataBlock::setReport()
     * @uses DataBlock::setDebtorNewAccountNotice()
     * @uses DataBlock::setExtDoc()
     * @uses DataBlock::setProcDoc()
     * @uses DataBlock::setExtDebtFix()
     * @uses DataBlock::setRecallDoc()
     * @uses DataBlock::setDebtorPropertyChange()
     * @uses DataBlock::setDebtRequest()
     * @uses DataBlock::setDebt()
     * @uses DataBlock::setExtPayments()
     * @uses DataBlock::setOspRequest()
     * @uses DataBlock::setOspProperties()
     * @uses DataBlock::setBankruptDoc()
     * @uses DataBlock::setArrestFourthStageProperty()
     * @uses DataBlock::setDebtorIpNotify()
     * @uses DataBlock::setNoticeReadinessSaleSeizedProperty()
     * @uses DataBlock::setNoticeSaleSeizedProperty()
     * @uses DataBlock::setCertificateDeliveryAcceptance()
     * @uses DataBlock::setReportExecutionSale()
     * @uses DataBlock::setIPSideQuery()
     * @uses DataBlock::setIPSideAnswer()
     * @uses DataBlock::setExitRestrictionActRequest()
     * @uses DataBlock::setExitRestrictionActInfo()
     * @uses DataBlock::setRestrictionActRequest()
     * @uses DataBlock::setRestrictionActInfo()
     * @uses DataBlock::setIpDataRequest()
     * @uses DataBlock::setInvestigationDataInfo()
     * @uses DataBlock::setIpDataInfo()
     * @uses DataBlock::setRecoveredAmountRequest()
     * @uses DataBlock::setRecoveredAmountAnswer()
     * @uses DataBlock::setInvestigationRegistryQuery()
     * @uses DataBlock::setArrestRegistryQuery()
     * @uses DataBlock::setArrestRegistryInfo()
     * @uses DataBlock::setArrestRegistryDetail()
     * @uses DataBlock::setCrimeRegistryQuery()
     * @uses DataBlock::setCrimeRegistryInfo()
     * @uses DataBlock::setCrimeRegistryDetail()
     * @uses DataBlock::setCaRequest()
     * @uses DataBlock::setCaAnswer()
     * @uses DataBlock::setInvestigationRegistry()
     * @uses DataBlock::setPenaltyChargesRegistry()
     * @uses DataBlock::setRestrictionRegistry()
     * @uses DataBlock::setReqAppResult()
     * @uses DataBlock::setAnswerAppResult()
     * @uses DataBlock::setMessage()
     * @uses DataBlock::setDebtorIPListRequest()
     * @uses DataBlock::setIPSideRequestExistence()
     * @uses DataBlock::setIPSideRequestCourseID()
     * @uses DataBlock::setIPSideRequestCourseIP()
     * @uses DataBlock::setIPReqAppResultRequest()
     * @uses DataBlock::setDebtorIPListResponseType()
     * @uses DataBlock::setIPReqAppResponseType()
     * @uses DataBlock::setIPReqAppResultReponseType()
     * @uses DataBlock::setEApplicationType()
     * @uses DataBlock::setEApplicationResultType()
     * @uses DataBlock::setMailStateTrackingRequest()
     * @uses DataBlock::setMailState()
     * @uses DataBlock::setIncomingForcedExecDocument()
     * @uses DataBlock::setOutgoingForcedExecDocument()
     * @uses DataBlock::setIncomingEMailMessage()
     * @uses DataBlock::setOutgoingEMailMessage()
     * @uses DataBlock::setId()
     * @param int $internalKey
     * @param string $externalKey
     * @param string $fsspTo
     * @param string $fsspOsp
     * @param string $orgAMD
     * @param string $divAMD
     * @param string $signed
     * @param \AisFssp\StructType\Query[] $query
     * @param \AisFssp\StructType\Answer[] $answer
     * @param \AisFssp\StructType\AccountQuery[] $accountQuery
     * @param \AisFssp\StructType\AccountAnswer[] $accountAnswer
     * @param \AisFssp\StructType\SalaryWithheldQuery[] $salaryWithheldQuery
     * @param \AisFssp\StructType\SalaryWithheldAnswer[] $salaryWithheldAnswer
     * @param \AisFssp\StructType\Restrictn[] $restrictn
     * @param \AisFssp\StructType\Report[] $report
     * @param \AisFssp\StructType\DebtorNewAccountNotice[] $debtorNewAccountNotice
     * @param \AisFssp\StructType\ExtDoc[] $extDoc
     * @param \AisFssp\StructType\ProcDoc[] $procDoc
     * @param \AisFssp\StructType\ExtDebtFix[] $extDebtFix
     * @param \AisFssp\StructType\RecallDoc[] $recallDoc
     * @param \AisFssp\StructType\DebtorPropertyChange[] $debtorPropertyChange
     * @param \AisFssp\StructType\DebtRequest[] $debtRequest
     * @param \AisFssp\StructType\Debt $debt
     * @param \AisFssp\StructType\ExtPayments[] $extPayments
     * @param \AisFssp\StructType\OspRequest[] $ospRequest
     * @param \AisFssp\StructType\OspProperties[] $ospProperties
     * @param \AisFssp\StructType\BankruptDoc[] $bankruptDoc
     * @param \AisFssp\StructType\ArrestFourthStagePropertyType[] $arrestFourthStageProperty
     * @param \AisFssp\StructType\DebtorIpNotify[] $debtorIpNotify
     * @param \AisFssp\StructType\NoticeReadinessSaleSeizedProperty[] $noticeReadinessSaleSeizedProperty
     * @param \AisFssp\StructType\NoticeSaleSeizedProperty[] $noticeSaleSeizedProperty
     * @param \AisFssp\StructType\CertificateDeliveryAcceptance[] $certificateDeliveryAcceptance
     * @param \AisFssp\StructType\ReportExecutionSale[] $reportExecutionSale
     * @param \AisFssp\StructType\IPSideQuery[] $iPSideQuery
     * @param \AisFssp\StructType\IPSideAnswer[] $iPSideAnswer
     * @param \AisFssp\StructType\ExitRestrictionActRequest[] $exitRestrictionActRequest
     * @param \AisFssp\StructType\ExitRestrictionActInfo[] $exitRestrictionActInfo
     * @param \AisFssp\StructType\RestrictionActRequest[] $restrictionActRequest
     * @param \AisFssp\StructType\RestrictionActInfo[] $restrictionActInfo
     * @param \AisFssp\StructType\IPDataRequest[] $ipDataRequest
     * @param \AisFssp\StructType\InvestigationDataInfo[] $investigationDataInfo
     * @param \AisFssp\StructType\IPDataInfo[] $ipDataInfo
     * @param \AisFssp\StructType\RecoveredAmountRequest[] $recoveredAmountRequest
     * @param \AisFssp\StructType\RecoveredAmountAnswer[] $recoveredAmountAnswer
     * @param \AisFssp\StructType\InvestigationRegistryQuery[] $investigationRegistryQuery
     * @param \AisFssp\StructType\ArrestRegistryQuery[] $arrestRegistryQuery
     * @param \AisFssp\StructType\ArrestRegistryInfo[] $arrestRegistryInfo
     * @param \AisFssp\StructType\ArrestRegistryDetail[] $arrestRegistryDetail
     * @param \AisFssp\StructType\CrimeRegistryQuery[] $crimeRegistryQuery
     * @param \AisFssp\StructType\CrimeRegistryInfo[] $crimeRegistryInfo
     * @param \AisFssp\StructType\CrimeRegistryDetail[] $crimeRegistryDetail
     * @param \AisFssp\StructType\CaRequest[] $caRequest
     * @param \AisFssp\StructType\CaAnswer[] $caAnswer
     * @param \AisFssp\StructType\InvestigationRegistry[] $investigationRegistry
     * @param \AisFssp\StructType\PenaltyChargesRegistry[] $penaltyChargesRegistry
     * @param \AisFssp\StructType\RestrictionRegistry[] $restrictionRegistry
     * @param \AisFssp\StructType\ReqAppResult[] $reqAppResult
     * @param \AisFssp\StructType\AnswerAppResult[] $answerAppResult
     * @param \AisFssp\StructType\DocumentNote[] $message
     * @param \AisFssp\StructType\DebtorIPListRequestType[] $debtorIPListRequest
     * @param \AisFssp\StructType\IPSideRequestExistenceType[] $iPSideRequestExistence
     * @param \AisFssp\StructType\IPSideRequestCourseIDType[] $iPSideRequestCourseID
     * @param \AisFssp\StructType\IPSideRequestCourseIPType[] $iPSideRequestCourseIP
     * @param \AisFssp\StructType\IPReqAppResultRequestType[] $iPReqAppResultRequest
     * @param \AisFssp\StructType\DebtorIPListResponseType[] $debtorIPListResponseType
     * @param \AisFssp\StructType\IPReqAppResponseType[] $iPReqAppResponseType
     * @param \AisFssp\StructType\IPReqAppResultReponseType[] $iPReqAppResultReponseType
     * @param \AisFssp\StructType\EApplicationType[] $eApplicationType
     * @param \AisFssp\StructType\EApplicationResultType[] $eApplicationResultType
     * @param \AisFssp\StructType\MailStateTrackingRequest[] $mailStateTrackingRequest
     * @param \AisFssp\StructType\MailState[] $mailState
     * @param \AisFssp\StructType\IncomingForcedExecDocument[] $incomingForcedExecDocument
     * @param \AisFssp\StructType\OutgoingForcedExecDocument[] $outgoingForcedExecDocument
     * @param \AisFssp\StructType\IncomingEMailMessage[] $incomingEMailMessage
     * @param \AisFssp\StructType\OutgoingEMailMessage[] $outgoingEMailMessage
     * @param string $id
     */
    public function __construct($internalKey = null, $externalKey = null, $fsspTo = null, $fsspOsp = null, $orgAMD = null, $divAMD = null, $signed = null, array $query = array(), array $answer = array(), array $accountQuery = array(), array $accountAnswer = array(), array $salaryWithheldQuery = array(), array $salaryWithheldAnswer = array(), array $restrictn = array(), array $report = array(), array $debtorNewAccountNotice = array(), array $extDoc = array(), array $procDoc = array(), array $extDebtFix = array(), array $recallDoc = array(), array $debtorPropertyChange = array(), array $debtRequest = array(), \AisFssp\StructType\Debt $debt = null, array $extPayments = array(), array $ospRequest = array(), array $ospProperties = array(), array $bankruptDoc = array(), array $arrestFourthStageProperty = array(), array $debtorIpNotify = array(), array $noticeReadinessSaleSeizedProperty = array(), array $noticeSaleSeizedProperty = array(), array $certificateDeliveryAcceptance = array(), array $reportExecutionSale = array(), array $iPSideQuery = array(), array $iPSideAnswer = array(), array $exitRestrictionActRequest = array(), array $exitRestrictionActInfo = array(), array $restrictionActRequest = array(), array $restrictionActInfo = array(), array $ipDataRequest = array(), array $investigationDataInfo = array(), array $ipDataInfo = array(), array $recoveredAmountRequest = array(), array $recoveredAmountAnswer = array(), array $investigationRegistryQuery = array(), array $arrestRegistryQuery = array(), array $arrestRegistryInfo = array(), array $arrestRegistryDetail = array(), array $crimeRegistryQuery = array(), array $crimeRegistryInfo = array(), array $crimeRegistryDetail = array(), array $caRequest = array(), array $caAnswer = array(), array $investigationRegistry = array(), array $penaltyChargesRegistry = array(), array $restrictionRegistry = array(), array $reqAppResult = array(), array $answerAppResult = array(), array $message = array(), array $debtorIPListRequest = array(), array $iPSideRequestExistence = array(), array $iPSideRequestCourseID = array(), array $iPSideRequestCourseIP = array(), array $iPReqAppResultRequest = array(), array $debtorIPListResponseType = array(), array $iPReqAppResponseType = array(), array $iPReqAppResultReponseType = array(), array $eApplicationType = array(), array $eApplicationResultType = array(), array $mailStateTrackingRequest = array(), array $mailState = array(), array $incomingForcedExecDocument = array(), array $outgoingForcedExecDocument = array(), array $incomingEMailMessage = array(), array $outgoingEMailMessage = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setExternalKey($externalKey)
            ->setFsspTo($fsspTo)
            ->setFsspOsp($fsspOsp)
            ->setOrgAMD($orgAMD)
            ->setDivAMD($divAMD)
            ->setSigned($signed)
            ->setQuery($query)
            ->setAnswer($answer)
            ->setAccountQuery($accountQuery)
            ->setAccountAnswer($accountAnswer)
            ->setSalaryWithheldQuery($salaryWithheldQuery)
            ->setSalaryWithheldAnswer($salaryWithheldAnswer)
            ->setRestrictn($restrictn)
            ->setReport($report)
            ->setDebtorNewAccountNotice($debtorNewAccountNotice)
            ->setExtDoc($extDoc)
            ->setProcDoc($procDoc)
            ->setExtDebtFix($extDebtFix)
            ->setRecallDoc($recallDoc)
            ->setDebtorPropertyChange($debtorPropertyChange)
            ->setDebtRequest($debtRequest)
            ->setDebt($debt)
            ->setExtPayments($extPayments)
            ->setOspRequest($ospRequest)
            ->setOspProperties($ospProperties)
            ->setBankruptDoc($bankruptDoc)
            ->setArrestFourthStageProperty($arrestFourthStageProperty)
            ->setDebtorIpNotify($debtorIpNotify)
            ->setNoticeReadinessSaleSeizedProperty($noticeReadinessSaleSeizedProperty)
            ->setNoticeSaleSeizedProperty($noticeSaleSeizedProperty)
            ->setCertificateDeliveryAcceptance($certificateDeliveryAcceptance)
            ->setReportExecutionSale($reportExecutionSale)
            ->setIPSideQuery($iPSideQuery)
            ->setIPSideAnswer($iPSideAnswer)
            ->setExitRestrictionActRequest($exitRestrictionActRequest)
            ->setExitRestrictionActInfo($exitRestrictionActInfo)
            ->setRestrictionActRequest($restrictionActRequest)
            ->setRestrictionActInfo($restrictionActInfo)
            ->setIpDataRequest($ipDataRequest)
            ->setInvestigationDataInfo($investigationDataInfo)
            ->setIpDataInfo($ipDataInfo)
            ->setRecoveredAmountRequest($recoveredAmountRequest)
            ->setRecoveredAmountAnswer($recoveredAmountAnswer)
            ->setInvestigationRegistryQuery($investigationRegistryQuery)
            ->setArrestRegistryQuery($arrestRegistryQuery)
            ->setArrestRegistryInfo($arrestRegistryInfo)
            ->setArrestRegistryDetail($arrestRegistryDetail)
            ->setCrimeRegistryQuery($crimeRegistryQuery)
            ->setCrimeRegistryInfo($crimeRegistryInfo)
            ->setCrimeRegistryDetail($crimeRegistryDetail)
            ->setCaRequest($caRequest)
            ->setCaAnswer($caAnswer)
            ->setInvestigationRegistry($investigationRegistry)
            ->setPenaltyChargesRegistry($penaltyChargesRegistry)
            ->setRestrictionRegistry($restrictionRegistry)
            ->setReqAppResult($reqAppResult)
            ->setAnswerAppResult($answerAppResult)
            ->setMessage($message)
            ->setDebtorIPListRequest($debtorIPListRequest)
            ->setIPSideRequestExistence($iPSideRequestExistence)
            ->setIPSideRequestCourseID($iPSideRequestCourseID)
            ->setIPSideRequestCourseIP($iPSideRequestCourseIP)
            ->setIPReqAppResultRequest($iPReqAppResultRequest)
            ->setDebtorIPListResponseType($debtorIPListResponseType)
            ->setIPReqAppResponseType($iPReqAppResponseType)
            ->setIPReqAppResultReponseType($iPReqAppResultReponseType)
            ->setEApplicationType($eApplicationType)
            ->setEApplicationResultType($eApplicationResultType)
            ->setMailStateTrackingRequest($mailStateTrackingRequest)
            ->setMailState($mailState)
            ->setIncomingForcedExecDocument($incomingForcedExecDocument)
            ->setOutgoingForcedExecDocument($outgoingForcedExecDocument)
            ->setIncomingEMailMessage($incomingEMailMessage)
            ->setOutgoingEMailMessage($outgoingEMailMessage)
            ->setId($id);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\DataBlock
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\DataBlock
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get FsspTo value
     * @return string|null
     */
    public function getFsspTo()
    {
        return $this->FsspTo;
    }
    /**
     * Set FsspTo value
     * @param string $fsspTo
     * @return \AisFssp\StructType\DataBlock
     */
    public function setFsspTo($fsspTo = null)
    {
        // validation for constraint: length
        if ((is_scalar($fsspTo) && strlen($fsspTo) !== 5) || (is_array($fsspTo) && count($fsspTo) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($fsspTo) && !preg_match('/[0-9]{5}/', $fsspTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($fsspTo, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fsspTo) && !is_string($fsspTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fsspTo)), __LINE__);
        }
        $this->FsspTo = $fsspTo;
        return $this;
    }
    /**
     * Get FsspOsp value
     * @return string|null
     */
    public function getFsspOsp()
    {
        return $this->FsspOsp;
    }
    /**
     * Set FsspOsp value
     * @param string $fsspOsp
     * @return \AisFssp\StructType\DataBlock
     */
    public function setFsspOsp($fsspOsp = null)
    {
        // validation for constraint: length
        if ((is_scalar($fsspOsp) && strlen($fsspOsp) !== 5) || (is_array($fsspOsp) && count($fsspOsp) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($fsspOsp) && !preg_match('/[0-9]{5}/', $fsspOsp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($fsspOsp, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fsspOsp) && !is_string($fsspOsp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fsspOsp)), __LINE__);
        }
        $this->FsspOsp = $fsspOsp;
        return $this;
    }
    /**
     * Get OrgAMD value
     * @return string|null
     */
    public function getOrgAMD()
    {
        return $this->OrgAMD;
    }
    /**
     * Set OrgAMD value
     * @param string $orgAMD
     * @return \AisFssp\StructType\DataBlock
     */
    public function setOrgAMD($orgAMD = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($orgAMD) && strlen($orgAMD) > 20) || (is_array($orgAMD) && count($orgAMD) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($orgAMD) ? strlen($orgAMD) : count($orgAMD)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($orgAMD) && strlen($orgAMD) < 1) || (is_array($orgAMD) && count($orgAMD) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($orgAMD) && !is_string($orgAMD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgAMD)), __LINE__);
        }
        $this->OrgAMD = $orgAMD;
        return $this;
    }
    /**
     * Get DivAMD value
     * @return string|null
     */
    public function getDivAMD()
    {
        return $this->DivAMD;
    }
    /**
     * Set DivAMD value
     * @param string $divAMD
     * @return \AisFssp\StructType\DataBlock
     */
    public function setDivAMD($divAMD = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($divAMD) && strlen($divAMD) > 320) || (is_array($divAMD) && count($divAMD) > 320)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 320 element(s) or a scalar of 320 character(s) at most, "%d" length given', is_scalar($divAMD) ? strlen($divAMD) : count($divAMD)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($divAMD) && strlen($divAMD) < 1) || (is_array($divAMD) && count($divAMD) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($divAMD) && !is_string($divAMD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($divAMD)), __LINE__);
        }
        $this->DivAMD = $divAMD;
        return $this;
    }
    /**
     * Get Signed value
     * @return string|null
     */
    public function getSigned()
    {
        return $this->Signed;
    }
    /**
     * Set Signed value
     * @param string $signed
     * @return \AisFssp\StructType\DataBlock
     */
    public function setSigned($signed = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($signed) && strlen($signed) > 50) || (is_array($signed) && count($signed) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($signed) ? strlen($signed) : count($signed)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($signed) && strlen($signed) < 1) || (is_array($signed) && count($signed) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signed) && !is_string($signed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signed)), __LINE__);
        }
        $this->Signed = $signed;
        return $this;
    }
    /**
     * Get Query value
     * @return \AisFssp\StructType\Query[]|null
     */
    public function getQuery()
    {
        return $this->Query;
    }
    /**
     * Set Query value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Query[] $query
     * @return \AisFssp\StructType\DataBlock
     */
    public function setQuery(array $query = array())
    {
        foreach ($query as $dataBlockQueryItem) {
            // validation for constraint: itemType
            if (!$dataBlockQueryItem instanceof \AisFssp\StructType\Query) {
                throw new \InvalidArgumentException(sprintf('The Query property can only contain items of \AisFssp\StructType\Query, "%s" given', is_object($dataBlockQueryItem) ? get_class($dataBlockQueryItem) : gettype($dataBlockQueryItem)), __LINE__);
            }
        }
        $this->Query = $query;
        return $this;
    }
    /**
     * Add item to Query value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Query $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToQuery(\AisFssp\StructType\Query $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Query) {
            throw new \InvalidArgumentException(sprintf('The Query property can only contain items of \AisFssp\StructType\Query, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Query[] = $item;
        return $this;
    }
    /**
     * Get Answer value
     * @return \AisFssp\StructType\Answer[]|null
     */
    public function getAnswer()
    {
        return $this->Answer;
    }
    /**
     * Set Answer value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Answer[] $answer
     * @return \AisFssp\StructType\DataBlock
     */
    public function setAnswer(array $answer = array())
    {
        foreach ($answer as $dataBlockAnswerItem) {
            // validation for constraint: itemType
            if (!$dataBlockAnswerItem instanceof \AisFssp\StructType\Answer) {
                throw new \InvalidArgumentException(sprintf('The Answer property can only contain items of \AisFssp\StructType\Answer, "%s" given', is_object($dataBlockAnswerItem) ? get_class($dataBlockAnswerItem) : gettype($dataBlockAnswerItem)), __LINE__);
            }
        }
        $this->Answer = $answer;
        return $this;
    }
    /**
     * Add item to Answer value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Answer $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToAnswer(\AisFssp\StructType\Answer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Answer) {
            throw new \InvalidArgumentException(sprintf('The Answer property can only contain items of \AisFssp\StructType\Answer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Answer[] = $item;
        return $this;
    }
    /**
     * Get AccountQuery value
     * @return \AisFssp\StructType\AccountQuery[]|null
     */
    public function getAccountQuery()
    {
        return $this->AccountQuery;
    }
    /**
     * Set AccountQuery value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AccountQuery[] $accountQuery
     * @return \AisFssp\StructType\DataBlock
     */
    public function setAccountQuery(array $accountQuery = array())
    {
        foreach ($accountQuery as $dataBlockAccountQueryItem) {
            // validation for constraint: itemType
            if (!$dataBlockAccountQueryItem instanceof \AisFssp\StructType\AccountQuery) {
                throw new \InvalidArgumentException(sprintf('The AccountQuery property can only contain items of \AisFssp\StructType\AccountQuery, "%s" given', is_object($dataBlockAccountQueryItem) ? get_class($dataBlockAccountQueryItem) : gettype($dataBlockAccountQueryItem)), __LINE__);
            }
        }
        $this->AccountQuery = $accountQuery;
        return $this;
    }
    /**
     * Add item to AccountQuery value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AccountQuery $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToAccountQuery(\AisFssp\StructType\AccountQuery $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\AccountQuery) {
            throw new \InvalidArgumentException(sprintf('The AccountQuery property can only contain items of \AisFssp\StructType\AccountQuery, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountQuery[] = $item;
        return $this;
    }
    /**
     * Get AccountAnswer value
     * @return \AisFssp\StructType\AccountAnswer[]|null
     */
    public function getAccountAnswer()
    {
        return $this->AccountAnswer;
    }
    /**
     * Set AccountAnswer value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AccountAnswer[] $accountAnswer
     * @return \AisFssp\StructType\DataBlock
     */
    public function setAccountAnswer(array $accountAnswer = array())
    {
        foreach ($accountAnswer as $dataBlockAccountAnswerItem) {
            // validation for constraint: itemType
            if (!$dataBlockAccountAnswerItem instanceof \AisFssp\StructType\AccountAnswer) {
                throw new \InvalidArgumentException(sprintf('The AccountAnswer property can only contain items of \AisFssp\StructType\AccountAnswer, "%s" given', is_object($dataBlockAccountAnswerItem) ? get_class($dataBlockAccountAnswerItem) : gettype($dataBlockAccountAnswerItem)), __LINE__);
            }
        }
        $this->AccountAnswer = $accountAnswer;
        return $this;
    }
    /**
     * Add item to AccountAnswer value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AccountAnswer $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToAccountAnswer(\AisFssp\StructType\AccountAnswer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\AccountAnswer) {
            throw new \InvalidArgumentException(sprintf('The AccountAnswer property can only contain items of \AisFssp\StructType\AccountAnswer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountAnswer[] = $item;
        return $this;
    }
    /**
     * Get SalaryWithheldQuery value
     * @return \AisFssp\StructType\SalaryWithheldQuery[]|null
     */
    public function getSalaryWithheldQuery()
    {
        return $this->SalaryWithheldQuery;
    }
    /**
     * Set SalaryWithheldQuery value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SalaryWithheldQuery[] $salaryWithheldQuery
     * @return \AisFssp\StructType\DataBlock
     */
    public function setSalaryWithheldQuery(array $salaryWithheldQuery = array())
    {
        foreach ($salaryWithheldQuery as $dataBlockSalaryWithheldQueryItem) {
            // validation for constraint: itemType
            if (!$dataBlockSalaryWithheldQueryItem instanceof \AisFssp\StructType\SalaryWithheldQuery) {
                throw new \InvalidArgumentException(sprintf('The SalaryWithheldQuery property can only contain items of \AisFssp\StructType\SalaryWithheldQuery, "%s" given', is_object($dataBlockSalaryWithheldQueryItem) ? get_class($dataBlockSalaryWithheldQueryItem) : gettype($dataBlockSalaryWithheldQueryItem)), __LINE__);
            }
        }
        $this->SalaryWithheldQuery = $salaryWithheldQuery;
        return $this;
    }
    /**
     * Add item to SalaryWithheldQuery value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SalaryWithheldQuery $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToSalaryWithheldQuery(\AisFssp\StructType\SalaryWithheldQuery $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SalaryWithheldQuery) {
            throw new \InvalidArgumentException(sprintf('The SalaryWithheldQuery property can only contain items of \AisFssp\StructType\SalaryWithheldQuery, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SalaryWithheldQuery[] = $item;
        return $this;
    }
    /**
     * Get SalaryWithheldAnswer value
     * @return \AisFssp\StructType\SalaryWithheldAnswer[]|null
     */
    public function getSalaryWithheldAnswer()
    {
        return $this->SalaryWithheldAnswer;
    }
    /**
     * Set SalaryWithheldAnswer value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SalaryWithheldAnswer[] $salaryWithheldAnswer
     * @return \AisFssp\StructType\DataBlock
     */
    public function setSalaryWithheldAnswer(array $salaryWithheldAnswer = array())
    {
        foreach ($salaryWithheldAnswer as $dataBlockSalaryWithheldAnswerItem) {
            // validation for constraint: itemType
            if (!$dataBlockSalaryWithheldAnswerItem instanceof \AisFssp\StructType\SalaryWithheldAnswer) {
                throw new \InvalidArgumentException(sprintf('The SalaryWithheldAnswer property can only contain items of \AisFssp\StructType\SalaryWithheldAnswer, "%s" given', is_object($dataBlockSalaryWithheldAnswerItem) ? get_class($dataBlockSalaryWithheldAnswerItem) : gettype($dataBlockSalaryWithheldAnswerItem)), __LINE__);
            }
        }
        $this->SalaryWithheldAnswer = $salaryWithheldAnswer;
        return $this;
    }
    /**
     * Add item to SalaryWithheldAnswer value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SalaryWithheldAnswer $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToSalaryWithheldAnswer(\AisFssp\StructType\SalaryWithheldAnswer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SalaryWithheldAnswer) {
            throw new \InvalidArgumentException(sprintf('The SalaryWithheldAnswer property can only contain items of \AisFssp\StructType\SalaryWithheldAnswer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SalaryWithheldAnswer[] = $item;
        return $this;
    }
    /**
     * Get Restrictn value
     * @return \AisFssp\StructType\Restrictn[]|null
     */
    public function getRestrictn()
    {
        return $this->Restrictn;
    }
    /**
     * Set Restrictn value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Restrictn[] $restrictn
     * @return \AisFssp\StructType\DataBlock
     */
    public function setRestrictn(array $restrictn = array())
    {
        foreach ($restrictn as $dataBlockRestrictnItem) {
            // validation for constraint: itemType
            if (!$dataBlockRestrictnItem instanceof \AisFssp\StructType\Restrictn) {
                throw new \InvalidArgumentException(sprintf('The Restrictn property can only contain items of \AisFssp\StructType\Restrictn, "%s" given', is_object($dataBlockRestrictnItem) ? get_class($dataBlockRestrictnItem) : gettype($dataBlockRestrictnItem)), __LINE__);
            }
        }
        $this->Restrictn = $restrictn;
        return $this;
    }
    /**
     * Add item to Restrictn value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Restrictn $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToRestrictn(\AisFssp\StructType\Restrictn $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Restrictn) {
            throw new \InvalidArgumentException(sprintf('The Restrictn property can only contain items of \AisFssp\StructType\Restrictn, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Restrictn[] = $item;
        return $this;
    }
    /**
     * Get Report value
     * @return \AisFssp\StructType\Report[]|null
     */
    public function getReport()
    {
        return $this->Report;
    }
    /**
     * Set Report value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Report[] $report
     * @return \AisFssp\StructType\DataBlock
     */
    public function setReport(array $report = array())
    {
        foreach ($report as $dataBlockReportItem) {
            // validation for constraint: itemType
            if (!$dataBlockReportItem instanceof \AisFssp\StructType\Report) {
                throw new \InvalidArgumentException(sprintf('The Report property can only contain items of \AisFssp\StructType\Report, "%s" given', is_object($dataBlockReportItem) ? get_class($dataBlockReportItem) : gettype($dataBlockReportItem)), __LINE__);
            }
        }
        $this->Report = $report;
        return $this;
    }
    /**
     * Add item to Report value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Report $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToReport(\AisFssp\StructType\Report $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Report) {
            throw new \InvalidArgumentException(sprintf('The Report property can only contain items of \AisFssp\StructType\Report, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Report[] = $item;
        return $this;
    }
    /**
     * Get DebtorNewAccountNotice value
     * @return \AisFssp\StructType\DebtorNewAccountNotice[]|null
     */
    public function getDebtorNewAccountNotice()
    {
        return $this->DebtorNewAccountNotice;
    }
    /**
     * Set DebtorNewAccountNotice value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\DebtorNewAccountNotice[] $debtorNewAccountNotice
     * @return \AisFssp\StructType\DataBlock
     */
    public function setDebtorNewAccountNotice(array $debtorNewAccountNotice = array())
    {
        foreach ($debtorNewAccountNotice as $dataBlockDebtorNewAccountNoticeItem) {
            // validation for constraint: itemType
            if (!$dataBlockDebtorNewAccountNoticeItem instanceof \AisFssp\StructType\DebtorNewAccountNotice) {
                throw new \InvalidArgumentException(sprintf('The DebtorNewAccountNotice property can only contain items of \AisFssp\StructType\DebtorNewAccountNotice, "%s" given', is_object($dataBlockDebtorNewAccountNoticeItem) ? get_class($dataBlockDebtorNewAccountNoticeItem) : gettype($dataBlockDebtorNewAccountNoticeItem)), __LINE__);
            }
        }
        $this->DebtorNewAccountNotice = $debtorNewAccountNotice;
        return $this;
    }
    /**
     * Add item to DebtorNewAccountNotice value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\DebtorNewAccountNotice $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToDebtorNewAccountNotice(\AisFssp\StructType\DebtorNewAccountNotice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\DebtorNewAccountNotice) {
            throw new \InvalidArgumentException(sprintf('The DebtorNewAccountNotice property can only contain items of \AisFssp\StructType\DebtorNewAccountNotice, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DebtorNewAccountNotice[] = $item;
        return $this;
    }
    /**
     * Get ExtDoc value
     * @return \AisFssp\StructType\ExtDoc[]|null
     */
    public function getExtDoc()
    {
        return $this->ExtDoc;
    }
    /**
     * Set ExtDoc value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ExtDoc[] $extDoc
     * @return \AisFssp\StructType\DataBlock
     */
    public function setExtDoc(array $extDoc = array())
    {
        foreach ($extDoc as $dataBlockExtDocItem) {
            // validation for constraint: itemType
            if (!$dataBlockExtDocItem instanceof \AisFssp\StructType\ExtDoc) {
                throw new \InvalidArgumentException(sprintf('The ExtDoc property can only contain items of \AisFssp\StructType\ExtDoc, "%s" given', is_object($dataBlockExtDocItem) ? get_class($dataBlockExtDocItem) : gettype($dataBlockExtDocItem)), __LINE__);
            }
        }
        $this->ExtDoc = $extDoc;
        return $this;
    }
    /**
     * Add item to ExtDoc value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ExtDoc $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToExtDoc(\AisFssp\StructType\ExtDoc $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\ExtDoc) {
            throw new \InvalidArgumentException(sprintf('The ExtDoc property can only contain items of \AisFssp\StructType\ExtDoc, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ExtDoc[] = $item;
        return $this;
    }
    /**
     * Get ProcDoc value
     * @return \AisFssp\StructType\ProcDoc[]|null
     */
    public function getProcDoc()
    {
        return $this->ProcDoc;
    }
    /**
     * Set ProcDoc value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ProcDoc[] $procDoc
     * @return \AisFssp\StructType\DataBlock
     */
    public function setProcDoc(array $procDoc = array())
    {
        foreach ($procDoc as $dataBlockProcDocItem) {
            // validation for constraint: itemType
            if (!$dataBlockProcDocItem instanceof \AisFssp\StructType\ProcDoc) {
                throw new \InvalidArgumentException(sprintf('The ProcDoc property can only contain items of \AisFssp\StructType\ProcDoc, "%s" given', is_object($dataBlockProcDocItem) ? get_class($dataBlockProcDocItem) : gettype($dataBlockProcDocItem)), __LINE__);
            }
        }
        $this->ProcDoc = $procDoc;
        return $this;
    }
    /**
     * Add item to ProcDoc value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ProcDoc $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToProcDoc(\AisFssp\StructType\ProcDoc $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\ProcDoc) {
            throw new \InvalidArgumentException(sprintf('The ProcDoc property can only contain items of \AisFssp\StructType\ProcDoc, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProcDoc[] = $item;
        return $this;
    }
    /**
     * Get ExtDebtFix value
     * @return \AisFssp\StructType\ExtDebtFix[]|null
     */
    public function getExtDebtFix()
    {
        return $this->ExtDebtFix;
    }
    /**
     * Set ExtDebtFix value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ExtDebtFix[] $extDebtFix
     * @return \AisFssp\StructType\DataBlock
     */
    public function setExtDebtFix(array $extDebtFix = array())
    {
        foreach ($extDebtFix as $dataBlockExtDebtFixItem) {
            // validation for constraint: itemType
            if (!$dataBlockExtDebtFixItem instanceof \AisFssp\StructType\ExtDebtFix) {
                throw new \InvalidArgumentException(sprintf('The ExtDebtFix property can only contain items of \AisFssp\StructType\ExtDebtFix, "%s" given', is_object($dataBlockExtDebtFixItem) ? get_class($dataBlockExtDebtFixItem) : gettype($dataBlockExtDebtFixItem)), __LINE__);
            }
        }
        $this->ExtDebtFix = $extDebtFix;
        return $this;
    }
    /**
     * Add item to ExtDebtFix value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ExtDebtFix $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToExtDebtFix(\AisFssp\StructType\ExtDebtFix $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\ExtDebtFix) {
            throw new \InvalidArgumentException(sprintf('The ExtDebtFix property can only contain items of \AisFssp\StructType\ExtDebtFix, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ExtDebtFix[] = $item;
        return $this;
    }
    /**
     * Get RecallDoc value
     * @return \AisFssp\StructType\RecallDoc[]|null
     */
    public function getRecallDoc()
    {
        return $this->RecallDoc;
    }
    /**
     * Set RecallDoc value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\RecallDoc[] $recallDoc
     * @return \AisFssp\StructType\DataBlock
     */
    public function setRecallDoc(array $recallDoc = array())
    {
        foreach ($recallDoc as $dataBlockRecallDocItem) {
            // validation for constraint: itemType
            if (!$dataBlockRecallDocItem instanceof \AisFssp\StructType\RecallDoc) {
                throw new \InvalidArgumentException(sprintf('The RecallDoc property can only contain items of \AisFssp\StructType\RecallDoc, "%s" given', is_object($dataBlockRecallDocItem) ? get_class($dataBlockRecallDocItem) : gettype($dataBlockRecallDocItem)), __LINE__);
            }
        }
        $this->RecallDoc = $recallDoc;
        return $this;
    }
    /**
     * Add item to RecallDoc value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\RecallDoc $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToRecallDoc(\AisFssp\StructType\RecallDoc $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\RecallDoc) {
            throw new \InvalidArgumentException(sprintf('The RecallDoc property can only contain items of \AisFssp\StructType\RecallDoc, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RecallDoc[] = $item;
        return $this;
    }
    /**
     * Get DebtorPropertyChange value
     * @return \AisFssp\StructType\DebtorPropertyChange[]|null
     */
    public function getDebtorPropertyChange()
    {
        return $this->DebtorPropertyChange;
    }
    /**
     * Set DebtorPropertyChange value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\DebtorPropertyChange[] $debtorPropertyChange
     * @return \AisFssp\StructType\DataBlock
     */
    public function setDebtorPropertyChange(array $debtorPropertyChange = array())
    {
        foreach ($debtorPropertyChange as $dataBlockDebtorPropertyChangeItem) {
            // validation for constraint: itemType
            if (!$dataBlockDebtorPropertyChangeItem instanceof \AisFssp\StructType\DebtorPropertyChange) {
                throw new \InvalidArgumentException(sprintf('The DebtorPropertyChange property can only contain items of \AisFssp\StructType\DebtorPropertyChange, "%s" given', is_object($dataBlockDebtorPropertyChangeItem) ? get_class($dataBlockDebtorPropertyChangeItem) : gettype($dataBlockDebtorPropertyChangeItem)), __LINE__);
            }
        }
        $this->DebtorPropertyChange = $debtorPropertyChange;
        return $this;
    }
    /**
     * Add item to DebtorPropertyChange value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\DebtorPropertyChange $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToDebtorPropertyChange(\AisFssp\StructType\DebtorPropertyChange $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\DebtorPropertyChange) {
            throw new \InvalidArgumentException(sprintf('The DebtorPropertyChange property can only contain items of \AisFssp\StructType\DebtorPropertyChange, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DebtorPropertyChange[] = $item;
        return $this;
    }
    /**
     * Get DebtRequest value
     * @return \AisFssp\StructType\DebtRequest[]|null
     */
    public function getDebtRequest()
    {
        return $this->DebtRequest;
    }
    /**
     * Set DebtRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\DebtRequest[] $debtRequest
     * @return \AisFssp\StructType\DataBlock
     */
    public function setDebtRequest(array $debtRequest = array())
    {
        foreach ($debtRequest as $dataBlockDebtRequestItem) {
            // validation for constraint: itemType
            if (!$dataBlockDebtRequestItem instanceof \AisFssp\StructType\DebtRequest) {
                throw new \InvalidArgumentException(sprintf('The DebtRequest property can only contain items of \AisFssp\StructType\DebtRequest, "%s" given', is_object($dataBlockDebtRequestItem) ? get_class($dataBlockDebtRequestItem) : gettype($dataBlockDebtRequestItem)), __LINE__);
            }
        }
        $this->DebtRequest = $debtRequest;
        return $this;
    }
    /**
     * Add item to DebtRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\DebtRequest $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToDebtRequest(\AisFssp\StructType\DebtRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\DebtRequest) {
            throw new \InvalidArgumentException(sprintf('The DebtRequest property can only contain items of \AisFssp\StructType\DebtRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DebtRequest[] = $item;
        return $this;
    }
    /**
     * Get Debt value
     * @return \AisFssp\StructType\Debt|null
     */
    public function getDebt()
    {
        return $this->Debt;
    }
    /**
     * Set Debt value
     * @param \AisFssp\StructType\Debt $debt
     * @return \AisFssp\StructType\DataBlock
     */
    public function setDebt(\AisFssp\StructType\Debt $debt = null)
    {
        $this->Debt = $debt;
        return $this;
    }
    /**
     * Get ExtPayments value
     * @return \AisFssp\StructType\ExtPayments[]|null
     */
    public function getExtPayments()
    {
        return $this->ExtPayments;
    }
    /**
     * Set ExtPayments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ExtPayments[] $extPayments
     * @return \AisFssp\StructType\DataBlock
     */
    public function setExtPayments(array $extPayments = array())
    {
        foreach ($extPayments as $dataBlockExtPaymentsItem) {
            // validation for constraint: itemType
            if (!$dataBlockExtPaymentsItem instanceof \AisFssp\StructType\ExtPayments) {
                throw new \InvalidArgumentException(sprintf('The ExtPayments property can only contain items of \AisFssp\StructType\ExtPayments, "%s" given', is_object($dataBlockExtPaymentsItem) ? get_class($dataBlockExtPaymentsItem) : gettype($dataBlockExtPaymentsItem)), __LINE__);
            }
        }
        $this->ExtPayments = $extPayments;
        return $this;
    }
    /**
     * Add item to ExtPayments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ExtPayments $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToExtPayments(\AisFssp\StructType\ExtPayments $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\ExtPayments) {
            throw new \InvalidArgumentException(sprintf('The ExtPayments property can only contain items of \AisFssp\StructType\ExtPayments, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ExtPayments[] = $item;
        return $this;
    }
    /**
     * Get OspRequest value
     * @return \AisFssp\StructType\OspRequest[]|null
     */
    public function getOspRequest()
    {
        return $this->OspRequest;
    }
    /**
     * Set OspRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\OspRequest[] $ospRequest
     * @return \AisFssp\StructType\DataBlock
     */
    public function setOspRequest(array $ospRequest = array())
    {
        foreach ($ospRequest as $dataBlockOspRequestItem) {
            // validation for constraint: itemType
            if (!$dataBlockOspRequestItem instanceof \AisFssp\StructType\OspRequest) {
                throw new \InvalidArgumentException(sprintf('The OspRequest property can only contain items of \AisFssp\StructType\OspRequest, "%s" given', is_object($dataBlockOspRequestItem) ? get_class($dataBlockOspRequestItem) : gettype($dataBlockOspRequestItem)), __LINE__);
            }
        }
        $this->OspRequest = $ospRequest;
        return $this;
    }
    /**
     * Add item to OspRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\OspRequest $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToOspRequest(\AisFssp\StructType\OspRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\OspRequest) {
            throw new \InvalidArgumentException(sprintf('The OspRequest property can only contain items of \AisFssp\StructType\OspRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OspRequest[] = $item;
        return $this;
    }
    /**
     * Get OspProperties value
     * @return \AisFssp\StructType\OspProperties[]|null
     */
    public function getOspProperties()
    {
        return $this->OspProperties;
    }
    /**
     * Set OspProperties value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\OspProperties[] $ospProperties
     * @return \AisFssp\StructType\DataBlock
     */
    public function setOspProperties(array $ospProperties = array())
    {
        foreach ($ospProperties as $dataBlockOspPropertiesItem) {
            // validation for constraint: itemType
            if (!$dataBlockOspPropertiesItem instanceof \AisFssp\StructType\OspProperties) {
                throw new \InvalidArgumentException(sprintf('The OspProperties property can only contain items of \AisFssp\StructType\OspProperties, "%s" given', is_object($dataBlockOspPropertiesItem) ? get_class($dataBlockOspPropertiesItem) : gettype($dataBlockOspPropertiesItem)), __LINE__);
            }
        }
        $this->OspProperties = $ospProperties;
        return $this;
    }
    /**
     * Add item to OspProperties value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\OspProperties $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToOspProperties(\AisFssp\StructType\OspProperties $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\OspProperties) {
            throw new \InvalidArgumentException(sprintf('The OspProperties property can only contain items of \AisFssp\StructType\OspProperties, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OspProperties[] = $item;
        return $this;
    }
    /**
     * Get BankruptDoc value
     * @return \AisFssp\StructType\BankruptDoc[]|null
     */
    public function getBankruptDoc()
    {
        return $this->BankruptDoc;
    }
    /**
     * Set BankruptDoc value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\BankruptDoc[] $bankruptDoc
     * @return \AisFssp\StructType\DataBlock
     */
    public function setBankruptDoc(array $bankruptDoc = array())
    {
        foreach ($bankruptDoc as $dataBlockBankruptDocItem) {
            // validation for constraint: itemType
            if (!$dataBlockBankruptDocItem instanceof \AisFssp\StructType\BankruptDoc) {
                throw new \InvalidArgumentException(sprintf('The BankruptDoc property can only contain items of \AisFssp\StructType\BankruptDoc, "%s" given', is_object($dataBlockBankruptDocItem) ? get_class($dataBlockBankruptDocItem) : gettype($dataBlockBankruptDocItem)), __LINE__);
            }
        }
        $this->BankruptDoc = $bankruptDoc;
        return $this;
    }
    /**
     * Add item to BankruptDoc value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\BankruptDoc $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToBankruptDoc(\AisFssp\StructType\BankruptDoc $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\BankruptDoc) {
            throw new \InvalidArgumentException(sprintf('The BankruptDoc property can only contain items of \AisFssp\StructType\BankruptDoc, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BankruptDoc[] = $item;
        return $this;
    }
    /**
     * Get ArrestFourthStageProperty value
     * @return \AisFssp\StructType\ArrestFourthStagePropertyType[]|null
     */
    public function getArrestFourthStageProperty()
    {
        return $this->ArrestFourthStageProperty;
    }
    /**
     * Set ArrestFourthStageProperty value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ArrestFourthStagePropertyType[] $arrestFourthStageProperty
     * @return \AisFssp\StructType\DataBlock
     */
    public function setArrestFourthStageProperty(array $arrestFourthStageProperty = array())
    {
        foreach ($arrestFourthStageProperty as $dataBlockArrestFourthStagePropertyItem) {
            // validation for constraint: itemType
            if (!$dataBlockArrestFourthStagePropertyItem instanceof \AisFssp\StructType\ArrestFourthStagePropertyType) {
                throw new \InvalidArgumentException(sprintf('The ArrestFourthStageProperty property can only contain items of \AisFssp\StructType\ArrestFourthStagePropertyType, "%s" given', is_object($dataBlockArrestFourthStagePropertyItem) ? get_class($dataBlockArrestFourthStagePropertyItem) : gettype($dataBlockArrestFourthStagePropertyItem)), __LINE__);
            }
        }
        $this->ArrestFourthStageProperty = $arrestFourthStageProperty;
        return $this;
    }
    /**
     * Add item to ArrestFourthStageProperty value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ArrestFourthStagePropertyType $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToArrestFourthStageProperty(\AisFssp\StructType\ArrestFourthStagePropertyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\ArrestFourthStagePropertyType) {
            throw new \InvalidArgumentException(sprintf('The ArrestFourthStageProperty property can only contain items of \AisFssp\StructType\ArrestFourthStagePropertyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ArrestFourthStageProperty[] = $item;
        return $this;
    }
    /**
     * Get DebtorIpNotify value
     * @return \AisFssp\StructType\DebtorIpNotify[]|null
     */
    public function getDebtorIpNotify()
    {
        return $this->DebtorIpNotify;
    }
    /**
     * Set DebtorIpNotify value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\DebtorIpNotify[] $debtorIpNotify
     * @return \AisFssp\StructType\DataBlock
     */
    public function setDebtorIpNotify(array $debtorIpNotify = array())
    {
        foreach ($debtorIpNotify as $dataBlockDebtorIpNotifyItem) {
            // validation for constraint: itemType
            if (!$dataBlockDebtorIpNotifyItem instanceof \AisFssp\StructType\DebtorIpNotify) {
                throw new \InvalidArgumentException(sprintf('The DebtorIpNotify property can only contain items of \AisFssp\StructType\DebtorIpNotify, "%s" given', is_object($dataBlockDebtorIpNotifyItem) ? get_class($dataBlockDebtorIpNotifyItem) : gettype($dataBlockDebtorIpNotifyItem)), __LINE__);
            }
        }
        $this->DebtorIpNotify = $debtorIpNotify;
        return $this;
    }
    /**
     * Add item to DebtorIpNotify value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\DebtorIpNotify $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToDebtorIpNotify(\AisFssp\StructType\DebtorIpNotify $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\DebtorIpNotify) {
            throw new \InvalidArgumentException(sprintf('The DebtorIpNotify property can only contain items of \AisFssp\StructType\DebtorIpNotify, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DebtorIpNotify[] = $item;
        return $this;
    }
    /**
     * Get NoticeReadinessSaleSeizedProperty value
     * @return \AisFssp\StructType\NoticeReadinessSaleSeizedProperty[]|null
     */
    public function getNoticeReadinessSaleSeizedProperty()
    {
        return $this->NoticeReadinessSaleSeizedProperty;
    }
    /**
     * Set NoticeReadinessSaleSeizedProperty value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\NoticeReadinessSaleSeizedProperty[] $noticeReadinessSaleSeizedProperty
     * @return \AisFssp\StructType\DataBlock
     */
    public function setNoticeReadinessSaleSeizedProperty(array $noticeReadinessSaleSeizedProperty = array())
    {
        foreach ($noticeReadinessSaleSeizedProperty as $dataBlockNoticeReadinessSaleSeizedPropertyItem) {
            // validation for constraint: itemType
            if (!$dataBlockNoticeReadinessSaleSeizedPropertyItem instanceof \AisFssp\StructType\NoticeReadinessSaleSeizedProperty) {
                throw new \InvalidArgumentException(sprintf('The NoticeReadinessSaleSeizedProperty property can only contain items of \AisFssp\StructType\NoticeReadinessSaleSeizedProperty, "%s" given', is_object($dataBlockNoticeReadinessSaleSeizedPropertyItem) ? get_class($dataBlockNoticeReadinessSaleSeizedPropertyItem) : gettype($dataBlockNoticeReadinessSaleSeizedPropertyItem)), __LINE__);
            }
        }
        $this->NoticeReadinessSaleSeizedProperty = $noticeReadinessSaleSeizedProperty;
        return $this;
    }
    /**
     * Add item to NoticeReadinessSaleSeizedProperty value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\NoticeReadinessSaleSeizedProperty $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToNoticeReadinessSaleSeizedProperty(\AisFssp\StructType\NoticeReadinessSaleSeizedProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\NoticeReadinessSaleSeizedProperty) {
            throw new \InvalidArgumentException(sprintf('The NoticeReadinessSaleSeizedProperty property can only contain items of \AisFssp\StructType\NoticeReadinessSaleSeizedProperty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NoticeReadinessSaleSeizedProperty[] = $item;
        return $this;
    }
    /**
     * Get NoticeSaleSeizedProperty value
     * @return \AisFssp\StructType\NoticeSaleSeizedProperty[]|null
     */
    public function getNoticeSaleSeizedProperty()
    {
        return $this->NoticeSaleSeizedProperty;
    }
    /**
     * Set NoticeSaleSeizedProperty value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\NoticeSaleSeizedProperty[] $noticeSaleSeizedProperty
     * @return \AisFssp\StructType\DataBlock
     */
    public function setNoticeSaleSeizedProperty(array $noticeSaleSeizedProperty = array())
    {
        foreach ($noticeSaleSeizedProperty as $dataBlockNoticeSaleSeizedPropertyItem) {
            // validation for constraint: itemType
            if (!$dataBlockNoticeSaleSeizedPropertyItem instanceof \AisFssp\StructType\NoticeSaleSeizedProperty) {
                throw new \InvalidArgumentException(sprintf('The NoticeSaleSeizedProperty property can only contain items of \AisFssp\StructType\NoticeSaleSeizedProperty, "%s" given', is_object($dataBlockNoticeSaleSeizedPropertyItem) ? get_class($dataBlockNoticeSaleSeizedPropertyItem) : gettype($dataBlockNoticeSaleSeizedPropertyItem)), __LINE__);
            }
        }
        $this->NoticeSaleSeizedProperty = $noticeSaleSeizedProperty;
        return $this;
    }
    /**
     * Add item to NoticeSaleSeizedProperty value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\NoticeSaleSeizedProperty $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToNoticeSaleSeizedProperty(\AisFssp\StructType\NoticeSaleSeizedProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\NoticeSaleSeizedProperty) {
            throw new \InvalidArgumentException(sprintf('The NoticeSaleSeizedProperty property can only contain items of \AisFssp\StructType\NoticeSaleSeizedProperty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NoticeSaleSeizedProperty[] = $item;
        return $this;
    }
    /**
     * Get CertificateDeliveryAcceptance value
     * @return \AisFssp\StructType\CertificateDeliveryAcceptance[]|null
     */
    public function getCertificateDeliveryAcceptance()
    {
        return $this->CertificateDeliveryAcceptance;
    }
    /**
     * Set CertificateDeliveryAcceptance value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\CertificateDeliveryAcceptance[] $certificateDeliveryAcceptance
     * @return \AisFssp\StructType\DataBlock
     */
    public function setCertificateDeliveryAcceptance(array $certificateDeliveryAcceptance = array())
    {
        foreach ($certificateDeliveryAcceptance as $dataBlockCertificateDeliveryAcceptanceItem) {
            // validation for constraint: itemType
            if (!$dataBlockCertificateDeliveryAcceptanceItem instanceof \AisFssp\StructType\CertificateDeliveryAcceptance) {
                throw new \InvalidArgumentException(sprintf('The CertificateDeliveryAcceptance property can only contain items of \AisFssp\StructType\CertificateDeliveryAcceptance, "%s" given', is_object($dataBlockCertificateDeliveryAcceptanceItem) ? get_class($dataBlockCertificateDeliveryAcceptanceItem) : gettype($dataBlockCertificateDeliveryAcceptanceItem)), __LINE__);
            }
        }
        $this->CertificateDeliveryAcceptance = $certificateDeliveryAcceptance;
        return $this;
    }
    /**
     * Add item to CertificateDeliveryAcceptance value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\CertificateDeliveryAcceptance $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToCertificateDeliveryAcceptance(\AisFssp\StructType\CertificateDeliveryAcceptance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\CertificateDeliveryAcceptance) {
            throw new \InvalidArgumentException(sprintf('The CertificateDeliveryAcceptance property can only contain items of \AisFssp\StructType\CertificateDeliveryAcceptance, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CertificateDeliveryAcceptance[] = $item;
        return $this;
    }
    /**
     * Get ReportExecutionSale value
     * @return \AisFssp\StructType\ReportExecutionSale[]|null
     */
    public function getReportExecutionSale()
    {
        return $this->ReportExecutionSale;
    }
    /**
     * Set ReportExecutionSale value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ReportExecutionSale[] $reportExecutionSale
     * @return \AisFssp\StructType\DataBlock
     */
    public function setReportExecutionSale(array $reportExecutionSale = array())
    {
        foreach ($reportExecutionSale as $dataBlockReportExecutionSaleItem) {
            // validation for constraint: itemType
            if (!$dataBlockReportExecutionSaleItem instanceof \AisFssp\StructType\ReportExecutionSale) {
                throw new \InvalidArgumentException(sprintf('The ReportExecutionSale property can only contain items of \AisFssp\StructType\ReportExecutionSale, "%s" given', is_object($dataBlockReportExecutionSaleItem) ? get_class($dataBlockReportExecutionSaleItem) : gettype($dataBlockReportExecutionSaleItem)), __LINE__);
            }
        }
        $this->ReportExecutionSale = $reportExecutionSale;
        return $this;
    }
    /**
     * Add item to ReportExecutionSale value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ReportExecutionSale $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToReportExecutionSale(\AisFssp\StructType\ReportExecutionSale $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\ReportExecutionSale) {
            throw new \InvalidArgumentException(sprintf('The ReportExecutionSale property can only contain items of \AisFssp\StructType\ReportExecutionSale, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ReportExecutionSale[] = $item;
        return $this;
    }
    /**
     * Get IPSideQuery value
     * @return \AisFssp\StructType\IPSideQuery[]|null
     */
    public function getIPSideQuery()
    {
        return $this->IPSideQuery;
    }
    /**
     * Set IPSideQuery value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPSideQuery[] $iPSideQuery
     * @return \AisFssp\StructType\DataBlock
     */
    public function setIPSideQuery(array $iPSideQuery = array())
    {
        foreach ($iPSideQuery as $dataBlockIPSideQueryItem) {
            // validation for constraint: itemType
            if (!$dataBlockIPSideQueryItem instanceof \AisFssp\StructType\IPSideQuery) {
                throw new \InvalidArgumentException(sprintf('The IPSideQuery property can only contain items of \AisFssp\StructType\IPSideQuery, "%s" given', is_object($dataBlockIPSideQueryItem) ? get_class($dataBlockIPSideQueryItem) : gettype($dataBlockIPSideQueryItem)), __LINE__);
            }
        }
        $this->IPSideQuery = $iPSideQuery;
        return $this;
    }
    /**
     * Add item to IPSideQuery value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPSideQuery $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToIPSideQuery(\AisFssp\StructType\IPSideQuery $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\IPSideQuery) {
            throw new \InvalidArgumentException(sprintf('The IPSideQuery property can only contain items of \AisFssp\StructType\IPSideQuery, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IPSideQuery[] = $item;
        return $this;
    }
    /**
     * Get IPSideAnswer value
     * @return \AisFssp\StructType\IPSideAnswer[]|null
     */
    public function getIPSideAnswer()
    {
        return $this->IPSideAnswer;
    }
    /**
     * Set IPSideAnswer value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPSideAnswer[] $iPSideAnswer
     * @return \AisFssp\StructType\DataBlock
     */
    public function setIPSideAnswer(array $iPSideAnswer = array())
    {
        foreach ($iPSideAnswer as $dataBlockIPSideAnswerItem) {
            // validation for constraint: itemType
            if (!$dataBlockIPSideAnswerItem instanceof \AisFssp\StructType\IPSideAnswer) {
                throw new \InvalidArgumentException(sprintf('The IPSideAnswer property can only contain items of \AisFssp\StructType\IPSideAnswer, "%s" given', is_object($dataBlockIPSideAnswerItem) ? get_class($dataBlockIPSideAnswerItem) : gettype($dataBlockIPSideAnswerItem)), __LINE__);
            }
        }
        $this->IPSideAnswer = $iPSideAnswer;
        return $this;
    }
    /**
     * Add item to IPSideAnswer value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPSideAnswer $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToIPSideAnswer(\AisFssp\StructType\IPSideAnswer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\IPSideAnswer) {
            throw new \InvalidArgumentException(sprintf('The IPSideAnswer property can only contain items of \AisFssp\StructType\IPSideAnswer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IPSideAnswer[] = $item;
        return $this;
    }
    /**
     * Get exitRestrictionActRequest value
     * @return \AisFssp\StructType\ExitRestrictionActRequest[]|null
     */
    public function getExitRestrictionActRequest()
    {
        return $this->exitRestrictionActRequest;
    }
    /**
     * Set exitRestrictionActRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ExitRestrictionActRequest[] $exitRestrictionActRequest
     * @return \AisFssp\StructType\DataBlock
     */
    public function setExitRestrictionActRequest(array $exitRestrictionActRequest = array())
    {
        foreach ($exitRestrictionActRequest as $dataBlockExitRestrictionActRequestItem) {
            // validation for constraint: itemType
            if (!$dataBlockExitRestrictionActRequestItem instanceof \AisFssp\StructType\ExitRestrictionActRequest) {
                throw new \InvalidArgumentException(sprintf('The exitRestrictionActRequest property can only contain items of \AisFssp\StructType\ExitRestrictionActRequest, "%s" given', is_object($dataBlockExitRestrictionActRequestItem) ? get_class($dataBlockExitRestrictionActRequestItem) : gettype($dataBlockExitRestrictionActRequestItem)), __LINE__);
            }
        }
        $this->exitRestrictionActRequest = $exitRestrictionActRequest;
        return $this;
    }
    /**
     * Add item to exitRestrictionActRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ExitRestrictionActRequest $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToExitRestrictionActRequest(\AisFssp\StructType\ExitRestrictionActRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\ExitRestrictionActRequest) {
            throw new \InvalidArgumentException(sprintf('The exitRestrictionActRequest property can only contain items of \AisFssp\StructType\ExitRestrictionActRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->exitRestrictionActRequest[] = $item;
        return $this;
    }
    /**
     * Get exitRestrictionActInfo value
     * @return \AisFssp\StructType\ExitRestrictionActInfo[]|null
     */
    public function getExitRestrictionActInfo()
    {
        return $this->exitRestrictionActInfo;
    }
    /**
     * Set exitRestrictionActInfo value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ExitRestrictionActInfo[] $exitRestrictionActInfo
     * @return \AisFssp\StructType\DataBlock
     */
    public function setExitRestrictionActInfo(array $exitRestrictionActInfo = array())
    {
        foreach ($exitRestrictionActInfo as $dataBlockExitRestrictionActInfoItem) {
            // validation for constraint: itemType
            if (!$dataBlockExitRestrictionActInfoItem instanceof \AisFssp\StructType\ExitRestrictionActInfo) {
                throw new \InvalidArgumentException(sprintf('The exitRestrictionActInfo property can only contain items of \AisFssp\StructType\ExitRestrictionActInfo, "%s" given', is_object($dataBlockExitRestrictionActInfoItem) ? get_class($dataBlockExitRestrictionActInfoItem) : gettype($dataBlockExitRestrictionActInfoItem)), __LINE__);
            }
        }
        $this->exitRestrictionActInfo = $exitRestrictionActInfo;
        return $this;
    }
    /**
     * Add item to exitRestrictionActInfo value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ExitRestrictionActInfo $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToExitRestrictionActInfo(\AisFssp\StructType\ExitRestrictionActInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\ExitRestrictionActInfo) {
            throw new \InvalidArgumentException(sprintf('The exitRestrictionActInfo property can only contain items of \AisFssp\StructType\ExitRestrictionActInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->exitRestrictionActInfo[] = $item;
        return $this;
    }
    /**
     * Get RestrictionActRequest value
     * @return \AisFssp\StructType\RestrictionActRequest[]|null
     */
    public function getRestrictionActRequest()
    {
        return $this->RestrictionActRequest;
    }
    /**
     * Set RestrictionActRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\RestrictionActRequest[] $restrictionActRequest
     * @return \AisFssp\StructType\DataBlock
     */
    public function setRestrictionActRequest(array $restrictionActRequest = array())
    {
        foreach ($restrictionActRequest as $dataBlockRestrictionActRequestItem) {
            // validation for constraint: itemType
            if (!$dataBlockRestrictionActRequestItem instanceof \AisFssp\StructType\RestrictionActRequest) {
                throw new \InvalidArgumentException(sprintf('The RestrictionActRequest property can only contain items of \AisFssp\StructType\RestrictionActRequest, "%s" given', is_object($dataBlockRestrictionActRequestItem) ? get_class($dataBlockRestrictionActRequestItem) : gettype($dataBlockRestrictionActRequestItem)), __LINE__);
            }
        }
        $this->RestrictionActRequest = $restrictionActRequest;
        return $this;
    }
    /**
     * Add item to RestrictionActRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\RestrictionActRequest $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToRestrictionActRequest(\AisFssp\StructType\RestrictionActRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\RestrictionActRequest) {
            throw new \InvalidArgumentException(sprintf('The RestrictionActRequest property can only contain items of \AisFssp\StructType\RestrictionActRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RestrictionActRequest[] = $item;
        return $this;
    }
    /**
     * Get RestrictionActInfo value
     * @return \AisFssp\StructType\RestrictionActInfo[]|null
     */
    public function getRestrictionActInfo()
    {
        return $this->RestrictionActInfo;
    }
    /**
     * Set RestrictionActInfo value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\RestrictionActInfo[] $restrictionActInfo
     * @return \AisFssp\StructType\DataBlock
     */
    public function setRestrictionActInfo(array $restrictionActInfo = array())
    {
        foreach ($restrictionActInfo as $dataBlockRestrictionActInfoItem) {
            // validation for constraint: itemType
            if (!$dataBlockRestrictionActInfoItem instanceof \AisFssp\StructType\RestrictionActInfo) {
                throw new \InvalidArgumentException(sprintf('The RestrictionActInfo property can only contain items of \AisFssp\StructType\RestrictionActInfo, "%s" given', is_object($dataBlockRestrictionActInfoItem) ? get_class($dataBlockRestrictionActInfoItem) : gettype($dataBlockRestrictionActInfoItem)), __LINE__);
            }
        }
        $this->RestrictionActInfo = $restrictionActInfo;
        return $this;
    }
    /**
     * Add item to RestrictionActInfo value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\RestrictionActInfo $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToRestrictionActInfo(\AisFssp\StructType\RestrictionActInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\RestrictionActInfo) {
            throw new \InvalidArgumentException(sprintf('The RestrictionActInfo property can only contain items of \AisFssp\StructType\RestrictionActInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RestrictionActInfo[] = $item;
        return $this;
    }
    /**
     * Get ipDataRequest value
     * @return \AisFssp\StructType\IPDataRequest[]|null
     */
    public function getIpDataRequest()
    {
        return $this->ipDataRequest;
    }
    /**
     * Set ipDataRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPDataRequest[] $ipDataRequest
     * @return \AisFssp\StructType\DataBlock
     */
    public function setIpDataRequest(array $ipDataRequest = array())
    {
        foreach ($ipDataRequest as $dataBlockIpDataRequestItem) {
            // validation for constraint: itemType
            if (!$dataBlockIpDataRequestItem instanceof \AisFssp\StructType\IPDataRequest) {
                throw new \InvalidArgumentException(sprintf('The ipDataRequest property can only contain items of \AisFssp\StructType\IPDataRequest, "%s" given', is_object($dataBlockIpDataRequestItem) ? get_class($dataBlockIpDataRequestItem) : gettype($dataBlockIpDataRequestItem)), __LINE__);
            }
        }
        $this->ipDataRequest = $ipDataRequest;
        return $this;
    }
    /**
     * Add item to ipDataRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPDataRequest $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToIpDataRequest(\AisFssp\StructType\IPDataRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\IPDataRequest) {
            throw new \InvalidArgumentException(sprintf('The ipDataRequest property can only contain items of \AisFssp\StructType\IPDataRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ipDataRequest[] = $item;
        return $this;
    }
    /**
     * Get investigationDataInfo value
     * @return \AisFssp\StructType\InvestigationDataInfo[]|null
     */
    public function getInvestigationDataInfo()
    {
        return $this->investigationDataInfo;
    }
    /**
     * Set investigationDataInfo value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\InvestigationDataInfo[] $investigationDataInfo
     * @return \AisFssp\StructType\DataBlock
     */
    public function setInvestigationDataInfo(array $investigationDataInfo = array())
    {
        foreach ($investigationDataInfo as $dataBlockInvestigationDataInfoItem) {
            // validation for constraint: itemType
            if (!$dataBlockInvestigationDataInfoItem instanceof \AisFssp\StructType\InvestigationDataInfo) {
                throw new \InvalidArgumentException(sprintf('The investigationDataInfo property can only contain items of \AisFssp\StructType\InvestigationDataInfo, "%s" given', is_object($dataBlockInvestigationDataInfoItem) ? get_class($dataBlockInvestigationDataInfoItem) : gettype($dataBlockInvestigationDataInfoItem)), __LINE__);
            }
        }
        $this->investigationDataInfo = $investigationDataInfo;
        return $this;
    }
    /**
     * Add item to investigationDataInfo value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\InvestigationDataInfo $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToInvestigationDataInfo(\AisFssp\StructType\InvestigationDataInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\InvestigationDataInfo) {
            throw new \InvalidArgumentException(sprintf('The investigationDataInfo property can only contain items of \AisFssp\StructType\InvestigationDataInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->investigationDataInfo[] = $item;
        return $this;
    }
    /**
     * Get ipDataInfo value
     * @return \AisFssp\StructType\IPDataInfo[]|null
     */
    public function getIpDataInfo()
    {
        return $this->ipDataInfo;
    }
    /**
     * Set ipDataInfo value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPDataInfo[] $ipDataInfo
     * @return \AisFssp\StructType\DataBlock
     */
    public function setIpDataInfo(array $ipDataInfo = array())
    {
        foreach ($ipDataInfo as $dataBlockIpDataInfoItem) {
            // validation for constraint: itemType
            if (!$dataBlockIpDataInfoItem instanceof \AisFssp\StructType\IPDataInfo) {
                throw new \InvalidArgumentException(sprintf('The ipDataInfo property can only contain items of \AisFssp\StructType\IPDataInfo, "%s" given', is_object($dataBlockIpDataInfoItem) ? get_class($dataBlockIpDataInfoItem) : gettype($dataBlockIpDataInfoItem)), __LINE__);
            }
        }
        $this->ipDataInfo = $ipDataInfo;
        return $this;
    }
    /**
     * Add item to ipDataInfo value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPDataInfo $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToIpDataInfo(\AisFssp\StructType\IPDataInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\IPDataInfo) {
            throw new \InvalidArgumentException(sprintf('The ipDataInfo property can only contain items of \AisFssp\StructType\IPDataInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ipDataInfo[] = $item;
        return $this;
    }
    /**
     * Get RecoveredAmountRequest value
     * @return \AisFssp\StructType\RecoveredAmountRequest[]|null
     */
    public function getRecoveredAmountRequest()
    {
        return $this->RecoveredAmountRequest;
    }
    /**
     * Set RecoveredAmountRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\RecoveredAmountRequest[] $recoveredAmountRequest
     * @return \AisFssp\StructType\DataBlock
     */
    public function setRecoveredAmountRequest(array $recoveredAmountRequest = array())
    {
        foreach ($recoveredAmountRequest as $dataBlockRecoveredAmountRequestItem) {
            // validation for constraint: itemType
            if (!$dataBlockRecoveredAmountRequestItem instanceof \AisFssp\StructType\RecoveredAmountRequest) {
                throw new \InvalidArgumentException(sprintf('The RecoveredAmountRequest property can only contain items of \AisFssp\StructType\RecoveredAmountRequest, "%s" given', is_object($dataBlockRecoveredAmountRequestItem) ? get_class($dataBlockRecoveredAmountRequestItem) : gettype($dataBlockRecoveredAmountRequestItem)), __LINE__);
            }
        }
        $this->RecoveredAmountRequest = $recoveredAmountRequest;
        return $this;
    }
    /**
     * Add item to RecoveredAmountRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\RecoveredAmountRequest $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToRecoveredAmountRequest(\AisFssp\StructType\RecoveredAmountRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\RecoveredAmountRequest) {
            throw new \InvalidArgumentException(sprintf('The RecoveredAmountRequest property can only contain items of \AisFssp\StructType\RecoveredAmountRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RecoveredAmountRequest[] = $item;
        return $this;
    }
    /**
     * Get RecoveredAmountAnswer value
     * @return \AisFssp\StructType\RecoveredAmountAnswer[]|null
     */
    public function getRecoveredAmountAnswer()
    {
        return $this->RecoveredAmountAnswer;
    }
    /**
     * Set RecoveredAmountAnswer value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\RecoveredAmountAnswer[] $recoveredAmountAnswer
     * @return \AisFssp\StructType\DataBlock
     */
    public function setRecoveredAmountAnswer(array $recoveredAmountAnswer = array())
    {
        foreach ($recoveredAmountAnswer as $dataBlockRecoveredAmountAnswerItem) {
            // validation for constraint: itemType
            if (!$dataBlockRecoveredAmountAnswerItem instanceof \AisFssp\StructType\RecoveredAmountAnswer) {
                throw new \InvalidArgumentException(sprintf('The RecoveredAmountAnswer property can only contain items of \AisFssp\StructType\RecoveredAmountAnswer, "%s" given', is_object($dataBlockRecoveredAmountAnswerItem) ? get_class($dataBlockRecoveredAmountAnswerItem) : gettype($dataBlockRecoveredAmountAnswerItem)), __LINE__);
            }
        }
        $this->RecoveredAmountAnswer = $recoveredAmountAnswer;
        return $this;
    }
    /**
     * Add item to RecoveredAmountAnswer value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\RecoveredAmountAnswer $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToRecoveredAmountAnswer(\AisFssp\StructType\RecoveredAmountAnswer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\RecoveredAmountAnswer) {
            throw new \InvalidArgumentException(sprintf('The RecoveredAmountAnswer property can only contain items of \AisFssp\StructType\RecoveredAmountAnswer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RecoveredAmountAnswer[] = $item;
        return $this;
    }
    /**
     * Get InvestigationRegistryQuery value
     * @return \AisFssp\StructType\InvestigationRegistryQuery[]|null
     */
    public function getInvestigationRegistryQuery()
    {
        return $this->InvestigationRegistryQuery;
    }
    /**
     * Set InvestigationRegistryQuery value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\InvestigationRegistryQuery[] $investigationRegistryQuery
     * @return \AisFssp\StructType\DataBlock
     */
    public function setInvestigationRegistryQuery(array $investigationRegistryQuery = array())
    {
        foreach ($investigationRegistryQuery as $dataBlockInvestigationRegistryQueryItem) {
            // validation for constraint: itemType
            if (!$dataBlockInvestigationRegistryQueryItem instanceof \AisFssp\StructType\InvestigationRegistryQuery) {
                throw new \InvalidArgumentException(sprintf('The InvestigationRegistryQuery property can only contain items of \AisFssp\StructType\InvestigationRegistryQuery, "%s" given', is_object($dataBlockInvestigationRegistryQueryItem) ? get_class($dataBlockInvestigationRegistryQueryItem) : gettype($dataBlockInvestigationRegistryQueryItem)), __LINE__);
            }
        }
        $this->InvestigationRegistryQuery = $investigationRegistryQuery;
        return $this;
    }
    /**
     * Add item to InvestigationRegistryQuery value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\InvestigationRegistryQuery $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToInvestigationRegistryQuery(\AisFssp\StructType\InvestigationRegistryQuery $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\InvestigationRegistryQuery) {
            throw new \InvalidArgumentException(sprintf('The InvestigationRegistryQuery property can only contain items of \AisFssp\StructType\InvestigationRegistryQuery, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InvestigationRegistryQuery[] = $item;
        return $this;
    }
    /**
     * Get ArrestRegistryQuery value
     * @return \AisFssp\StructType\ArrestRegistryQuery[]|null
     */
    public function getArrestRegistryQuery()
    {
        return $this->ArrestRegistryQuery;
    }
    /**
     * Set ArrestRegistryQuery value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ArrestRegistryQuery[] $arrestRegistryQuery
     * @return \AisFssp\StructType\DataBlock
     */
    public function setArrestRegistryQuery(array $arrestRegistryQuery = array())
    {
        foreach ($arrestRegistryQuery as $dataBlockArrestRegistryQueryItem) {
            // validation for constraint: itemType
            if (!$dataBlockArrestRegistryQueryItem instanceof \AisFssp\StructType\ArrestRegistryQuery) {
                throw new \InvalidArgumentException(sprintf('The ArrestRegistryQuery property can only contain items of \AisFssp\StructType\ArrestRegistryQuery, "%s" given', is_object($dataBlockArrestRegistryQueryItem) ? get_class($dataBlockArrestRegistryQueryItem) : gettype($dataBlockArrestRegistryQueryItem)), __LINE__);
            }
        }
        $this->ArrestRegistryQuery = $arrestRegistryQuery;
        return $this;
    }
    /**
     * Add item to ArrestRegistryQuery value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ArrestRegistryQuery $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToArrestRegistryQuery(\AisFssp\StructType\ArrestRegistryQuery $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\ArrestRegistryQuery) {
            throw new \InvalidArgumentException(sprintf('The ArrestRegistryQuery property can only contain items of \AisFssp\StructType\ArrestRegistryQuery, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ArrestRegistryQuery[] = $item;
        return $this;
    }
    /**
     * Get ArrestRegistryInfo value
     * @return \AisFssp\StructType\ArrestRegistryInfo[]|null
     */
    public function getArrestRegistryInfo()
    {
        return $this->ArrestRegistryInfo;
    }
    /**
     * Set ArrestRegistryInfo value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ArrestRegistryInfo[] $arrestRegistryInfo
     * @return \AisFssp\StructType\DataBlock
     */
    public function setArrestRegistryInfo(array $arrestRegistryInfo = array())
    {
        foreach ($arrestRegistryInfo as $dataBlockArrestRegistryInfoItem) {
            // validation for constraint: itemType
            if (!$dataBlockArrestRegistryInfoItem instanceof \AisFssp\StructType\ArrestRegistryInfo) {
                throw new \InvalidArgumentException(sprintf('The ArrestRegistryInfo property can only contain items of \AisFssp\StructType\ArrestRegistryInfo, "%s" given', is_object($dataBlockArrestRegistryInfoItem) ? get_class($dataBlockArrestRegistryInfoItem) : gettype($dataBlockArrestRegistryInfoItem)), __LINE__);
            }
        }
        $this->ArrestRegistryInfo = $arrestRegistryInfo;
        return $this;
    }
    /**
     * Add item to ArrestRegistryInfo value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ArrestRegistryInfo $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToArrestRegistryInfo(\AisFssp\StructType\ArrestRegistryInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\ArrestRegistryInfo) {
            throw new \InvalidArgumentException(sprintf('The ArrestRegistryInfo property can only contain items of \AisFssp\StructType\ArrestRegistryInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ArrestRegistryInfo[] = $item;
        return $this;
    }
    /**
     * Get ArrestRegistryDetail value
     * @return \AisFssp\StructType\ArrestRegistryDetail[]|null
     */
    public function getArrestRegistryDetail()
    {
        return $this->ArrestRegistryDetail;
    }
    /**
     * Set ArrestRegistryDetail value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ArrestRegistryDetail[] $arrestRegistryDetail
     * @return \AisFssp\StructType\DataBlock
     */
    public function setArrestRegistryDetail(array $arrestRegistryDetail = array())
    {
        foreach ($arrestRegistryDetail as $dataBlockArrestRegistryDetailItem) {
            // validation for constraint: itemType
            if (!$dataBlockArrestRegistryDetailItem instanceof \AisFssp\StructType\ArrestRegistryDetail) {
                throw new \InvalidArgumentException(sprintf('The ArrestRegistryDetail property can only contain items of \AisFssp\StructType\ArrestRegistryDetail, "%s" given', is_object($dataBlockArrestRegistryDetailItem) ? get_class($dataBlockArrestRegistryDetailItem) : gettype($dataBlockArrestRegistryDetailItem)), __LINE__);
            }
        }
        $this->ArrestRegistryDetail = $arrestRegistryDetail;
        return $this;
    }
    /**
     * Add item to ArrestRegistryDetail value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ArrestRegistryDetail $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToArrestRegistryDetail(\AisFssp\StructType\ArrestRegistryDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\ArrestRegistryDetail) {
            throw new \InvalidArgumentException(sprintf('The ArrestRegistryDetail property can only contain items of \AisFssp\StructType\ArrestRegistryDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ArrestRegistryDetail[] = $item;
        return $this;
    }
    /**
     * Get CrimeRegistryQuery value
     * @return \AisFssp\StructType\CrimeRegistryQuery[]|null
     */
    public function getCrimeRegistryQuery()
    {
        return $this->CrimeRegistryQuery;
    }
    /**
     * Set CrimeRegistryQuery value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\CrimeRegistryQuery[] $crimeRegistryQuery
     * @return \AisFssp\StructType\DataBlock
     */
    public function setCrimeRegistryQuery(array $crimeRegistryQuery = array())
    {
        foreach ($crimeRegistryQuery as $dataBlockCrimeRegistryQueryItem) {
            // validation for constraint: itemType
            if (!$dataBlockCrimeRegistryQueryItem instanceof \AisFssp\StructType\CrimeRegistryQuery) {
                throw new \InvalidArgumentException(sprintf('The CrimeRegistryQuery property can only contain items of \AisFssp\StructType\CrimeRegistryQuery, "%s" given', is_object($dataBlockCrimeRegistryQueryItem) ? get_class($dataBlockCrimeRegistryQueryItem) : gettype($dataBlockCrimeRegistryQueryItem)), __LINE__);
            }
        }
        $this->CrimeRegistryQuery = $crimeRegistryQuery;
        return $this;
    }
    /**
     * Add item to CrimeRegistryQuery value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\CrimeRegistryQuery $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToCrimeRegistryQuery(\AisFssp\StructType\CrimeRegistryQuery $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\CrimeRegistryQuery) {
            throw new \InvalidArgumentException(sprintf('The CrimeRegistryQuery property can only contain items of \AisFssp\StructType\CrimeRegistryQuery, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CrimeRegistryQuery[] = $item;
        return $this;
    }
    /**
     * Get CrimeRegistryInfo value
     * @return \AisFssp\StructType\CrimeRegistryInfo[]|null
     */
    public function getCrimeRegistryInfo()
    {
        return $this->CrimeRegistryInfo;
    }
    /**
     * Set CrimeRegistryInfo value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\CrimeRegistryInfo[] $crimeRegistryInfo
     * @return \AisFssp\StructType\DataBlock
     */
    public function setCrimeRegistryInfo(array $crimeRegistryInfo = array())
    {
        foreach ($crimeRegistryInfo as $dataBlockCrimeRegistryInfoItem) {
            // validation for constraint: itemType
            if (!$dataBlockCrimeRegistryInfoItem instanceof \AisFssp\StructType\CrimeRegistryInfo) {
                throw new \InvalidArgumentException(sprintf('The CrimeRegistryInfo property can only contain items of \AisFssp\StructType\CrimeRegistryInfo, "%s" given', is_object($dataBlockCrimeRegistryInfoItem) ? get_class($dataBlockCrimeRegistryInfoItem) : gettype($dataBlockCrimeRegistryInfoItem)), __LINE__);
            }
        }
        $this->CrimeRegistryInfo = $crimeRegistryInfo;
        return $this;
    }
    /**
     * Add item to CrimeRegistryInfo value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\CrimeRegistryInfo $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToCrimeRegistryInfo(\AisFssp\StructType\CrimeRegistryInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\CrimeRegistryInfo) {
            throw new \InvalidArgumentException(sprintf('The CrimeRegistryInfo property can only contain items of \AisFssp\StructType\CrimeRegistryInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CrimeRegistryInfo[] = $item;
        return $this;
    }
    /**
     * Get CrimeRegistryDetail value
     * @return \AisFssp\StructType\CrimeRegistryDetail[]|null
     */
    public function getCrimeRegistryDetail()
    {
        return $this->CrimeRegistryDetail;
    }
    /**
     * Set CrimeRegistryDetail value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\CrimeRegistryDetail[] $crimeRegistryDetail
     * @return \AisFssp\StructType\DataBlock
     */
    public function setCrimeRegistryDetail(array $crimeRegistryDetail = array())
    {
        foreach ($crimeRegistryDetail as $dataBlockCrimeRegistryDetailItem) {
            // validation for constraint: itemType
            if (!$dataBlockCrimeRegistryDetailItem instanceof \AisFssp\StructType\CrimeRegistryDetail) {
                throw new \InvalidArgumentException(sprintf('The CrimeRegistryDetail property can only contain items of \AisFssp\StructType\CrimeRegistryDetail, "%s" given', is_object($dataBlockCrimeRegistryDetailItem) ? get_class($dataBlockCrimeRegistryDetailItem) : gettype($dataBlockCrimeRegistryDetailItem)), __LINE__);
            }
        }
        $this->CrimeRegistryDetail = $crimeRegistryDetail;
        return $this;
    }
    /**
     * Add item to CrimeRegistryDetail value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\CrimeRegistryDetail $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToCrimeRegistryDetail(\AisFssp\StructType\CrimeRegistryDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\CrimeRegistryDetail) {
            throw new \InvalidArgumentException(sprintf('The CrimeRegistryDetail property can only contain items of \AisFssp\StructType\CrimeRegistryDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CrimeRegistryDetail[] = $item;
        return $this;
    }
    /**
     * Get caRequest value
     * @return \AisFssp\StructType\CaRequest[]|null
     */
    public function getCaRequest()
    {
        return $this->caRequest;
    }
    /**
     * Set caRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\CaRequest[] $caRequest
     * @return \AisFssp\StructType\DataBlock
     */
    public function setCaRequest(array $caRequest = array())
    {
        foreach ($caRequest as $dataBlockCaRequestItem) {
            // validation for constraint: itemType
            if (!$dataBlockCaRequestItem instanceof \AisFssp\StructType\CaRequest) {
                throw new \InvalidArgumentException(sprintf('The caRequest property can only contain items of \AisFssp\StructType\CaRequest, "%s" given', is_object($dataBlockCaRequestItem) ? get_class($dataBlockCaRequestItem) : gettype($dataBlockCaRequestItem)), __LINE__);
            }
        }
        $this->caRequest = $caRequest;
        return $this;
    }
    /**
     * Add item to caRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\CaRequest $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToCaRequest(\AisFssp\StructType\CaRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\CaRequest) {
            throw new \InvalidArgumentException(sprintf('The caRequest property can only contain items of \AisFssp\StructType\CaRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->caRequest[] = $item;
        return $this;
    }
    /**
     * Get caAnswer value
     * @return \AisFssp\StructType\CaAnswer[]|null
     */
    public function getCaAnswer()
    {
        return $this->caAnswer;
    }
    /**
     * Set caAnswer value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\CaAnswer[] $caAnswer
     * @return \AisFssp\StructType\DataBlock
     */
    public function setCaAnswer(array $caAnswer = array())
    {
        foreach ($caAnswer as $dataBlockCaAnswerItem) {
            // validation for constraint: itemType
            if (!$dataBlockCaAnswerItem instanceof \AisFssp\StructType\CaAnswer) {
                throw new \InvalidArgumentException(sprintf('The caAnswer property can only contain items of \AisFssp\StructType\CaAnswer, "%s" given', is_object($dataBlockCaAnswerItem) ? get_class($dataBlockCaAnswerItem) : gettype($dataBlockCaAnswerItem)), __LINE__);
            }
        }
        $this->caAnswer = $caAnswer;
        return $this;
    }
    /**
     * Add item to caAnswer value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\CaAnswer $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToCaAnswer(\AisFssp\StructType\CaAnswer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\CaAnswer) {
            throw new \InvalidArgumentException(sprintf('The caAnswer property can only contain items of \AisFssp\StructType\CaAnswer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->caAnswer[] = $item;
        return $this;
    }
    /**
     * Get investigationRegistry value
     * @return \AisFssp\StructType\InvestigationRegistry[]|null
     */
    public function getInvestigationRegistry()
    {
        return $this->investigationRegistry;
    }
    /**
     * Set investigationRegistry value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\InvestigationRegistry[] $investigationRegistry
     * @return \AisFssp\StructType\DataBlock
     */
    public function setInvestigationRegistry(array $investigationRegistry = array())
    {
        foreach ($investigationRegistry as $dataBlockInvestigationRegistryItem) {
            // validation for constraint: itemType
            if (!$dataBlockInvestigationRegistryItem instanceof \AisFssp\StructType\InvestigationRegistry) {
                throw new \InvalidArgumentException(sprintf('The investigationRegistry property can only contain items of \AisFssp\StructType\InvestigationRegistry, "%s" given', is_object($dataBlockInvestigationRegistryItem) ? get_class($dataBlockInvestigationRegistryItem) : gettype($dataBlockInvestigationRegistryItem)), __LINE__);
            }
        }
        $this->investigationRegistry = $investigationRegistry;
        return $this;
    }
    /**
     * Add item to investigationRegistry value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\InvestigationRegistry $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToInvestigationRegistry(\AisFssp\StructType\InvestigationRegistry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\InvestigationRegistry) {
            throw new \InvalidArgumentException(sprintf('The investigationRegistry property can only contain items of \AisFssp\StructType\InvestigationRegistry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->investigationRegistry[] = $item;
        return $this;
    }
    /**
     * Get PenaltyChargesRegistry value
     * @return \AisFssp\StructType\PenaltyChargesRegistry[]|null
     */
    public function getPenaltyChargesRegistry()
    {
        return $this->PenaltyChargesRegistry;
    }
    /**
     * Set PenaltyChargesRegistry value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\PenaltyChargesRegistry[] $penaltyChargesRegistry
     * @return \AisFssp\StructType\DataBlock
     */
    public function setPenaltyChargesRegistry(array $penaltyChargesRegistry = array())
    {
        foreach ($penaltyChargesRegistry as $dataBlockPenaltyChargesRegistryItem) {
            // validation for constraint: itemType
            if (!$dataBlockPenaltyChargesRegistryItem instanceof \AisFssp\StructType\PenaltyChargesRegistry) {
                throw new \InvalidArgumentException(sprintf('The PenaltyChargesRegistry property can only contain items of \AisFssp\StructType\PenaltyChargesRegistry, "%s" given', is_object($dataBlockPenaltyChargesRegistryItem) ? get_class($dataBlockPenaltyChargesRegistryItem) : gettype($dataBlockPenaltyChargesRegistryItem)), __LINE__);
            }
        }
        $this->PenaltyChargesRegistry = $penaltyChargesRegistry;
        return $this;
    }
    /**
     * Add item to PenaltyChargesRegistry value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\PenaltyChargesRegistry $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToPenaltyChargesRegistry(\AisFssp\StructType\PenaltyChargesRegistry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\PenaltyChargesRegistry) {
            throw new \InvalidArgumentException(sprintf('The PenaltyChargesRegistry property can only contain items of \AisFssp\StructType\PenaltyChargesRegistry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PenaltyChargesRegistry[] = $item;
        return $this;
    }
    /**
     * Get RestrictionRegistry value
     * @return \AisFssp\StructType\RestrictionRegistry[]|null
     */
    public function getRestrictionRegistry()
    {
        return $this->RestrictionRegistry;
    }
    /**
     * Set RestrictionRegistry value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\RestrictionRegistry[] $restrictionRegistry
     * @return \AisFssp\StructType\DataBlock
     */
    public function setRestrictionRegistry(array $restrictionRegistry = array())
    {
        foreach ($restrictionRegistry as $dataBlockRestrictionRegistryItem) {
            // validation for constraint: itemType
            if (!$dataBlockRestrictionRegistryItem instanceof \AisFssp\StructType\RestrictionRegistry) {
                throw new \InvalidArgumentException(sprintf('The RestrictionRegistry property can only contain items of \AisFssp\StructType\RestrictionRegistry, "%s" given', is_object($dataBlockRestrictionRegistryItem) ? get_class($dataBlockRestrictionRegistryItem) : gettype($dataBlockRestrictionRegistryItem)), __LINE__);
            }
        }
        $this->RestrictionRegistry = $restrictionRegistry;
        return $this;
    }
    /**
     * Add item to RestrictionRegistry value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\RestrictionRegistry $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToRestrictionRegistry(\AisFssp\StructType\RestrictionRegistry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\RestrictionRegistry) {
            throw new \InvalidArgumentException(sprintf('The RestrictionRegistry property can only contain items of \AisFssp\StructType\RestrictionRegistry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RestrictionRegistry[] = $item;
        return $this;
    }
    /**
     * Get ReqAppResult value
     * @return \AisFssp\StructType\ReqAppResult[]|null
     */
    public function getReqAppResult()
    {
        return $this->ReqAppResult;
    }
    /**
     * Set ReqAppResult value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ReqAppResult[] $reqAppResult
     * @return \AisFssp\StructType\DataBlock
     */
    public function setReqAppResult(array $reqAppResult = array())
    {
        foreach ($reqAppResult as $dataBlockReqAppResultItem) {
            // validation for constraint: itemType
            if (!$dataBlockReqAppResultItem instanceof \AisFssp\StructType\ReqAppResult) {
                throw new \InvalidArgumentException(sprintf('The ReqAppResult property can only contain items of \AisFssp\StructType\ReqAppResult, "%s" given', is_object($dataBlockReqAppResultItem) ? get_class($dataBlockReqAppResultItem) : gettype($dataBlockReqAppResultItem)), __LINE__);
            }
        }
        $this->ReqAppResult = $reqAppResult;
        return $this;
    }
    /**
     * Add item to ReqAppResult value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ReqAppResult $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToReqAppResult(\AisFssp\StructType\ReqAppResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\ReqAppResult) {
            throw new \InvalidArgumentException(sprintf('The ReqAppResult property can only contain items of \AisFssp\StructType\ReqAppResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ReqAppResult[] = $item;
        return $this;
    }
    /**
     * Get AnswerAppResult value
     * @return \AisFssp\StructType\AnswerAppResult[]|null
     */
    public function getAnswerAppResult()
    {
        return $this->AnswerAppResult;
    }
    /**
     * Set AnswerAppResult value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AnswerAppResult[] $answerAppResult
     * @return \AisFssp\StructType\DataBlock
     */
    public function setAnswerAppResult(array $answerAppResult = array())
    {
        foreach ($answerAppResult as $dataBlockAnswerAppResultItem) {
            // validation for constraint: itemType
            if (!$dataBlockAnswerAppResultItem instanceof \AisFssp\StructType\AnswerAppResult) {
                throw new \InvalidArgumentException(sprintf('The AnswerAppResult property can only contain items of \AisFssp\StructType\AnswerAppResult, "%s" given', is_object($dataBlockAnswerAppResultItem) ? get_class($dataBlockAnswerAppResultItem) : gettype($dataBlockAnswerAppResultItem)), __LINE__);
            }
        }
        $this->AnswerAppResult = $answerAppResult;
        return $this;
    }
    /**
     * Add item to AnswerAppResult value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AnswerAppResult $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToAnswerAppResult(\AisFssp\StructType\AnswerAppResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\AnswerAppResult) {
            throw new \InvalidArgumentException(sprintf('The AnswerAppResult property can only contain items of \AisFssp\StructType\AnswerAppResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AnswerAppResult[] = $item;
        return $this;
    }
    /**
     * Get Message value
     * @return \AisFssp\StructType\DocumentNote[]|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\DocumentNote[] $message
     * @return \AisFssp\StructType\DataBlock
     */
    public function setMessage(array $message = array())
    {
        foreach ($message as $dataBlockMessageItem) {
            // validation for constraint: itemType
            if (!$dataBlockMessageItem instanceof \AisFssp\StructType\DocumentNote) {
                throw new \InvalidArgumentException(sprintf('The Message property can only contain items of \AisFssp\StructType\DocumentNote, "%s" given', is_object($dataBlockMessageItem) ? get_class($dataBlockMessageItem) : gettype($dataBlockMessageItem)), __LINE__);
            }
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Add item to Message value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\DocumentNote $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToMessage(\AisFssp\StructType\DocumentNote $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\DocumentNote) {
            throw new \InvalidArgumentException(sprintf('The Message property can only contain items of \AisFssp\StructType\DocumentNote, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Message[] = $item;
        return $this;
    }
    /**
     * Get debtorIPListRequest value
     * @return \AisFssp\StructType\DebtorIPListRequestType[]|null
     */
    public function getDebtorIPListRequest()
    {
        return $this->debtorIPListRequest;
    }
    /**
     * Set debtorIPListRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\DebtorIPListRequestType[] $debtorIPListRequest
     * @return \AisFssp\StructType\DataBlock
     */
    public function setDebtorIPListRequest(array $debtorIPListRequest = array())
    {
        foreach ($debtorIPListRequest as $dataBlockDebtorIPListRequestItem) {
            // validation for constraint: itemType
            if (!$dataBlockDebtorIPListRequestItem instanceof \AisFssp\StructType\DebtorIPListRequestType) {
                throw new \InvalidArgumentException(sprintf('The debtorIPListRequest property can only contain items of \AisFssp\StructType\DebtorIPListRequestType, "%s" given', is_object($dataBlockDebtorIPListRequestItem) ? get_class($dataBlockDebtorIPListRequestItem) : gettype($dataBlockDebtorIPListRequestItem)), __LINE__);
            }
        }
        $this->debtorIPListRequest = $debtorIPListRequest;
        return $this;
    }
    /**
     * Add item to debtorIPListRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\DebtorIPListRequestType $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToDebtorIPListRequest(\AisFssp\StructType\DebtorIPListRequestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\DebtorIPListRequestType) {
            throw new \InvalidArgumentException(sprintf('The debtorIPListRequest property can only contain items of \AisFssp\StructType\DebtorIPListRequestType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->debtorIPListRequest[] = $item;
        return $this;
    }
    /**
     * Get IPSideRequestExistence value
     * @return \AisFssp\StructType\IPSideRequestExistenceType[]|null
     */
    public function getIPSideRequestExistence()
    {
        return $this->IPSideRequestExistence;
    }
    /**
     * Set IPSideRequestExistence value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPSideRequestExistenceType[] $iPSideRequestExistence
     * @return \AisFssp\StructType\DataBlock
     */
    public function setIPSideRequestExistence(array $iPSideRequestExistence = array())
    {
        foreach ($iPSideRequestExistence as $dataBlockIPSideRequestExistenceItem) {
            // validation for constraint: itemType
            if (!$dataBlockIPSideRequestExistenceItem instanceof \AisFssp\StructType\IPSideRequestExistenceType) {
                throw new \InvalidArgumentException(sprintf('The IPSideRequestExistence property can only contain items of \AisFssp\StructType\IPSideRequestExistenceType, "%s" given', is_object($dataBlockIPSideRequestExistenceItem) ? get_class($dataBlockIPSideRequestExistenceItem) : gettype($dataBlockIPSideRequestExistenceItem)), __LINE__);
            }
        }
        $this->IPSideRequestExistence = $iPSideRequestExistence;
        return $this;
    }
    /**
     * Add item to IPSideRequestExistence value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPSideRequestExistenceType $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToIPSideRequestExistence(\AisFssp\StructType\IPSideRequestExistenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\IPSideRequestExistenceType) {
            throw new \InvalidArgumentException(sprintf('The IPSideRequestExistence property can only contain items of \AisFssp\StructType\IPSideRequestExistenceType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IPSideRequestExistence[] = $item;
        return $this;
    }
    /**
     * Get IPSideRequestCourseID value
     * @return \AisFssp\StructType\IPSideRequestCourseIDType[]|null
     */
    public function getIPSideRequestCourseID()
    {
        return $this->IPSideRequestCourseID;
    }
    /**
     * Set IPSideRequestCourseID value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPSideRequestCourseIDType[] $iPSideRequestCourseID
     * @return \AisFssp\StructType\DataBlock
     */
    public function setIPSideRequestCourseID(array $iPSideRequestCourseID = array())
    {
        foreach ($iPSideRequestCourseID as $dataBlockIPSideRequestCourseIDItem) {
            // validation for constraint: itemType
            if (!$dataBlockIPSideRequestCourseIDItem instanceof \AisFssp\StructType\IPSideRequestCourseIDType) {
                throw new \InvalidArgumentException(sprintf('The IPSideRequestCourseID property can only contain items of \AisFssp\StructType\IPSideRequestCourseIDType, "%s" given', is_object($dataBlockIPSideRequestCourseIDItem) ? get_class($dataBlockIPSideRequestCourseIDItem) : gettype($dataBlockIPSideRequestCourseIDItem)), __LINE__);
            }
        }
        $this->IPSideRequestCourseID = $iPSideRequestCourseID;
        return $this;
    }
    /**
     * Add item to IPSideRequestCourseID value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPSideRequestCourseIDType $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToIPSideRequestCourseID(\AisFssp\StructType\IPSideRequestCourseIDType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\IPSideRequestCourseIDType) {
            throw new \InvalidArgumentException(sprintf('The IPSideRequestCourseID property can only contain items of \AisFssp\StructType\IPSideRequestCourseIDType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IPSideRequestCourseID[] = $item;
        return $this;
    }
    /**
     * Get IPSideRequestCourseIP value
     * @return \AisFssp\StructType\IPSideRequestCourseIPType[]|null
     */
    public function getIPSideRequestCourseIP()
    {
        return $this->IPSideRequestCourseIP;
    }
    /**
     * Set IPSideRequestCourseIP value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPSideRequestCourseIPType[] $iPSideRequestCourseIP
     * @return \AisFssp\StructType\DataBlock
     */
    public function setIPSideRequestCourseIP(array $iPSideRequestCourseIP = array())
    {
        foreach ($iPSideRequestCourseIP as $dataBlockIPSideRequestCourseIPItem) {
            // validation for constraint: itemType
            if (!$dataBlockIPSideRequestCourseIPItem instanceof \AisFssp\StructType\IPSideRequestCourseIPType) {
                throw new \InvalidArgumentException(sprintf('The IPSideRequestCourseIP property can only contain items of \AisFssp\StructType\IPSideRequestCourseIPType, "%s" given', is_object($dataBlockIPSideRequestCourseIPItem) ? get_class($dataBlockIPSideRequestCourseIPItem) : gettype($dataBlockIPSideRequestCourseIPItem)), __LINE__);
            }
        }
        $this->IPSideRequestCourseIP = $iPSideRequestCourseIP;
        return $this;
    }
    /**
     * Add item to IPSideRequestCourseIP value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPSideRequestCourseIPType $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToIPSideRequestCourseIP(\AisFssp\StructType\IPSideRequestCourseIPType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\IPSideRequestCourseIPType) {
            throw new \InvalidArgumentException(sprintf('The IPSideRequestCourseIP property can only contain items of \AisFssp\StructType\IPSideRequestCourseIPType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IPSideRequestCourseIP[] = $item;
        return $this;
    }
    /**
     * Get IPReqAppResultRequest value
     * @return \AisFssp\StructType\IPReqAppResultRequestType[]|null
     */
    public function getIPReqAppResultRequest()
    {
        return $this->IPReqAppResultRequest;
    }
    /**
     * Set IPReqAppResultRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPReqAppResultRequestType[] $iPReqAppResultRequest
     * @return \AisFssp\StructType\DataBlock
     */
    public function setIPReqAppResultRequest(array $iPReqAppResultRequest = array())
    {
        foreach ($iPReqAppResultRequest as $dataBlockIPReqAppResultRequestItem) {
            // validation for constraint: itemType
            if (!$dataBlockIPReqAppResultRequestItem instanceof \AisFssp\StructType\IPReqAppResultRequestType) {
                throw new \InvalidArgumentException(sprintf('The IPReqAppResultRequest property can only contain items of \AisFssp\StructType\IPReqAppResultRequestType, "%s" given', is_object($dataBlockIPReqAppResultRequestItem) ? get_class($dataBlockIPReqAppResultRequestItem) : gettype($dataBlockIPReqAppResultRequestItem)), __LINE__);
            }
        }
        $this->IPReqAppResultRequest = $iPReqAppResultRequest;
        return $this;
    }
    /**
     * Add item to IPReqAppResultRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPReqAppResultRequestType $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToIPReqAppResultRequest(\AisFssp\StructType\IPReqAppResultRequestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\IPReqAppResultRequestType) {
            throw new \InvalidArgumentException(sprintf('The IPReqAppResultRequest property can only contain items of \AisFssp\StructType\IPReqAppResultRequestType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IPReqAppResultRequest[] = $item;
        return $this;
    }
    /**
     * Get DebtorIPListResponseType value
     * @return \AisFssp\StructType\DebtorIPListResponseType[]|null
     */
    public function getDebtorIPListResponseType()
    {
        return $this->DebtorIPListResponseType;
    }
    /**
     * Set DebtorIPListResponseType value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\DebtorIPListResponseType[] $debtorIPListResponseType
     * @return \AisFssp\StructType\DataBlock
     */
    public function setDebtorIPListResponseType(array $debtorIPListResponseType = array())
    {
        foreach ($debtorIPListResponseType as $dataBlockDebtorIPListResponseTypeItem) {
            // validation for constraint: itemType
            if (!$dataBlockDebtorIPListResponseTypeItem instanceof \AisFssp\StructType\DebtorIPListResponseType) {
                throw new \InvalidArgumentException(sprintf('The DebtorIPListResponseType property can only contain items of \AisFssp\StructType\DebtorIPListResponseType, "%s" given', is_object($dataBlockDebtorIPListResponseTypeItem) ? get_class($dataBlockDebtorIPListResponseTypeItem) : gettype($dataBlockDebtorIPListResponseTypeItem)), __LINE__);
            }
        }
        $this->DebtorIPListResponseType = $debtorIPListResponseType;
        return $this;
    }
    /**
     * Add item to DebtorIPListResponseType value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\DebtorIPListResponseType $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToDebtorIPListResponseType(\AisFssp\StructType\DebtorIPListResponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\DebtorIPListResponseType) {
            throw new \InvalidArgumentException(sprintf('The DebtorIPListResponseType property can only contain items of \AisFssp\StructType\DebtorIPListResponseType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DebtorIPListResponseType[] = $item;
        return $this;
    }
    /**
     * Get IPReqAppResponseType value
     * @return \AisFssp\StructType\IPReqAppResponseType[]|null
     */
    public function getIPReqAppResponseType()
    {
        return $this->IPReqAppResponseType;
    }
    /**
     * Set IPReqAppResponseType value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPReqAppResponseType[] $iPReqAppResponseType
     * @return \AisFssp\StructType\DataBlock
     */
    public function setIPReqAppResponseType(array $iPReqAppResponseType = array())
    {
        foreach ($iPReqAppResponseType as $dataBlockIPReqAppResponseTypeItem) {
            // validation for constraint: itemType
            if (!$dataBlockIPReqAppResponseTypeItem instanceof \AisFssp\StructType\IPReqAppResponseType) {
                throw new \InvalidArgumentException(sprintf('The IPReqAppResponseType property can only contain items of \AisFssp\StructType\IPReqAppResponseType, "%s" given', is_object($dataBlockIPReqAppResponseTypeItem) ? get_class($dataBlockIPReqAppResponseTypeItem) : gettype($dataBlockIPReqAppResponseTypeItem)), __LINE__);
            }
        }
        $this->IPReqAppResponseType = $iPReqAppResponseType;
        return $this;
    }
    /**
     * Add item to IPReqAppResponseType value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPReqAppResponseType $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToIPReqAppResponseType(\AisFssp\StructType\IPReqAppResponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\IPReqAppResponseType) {
            throw new \InvalidArgumentException(sprintf('The IPReqAppResponseType property can only contain items of \AisFssp\StructType\IPReqAppResponseType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IPReqAppResponseType[] = $item;
        return $this;
    }
    /**
     * Get IPReqAppResultReponseType value
     * @return \AisFssp\StructType\IPReqAppResultReponseType[]|null
     */
    public function getIPReqAppResultReponseType()
    {
        return $this->IPReqAppResultReponseType;
    }
    /**
     * Set IPReqAppResultReponseType value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPReqAppResultReponseType[] $iPReqAppResultReponseType
     * @return \AisFssp\StructType\DataBlock
     */
    public function setIPReqAppResultReponseType(array $iPReqAppResultReponseType = array())
    {
        foreach ($iPReqAppResultReponseType as $dataBlockIPReqAppResultReponseTypeItem) {
            // validation for constraint: itemType
            if (!$dataBlockIPReqAppResultReponseTypeItem instanceof \AisFssp\StructType\IPReqAppResultReponseType) {
                throw new \InvalidArgumentException(sprintf('The IPReqAppResultReponseType property can only contain items of \AisFssp\StructType\IPReqAppResultReponseType, "%s" given', is_object($dataBlockIPReqAppResultReponseTypeItem) ? get_class($dataBlockIPReqAppResultReponseTypeItem) : gettype($dataBlockIPReqAppResultReponseTypeItem)), __LINE__);
            }
        }
        $this->IPReqAppResultReponseType = $iPReqAppResultReponseType;
        return $this;
    }
    /**
     * Add item to IPReqAppResultReponseType value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPReqAppResultReponseType $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToIPReqAppResultReponseType(\AisFssp\StructType\IPReqAppResultReponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\IPReqAppResultReponseType) {
            throw new \InvalidArgumentException(sprintf('The IPReqAppResultReponseType property can only contain items of \AisFssp\StructType\IPReqAppResultReponseType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IPReqAppResultReponseType[] = $item;
        return $this;
    }
    /**
     * Get EApplicationType value
     * @return \AisFssp\StructType\EApplicationType[]|null
     */
    public function getEApplicationType()
    {
        return $this->EApplicationType;
    }
    /**
     * Set EApplicationType value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\EApplicationType[] $eApplicationType
     * @return \AisFssp\StructType\DataBlock
     */
    public function setEApplicationType(array $eApplicationType = array())
    {
        foreach ($eApplicationType as $dataBlockEApplicationTypeItem) {
            // validation for constraint: itemType
            if (!$dataBlockEApplicationTypeItem instanceof \AisFssp\StructType\EApplicationType) {
                throw new \InvalidArgumentException(sprintf('The EApplicationType property can only contain items of \AisFssp\StructType\EApplicationType, "%s" given', is_object($dataBlockEApplicationTypeItem) ? get_class($dataBlockEApplicationTypeItem) : gettype($dataBlockEApplicationTypeItem)), __LINE__);
            }
        }
        $this->EApplicationType = $eApplicationType;
        return $this;
    }
    /**
     * Add item to EApplicationType value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\EApplicationType $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToEApplicationType(\AisFssp\StructType\EApplicationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\EApplicationType) {
            throw new \InvalidArgumentException(sprintf('The EApplicationType property can only contain items of \AisFssp\StructType\EApplicationType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EApplicationType[] = $item;
        return $this;
    }
    /**
     * Get EApplicationResultType value
     * @return \AisFssp\StructType\EApplicationResultType[]|null
     */
    public function getEApplicationResultType()
    {
        return $this->EApplicationResultType;
    }
    /**
     * Set EApplicationResultType value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\EApplicationResultType[] $eApplicationResultType
     * @return \AisFssp\StructType\DataBlock
     */
    public function setEApplicationResultType(array $eApplicationResultType = array())
    {
        foreach ($eApplicationResultType as $dataBlockEApplicationResultTypeItem) {
            // validation for constraint: itemType
            if (!$dataBlockEApplicationResultTypeItem instanceof \AisFssp\StructType\EApplicationResultType) {
                throw new \InvalidArgumentException(sprintf('The EApplicationResultType property can only contain items of \AisFssp\StructType\EApplicationResultType, "%s" given', is_object($dataBlockEApplicationResultTypeItem) ? get_class($dataBlockEApplicationResultTypeItem) : gettype($dataBlockEApplicationResultTypeItem)), __LINE__);
            }
        }
        $this->EApplicationResultType = $eApplicationResultType;
        return $this;
    }
    /**
     * Add item to EApplicationResultType value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\EApplicationResultType $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToEApplicationResultType(\AisFssp\StructType\EApplicationResultType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\EApplicationResultType) {
            throw new \InvalidArgumentException(sprintf('The EApplicationResultType property can only contain items of \AisFssp\StructType\EApplicationResultType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EApplicationResultType[] = $item;
        return $this;
    }
    /**
     * Get MailStateTrackingRequest value
     * @return \AisFssp\StructType\MailStateTrackingRequest[]|null
     */
    public function getMailStateTrackingRequest()
    {
        return $this->MailStateTrackingRequest;
    }
    /**
     * Set MailStateTrackingRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\MailStateTrackingRequest[] $mailStateTrackingRequest
     * @return \AisFssp\StructType\DataBlock
     */
    public function setMailStateTrackingRequest(array $mailStateTrackingRequest = array())
    {
        foreach ($mailStateTrackingRequest as $dataBlockMailStateTrackingRequestItem) {
            // validation for constraint: itemType
            if (!$dataBlockMailStateTrackingRequestItem instanceof \AisFssp\StructType\MailStateTrackingRequest) {
                throw new \InvalidArgumentException(sprintf('The MailStateTrackingRequest property can only contain items of \AisFssp\StructType\MailStateTrackingRequest, "%s" given', is_object($dataBlockMailStateTrackingRequestItem) ? get_class($dataBlockMailStateTrackingRequestItem) : gettype($dataBlockMailStateTrackingRequestItem)), __LINE__);
            }
        }
        $this->MailStateTrackingRequest = $mailStateTrackingRequest;
        return $this;
    }
    /**
     * Add item to MailStateTrackingRequest value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\MailStateTrackingRequest $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToMailStateTrackingRequest(\AisFssp\StructType\MailStateTrackingRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\MailStateTrackingRequest) {
            throw new \InvalidArgumentException(sprintf('The MailStateTrackingRequest property can only contain items of \AisFssp\StructType\MailStateTrackingRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MailStateTrackingRequest[] = $item;
        return $this;
    }
    /**
     * Get MailState value
     * @return \AisFssp\StructType\MailState[]|null
     */
    public function getMailState()
    {
        return $this->MailState;
    }
    /**
     * Set MailState value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\MailState[] $mailState
     * @return \AisFssp\StructType\DataBlock
     */
    public function setMailState(array $mailState = array())
    {
        foreach ($mailState as $dataBlockMailStateItem) {
            // validation for constraint: itemType
            if (!$dataBlockMailStateItem instanceof \AisFssp\StructType\MailState) {
                throw new \InvalidArgumentException(sprintf('The MailState property can only contain items of \AisFssp\StructType\MailState, "%s" given', is_object($dataBlockMailStateItem) ? get_class($dataBlockMailStateItem) : gettype($dataBlockMailStateItem)), __LINE__);
            }
        }
        $this->MailState = $mailState;
        return $this;
    }
    /**
     * Add item to MailState value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\MailState $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToMailState(\AisFssp\StructType\MailState $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\MailState) {
            throw new \InvalidArgumentException(sprintf('The MailState property can only contain items of \AisFssp\StructType\MailState, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MailState[] = $item;
        return $this;
    }
    /**
     * Get IncomingForcedExecDocument value
     * @return \AisFssp\StructType\IncomingForcedExecDocument[]|null
     */
    public function getIncomingForcedExecDocument()
    {
        return $this->IncomingForcedExecDocument;
    }
    /**
     * Set IncomingForcedExecDocument value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IncomingForcedExecDocument[] $incomingForcedExecDocument
     * @return \AisFssp\StructType\DataBlock
     */
    public function setIncomingForcedExecDocument(array $incomingForcedExecDocument = array())
    {
        foreach ($incomingForcedExecDocument as $dataBlockIncomingForcedExecDocumentItem) {
            // validation for constraint: itemType
            if (!$dataBlockIncomingForcedExecDocumentItem instanceof \AisFssp\StructType\IncomingForcedExecDocument) {
                throw new \InvalidArgumentException(sprintf('The IncomingForcedExecDocument property can only contain items of \AisFssp\StructType\IncomingForcedExecDocument, "%s" given', is_object($dataBlockIncomingForcedExecDocumentItem) ? get_class($dataBlockIncomingForcedExecDocumentItem) : gettype($dataBlockIncomingForcedExecDocumentItem)), __LINE__);
            }
        }
        $this->IncomingForcedExecDocument = $incomingForcedExecDocument;
        return $this;
    }
    /**
     * Add item to IncomingForcedExecDocument value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IncomingForcedExecDocument $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToIncomingForcedExecDocument(\AisFssp\StructType\IncomingForcedExecDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\IncomingForcedExecDocument) {
            throw new \InvalidArgumentException(sprintf('The IncomingForcedExecDocument property can only contain items of \AisFssp\StructType\IncomingForcedExecDocument, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IncomingForcedExecDocument[] = $item;
        return $this;
    }
    /**
     * Get OutgoingForcedExecDocument value
     * @return \AisFssp\StructType\OutgoingForcedExecDocument[]|null
     */
    public function getOutgoingForcedExecDocument()
    {
        return $this->OutgoingForcedExecDocument;
    }
    /**
     * Set OutgoingForcedExecDocument value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\OutgoingForcedExecDocument[] $outgoingForcedExecDocument
     * @return \AisFssp\StructType\DataBlock
     */
    public function setOutgoingForcedExecDocument(array $outgoingForcedExecDocument = array())
    {
        foreach ($outgoingForcedExecDocument as $dataBlockOutgoingForcedExecDocumentItem) {
            // validation for constraint: itemType
            if (!$dataBlockOutgoingForcedExecDocumentItem instanceof \AisFssp\StructType\OutgoingForcedExecDocument) {
                throw new \InvalidArgumentException(sprintf('The OutgoingForcedExecDocument property can only contain items of \AisFssp\StructType\OutgoingForcedExecDocument, "%s" given', is_object($dataBlockOutgoingForcedExecDocumentItem) ? get_class($dataBlockOutgoingForcedExecDocumentItem) : gettype($dataBlockOutgoingForcedExecDocumentItem)), __LINE__);
            }
        }
        $this->OutgoingForcedExecDocument = $outgoingForcedExecDocument;
        return $this;
    }
    /**
     * Add item to OutgoingForcedExecDocument value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\OutgoingForcedExecDocument $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToOutgoingForcedExecDocument(\AisFssp\StructType\OutgoingForcedExecDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\OutgoingForcedExecDocument) {
            throw new \InvalidArgumentException(sprintf('The OutgoingForcedExecDocument property can only contain items of \AisFssp\StructType\OutgoingForcedExecDocument, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OutgoingForcedExecDocument[] = $item;
        return $this;
    }
    /**
     * Get IncomingEMailMessage value
     * @return \AisFssp\StructType\IncomingEMailMessage[]|null
     */
    public function getIncomingEMailMessage()
    {
        return $this->IncomingEMailMessage;
    }
    /**
     * Set IncomingEMailMessage value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IncomingEMailMessage[] $incomingEMailMessage
     * @return \AisFssp\StructType\DataBlock
     */
    public function setIncomingEMailMessage(array $incomingEMailMessage = array())
    {
        foreach ($incomingEMailMessage as $dataBlockIncomingEMailMessageItem) {
            // validation for constraint: itemType
            if (!$dataBlockIncomingEMailMessageItem instanceof \AisFssp\StructType\IncomingEMailMessage) {
                throw new \InvalidArgumentException(sprintf('The IncomingEMailMessage property can only contain items of \AisFssp\StructType\IncomingEMailMessage, "%s" given', is_object($dataBlockIncomingEMailMessageItem) ? get_class($dataBlockIncomingEMailMessageItem) : gettype($dataBlockIncomingEMailMessageItem)), __LINE__);
            }
        }
        $this->IncomingEMailMessage = $incomingEMailMessage;
        return $this;
    }
    /**
     * Add item to IncomingEMailMessage value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IncomingEMailMessage $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToIncomingEMailMessage(\AisFssp\StructType\IncomingEMailMessage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\IncomingEMailMessage) {
            throw new \InvalidArgumentException(sprintf('The IncomingEMailMessage property can only contain items of \AisFssp\StructType\IncomingEMailMessage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IncomingEMailMessage[] = $item;
        return $this;
    }
    /**
     * Get OutgoingEMailMessage value
     * @return \AisFssp\StructType\OutgoingEMailMessage[]|null
     */
    public function getOutgoingEMailMessage()
    {
        return $this->OutgoingEMailMessage;
    }
    /**
     * Set OutgoingEMailMessage value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\OutgoingEMailMessage[] $outgoingEMailMessage
     * @return \AisFssp\StructType\DataBlock
     */
    public function setOutgoingEMailMessage(array $outgoingEMailMessage = array())
    {
        foreach ($outgoingEMailMessage as $dataBlockOutgoingEMailMessageItem) {
            // validation for constraint: itemType
            if (!$dataBlockOutgoingEMailMessageItem instanceof \AisFssp\StructType\OutgoingEMailMessage) {
                throw new \InvalidArgumentException(sprintf('The OutgoingEMailMessage property can only contain items of \AisFssp\StructType\OutgoingEMailMessage, "%s" given', is_object($dataBlockOutgoingEMailMessageItem) ? get_class($dataBlockOutgoingEMailMessageItem) : gettype($dataBlockOutgoingEMailMessageItem)), __LINE__);
            }
        }
        $this->OutgoingEMailMessage = $outgoingEMailMessage;
        return $this;
    }
    /**
     * Add item to OutgoingEMailMessage value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\OutgoingEMailMessage $item
     * @return \AisFssp\StructType\DataBlock
     */
    public function addToOutgoingEMailMessage(\AisFssp\StructType\OutgoingEMailMessage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\OutgoingEMailMessage) {
            throw new \InvalidArgumentException(sprintf('The OutgoingEMailMessage property can only contain items of \AisFssp\StructType\OutgoingEMailMessage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OutgoingEMailMessage[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\DataBlock
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DataBlock
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
