<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXSystemInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Информация о системе
 * - type: tns:DXSystemInfo
 * @subpackage Structs
 */
class DXSystemInfo extends DXBlock
{
    /**
     * The SystemName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование системы | Заголовок
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $SystemName;
    /**
     * The Organization
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об организации
     * - minOccurs: 0
     * @var \AisFssp\StructType\OrganizationEx
     */
    public $Organization;
    /**
     * The Department
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о подразделении
     * - minOccurs: 0
     * @var \AisFssp\StructType\DepartmentEx
     */
    public $Department;
    /**
     * Constructor method for DXSystemInfo
     * @uses DXSystemInfo::setSystemName()
     * @uses DXSystemInfo::setOrganization()
     * @uses DXSystemInfo::setDepartment()
     * @param string $systemName
     * @param \AisFssp\StructType\OrganizationEx $organization
     * @param \AisFssp\StructType\DepartmentEx $department
     */
    public function __construct($systemName = null, \AisFssp\StructType\OrganizationEx $organization = null, \AisFssp\StructType\DepartmentEx $department = null)
    {
        $this
            ->setSystemName($systemName)
            ->setOrganization($organization)
            ->setDepartment($department);
    }
    /**
     * Get SystemName value
     * @return string|null
     */
    public function getSystemName()
    {
        return $this->SystemName;
    }
    /**
     * Set SystemName value
     * @param string $systemName
     * @return \AisFssp\StructType\DXSystemInfo
     */
    public function setSystemName($systemName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($systemName) && strlen($systemName) > 80) || (is_array($systemName) && count($systemName) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($systemName) ? strlen($systemName) : count($systemName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($systemName) && strlen($systemName) < 1) || (is_array($systemName) && count($systemName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($systemName) && !is_string($systemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemName)), __LINE__);
        }
        $this->SystemName = $systemName;
        return $this;
    }
    /**
     * Get Organization value
     * @return \AisFssp\StructType\OrganizationEx|null
     */
    public function getOrganization()
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @param \AisFssp\StructType\OrganizationEx $organization
     * @return \AisFssp\StructType\DXSystemInfo
     */
    public function setOrganization(\AisFssp\StructType\OrganizationEx $organization = null)
    {
        $this->Organization = $organization;
        return $this;
    }
    /**
     * Get Department value
     * @return \AisFssp\StructType\DepartmentEx|null
     */
    public function getDepartment()
    {
        return $this->Department;
    }
    /**
     * Set Department value
     * @param \AisFssp\StructType\DepartmentEx $department
     * @return \AisFssp\StructType\DXSystemInfo
     */
    public function setDepartment(\AisFssp\StructType\DepartmentEx $department = null)
    {
        $this->Department = $department;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DXSystemInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
