<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXSysInfoRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос информации о системе
 * - type: tns:DXSysInfoRequest
 * @subpackage Structs
 */
class DXSysInfoRequest extends DXBlock
{
    /**
     * The Asker
     * Meta informations extracted from the WSDL
     * - documentation: Наименование внешнего контрагента, произодящего запрос | Заголовок
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $Asker;
    /**
     * Constructor method for DXSysInfoRequest
     * @uses DXSysInfoRequest::setAsker()
     * @param string $asker
     */
    public function __construct($asker = null)
    {
        $this
            ->setAsker($asker);
    }
    /**
     * Get Asker value
     * @return string|null
     */
    public function getAsker()
    {
        return $this->Asker;
    }
    /**
     * Set Asker value
     * @param string $asker
     * @return \AisFssp\StructType\DXSysInfoRequest
     */
    public function setAsker($asker = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($asker) && strlen($asker) > 80) || (is_array($asker) && count($asker) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($asker) ? strlen($asker) : count($asker)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($asker) && strlen($asker) < 1) || (is_array($asker) && count($asker) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($asker) && !is_string($asker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asker)), __LINE__);
        }
        $this->Asker = $asker;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DXSysInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
