<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXReceipt StructType
 * Meta informations extracted from the WSDL
 * - documentation: Квитанция | Квитанция на пакет документов
 * - type: tns:DXReceipt
 * @subpackage Structs
 */
class DXReceipt extends DXBlock
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Статус обработки пакета
     * @var string
     */
    public $Status;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - documentation: Информация об ошибке
     * - minOccurs: 0
     * @var \AisFssp\StructType\MessageEx
     */
    public $ErrorMessage;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - documentation: Технологические сообщения о приеме документов
     * - minOccurs: 0
     * @var \AisFssp\StructType\DocNoteCollection
     */
    public $Notes;
    /**
     * The time_src_rcv
     * Meta informations extracted from the WSDL
     * - documentation: Дата в время приема пакета | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $time_src_rcv;
    /**
     * The recipient_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор пакета (получателя) | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $recipient_id;
    /**
     * The origin_pack_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор исходного пакета | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $origin_pack_id;
    /**
     * The is_completed
     * Meta informations extracted from the WSDL
     * - documentation: Признак окончательной квитанции | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $is_completed;
    /**
     * Constructor method for DXReceipt
     * @uses DXReceipt::setStatus()
     * @uses DXReceipt::setErrorMessage()
     * @uses DXReceipt::setNotes()
     * @uses DXReceipt::setTime_src_rcv()
     * @uses DXReceipt::setRecipient_id()
     * @uses DXReceipt::setOrigin_pack_id()
     * @uses DXReceipt::setIs_completed()
     * @param string $status
     * @param \AisFssp\StructType\MessageEx $errorMessage
     * @param \AisFssp\StructType\DocNoteCollection $notes
     * @param string $time_src_rcv
     * @param string $recipient_id
     * @param string $origin_pack_id
     * @param bool $is_completed
     */
    public function __construct($status = null, \AisFssp\StructType\MessageEx $errorMessage = null, \AisFssp\StructType\DocNoteCollection $notes = null, $time_src_rcv = null, $recipient_id = null, $origin_pack_id = null, $is_completed = null)
    {
        $this
            ->setStatus($status)
            ->setErrorMessage($errorMessage)
            ->setNotes($notes)
            ->setTime_src_rcv($time_src_rcv)
            ->setRecipient_id($recipient_id)
            ->setOrigin_pack_id($origin_pack_id)
            ->setIs_completed($is_completed);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \AisFssp\EnumType\ProcessResult::valueIsValid()
     * @uses \AisFssp\EnumType\ProcessResult::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \AisFssp\StructType\DXReceipt
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ProcessResult::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \AisFssp\EnumType\ProcessResult::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return \AisFssp\StructType\MessageEx|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param \AisFssp\StructType\MessageEx $errorMessage
     * @return \AisFssp\StructType\DXReceipt
     */
    public function setErrorMessage(\AisFssp\StructType\MessageEx $errorMessage = null)
    {
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get Notes value
     * @return \AisFssp\StructType\DocNoteCollection|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param \AisFssp\StructType\DocNoteCollection $notes
     * @return \AisFssp\StructType\DXReceipt
     */
    public function setNotes(\AisFssp\StructType\DocNoteCollection $notes = null)
    {
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get time_src_rcv value
     * @return string|null
     */
    public function getTime_src_rcv()
    {
        return $this->time_src_rcv;
    }
    /**
     * Set time_src_rcv value
     * @param string $time_src_rcv
     * @return \AisFssp\StructType\DXReceipt
     */
    public function setTime_src_rcv($time_src_rcv = null)
    {
        // validation for constraint: maxExclusive
        if ($time_src_rcv >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $time_src_rcv), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($time_src_rcv < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $time_src_rcv), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($time_src_rcv) && !is_string($time_src_rcv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time_src_rcv)), __LINE__);
        }
        $this->time_src_rcv = $time_src_rcv;
        return $this;
    }
    /**
     * Get recipient_id value
     * @return string|null
     */
    public function getRecipient_id()
    {
        return $this->recipient_id;
    }
    /**
     * Set recipient_id value
     * @param string $recipient_id
     * @return \AisFssp\StructType\DXReceipt
     */
    public function setRecipient_id($recipient_id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($recipient_id) && strlen($recipient_id) > 60) || (is_array($recipient_id) && count($recipient_id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($recipient_id) ? strlen($recipient_id) : count($recipient_id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($recipient_id) && strlen($recipient_id) < 1) || (is_array($recipient_id) && count($recipient_id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($recipient_id) && !is_string($recipient_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipient_id)), __LINE__);
        }
        $this->recipient_id = $recipient_id;
        return $this;
    }
    /**
     * Get origin_pack_id value
     * @return string|null
     */
    public function getOrigin_pack_id()
    {
        return $this->origin_pack_id;
    }
    /**
     * Set origin_pack_id value
     * @param string $origin_pack_id
     * @return \AisFssp\StructType\DXReceipt
     */
    public function setOrigin_pack_id($origin_pack_id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($origin_pack_id) && strlen($origin_pack_id) > 60) || (is_array($origin_pack_id) && count($origin_pack_id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($origin_pack_id) ? strlen($origin_pack_id) : count($origin_pack_id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($origin_pack_id) && strlen($origin_pack_id) < 1) || (is_array($origin_pack_id) && count($origin_pack_id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($origin_pack_id) && !is_string($origin_pack_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($origin_pack_id)), __LINE__);
        }
        $this->origin_pack_id = $origin_pack_id;
        return $this;
    }
    /**
     * Get is_completed value
     * @return bool|null
     */
    public function getIs_completed()
    {
        return $this->is_completed;
    }
    /**
     * Set is_completed value
     * @param bool $is_completed
     * @return \AisFssp\StructType\DXReceipt
     */
    public function setIs_completed($is_completed = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_completed) && !is_bool($is_completed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($is_completed)), __LINE__);
        }
        $this->is_completed = $is_completed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DXReceipt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
