<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXPutDocument StructType
 * Meta informations extracted from the WSDL
 * - documentation: Дополнительные атрибуты документов
 * - type: tns:DXPutDocument
 * @subpackage Structs
 */
class DXPutDocument extends DXEnvBlock
{
    /**
     * The DocumentAttrs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:DocumentAttrs
     * @var \AisFssp\StructType\DocumentAttrs
     */
    public $DocumentAttrs;
    /**
     * The Document
     * @var \AisFssp\StructType\DocumentContainer
     */
    public $Document;
    /**
     * Constructor method for DXPutDocument
     * @uses DXPutDocument::setDocumentAttrs()
     * @uses DXPutDocument::setDocument()
     * @param \AisFssp\StructType\DocumentAttrs $documentAttrs
     * @param \AisFssp\StructType\DocumentContainer $document
     */
    public function __construct(\AisFssp\StructType\DocumentAttrs $documentAttrs = null, \AisFssp\StructType\DocumentContainer $document = null)
    {
        $this
            ->setDocumentAttrs($documentAttrs)
            ->setDocument($document);
    }
    /**
     * Get DocumentAttrs value
     * @return \AisFssp\StructType\DocumentAttrs|null
     */
    public function getDocumentAttrs()
    {
        return $this->DocumentAttrs;
    }
    /**
     * Set DocumentAttrs value
     * @param \AisFssp\StructType\DocumentAttrs $documentAttrs
     * @return \AisFssp\StructType\DXPutDocument
     */
    public function setDocumentAttrs(\AisFssp\StructType\DocumentAttrs $documentAttrs = null)
    {
        $this->DocumentAttrs = $documentAttrs;
        return $this;
    }
    /**
     * Get Document value
     * @return \AisFssp\StructType\DocumentContainer|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param \AisFssp\StructType\DocumentContainer $document
     * @return \AisFssp\StructType\DXPutDocument
     */
    public function setDocument(\AisFssp\StructType\DocumentContainer $document = null)
    {
        $this->Document = $document;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DXPutDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
