<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXPack StructType
 * Meta informations extracted from the WSDL
 * - documentation: Пакет документов
 * - type: tns:DXPack
 * @subpackage Structs
 */
class DXPack extends DXBlock
{
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата создания пакета документов | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер пакета документов в документообороте | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The Generation
     * Meta informations extracted from the WSDL
     * - documentation: Номер поколения | Номер поколения пакета
     * - minOccurs: 0
     * @var int
     */
    public $Generation;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - documentation: Приоритет пакета
     * - minOccurs: 0
     * @var string
     */
    public $Priority;
    /**
     * The Signed
     * Meta informations extracted from the WSDL
     * - documentation: Подписал
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $Signed;
    /**
     * The Documents
     * @var \AisFssp\StructType\Documents
     */
    public $Documents;
    /**
     * The Envelopes
     * @var \AisFssp\StructType\Envelopes
     */
    public $Envelopes;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - documentation: Технологические сообщения протокола обмена данными
     * - minOccurs: 0
     * @var \AisFssp\StructType\DocNoteCollection
     */
    public $Notes;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType
     */
    public $Signature;
    /**
     * The origin_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор создателя пакета | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $origin_id;
    /**
     * The time_created
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время создания пакета | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $time_created;
    /**
     * The time_queued
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время постановки пакета в очередь | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $time_queued;
    /**
     * The reset
     * Meta informations extracted from the WSDL
     * - documentation: Признак необходимости произвести полную или частичную перезапись пакета получателем | Обертка стандартного xs:boolean |
     * Логический
     * @var bool
     */
    public $reset;
    /**
     * Constructor method for DXPack
     * @uses DXPack::setDocDate()
     * @uses DXPack::setDocNumber()
     * @uses DXPack::setGeneration()
     * @uses DXPack::setPriority()
     * @uses DXPack::setSigned()
     * @uses DXPack::setDocuments()
     * @uses DXPack::setEnvelopes()
     * @uses DXPack::setNotes()
     * @uses DXPack::setSignature()
     * @uses DXPack::setOrigin_id()
     * @uses DXPack::setTime_created()
     * @uses DXPack::setTime_queued()
     * @uses DXPack::setReset()
     * @param string $docDate
     * @param string $docNumber
     * @param int $generation
     * @param string $priority
     * @param string $signed
     * @param \AisFssp\StructType\Documents $documents
     * @param \AisFssp\StructType\Envelopes $envelopes
     * @param \AisFssp\StructType\DocNoteCollection $notes
     * @param \AisFssp\StructType\SignatureType $signature
     * @param string $origin_id
     * @param string $time_created
     * @param string $time_queued
     * @param bool $reset
     */
    public function __construct($docDate = null, $docNumber = null, $generation = null, $priority = null, $signed = null, \AisFssp\StructType\Documents $documents = null, \AisFssp\StructType\Envelopes $envelopes = null, \AisFssp\StructType\DocNoteCollection $notes = null, \AisFssp\StructType\SignatureType $signature = null, $origin_id = null, $time_created = null, $time_queued = null, $reset = null)
    {
        $this
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setGeneration($generation)
            ->setPriority($priority)
            ->setSigned($signed)
            ->setDocuments($documents)
            ->setEnvelopes($envelopes)
            ->setNotes($notes)
            ->setSignature($signature)
            ->setOrigin_id($origin_id)
            ->setTime_created($time_created)
            ->setTime_queued($time_queued)
            ->setReset($reset);
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\DXPack
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\DXPack
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get Generation value
     * @return int|null
     */
    public function getGeneration()
    {
        return $this->Generation;
    }
    /**
     * Set Generation value
     * @param int $generation
     * @return \AisFssp\StructType\DXPack
     */
    public function setGeneration($generation = null)
    {
        // validation for constraint: int
        if (!is_null($generation) && !is_numeric($generation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($generation)), __LINE__);
        }
        $this->Generation = $generation;
        return $this;
    }
    /**
     * Get Priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @uses \AisFssp\EnumType\Priority::valueIsValid()
     * @uses \AisFssp\EnumType\Priority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \AisFssp\StructType\DXPack
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\Priority::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priority, implode(', ', \AisFssp\EnumType\Priority::getValidValues())), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get Signed value
     * @return string|null
     */
    public function getSigned()
    {
        return $this->Signed;
    }
    /**
     * Set Signed value
     * @param string $signed
     * @return \AisFssp\StructType\DXPack
     */
    public function setSigned($signed = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($signed) && strlen($signed) > 100) || (is_array($signed) && count($signed) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($signed) ? strlen($signed) : count($signed)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($signed) && strlen($signed) < 1) || (is_array($signed) && count($signed) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signed) && !is_string($signed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signed)), __LINE__);
        }
        $this->Signed = $signed;
        return $this;
    }
    /**
     * Get Documents value
     * @return \AisFssp\StructType\Documents|null
     */
    public function getDocuments()
    {
        return $this->Documents;
    }
    /**
     * Set Documents value
     * @param \AisFssp\StructType\Documents $documents
     * @return \AisFssp\StructType\DXPack
     */
    public function setDocuments(\AisFssp\StructType\Documents $documents = null)
    {
        $this->Documents = $documents;
        return $this;
    }
    /**
     * Get Envelopes value
     * @return \AisFssp\StructType\Envelopes|null
     */
    public function getEnvelopes()
    {
        return $this->Envelopes;
    }
    /**
     * Set Envelopes value
     * @param \AisFssp\StructType\Envelopes $envelopes
     * @return \AisFssp\StructType\DXPack
     */
    public function setEnvelopes(\AisFssp\StructType\Envelopes $envelopes = null)
    {
        $this->Envelopes = $envelopes;
        return $this;
    }
    /**
     * Get Notes value
     * @return \AisFssp\StructType\DocNoteCollection|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param \AisFssp\StructType\DocNoteCollection $notes
     * @return \AisFssp\StructType\DXPack
     */
    public function setNotes(\AisFssp\StructType\DocNoteCollection $notes = null)
    {
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param \AisFssp\StructType\SignatureType $signature
     * @return \AisFssp\StructType\DXPack
     */
    public function setSignature(\AisFssp\StructType\SignatureType $signature = null)
    {
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Get origin_id value
     * @return string|null
     */
    public function getOrigin_id()
    {
        return $this->origin_id;
    }
    /**
     * Set origin_id value
     * @param string $origin_id
     * @return \AisFssp\StructType\DXPack
     */
    public function setOrigin_id($origin_id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($origin_id) && strlen($origin_id) > 60) || (is_array($origin_id) && count($origin_id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($origin_id) ? strlen($origin_id) : count($origin_id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($origin_id) && strlen($origin_id) < 1) || (is_array($origin_id) && count($origin_id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($origin_id) && !is_string($origin_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($origin_id)), __LINE__);
        }
        $this->origin_id = $origin_id;
        return $this;
    }
    /**
     * Get time_created value
     * @return string|null
     */
    public function getTime_created()
    {
        return $this->time_created;
    }
    /**
     * Set time_created value
     * @param string $time_created
     * @return \AisFssp\StructType\DXPack
     */
    public function setTime_created($time_created = null)
    {
        // validation for constraint: maxExclusive
        if ($time_created >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $time_created), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($time_created < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $time_created), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($time_created) && !is_string($time_created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time_created)), __LINE__);
        }
        $this->time_created = $time_created;
        return $this;
    }
    /**
     * Get time_queued value
     * @return string|null
     */
    public function getTime_queued()
    {
        return $this->time_queued;
    }
    /**
     * Set time_queued value
     * @param string $time_queued
     * @return \AisFssp\StructType\DXPack
     */
    public function setTime_queued($time_queued = null)
    {
        // validation for constraint: maxExclusive
        if ($time_queued >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $time_queued), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($time_queued < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $time_queued), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($time_queued) && !is_string($time_queued)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time_queued)), __LINE__);
        }
        $this->time_queued = $time_queued;
        return $this;
    }
    /**
     * Get reset value
     * @return bool|null
     */
    public function getReset()
    {
        return $this->reset;
    }
    /**
     * Set reset value
     * @param bool $reset
     * @return \AisFssp\StructType\DXPack
     */
    public function setReset($reset = null)
    {
        // validation for constraint: boolean
        if (!is_null($reset) && !is_bool($reset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($reset)), __LINE__);
        }
        $this->reset = $reset;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DXPack
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
