<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXNotifyDocument StructType
 * Meta informations extracted from the WSDL
 * - type: tns:DXNotifyDocument
 * @subpackage Structs
 */
class DXNotifyDocument extends DXEnvBlock
{
    /**
     * The Event
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Наименование события документооборота
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $Event;
    /**
     * Constructor method for DXNotifyDocument
     * @uses DXNotifyDocument::setEvent()
     * @param string $event
     */
    public function __construct($event = null)
    {
        $this
            ->setEvent($event);
    }
    /**
     * Get Event value
     * @return string|null
     */
    public function getEvent()
    {
        return $this->Event;
    }
    /**
     * Set Event value
     * @param string $event
     * @return \AisFssp\StructType\DXNotifyDocument
     */
    public function setEvent($event = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($event) && strlen($event) > 80) || (is_array($event) && count($event) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($event) ? strlen($event) : count($event)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($event) && strlen($event) < 1) || (is_array($event) && count($event) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($event) && !is_string($event)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($event)), __LINE__);
        }
        $this->Event = $event;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DXNotifyDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
