<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXEnvBlock StructType
 * @subpackage Structs
 */
class DXEnvBlock extends DXBlock
{
    /**
     * The env_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор конверта | Идентификатор объекта | Атрибут документа
     * - use: required
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $env_id;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The doc_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа отправителя документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $doc_id;
    /**
     * The doc_type
     * Meta informations extracted from the WSDL
     * - documentation: Код типа документа отправителя документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного
     * документооборота | NSI_Document | Наименование объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $doc_type;
    /**
     * Constructor method for DXEnvBlock
     * @uses DXEnvBlock::setEnv_id()
     * @uses DXEnvBlock::setDocNumber()
     * @uses DXEnvBlock::setDocDate()
     * @uses DXEnvBlock::setDoc_id()
     * @uses DXEnvBlock::setDoc_type()
     * @param string $env_id
     * @param string $docNumber
     * @param string $docDate
     * @param string $doc_id
     * @param string $doc_type
     */
    public function __construct($env_id = null, $docNumber = null, $docDate = null, $doc_id = null, $doc_type = null)
    {
        $this
            ->setEnv_id($env_id)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setDoc_id($doc_id)
            ->setDoc_type($doc_type);
    }
    /**
     * Get env_id value
     * @return string
     */
    public function getEnv_id()
    {
        return $this->env_id;
    }
    /**
     * Set env_id value
     * @param string $env_id
     * @return \AisFssp\StructType\DXEnvBlock
     */
    public function setEnv_id($env_id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($env_id) && strlen($env_id) > 60) || (is_array($env_id) && count($env_id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($env_id) ? strlen($env_id) : count($env_id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($env_id) && strlen($env_id) < 1) || (is_array($env_id) && count($env_id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($env_id) && !is_string($env_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($env_id)), __LINE__);
        }
        $this->env_id = $env_id;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\DXEnvBlock
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\DXEnvBlock
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get doc_id value
     * @return string|null
     */
    public function getDoc_id()
    {
        return $this->doc_id;
    }
    /**
     * Set doc_id value
     * @param string $doc_id
     * @return \AisFssp\StructType\DXEnvBlock
     */
    public function setDoc_id($doc_id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($doc_id) && strlen($doc_id) > 60) || (is_array($doc_id) && count($doc_id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($doc_id) ? strlen($doc_id) : count($doc_id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($doc_id) && strlen($doc_id) < 1) || (is_array($doc_id) && count($doc_id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($doc_id) && !is_string($doc_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($doc_id)), __LINE__);
        }
        $this->doc_id = $doc_id;
        return $this;
    }
    /**
     * Get doc_type value
     * @return string|null
     */
    public function getDoc_type()
    {
        return $this->doc_type;
    }
    /**
     * Set doc_type value
     * @param string $doc_type
     * @return \AisFssp\StructType\DXEnvBlock
     */
    public function setDoc_type($doc_type = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($doc_type) && strlen($doc_type) > 1) || (is_array($doc_type) && count($doc_type) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($doc_type) ? strlen($doc_type) : count($doc_type)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($doc_type) && strlen($doc_type) < 1) || (is_array($doc_type) && count($doc_type) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($doc_type) && !is_string($doc_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($doc_type)), __LINE__);
        }
        $this->doc_type = $doc_type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DXEnvBlock
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
