<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXBlock StructType
 * Meta informations extracted from the WSDL
 * - documentation: Служебный блок
 * @subpackage Structs
 */
abstract class DXBlock extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: Уникальный идентификатор блока | Идентификатор объекта | Атрибут документа
     * - use: required
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $id;
    /**
     * The time_sent
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время включения блока в корневое сообщение протокола | Дата и время | Дата и время
     * - use: required
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $time_sent;
    /**
     * The Direction
     * Meta informations extracted from the WSDL
     * - documentation: Адреса отправителя и получателя блока. При обмене данными через СМЭВ без использования подразделений может не заполняться
     * - minOccurs: 0
     * @var \AisFssp\StructType\Direction
     */
    public $Direction;
    /**
     * The session_id
     * Meta informations extracted from the WSDL
     * - documentation: Номер сессии | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $session_id;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - documentation: Последовательный номер сообщения в сессии | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $sequence;
    /**
     * The reply_to_type
     * Meta informations extracted from the WSDL
     * - documentation: Тип блока, на который данный блок является ответом
     * @var string
     */
    public $reply_to_type;
    /**
     * The reply_to
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор блока, на который данный блок является ответом | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $reply_to;
    /**
     * Constructor method for DXBlock
     * @uses DXBlock::setId()
     * @uses DXBlock::setTime_sent()
     * @uses DXBlock::setDirection()
     * @uses DXBlock::setSession_id()
     * @uses DXBlock::setSequence()
     * @uses DXBlock::setReply_to_type()
     * @uses DXBlock::setReply_to()
     * @param string $id
     * @param string $time_sent
     * @param \AisFssp\StructType\Direction $direction
     * @param string $session_id
     * @param int $sequence
     * @param string $reply_to_type
     * @param string $reply_to
     */
    public function __construct($id = null, $time_sent = null, \AisFssp\StructType\Direction $direction = null, $session_id = null, $sequence = null, $reply_to_type = null, $reply_to = null)
    {
        $this
            ->setId($id)
            ->setTime_sent($time_sent)
            ->setDirection($direction)
            ->setSession_id($session_id)
            ->setSequence($sequence)
            ->setReply_to_type($reply_to_type)
            ->setReply_to($reply_to);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \AisFssp\StructType\DXBlock
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get time_sent value
     * @return string
     */
    public function getTime_sent()
    {
        return $this->time_sent;
    }
    /**
     * Set time_sent value
     * @param string $time_sent
     * @return \AisFssp\StructType\DXBlock
     */
    public function setTime_sent($time_sent = null)
    {
        // validation for constraint: maxExclusive
        if ($time_sent >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $time_sent), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($time_sent < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $time_sent), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($time_sent) && !is_string($time_sent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time_sent)), __LINE__);
        }
        $this->time_sent = $time_sent;
        return $this;
    }
    /**
     * Get Direction value
     * @return \AisFssp\StructType\Direction|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param \AisFssp\StructType\Direction $direction
     * @return \AisFssp\StructType\DXBlock
     */
    public function setDirection(\AisFssp\StructType\Direction $direction = null)
    {
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get session_id value
     * @return string|null
     */
    public function getSession_id()
    {
        return $this->session_id;
    }
    /**
     * Set session_id value
     * @param string $session_id
     * @return \AisFssp\StructType\DXBlock
     */
    public function setSession_id($session_id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($session_id) && strlen($session_id) > 60) || (is_array($session_id) && count($session_id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($session_id) ? strlen($session_id) : count($session_id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($session_id) && strlen($session_id) < 1) || (is_array($session_id) && count($session_id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($session_id) && !is_string($session_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($session_id)), __LINE__);
        }
        $this->session_id = $session_id;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \AisFssp\StructType\DXBlock
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: maxInclusive
        if ($sequence > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $sequence), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Get reply_to_type value
     * @return string|null
     */
    public function getReply_to_type()
    {
        return $this->reply_to_type;
    }
    /**
     * Set reply_to_type value
     * @uses \AisFssp\EnumType\BlockType::valueIsValid()
     * @uses \AisFssp\EnumType\BlockType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reply_to_type
     * @return \AisFssp\StructType\DXBlock
     */
    public function setReply_to_type($reply_to_type = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\BlockType::valueIsValid($reply_to_type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $reply_to_type, implode(', ', \AisFssp\EnumType\BlockType::getValidValues())), __LINE__);
        }
        $this->reply_to_type = $reply_to_type;
        return $this;
    }
    /**
     * Get reply_to value
     * @return string|null
     */
    public function getReply_to()
    {
        return $this->reply_to;
    }
    /**
     * Set reply_to value
     * @param string $reply_to
     * @return \AisFssp\StructType\DXBlock
     */
    public function setReply_to($reply_to = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($reply_to) && strlen($reply_to) > 60) || (is_array($reply_to) && count($reply_to) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($reply_to) ? strlen($reply_to) : count($reply_to)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($reply_to) && strlen($reply_to) < 1) || (is_array($reply_to) && count($reply_to) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($reply_to) && !is_string($reply_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reply_to)), __LINE__);
        }
        $this->reply_to = $reply_to;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DXBlock
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
