<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyManagementDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о физ. лицах, имеющих право без доверенности действовать от имени юр. лица
 * @subpackage Structs
 */
class CompanyManagementDatumType extends PersonDatumType
{
    /**
     * The position
     * Meta informations extracted from the WSDL
     * - documentation: Должность | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $position;
    /**
     * Constructor method for CompanyManagementDatumType
     * @uses CompanyManagementDatumType::setPosition()
     * @param string $position
     */
    public function __construct($position = null)
    {
        $this
            ->setPosition($position);
    }
    /**
     * Get position value
     * @return string|null
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * Set position value
     * @param string $position
     * @return \AisFssp\StructType\CompanyManagementDatumType
     */
    public function setPosition($position = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($position) && strlen($position) > 255) || (is_array($position) && count($position) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($position) ? strlen($position) : count($position)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($position) && strlen($position) < 1) || (is_array($position) && count($position) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($position) && !is_string($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($position)), __LINE__);
        }
        $this->position = $position;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\CompanyManagementDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
