<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyExtDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Расширенные сведения о юридическом лице
 * @subpackage Structs
 */
class CompanyExtDatumType extends CompanyDatumType
{
    /**
     * The documentId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа ФНС | Идентификатор документа в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 9
     * @var int
     */
    public $documentId;
    /**
     * The OKVED
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о видах экономической деятельности
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\OkvedDetailType[]
     */
    public $OKVED;
    /**
     * The statusId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор состояния юридического лица | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $statusId;
    /**
     * The nameActDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата внесения записи со сведениями о наименовании в ЕГРЮЛ | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $nameActDate;
    /**
     * The shortName
     * Meta informations extracted from the WSDL
     * - documentation: Сокращенное наименование юридического лица | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $shortName;
    /**
     * The brandName
     * Meta informations extracted from the WSDL
     * - documentation: Фирменное наименование юридического лица | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $brandName;
    /**
     * The nationalName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование на национальном языке | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $nationalName;
    /**
     * The nationalLangId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор национального языка | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $nationalLangId;
    /**
     * The nationalLangCode
     * Meta informations extracted from the WSDL
     * - documentation: Код национального языка | Код языка | По общероссийскому классификатору ОКИН
     * - minOccurs: 0
     * - length: 3
     * - pattern: [0-9]{3}
     * @var string
     */
    public $nationalLangCode;
    /**
     * The nationalLangName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование национального языка | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $nationalLangName;
    /**
     * The foreignName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование на иностранном языке | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $foreignName;
    /**
     * The foreignLangId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор иностранного языка | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $foreignLangId;
    /**
     * The foreignLangCode
     * Meta informations extracted from the WSDL
     * - documentation: Код иностранного языка | Код языка | По общероссийскому классификатору ОКИН
     * - minOccurs: 0
     * - length: 3
     * - pattern: [0-9]{3}
     * @var string
     */
    public $foreignLangCode;
    /**
     * The foreignLandName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование иностранного языка | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $foreignLandName;
    /**
     * The capitalActDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата сведений о капитале в ЕГРЮЛ | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $capitalActDate;
    /**
     * The capitalAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма капитала | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $capitalAmount;
    /**
     * The capitalKindId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор вида капитал | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $capitalKindId;
    /**
     * The capitalKindName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида капитала | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $capitalKindName;
    /**
     * The foundRegNum
     * Meta informations extracted from the WSDL
     * - documentation: ОГРН или регистрационный номер для юридических лиц, созданных до 01.07.2002 | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $foundRegNum;
    /**
     * The foundRegKindId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор вида регистрации сведений об образовании юридического лица | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $foundRegKindId;
    /**
     * The foundRegKindName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида регистрации сведений об образовании юридического лица | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $foundRegKindName;
    /**
     * The closureRegNum
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер прекращения деятельности | Строка длиной от 1 до 13 символов
     * - minOccurs: 0
     * - maxLength: 13
     * - minLength: 1
     * @var string
     */
    public $closureRegNum;
    /**
     * The closureDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации прекращения деятельности | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $closureDate;
    /**
     * The closureRegKindId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор способа прекращения деятельности (вид регистрации) | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $closureRegKindId;
    /**
     * The closureRegKindName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование способа прекращения деятельности (вид регистрации) | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $closureRegKindName;
    /**
     * The founderCompanyCount
     * Meta informations extracted from the WSDL
     * - documentation: Количество учредителей — российских юридических лиц | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $founderCompanyCount;
    /**
     * The founderForeignCompanyCount
     * Meta informations extracted from the WSDL
     * - documentation: Количество учредителей — иностранных юридических лиц | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $founderForeignCompanyCount;
    /**
     * The founderPersonCount
     * Meta informations extracted from the WSDL
     * - documentation: Количество учредителей — физических лиц | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $founderPersonCount;
    /**
     * Constructor method for CompanyExtDatumType
     * @uses CompanyExtDatumType::setDocumentId()
     * @uses CompanyExtDatumType::setOKVED()
     * @uses CompanyExtDatumType::setStatusId()
     * @uses CompanyExtDatumType::setNameActDate()
     * @uses CompanyExtDatumType::setShortName()
     * @uses CompanyExtDatumType::setBrandName()
     * @uses CompanyExtDatumType::setNationalName()
     * @uses CompanyExtDatumType::setNationalLangId()
     * @uses CompanyExtDatumType::setNationalLangCode()
     * @uses CompanyExtDatumType::setNationalLangName()
     * @uses CompanyExtDatumType::setForeignName()
     * @uses CompanyExtDatumType::setForeignLangId()
     * @uses CompanyExtDatumType::setForeignLangCode()
     * @uses CompanyExtDatumType::setForeignLandName()
     * @uses CompanyExtDatumType::setCapitalActDate()
     * @uses CompanyExtDatumType::setCapitalAmount()
     * @uses CompanyExtDatumType::setCapitalKindId()
     * @uses CompanyExtDatumType::setCapitalKindName()
     * @uses CompanyExtDatumType::setFoundRegNum()
     * @uses CompanyExtDatumType::setFoundRegKindId()
     * @uses CompanyExtDatumType::setFoundRegKindName()
     * @uses CompanyExtDatumType::setClosureRegNum()
     * @uses CompanyExtDatumType::setClosureDate()
     * @uses CompanyExtDatumType::setClosureRegKindId()
     * @uses CompanyExtDatumType::setClosureRegKindName()
     * @uses CompanyExtDatumType::setFounderCompanyCount()
     * @uses CompanyExtDatumType::setFounderForeignCompanyCount()
     * @uses CompanyExtDatumType::setFounderPersonCount()
     * @param int $documentId
     * @param \AisFssp\StructType\OkvedDetailType[] $oKVED
     * @param int $statusId
     * @param string $nameActDate
     * @param string $shortName
     * @param string $brandName
     * @param string $nationalName
     * @param int $nationalLangId
     * @param string $nationalLangCode
     * @param string $nationalLangName
     * @param string $foreignName
     * @param int $foreignLangId
     * @param string $foreignLangCode
     * @param string $foreignLandName
     * @param string $capitalActDate
     * @param float $capitalAmount
     * @param int $capitalKindId
     * @param string $capitalKindName
     * @param string $foundRegNum
     * @param int $foundRegKindId
     * @param string $foundRegKindName
     * @param string $closureRegNum
     * @param string $closureDate
     * @param int $closureRegKindId
     * @param string $closureRegKindName
     * @param int $founderCompanyCount
     * @param int $founderForeignCompanyCount
     * @param int $founderPersonCount
     */
    public function __construct($documentId = null, array $oKVED = array(), $statusId = null, $nameActDate = null, $shortName = null, $brandName = null, $nationalName = null, $nationalLangId = null, $nationalLangCode = null, $nationalLangName = null, $foreignName = null, $foreignLangId = null, $foreignLangCode = null, $foreignLandName = null, $capitalActDate = null, $capitalAmount = null, $capitalKindId = null, $capitalKindName = null, $foundRegNum = null, $foundRegKindId = null, $foundRegKindName = null, $closureRegNum = null, $closureDate = null, $closureRegKindId = null, $closureRegKindName = null, $founderCompanyCount = null, $founderForeignCompanyCount = null, $founderPersonCount = null)
    {
        $this
            ->setDocumentId($documentId)
            ->setOKVED($oKVED)
            ->setStatusId($statusId)
            ->setNameActDate($nameActDate)
            ->setShortName($shortName)
            ->setBrandName($brandName)
            ->setNationalName($nationalName)
            ->setNationalLangId($nationalLangId)
            ->setNationalLangCode($nationalLangCode)
            ->setNationalLangName($nationalLangName)
            ->setForeignName($foreignName)
            ->setForeignLangId($foreignLangId)
            ->setForeignLangCode($foreignLangCode)
            ->setForeignLandName($foreignLandName)
            ->setCapitalActDate($capitalActDate)
            ->setCapitalAmount($capitalAmount)
            ->setCapitalKindId($capitalKindId)
            ->setCapitalKindName($capitalKindName)
            ->setFoundRegNum($foundRegNum)
            ->setFoundRegKindId($foundRegKindId)
            ->setFoundRegKindName($foundRegKindName)
            ->setClosureRegNum($closureRegNum)
            ->setClosureDate($closureDate)
            ->setClosureRegKindId($closureRegKindId)
            ->setClosureRegKindName($closureRegKindName)
            ->setFounderCompanyCount($founderCompanyCount)
            ->setFounderForeignCompanyCount($founderForeignCompanyCount)
            ->setFounderPersonCount($founderPersonCount);
    }
    /**
     * Get documentId value
     * @return int|null
     */
    public function getDocumentId()
    {
        return $this->documentId;
    }
    /**
     * Set documentId value
     * @param int $documentId
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($documentId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $documentId)) !== 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 9 digits, "%d" given', strlen(substr($documentId, strpos($documentId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($documentId) && !is_numeric($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($documentId)), __LINE__);
        }
        $this->documentId = $documentId;
        return $this;
    }
    /**
     * Get OKVED value
     * @return \AisFssp\StructType\OkvedDetailType[]|null
     */
    public function getOKVED()
    {
        return $this->OKVED;
    }
    /**
     * Set OKVED value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\OkvedDetailType[] $oKVED
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setOKVED(array $oKVED = array())
    {
        foreach ($oKVED as $companyExtDatumTypeOKVEDItem) {
            // validation for constraint: itemType
            if (!$companyExtDatumTypeOKVEDItem instanceof \AisFssp\StructType\OkvedDetailType) {
                throw new \InvalidArgumentException(sprintf('The OKVED property can only contain items of \AisFssp\StructType\OkvedDetailType, "%s" given', is_object($companyExtDatumTypeOKVEDItem) ? get_class($companyExtDatumTypeOKVEDItem) : gettype($companyExtDatumTypeOKVEDItem)), __LINE__);
            }
        }
        $this->OKVED = $oKVED;
        return $this;
    }
    /**
     * Add item to OKVED value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\OkvedDetailType $item
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function addToOKVED(\AisFssp\StructType\OkvedDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\OkvedDetailType) {
            throw new \InvalidArgumentException(sprintf('The OKVED property can only contain items of \AisFssp\StructType\OkvedDetailType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OKVED[] = $item;
        return $this;
    }
    /**
     * Get statusId value
     * @return int|null
     */
    public function getStatusId()
    {
        return $this->statusId;
    }
    /**
     * Set statusId value
     * @param int $statusId
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setStatusId($statusId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($statusId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $statusId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($statusId, strpos($statusId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($statusId) && !is_numeric($statusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($statusId)), __LINE__);
        }
        $this->statusId = $statusId;
        return $this;
    }
    /**
     * Get nameActDate value
     * @return string|null
     */
    public function getNameActDate()
    {
        return $this->nameActDate;
    }
    /**
     * Set nameActDate value
     * @param string $nameActDate
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setNameActDate($nameActDate = null)
    {
        // validation for constraint: maxExclusive
        if ($nameActDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $nameActDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($nameActDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $nameActDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nameActDate) && !is_string($nameActDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameActDate)), __LINE__);
        }
        $this->nameActDate = $nameActDate;
        return $this;
    }
    /**
     * Get shortName value
     * @return string|null
     */
    public function getShortName()
    {
        return $this->shortName;
    }
    /**
     * Set shortName value
     * @param string $shortName
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setShortName($shortName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($shortName) && strlen($shortName) > 255) || (is_array($shortName) && count($shortName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($shortName) ? strlen($shortName) : count($shortName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($shortName) && strlen($shortName) < 1) || (is_array($shortName) && count($shortName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($shortName) && !is_string($shortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortName)), __LINE__);
        }
        $this->shortName = $shortName;
        return $this;
    }
    /**
     * Get brandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->brandName;
    }
    /**
     * Set brandName value
     * @param string $brandName
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setBrandName($brandName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($brandName) && strlen($brandName) > 255) || (is_array($brandName) && count($brandName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($brandName) ? strlen($brandName) : count($brandName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($brandName) && strlen($brandName) < 1) || (is_array($brandName) && count($brandName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($brandName) && !is_string($brandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brandName)), __LINE__);
        }
        $this->brandName = $brandName;
        return $this;
    }
    /**
     * Get nationalName value
     * @return string|null
     */
    public function getNationalName()
    {
        return $this->nationalName;
    }
    /**
     * Set nationalName value
     * @param string $nationalName
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setNationalName($nationalName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nationalName) && strlen($nationalName) > 255) || (is_array($nationalName) && count($nationalName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($nationalName) ? strlen($nationalName) : count($nationalName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($nationalName) && strlen($nationalName) < 1) || (is_array($nationalName) && count($nationalName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nationalName) && !is_string($nationalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationalName)), __LINE__);
        }
        $this->nationalName = $nationalName;
        return $this;
    }
    /**
     * Get nationalLangId value
     * @return int|null
     */
    public function getNationalLangId()
    {
        return $this->nationalLangId;
    }
    /**
     * Set nationalLangId value
     * @param int $nationalLangId
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setNationalLangId($nationalLangId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($nationalLangId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $nationalLangId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($nationalLangId, strpos($nationalLangId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($nationalLangId) && !is_numeric($nationalLangId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nationalLangId)), __LINE__);
        }
        $this->nationalLangId = $nationalLangId;
        return $this;
    }
    /**
     * Get nationalLangCode value
     * @return string|null
     */
    public function getNationalLangCode()
    {
        return $this->nationalLangCode;
    }
    /**
     * Set nationalLangCode value
     * @param string $nationalLangCode
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setNationalLangCode($nationalLangCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($nationalLangCode) && strlen($nationalLangCode) !== 3) || (is_array($nationalLangCode) && count($nationalLangCode) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($nationalLangCode) && !preg_match('/[0-9]{3}/', $nationalLangCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{3}", "%s" given', var_export($nationalLangCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nationalLangCode) && !is_string($nationalLangCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationalLangCode)), __LINE__);
        }
        $this->nationalLangCode = $nationalLangCode;
        return $this;
    }
    /**
     * Get nationalLangName value
     * @return string|null
     */
    public function getNationalLangName()
    {
        return $this->nationalLangName;
    }
    /**
     * Set nationalLangName value
     * @param string $nationalLangName
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setNationalLangName($nationalLangName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nationalLangName) && strlen($nationalLangName) > 255) || (is_array($nationalLangName) && count($nationalLangName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($nationalLangName) ? strlen($nationalLangName) : count($nationalLangName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($nationalLangName) && strlen($nationalLangName) < 1) || (is_array($nationalLangName) && count($nationalLangName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nationalLangName) && !is_string($nationalLangName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationalLangName)), __LINE__);
        }
        $this->nationalLangName = $nationalLangName;
        return $this;
    }
    /**
     * Get foreignName value
     * @return string|null
     */
    public function getForeignName()
    {
        return $this->foreignName;
    }
    /**
     * Set foreignName value
     * @param string $foreignName
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setForeignName($foreignName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($foreignName) && strlen($foreignName) > 255) || (is_array($foreignName) && count($foreignName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($foreignName) ? strlen($foreignName) : count($foreignName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($foreignName) && strlen($foreignName) < 1) || (is_array($foreignName) && count($foreignName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($foreignName) && !is_string($foreignName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($foreignName)), __LINE__);
        }
        $this->foreignName = $foreignName;
        return $this;
    }
    /**
     * Get foreignLangId value
     * @return int|null
     */
    public function getForeignLangId()
    {
        return $this->foreignLangId;
    }
    /**
     * Set foreignLangId value
     * @param int $foreignLangId
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setForeignLangId($foreignLangId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($foreignLangId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $foreignLangId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($foreignLangId, strpos($foreignLangId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($foreignLangId) && !is_numeric($foreignLangId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($foreignLangId)), __LINE__);
        }
        $this->foreignLangId = $foreignLangId;
        return $this;
    }
    /**
     * Get foreignLangCode value
     * @return string|null
     */
    public function getForeignLangCode()
    {
        return $this->foreignLangCode;
    }
    /**
     * Set foreignLangCode value
     * @param string $foreignLangCode
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setForeignLangCode($foreignLangCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($foreignLangCode) && strlen($foreignLangCode) !== 3) || (is_array($foreignLangCode) && count($foreignLangCode) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($foreignLangCode) && !preg_match('/[0-9]{3}/', $foreignLangCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{3}", "%s" given', var_export($foreignLangCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($foreignLangCode) && !is_string($foreignLangCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($foreignLangCode)), __LINE__);
        }
        $this->foreignLangCode = $foreignLangCode;
        return $this;
    }
    /**
     * Get foreignLandName value
     * @return string|null
     */
    public function getForeignLandName()
    {
        return $this->foreignLandName;
    }
    /**
     * Set foreignLandName value
     * @param string $foreignLandName
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setForeignLandName($foreignLandName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($foreignLandName) && strlen($foreignLandName) > 255) || (is_array($foreignLandName) && count($foreignLandName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($foreignLandName) ? strlen($foreignLandName) : count($foreignLandName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($foreignLandName) && strlen($foreignLandName) < 1) || (is_array($foreignLandName) && count($foreignLandName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($foreignLandName) && !is_string($foreignLandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($foreignLandName)), __LINE__);
        }
        $this->foreignLandName = $foreignLandName;
        return $this;
    }
    /**
     * Get capitalActDate value
     * @return string|null
     */
    public function getCapitalActDate()
    {
        return $this->capitalActDate;
    }
    /**
     * Set capitalActDate value
     * @param string $capitalActDate
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setCapitalActDate($capitalActDate = null)
    {
        // validation for constraint: maxExclusive
        if ($capitalActDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $capitalActDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($capitalActDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $capitalActDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($capitalActDate) && !is_string($capitalActDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($capitalActDate)), __LINE__);
        }
        $this->capitalActDate = $capitalActDate;
        return $this;
    }
    /**
     * Get capitalAmount value
     * @return float|null
     */
    public function getCapitalAmount()
    {
        return $this->capitalAmount;
    }
    /**
     * Set capitalAmount value
     * @param float $capitalAmount
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setCapitalAmount($capitalAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($capitalAmount) && strlen(substr($capitalAmount, strpos($capitalAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($capitalAmount, strpos($capitalAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($capitalAmount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $capitalAmount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($capitalAmount, strpos($capitalAmount, '.')))), __LINE__);
        }
        $this->capitalAmount = $capitalAmount;
        return $this;
    }
    /**
     * Get capitalKindId value
     * @return int|null
     */
    public function getCapitalKindId()
    {
        return $this->capitalKindId;
    }
    /**
     * Set capitalKindId value
     * @param int $capitalKindId
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setCapitalKindId($capitalKindId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($capitalKindId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $capitalKindId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($capitalKindId, strpos($capitalKindId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($capitalKindId) && !is_numeric($capitalKindId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($capitalKindId)), __LINE__);
        }
        $this->capitalKindId = $capitalKindId;
        return $this;
    }
    /**
     * Get capitalKindName value
     * @return string|null
     */
    public function getCapitalKindName()
    {
        return $this->capitalKindName;
    }
    /**
     * Set capitalKindName value
     * @param string $capitalKindName
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setCapitalKindName($capitalKindName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($capitalKindName) && strlen($capitalKindName) > 255) || (is_array($capitalKindName) && count($capitalKindName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($capitalKindName) ? strlen($capitalKindName) : count($capitalKindName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($capitalKindName) && strlen($capitalKindName) < 1) || (is_array($capitalKindName) && count($capitalKindName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($capitalKindName) && !is_string($capitalKindName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($capitalKindName)), __LINE__);
        }
        $this->capitalKindName = $capitalKindName;
        return $this;
    }
    /**
     * Get foundRegNum value
     * @return string|null
     */
    public function getFoundRegNum()
    {
        return $this->foundRegNum;
    }
    /**
     * Set foundRegNum value
     * @param string $foundRegNum
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setFoundRegNum($foundRegNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($foundRegNum) && strlen($foundRegNum) > 255) || (is_array($foundRegNum) && count($foundRegNum) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($foundRegNum) ? strlen($foundRegNum) : count($foundRegNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($foundRegNum) && strlen($foundRegNum) < 1) || (is_array($foundRegNum) && count($foundRegNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($foundRegNum) && !is_string($foundRegNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($foundRegNum)), __LINE__);
        }
        $this->foundRegNum = $foundRegNum;
        return $this;
    }
    /**
     * Get foundRegKindId value
     * @return int|null
     */
    public function getFoundRegKindId()
    {
        return $this->foundRegKindId;
    }
    /**
     * Set foundRegKindId value
     * @param int $foundRegKindId
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setFoundRegKindId($foundRegKindId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($foundRegKindId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $foundRegKindId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($foundRegKindId, strpos($foundRegKindId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($foundRegKindId) && !is_numeric($foundRegKindId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($foundRegKindId)), __LINE__);
        }
        $this->foundRegKindId = $foundRegKindId;
        return $this;
    }
    /**
     * Get foundRegKindName value
     * @return string|null
     */
    public function getFoundRegKindName()
    {
        return $this->foundRegKindName;
    }
    /**
     * Set foundRegKindName value
     * @param string $foundRegKindName
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setFoundRegKindName($foundRegKindName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($foundRegKindName) && strlen($foundRegKindName) > 255) || (is_array($foundRegKindName) && count($foundRegKindName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($foundRegKindName) ? strlen($foundRegKindName) : count($foundRegKindName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($foundRegKindName) && strlen($foundRegKindName) < 1) || (is_array($foundRegKindName) && count($foundRegKindName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($foundRegKindName) && !is_string($foundRegKindName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($foundRegKindName)), __LINE__);
        }
        $this->foundRegKindName = $foundRegKindName;
        return $this;
    }
    /**
     * Get closureRegNum value
     * @return string|null
     */
    public function getClosureRegNum()
    {
        return $this->closureRegNum;
    }
    /**
     * Set closureRegNum value
     * @param string $closureRegNum
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setClosureRegNum($closureRegNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($closureRegNum) && strlen($closureRegNum) > 13) || (is_array($closureRegNum) && count($closureRegNum) > 13)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at most, "%d" length given', is_scalar($closureRegNum) ? strlen($closureRegNum) : count($closureRegNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($closureRegNum) && strlen($closureRegNum) < 1) || (is_array($closureRegNum) && count($closureRegNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($closureRegNum) && !is_string($closureRegNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($closureRegNum)), __LINE__);
        }
        $this->closureRegNum = $closureRegNum;
        return $this;
    }
    /**
     * Get closureDate value
     * @return string|null
     */
    public function getClosureDate()
    {
        return $this->closureDate;
    }
    /**
     * Set closureDate value
     * @param string $closureDate
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setClosureDate($closureDate = null)
    {
        // validation for constraint: maxExclusive
        if ($closureDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $closureDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($closureDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $closureDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($closureDate) && !is_string($closureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($closureDate)), __LINE__);
        }
        $this->closureDate = $closureDate;
        return $this;
    }
    /**
     * Get closureRegKindId value
     * @return int|null
     */
    public function getClosureRegKindId()
    {
        return $this->closureRegKindId;
    }
    /**
     * Set closureRegKindId value
     * @param int $closureRegKindId
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setClosureRegKindId($closureRegKindId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($closureRegKindId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $closureRegKindId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($closureRegKindId, strpos($closureRegKindId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($closureRegKindId) && !is_numeric($closureRegKindId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($closureRegKindId)), __LINE__);
        }
        $this->closureRegKindId = $closureRegKindId;
        return $this;
    }
    /**
     * Get closureRegKindName value
     * @return string|null
     */
    public function getClosureRegKindName()
    {
        return $this->closureRegKindName;
    }
    /**
     * Set closureRegKindName value
     * @param string $closureRegKindName
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setClosureRegKindName($closureRegKindName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($closureRegKindName) && strlen($closureRegKindName) > 255) || (is_array($closureRegKindName) && count($closureRegKindName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($closureRegKindName) ? strlen($closureRegKindName) : count($closureRegKindName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($closureRegKindName) && strlen($closureRegKindName) < 1) || (is_array($closureRegKindName) && count($closureRegKindName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($closureRegKindName) && !is_string($closureRegKindName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($closureRegKindName)), __LINE__);
        }
        $this->closureRegKindName = $closureRegKindName;
        return $this;
    }
    /**
     * Get founderCompanyCount value
     * @return int|null
     */
    public function getFounderCompanyCount()
    {
        return $this->founderCompanyCount;
    }
    /**
     * Set founderCompanyCount value
     * @param int $founderCompanyCount
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setFounderCompanyCount($founderCompanyCount = null)
    {
        // validation for constraint: maxInclusive
        if ($founderCompanyCount > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $founderCompanyCount), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($founderCompanyCount) && !is_numeric($founderCompanyCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($founderCompanyCount)), __LINE__);
        }
        $this->founderCompanyCount = $founderCompanyCount;
        return $this;
    }
    /**
     * Get founderForeignCompanyCount value
     * @return int|null
     */
    public function getFounderForeignCompanyCount()
    {
        return $this->founderForeignCompanyCount;
    }
    /**
     * Set founderForeignCompanyCount value
     * @param int $founderForeignCompanyCount
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setFounderForeignCompanyCount($founderForeignCompanyCount = null)
    {
        // validation for constraint: maxInclusive
        if ($founderForeignCompanyCount > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $founderForeignCompanyCount), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($founderForeignCompanyCount) && !is_numeric($founderForeignCompanyCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($founderForeignCompanyCount)), __LINE__);
        }
        $this->founderForeignCompanyCount = $founderForeignCompanyCount;
        return $this;
    }
    /**
     * Get founderPersonCount value
     * @return int|null
     */
    public function getFounderPersonCount()
    {
        return $this->founderPersonCount;
    }
    /**
     * Set founderPersonCount value
     * @param int $founderPersonCount
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public function setFounderPersonCount($founderPersonCount = null)
    {
        // validation for constraint: maxInclusive
        if ($founderPersonCount > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $founderPersonCount), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($founderPersonCount) && !is_numeric($founderPersonCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($founderPersonCount)), __LINE__);
        }
        $this->founderPersonCount = $founderPersonCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\CompanyExtDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
