<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о юридическом лице
 * @subpackage Structs
 */
class CompanyDatumType extends OrganizationDatumType
{
    /**
     * The INN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН организации | ИНН юридического лица
     * - minOccurs: 0
     * - length: 10
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}
     * @var string
     */
    public $INN;
    /**
     * The KPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП организации | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $KPP;
    /**
     * The OGRN
     * Meta informations extracted from the WSDL
     * - documentation: ОГРН организации | Основной государственный регистрационный номер (ОГРН)
     * - minOccurs: 0
     * - length: 13
     * - pattern: [0-9]{13}
     * @var string
     */
    public $OGRN;
    /**
     * The OGRNDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата присвоения ОГРН | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $OGRNDate;
    /**
     * The KIO
     * Meta informations extracted from the WSDL
     * - documentation: Код иностранной организации | Код иностранной организации
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $KIO;
    /**
     * The statusName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование состояния юридического лица | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $statusName;
    /**
     * The statusDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала действия указанного статуса (состояния) | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $statusDate;
    /**
     * The numSt
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер учредителя — юридического лица (до 01.07.2002) | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $numSt;
    /**
     * The foundDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации образования учредителя — юридического лица | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $foundDate;
    /**
     * The FNSResource
     * Meta informations extracted from the WSDL
     * - documentation: Вид ресурса - источника сведений | Вид ресурса (реестра) ФНС
     * - minOccurs: 0
     * - maxInclusive: 3
     * - minInclusive: 1
     * @var int
     */
    public $FNSResource;
    /**
     * The OPFId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор ОПФ | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $OPFId;
    /**
     * The OPFKind
     * Meta informations extracted from the WSDL
     * - documentation: Наименование классификатора: ОКОПФ, КОПФ
     * - minOccurs: 0
     * @var string
     */
    public $OPFKind;
    /**
     * The OPFCode
     * Meta informations extracted from the WSDL
     * - documentation: Код по справочнику ОКОПФ или КОПФ | Код по справочнику ОКОПФ или КОПФ
     * - minOccurs: 0
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $OPFCode;
    /**
     * The OPFName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование ОПФ | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $OPFName;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - documentation: Электропочта | Адрес электронной почты
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $email;
    /**
     * Constructor method for CompanyDatumType
     * @uses CompanyDatumType::setINN()
     * @uses CompanyDatumType::setKPP()
     * @uses CompanyDatumType::setOGRN()
     * @uses CompanyDatumType::setOGRNDate()
     * @uses CompanyDatumType::setKIO()
     * @uses CompanyDatumType::setStatusName()
     * @uses CompanyDatumType::setStatusDate()
     * @uses CompanyDatumType::setNumSt()
     * @uses CompanyDatumType::setFoundDate()
     * @uses CompanyDatumType::setFNSResource()
     * @uses CompanyDatumType::setOPFId()
     * @uses CompanyDatumType::setOPFKind()
     * @uses CompanyDatumType::setOPFCode()
     * @uses CompanyDatumType::setOPFName()
     * @uses CompanyDatumType::setEmail()
     * @param string $iNN
     * @param string $kPP
     * @param string $oGRN
     * @param string $oGRNDate
     * @param string $kIO
     * @param string $statusName
     * @param string $statusDate
     * @param string $numSt
     * @param string $foundDate
     * @param int $fNSResource
     * @param int $oPFId
     * @param string $oPFKind
     * @param string $oPFCode
     * @param string $oPFName
     * @param string $email
     */
    public function __construct($iNN = null, $kPP = null, $oGRN = null, $oGRNDate = null, $kIO = null, $statusName = null, $statusDate = null, $numSt = null, $foundDate = null, $fNSResource = null, $oPFId = null, $oPFKind = null, $oPFCode = null, $oPFName = null, $email = null)
    {
        $this
            ->setINN($iNN)
            ->setKPP($kPP)
            ->setOGRN($oGRN)
            ->setOGRNDate($oGRNDate)
            ->setKIO($kIO)
            ->setStatusName($statusName)
            ->setStatusDate($statusDate)
            ->setNumSt($numSt)
            ->setFoundDate($foundDate)
            ->setFNSResource($fNSResource)
            ->setOPFId($oPFId)
            ->setOPFKind($oPFKind)
            ->setOPFCode($oPFCode)
            ->setOPFName($oPFName)
            ->setEmail($email);
    }
    /**
     * Get INN value
     * @return string|null
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \AisFssp\StructType\CompanyDatumType
     */
    public function setINN($iNN = null)
    {
        // validation for constraint: length
        if ((is_scalar($iNN) && strlen($iNN) !== 10) || (is_array($iNN) && count($iNN) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($iNN) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}/', $iNN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}", "%s" given', var_export($iNN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iNN) && !is_string($iNN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNN)), __LINE__);
        }
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get KPP value
     * @return string|null
     */
    public function getKPP()
    {
        return $this->KPP;
    }
    /**
     * Set KPP value
     * @param string $kPP
     * @return \AisFssp\StructType\CompanyDatumType
     */
    public function setKPP($kPP = null)
    {
        // validation for constraint: length
        if ((is_scalar($kPP) && strlen($kPP) !== 9) || (is_array($kPP) && count($kPP) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($kPP) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}/', $kPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}", "%s" given', var_export($kPP, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kPP) && !is_string($kPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kPP)), __LINE__);
        }
        $this->KPP = $kPP;
        return $this;
    }
    /**
     * Get OGRN value
     * @return string|null
     */
    public function getOGRN()
    {
        return $this->OGRN;
    }
    /**
     * Set OGRN value
     * @param string $oGRN
     * @return \AisFssp\StructType\CompanyDatumType
     */
    public function setOGRN($oGRN = null)
    {
        // validation for constraint: length
        if ((is_scalar($oGRN) && strlen($oGRN) !== 13) || (is_array($oGRN) && count($oGRN) !== 13)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($oGRN) && !preg_match('/[0-9]{13}/', $oGRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{13}", "%s" given', var_export($oGRN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oGRN) && !is_string($oGRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oGRN)), __LINE__);
        }
        $this->OGRN = $oGRN;
        return $this;
    }
    /**
     * Get OGRNDate value
     * @return string|null
     */
    public function getOGRNDate()
    {
        return $this->OGRNDate;
    }
    /**
     * Set OGRNDate value
     * @param string $oGRNDate
     * @return \AisFssp\StructType\CompanyDatumType
     */
    public function setOGRNDate($oGRNDate = null)
    {
        // validation for constraint: maxExclusive
        if ($oGRNDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $oGRNDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($oGRNDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $oGRNDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oGRNDate) && !is_string($oGRNDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oGRNDate)), __LINE__);
        }
        $this->OGRNDate = $oGRNDate;
        return $this;
    }
    /**
     * Get KIO value
     * @return string|null
     */
    public function getKIO()
    {
        return $this->KIO;
    }
    /**
     * Set KIO value
     * @param string $kIO
     * @return \AisFssp\StructType\CompanyDatumType
     */
    public function setKIO($kIO = null)
    {
        // validation for constraint: length
        if ((is_scalar($kIO) && strlen($kIO) !== 5) || (is_array($kIO) && count($kIO) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($kIO) && !preg_match('/[0-9]{5}/', $kIO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($kIO, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kIO) && !is_string($kIO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kIO)), __LINE__);
        }
        $this->KIO = $kIO;
        return $this;
    }
    /**
     * Get statusName value
     * @return string|null
     */
    public function getStatusName()
    {
        return $this->statusName;
    }
    /**
     * Set statusName value
     * @param string $statusName
     * @return \AisFssp\StructType\CompanyDatumType
     */
    public function setStatusName($statusName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($statusName) && strlen($statusName) > 255) || (is_array($statusName) && count($statusName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($statusName) ? strlen($statusName) : count($statusName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($statusName) && strlen($statusName) < 1) || (is_array($statusName) && count($statusName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($statusName) && !is_string($statusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusName)), __LINE__);
        }
        $this->statusName = $statusName;
        return $this;
    }
    /**
     * Get statusDate value
     * @return string|null
     */
    public function getStatusDate()
    {
        return $this->statusDate;
    }
    /**
     * Set statusDate value
     * @param string $statusDate
     * @return \AisFssp\StructType\CompanyDatumType
     */
    public function setStatusDate($statusDate = null)
    {
        // validation for constraint: maxExclusive
        if ($statusDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $statusDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($statusDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $statusDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($statusDate) && !is_string($statusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusDate)), __LINE__);
        }
        $this->statusDate = $statusDate;
        return $this;
    }
    /**
     * Get numSt value
     * @return string|null
     */
    public function getNumSt()
    {
        return $this->numSt;
    }
    /**
     * Set numSt value
     * @param string $numSt
     * @return \AisFssp\StructType\CompanyDatumType
     */
    public function setNumSt($numSt = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($numSt) && strlen($numSt) > 255) || (is_array($numSt) && count($numSt) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($numSt) ? strlen($numSt) : count($numSt)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($numSt) && strlen($numSt) < 1) || (is_array($numSt) && count($numSt) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($numSt) && !is_string($numSt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numSt)), __LINE__);
        }
        $this->numSt = $numSt;
        return $this;
    }
    /**
     * Get foundDate value
     * @return string|null
     */
    public function getFoundDate()
    {
        return $this->foundDate;
    }
    /**
     * Set foundDate value
     * @param string $foundDate
     * @return \AisFssp\StructType\CompanyDatumType
     */
    public function setFoundDate($foundDate = null)
    {
        // validation for constraint: maxExclusive
        if ($foundDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $foundDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($foundDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $foundDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($foundDate) && !is_string($foundDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($foundDate)), __LINE__);
        }
        $this->foundDate = $foundDate;
        return $this;
    }
    /**
     * Get FNSResource value
     * @return int|null
     */
    public function getFNSResource()
    {
        return $this->FNSResource;
    }
    /**
     * Set FNSResource value
     * @param int $fNSResource
     * @return \AisFssp\StructType\CompanyDatumType
     */
    public function setFNSResource($fNSResource = null)
    {
        // validation for constraint: maxInclusive
        if ($fNSResource > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 3, "%s" given', $fNSResource), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($fNSResource < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $fNSResource), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($fNSResource) && !is_numeric($fNSResource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fNSResource)), __LINE__);
        }
        $this->FNSResource = $fNSResource;
        return $this;
    }
    /**
     * Get OPFId value
     * @return int|null
     */
    public function getOPFId()
    {
        return $this->OPFId;
    }
    /**
     * Set OPFId value
     * @param int $oPFId
     * @return \AisFssp\StructType\CompanyDatumType
     */
    public function setOPFId($oPFId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($oPFId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $oPFId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($oPFId, strpos($oPFId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($oPFId) && !is_numeric($oPFId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($oPFId)), __LINE__);
        }
        $this->OPFId = $oPFId;
        return $this;
    }
    /**
     * Get OPFKind value
     * @return string|null
     */
    public function getOPFKind()
    {
        return $this->OPFKind;
    }
    /**
     * Set OPFKind value
     * @uses \AisFssp\EnumType\OPFKindType::valueIsValid()
     * @uses \AisFssp\EnumType\OPFKindType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $oPFKind
     * @return \AisFssp\StructType\CompanyDatumType
     */
    public function setOPFKind($oPFKind = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\OPFKindType::valueIsValid($oPFKind)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $oPFKind, implode(', ', \AisFssp\EnumType\OPFKindType::getValidValues())), __LINE__);
        }
        $this->OPFKind = $oPFKind;
        return $this;
    }
    /**
     * Get OPFCode value
     * @return string|null
     */
    public function getOPFCode()
    {
        return $this->OPFCode;
    }
    /**
     * Set OPFCode value
     * @param string $oPFCode
     * @return \AisFssp\StructType\CompanyDatumType
     */
    public function setOPFCode($oPFCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($oPFCode) && strlen($oPFCode) !== 2) || (is_array($oPFCode) && count($oPFCode) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($oPFCode) && !preg_match('/[0-9]{2}/', $oPFCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{2}", "%s" given', var_export($oPFCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oPFCode) && !is_string($oPFCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oPFCode)), __LINE__);
        }
        $this->OPFCode = $oPFCode;
        return $this;
    }
    /**
     * Get OPFName value
     * @return string|null
     */
    public function getOPFName()
    {
        return $this->OPFName;
    }
    /**
     * Set OPFName value
     * @param string $oPFName
     * @return \AisFssp\StructType\CompanyDatumType
     */
    public function setOPFName($oPFName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oPFName) && strlen($oPFName) > 255) || (is_array($oPFName) && count($oPFName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($oPFName) ? strlen($oPFName) : count($oPFName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($oPFName) && strlen($oPFName) < 1) || (is_array($oPFName) && count($oPFName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oPFName) && !is_string($oPFName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oPFName)), __LINE__);
        }
        $this->OPFName = $oPFName;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \AisFssp\StructType\CompanyDatumType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($email) && strlen($email) > 100) || (is_array($email) && count($email) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($email) ? strlen($email) : count($email)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($email) && strlen($email) < 1) || (is_array($email) && count($email) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\CompanyDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
