<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClaimerIPListResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ ClaimerIPListResponseType «Список исполнительных производств по взыскателю» | ЭП
 * @subpackage Structs
 */
class ClaimerIPListResponseType extends AbstractStructBase
{
    /**
     * The responseKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ответа ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $responseKey;
    /**
     * The requestKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ запроса АИС внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и
     * прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным
     * внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $requestKey;
    /**
     * The IPInformation
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об исполнительных производствах
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\BriefIPInformationType[]
     */
    public $IPInformation;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for ClaimerIPListResponseType
     * @uses ClaimerIPListResponseType::setResponseKey()
     * @uses ClaimerIPListResponseType::setRequestKey()
     * @uses ClaimerIPListResponseType::setIPInformation()
     * @uses ClaimerIPListResponseType::setSignature()
     * @uses ClaimerIPListResponseType::setId()
     * @param int $responseKey
     * @param string $requestKey
     * @param \AisFssp\StructType\BriefIPInformationType[] $iPInformation
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($responseKey = null, $requestKey = null, array $iPInformation = array(), array $signature = array(), $id = null)
    {
        $this
            ->setResponseKey($responseKey)
            ->setRequestKey($requestKey)
            ->setIPInformation($iPInformation)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get responseKey value
     * @return int|null
     */
    public function getResponseKey()
    {
        return $this->responseKey;
    }
    /**
     * Set responseKey value
     * @param int $responseKey
     * @return \AisFssp\StructType\ClaimerIPListResponseType
     */
    public function setResponseKey($responseKey = null)
    {
        // validation for constraint: maxInclusive
        if ($responseKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $responseKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($responseKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $responseKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($responseKey) && !is_numeric($responseKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($responseKey)), __LINE__);
        }
        $this->responseKey = $responseKey;
        return $this;
    }
    /**
     * Get requestKey value
     * @return string|null
     */
    public function getRequestKey()
    {
        return $this->requestKey;
    }
    /**
     * Set requestKey value
     * @param string $requestKey
     * @return \AisFssp\StructType\ClaimerIPListResponseType
     */
    public function setRequestKey($requestKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestKey) && strlen($requestKey) > 60) || (is_array($requestKey) && count($requestKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($requestKey) ? strlen($requestKey) : count($requestKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestKey) && strlen($requestKey) < 1) || (is_array($requestKey) && count($requestKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestKey) && !is_string($requestKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestKey)), __LINE__);
        }
        $this->requestKey = $requestKey;
        return $this;
    }
    /**
     * Get IPInformation value
     * @return \AisFssp\StructType\BriefIPInformationType[]|null
     */
    public function getIPInformation()
    {
        return $this->IPInformation;
    }
    /**
     * Set IPInformation value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\BriefIPInformationType[] $iPInformation
     * @return \AisFssp\StructType\ClaimerIPListResponseType
     */
    public function setIPInformation(array $iPInformation = array())
    {
        foreach ($iPInformation as $claimerIPListResponseTypeIPInformationItem) {
            // validation for constraint: itemType
            if (!$claimerIPListResponseTypeIPInformationItem instanceof \AisFssp\StructType\BriefIPInformationType) {
                throw new \InvalidArgumentException(sprintf('The IPInformation property can only contain items of \AisFssp\StructType\BriefIPInformationType, "%s" given', is_object($claimerIPListResponseTypeIPInformationItem) ? get_class($claimerIPListResponseTypeIPInformationItem) : gettype($claimerIPListResponseTypeIPInformationItem)), __LINE__);
            }
        }
        $this->IPInformation = $iPInformation;
        return $this;
    }
    /**
     * Add item to IPInformation value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\BriefIPInformationType $item
     * @return \AisFssp\StructType\ClaimerIPListResponseType
     */
    public function addToIPInformation(\AisFssp\StructType\BriefIPInformationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\BriefIPInformationType) {
            throw new \InvalidArgumentException(sprintf('The IPInformation property can only contain items of \AisFssp\StructType\BriefIPInformationType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IPInformation[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\ClaimerIPListResponseType
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $claimerIPListResponseTypeSignatureItem) {
            // validation for constraint: itemType
            if (!$claimerIPListResponseTypeSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($claimerIPListResponseTypeSignatureItem) ? get_class($claimerIPListResponseTypeSignatureItem) : gettype($claimerIPListResponseTypeSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\ClaimerIPListResponseType
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\ClaimerIPListResponseType
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ClaimerIPListResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
