<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClaimerIPListRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ ClaimerIPListRequestType «Запрос реестра ИП по взыскателю» | ЭП
 * @subpackage Structs
 */
class ClaimerIPListRequestType extends AbstractStructBase
{
    /**
     * The INN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН взыскателя | ИНН юридического лица
     * - minOccurs: 1
     * - length: 10
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}
     * @var string
     */
    public $INN;
    /**
     * The IDNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер исполнительного документа | Номер документа
     * - minOccurs: 1
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IDNum;
    /**
     * The requestKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ запроса АИС внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и
     * прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным
     * внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $requestKey;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for ClaimerIPListRequestType
     * @uses ClaimerIPListRequestType::setINN()
     * @uses ClaimerIPListRequestType::setIDNum()
     * @uses ClaimerIPListRequestType::setRequestKey()
     * @uses ClaimerIPListRequestType::setSignature()
     * @uses ClaimerIPListRequestType::setId()
     * @param string $iNN
     * @param string $iDNum
     * @param string $requestKey
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($iNN = null, $iDNum = null, $requestKey = null, array $signature = array(), $id = null)
    {
        $this
            ->setINN($iNN)
            ->setIDNum($iDNum)
            ->setRequestKey($requestKey)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get INN value
     * @return string
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \AisFssp\StructType\ClaimerIPListRequestType
     */
    public function setINN($iNN = null)
    {
        // validation for constraint: length
        if ((is_scalar($iNN) && strlen($iNN) !== 10) || (is_array($iNN) && count($iNN) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($iNN) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}/', $iNN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}", "%s" given', var_export($iNN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iNN) && !is_string($iNN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNN)), __LINE__);
        }
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get IDNum value
     * @return string
     */
    public function getIDNum()
    {
        return $this->IDNum;
    }
    /**
     * Set IDNum value
     * @param string $iDNum
     * @return \AisFssp\StructType\ClaimerIPListRequestType
     */
    public function setIDNum($iDNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDNum) && strlen($iDNum) > 25) || (is_array($iDNum) && count($iDNum) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($iDNum) ? strlen($iDNum) : count($iDNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDNum) && strlen($iDNum) < 1) || (is_array($iDNum) && count($iDNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDNum) && !is_string($iDNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDNum)), __LINE__);
        }
        $this->IDNum = $iDNum;
        return $this;
    }
    /**
     * Get requestKey value
     * @return string|null
     */
    public function getRequestKey()
    {
        return $this->requestKey;
    }
    /**
     * Set requestKey value
     * @param string $requestKey
     * @return \AisFssp\StructType\ClaimerIPListRequestType
     */
    public function setRequestKey($requestKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestKey) && strlen($requestKey) > 60) || (is_array($requestKey) && count($requestKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($requestKey) ? strlen($requestKey) : count($requestKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestKey) && strlen($requestKey) < 1) || (is_array($requestKey) && count($requestKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestKey) && !is_string($requestKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestKey)), __LINE__);
        }
        $this->requestKey = $requestKey;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\ClaimerIPListRequestType
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $claimerIPListRequestTypeSignatureItem) {
            // validation for constraint: itemType
            if (!$claimerIPListRequestTypeSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($claimerIPListRequestTypeSignatureItem) ? get_class($claimerIPListRequestTypeSignatureItem) : gettype($claimerIPListRequestTypeSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\ClaimerIPListRequestType
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\ClaimerIPListRequestType
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ClaimerIPListRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
