<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BarcodeList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Список идентификаторов отправлений, присвоенный ФГУП «Почта России»
 * @subpackage Structs
 */
class BarcodeList extends AbstractStructBase
{
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор отправления, присвоенный ФГУП «Почта России» | Штрих-код в формате code39
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - maxLength: 44
     * - minLength: 1
     * - pattern: [0-9A-Z\-\.\+$/%]+
     * @var string[]
     */
    public $Barcode;
    /**
     * Constructor method for BarcodeList
     * @uses BarcodeList::setBarcode()
     * @param string[] $barcode
     */
    public function __construct(array $barcode = array())
    {
        $this
            ->setBarcode($barcode);
    }
    /**
     * Get Barcode value
     * @return string[]
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @throws \InvalidArgumentException
     * @param string[] $barcode
     * @return \AisFssp\StructType\BarcodeList
     */
    public function setBarcode(array $barcode = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($barcode) && strlen($barcode) > 44) || (is_array($barcode) && count($barcode) > 44)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 44 element(s) or a scalar of 44 character(s) at most, "%d" length given', is_scalar($barcode) ? strlen($barcode) : count($barcode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($barcode) && strlen($barcode) < 1) || (is_array($barcode) && count($barcode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($barcode) && !preg_match('/[0-9A-Z\\-\\.\\+$\/%]+/', $barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9A-Z\-\.\+$/%]+", "%s" given', var_export($barcode, true)), __LINE__);
        }
        foreach ($barcode as $barcodeListBarcodeItem) {
            // validation for constraint: itemType
            if (!is_string($barcodeListBarcodeItem)) {
                throw new \InvalidArgumentException(sprintf('The Barcode property can only contain items of string, "%s" given', is_object($barcodeListBarcodeItem) ? get_class($barcodeListBarcodeItem) : gettype($barcodeListBarcodeItem)), __LINE__);
            }
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Add item to Barcode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \AisFssp\StructType\BarcodeList
     */
    public function addToBarcode($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 44) || (is_array($item) && count($item) > 44)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 44 element(s) or a scalar of 44 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($item) && strlen($item) < 1) || (is_array($item) && count($item) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($item) && !preg_match('/[0-9A-Z\\-\\.\\+$\/%]+/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9A-Z\-\.\+$/%]+", "%s" given', var_export($item, true)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Barcode property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Barcode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\BarcodeList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
